/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.resources;

import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.IndexSegmentBuilder;
import com.bigdata.mdi.IResourceMetadata;
import com.bigdata.mdi.SegmentMetadata;
import com.bigdata.resources.AbstractResult;
import com.bigdata.service.Params;
import java.util.HashMap;
import java.util.Map;

public class BuildResult
extends AbstractResult
implements Params {
    public final int sourceCount;
    public IResourceMetadata[] sources;
    public boolean compactingMerge;
    public final SegmentMetadata segmentMetadata;
    public final IndexSegmentBuilder builder;

    public BuildResult(String name, boolean compactingMerge, AbstractBTree[] sources, IndexMetadata indexMetadata, SegmentMetadata segmentMetadata, IndexSegmentBuilder builder) {
        super(name, indexMetadata);
        if (sources == null) {
            throw new IllegalArgumentException();
        }
        if (sources.length == 0) {
            throw new IllegalArgumentException();
        }
        for (AbstractBTree src : sources) {
            if (src != null) continue;
            throw new IllegalArgumentException();
        }
        if (segmentMetadata == null) {
            throw new IllegalArgumentException();
        }
        if (builder == null) {
            throw new IllegalArgumentException();
        }
        this.sourceCount = sources.length;
        this.compactingMerge = compactingMerge;
        this.sources = new IResourceMetadata[this.sourceCount];
        for (int i = 0; i < this.sourceCount; ++i) {
            this.sources[i] = sources[i].getStore().getResourceMetadata();
        }
        this.segmentMetadata = segmentMetadata;
        this.builder = builder;
    }

    @Override
    public String toString() {
        return "BuildResult{name=" + this.name + ", #sources=" + this.sourceCount + ", merge=" + this.compactingMerge + ", #tuples(out)=" + this.builder.getCheckpoint().nentries + "}";
    }

    @Override
    public Map<String, Object> getParams() {
        HashMap<String, Object> v = new HashMap<String, Object>();
        v.put("name", this.name);
        v.put("#sources", this.sourceCount);
        v.put("merge", this.compactingMerge);
        v.put("#tuples(out)", this.builder.getCheckpoint().nentries);
        return v;
    }
}

