/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.resources;

import com.bigdata.btree.BTreeCounters;
import com.bigdata.btree.ITuple;
import com.bigdata.io.DataInputBuffer;
import com.bigdata.journal.Name2Addr;
import com.bigdata.resources.OverflowActionEnum;
import com.bigdata.resources.ResourceManager;
import com.bigdata.resources.Score;
import com.bigdata.resources.StoreManager;
import com.bigdata.resources.ViewMetadata;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class OverflowMetadata {
    protected static final Logger log = Logger.getLogger(OverflowMetadata.class);
    public final ResourceManager resourceManager;
    public final long lastCommitTime;
    public boolean postProcess;
    private double totalRawStore;
    private final Score[] scores;
    private final Map<String, Score> scoreMap;
    private final LinkedHashMap<String, ViewMetadata> views;
    private final Map<OverflowActionEnum, AtomicInteger> actionCounts = new HashMap<OverflowActionEnum, AtomicInteger>();

    void clearViews() {
        for (ViewMetadata view : this.views.values()) {
            view.clearRef();
        }
        this.views.clear();
    }

    public final ViewMetadata getViewMetadata(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        ViewMetadata vmd = this.views.get(name);
        return vmd;
    }

    public Iterator<ViewMetadata> views() {
        return Collections.unmodifiableMap(this.views).values().iterator();
    }

    public int getIndexCount() {
        return this.views.size();
    }

    public boolean isCopied(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        ViewMetadata vmd = this.views.get(name);
        if (vmd == null) {
            throw new IllegalArgumentException();
        }
        return OverflowActionEnum.Copy.equals((Object)vmd.getAction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAction(String name, OverflowActionEnum action) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        ViewMetadata vmd = this.views.get(name);
        if (vmd == null) {
            throw new IllegalArgumentException();
        }
        vmd.lock.lock();
        try {
            vmd.setAction(action);
            Map<OverflowActionEnum, AtomicInteger> map = this.actionCounts;
            synchronized (map) {
                AtomicInteger counter = this.actionCounts.get((Object)action);
                if (counter == null) {
                    counter = new AtomicInteger();
                    this.actionCounts.put(action, counter);
                }
                counter.incrementAndGet();
            }
        }
        finally {
            vmd.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActionCount(OverflowActionEnum action) {
        if (action == null) {
            throw new IllegalArgumentException();
        }
        Map<OverflowActionEnum, AtomicInteger> map = this.actionCounts;
        synchronized (map) {
            AtomicInteger counter = this.actionCounts.get((Object)action);
            if (counter == null) {
                return 0;
            }
            return counter.get();
        }
    }

    public OverflowMetadata(ResourceManager resourceManager) {
        if (resourceManager == null) {
            throw new IllegalArgumentException();
        }
        this.resourceManager = resourceManager;
        StoreManager.ManagedJournal oldJournal = resourceManager.getLiveJournal();
        this.lastCommitTime = oldJournal.getRootBlockView().getLastCommitTime();
        BTreeCounters totalCounters = new BTreeCounters();
        int numIndices = (int)oldJournal.getName2Addr(this.lastCommitTime).rangeCount();
        this.views = new LinkedHashMap(numIndices);
        Iterator itr = oldJournal.getName2Addr(this.lastCommitTime).rangeIterator();
        Map<String, BTreeCounters> delta = resourceManager.markAndGetDelta();
        while (itr.hasNext()) {
            ITuple tuple = itr.next();
            Name2Addr.Entry entry = Name2Addr.EntrySerializer.INSTANCE.deserialize(new DataInputBuffer(tuple.getValue()));
            BTreeCounters btreeCounters = delta.get(entry.name);
            if (btreeCounters == null) {
                log.error((Object)("No performance counters? index=" + entry.name));
                btreeCounters = new BTreeCounters();
            }
            totalCounters.add(btreeCounters);
            this.views.put(entry.name, new ViewMetadata(resourceManager, this.lastCommitTime, entry.name, btreeCounters));
        }
        int nscores = this.views.size();
        this.scores = new Score[nscores];
        this.scoreMap = new HashMap<String, Score>(nscores);
        this.totalRawStore = totalCounters.computeRawWriteScore();
        if (nscores > 0) {
            itr = this.views.entrySet().iterator();
            int i = 0;
            while (itr.hasNext()) {
                Map.Entry entry = (Map.Entry)((Object)itr.next());
                String name = (String)entry.getKey();
                ViewMetadata vmd = (ViewMetadata)entry.getValue();
                BTreeCounters btreeCounters = vmd.btreeCounters;
                this.scores[i] = new Score(name, btreeCounters, this.totalRawStore);
                ++i;
            }
            Arrays.sort(this.scores);
            for (i = 0; i < this.scores.length; ++i) {
                this.scores[i].rank = i;
                this.scores[i].drank = (double)i / (double)this.scores.length;
                this.scoreMap.put(this.scores[i].name, this.scores[i]);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("The most active index was: " + this.scores[this.scores.length - 1]));
                log.debug((Object)("The least active index was: " + this.scores[0]));
            }
        }
    }

    public int getActiveCount() {
        return this.scores.length;
    }

    public List<Score> getScores() {
        return Arrays.asList(this.scores);
    }

    public Score getScore(String name) {
        Score score = this.scoreMap.get(name);
        if (score == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Index is cold: " + name));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Index score: " + score));
        }
        return score;
    }
}

