/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.resources;

import com.bigdata.btree.BTree;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.mdi.IResourceMetadata;
import com.bigdata.mdi.IndexPartitionCause;
import com.bigdata.mdi.LocalPartitionMetadata;
import com.bigdata.mdi.PartitionLocator;
import com.bigdata.resources.AbstractAtomicUpdateTask;
import com.bigdata.resources.AbstractPrepareTask;
import com.bigdata.resources.AbstractResult;
import com.bigdata.resources.BuildResult;
import com.bigdata.resources.OverflowActionEnum;
import com.bigdata.resources.OverflowSubtaskEnum;
import com.bigdata.resources.ResourceManager;
import com.bigdata.resources.SplitResult;
import com.bigdata.resources.StaleLocatorReason;
import com.bigdata.resources.ViewMetadata;
import com.bigdata.service.DataService;
import com.bigdata.service.Event;
import com.bigdata.service.Split;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public class SplitIndexPartitionTask
extends AbstractPrepareTask<AbstractResult> {
    protected final ViewMetadata vmd;
    protected final UUID[] moveTargets;
    private final long adjustedNominalShardSize;

    protected SplitIndexPartitionTask(ViewMetadata vmd, UUID moveTarget) {
        UUID[] uUIDArray;
        if (moveTarget == null) {
            uUIDArray = null;
        } else {
            UUID[] uUIDArray2 = new UUID[1];
            uUIDArray = uUIDArray2;
            uUIDArray2[0] = moveTarget;
        }
        this(vmd, uUIDArray);
    }

    protected SplitIndexPartitionTask(ViewMetadata vmd, UUID[] moveTargets) {
        super(vmd.resourceManager, TimestampUtility.asHistoricalRead(vmd.commitTime), vmd.name);
        this.vmd = vmd;
        if (vmd.pmd == null) {
            throw new IllegalStateException("Not an index partition.");
        }
        if (vmd.pmd.getSourcePartitionId() != -1) {
            throw new IllegalStateException("Split not allowed during move: sourcePartitionId=" + vmd.pmd.getSourcePartitionId());
        }
        if (moveTargets != null) {
            if (moveTargets.length == 0) {
                throw new IllegalArgumentException();
            }
            if (moveTargets.length == 1 && this.resourceManager.getDataServiceUUID().equals(moveTargets[0])) {
                throw new IllegalArgumentException();
            }
            for (UUID t : moveTargets) {
                if (t != null) continue;
                throw new IllegalArgumentException();
            }
        }
        this.moveTargets = moveTargets;
        this.adjustedNominalShardSize = vmd.getAdjustedNominalShardSize();
    }

    @Override
    protected void clearRefs() {
        this.vmd.clearRef();
    }

    /*
     * Exception decompiling
     */
    @Override
    protected AbstractResult doTask() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static void doSplitAtomicUpdate(ResourceManager resourceManager, ViewMetadata vmd, SplitResult result, OverflowActionEnum action, AtomicLong counter, Event parentEvent) {
        try {
            Split[] splits = result.splits;
            Object[] resources = new String[splits.length + 1];
            resources[0] = result.name;
            int i = 0;
            for (Split split : splits) {
                int partitionId = split.pmd.getPartitionId();
                resources[i + 1] = DataService.getIndexPartitionName(vmd.indexMetadata.getName(), partitionId);
                ++i;
            }
            AtomicUpdateSplitIndexPartitionTask task = new AtomicUpdateSplitIndexPartitionTask(resourceManager, (String[])resources, action, vmd.indexMetadata.getIndexUUID(), result, parentEvent.newSubEvent((Object)OverflowSubtaskEnum.AtomicUpdate).addDetail("summary", (Object)((Object)action) + "(" + vmd.name + "->" + Arrays.toString(resources)));
            resourceManager.getConcurrencyManager().submit(task).get();
            counter.incrementAndGet();
            return;
        }
        catch (Throwable t) {
            for (BuildResult r : result.buildResults) {
                if (r == null) continue;
                resourceManager.retentionSetRemove(r.segmentMetadata.getUUID());
                resourceManager.deleteResource(r.segmentMetadata.getUUID(), false);
            }
            throw new RuntimeException(t);
        }
    }

    protected static class AtomicUpdateSplitIndexPartitionTask
    extends AbstractAtomicUpdateTask<Void> {
        protected final UUID indexUUID;
        protected final OverflowActionEnum action;
        protected final SplitResult splitResult;
        private final Event updateEvent;

        public AtomicUpdateSplitIndexPartitionTask(ResourceManager resourceManager, String[] resource, OverflowActionEnum action, UUID indexUUID, SplitResult splitResult, Event updateEvent) {
            super(resourceManager, 0L, resource);
            if (action == null) {
                throw new IllegalArgumentException();
            }
            if (indexUUID == null) {
                throw new IllegalArgumentException();
            }
            if (splitResult == null) {
                throw new IllegalArgumentException();
            }
            if (updateEvent == null) {
                throw new IllegalArgumentException();
            }
            this.action = action;
            this.indexUUID = indexUUID;
            this.splitResult = splitResult;
            this.updateEvent = updateEvent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Void doTask() throws Exception {
            this.updateEvent.start();
            try {
                if (this.resourceManager.isOverflowAllowed()) {
                    throw new IllegalStateException();
                }
                String scaleOutIndexName = this.splitResult.indexMetadata.getName();
                String name = this.splitResult.name;
                BTree src = this.getIndex(name).getMutableBTree();
                this.assertSameIndex(this.indexUUID, src);
                if (INFO) {
                    log.info((Object)("src=" + name + ", counter=" + src.getCounter().get() + ", checkpoint=" + src.getCheckpoint()));
                    log.info((Object)("src=" + name + ", splitResult=" + this.splitResult));
                }
                long oldCounter = src.getCounter().get();
                LocalPartitionMetadata oldpmd = src.getIndexMetadata().getPartitionMetadata();
                if (oldpmd.getSourcePartitionId() != -1) {
                    throw new IllegalStateException("Split not allowed during move: sourcePartitionId=" + oldpmd.getSourcePartitionId());
                }
                Split[] splits = this.splitResult.splits;
                Object[] locators = new PartitionLocator[splits.length];
                for (int i = 0; i < splits.length; ++i) {
                    PartitionLocator locator;
                    IndexMetadata md = src.getIndexMetadata().clone();
                    LocalPartitionMetadata pmd = (LocalPartitionMetadata)splits[i].pmd;
                    assert (pmd.getResources() == null) : "Not expecting resources for index segment: " + pmd;
                    int partitionId = pmd.getPartitionId();
                    String name2 = DataService.getIndexPartitionName(scaleOutIndexName, partitionId);
                    locators[i] = locator = new PartitionLocator(pmd.getPartitionId(), this.resourceManager.getDataServiceUUID(), pmd.getLeftSeparatorKey(), pmd.getRightSeparatorKey());
                    String summary = (Object)((Object)this.action) + "(" + name + "->" + name2 + ")";
                    md.setPartitionMetadata(new LocalPartitionMetadata(pmd.getPartitionId(), -1, pmd.getLeftSeparatorKey(), pmd.getRightSeparatorKey(), new IResourceMetadata[]{this.resourceManager.getLiveJournal().getResourceMetadata(), this.splitResult.buildResults[i].segmentMetadata}, IndexPartitionCause.split(this.resourceManager)));
                    BTree btree = BTree.create(this.resourceManager.getLiveJournal(), md);
                    assert (partitionId == btree.getIndexMetadata().getPartitionMetadata().getPartitionId());
                    long newCounter = btree.getCounter().get();
                    assert (newCounter > oldCounter) : "newCounter=" + newCounter + " not GT oldCounter=" + oldCounter;
                    byte[] fromKey = pmd.getLeftSeparatorKey();
                    byte[] toKey = pmd.getRightSeparatorKey();
                    if (INFO) {
                        log.info((Object)("Copying data to new btree: index=" + scaleOutIndexName + ", pmd=" + pmd));
                    }
                    long ncopied = btree.rangeCopy(src, fromKey, toKey, false);
                    if (INFO) {
                        log.info((Object)("Copied " + ncopied + " index entries from the live index " + name + " onto " + name2));
                    }
                    if (INFO) {
                        log.info((Object)("Registering index: " + name2));
                    }
                    this.getJournal().registerIndex(name2, btree);
                }
                if (INFO) {
                    log.info((Object)("Dropping source index: " + name));
                }
                this.getJournal().dropIndex(name);
                this.resourceManager.getFederation().getMetadataService().splitIndexPartition(src.getIndexMetadata().getName(), new PartitionLocator(oldpmd.getPartitionId(), this.resourceManager.getDataServiceUUID(), oldpmd.getLeftSeparatorKey(), oldpmd.getRightSeparatorKey()), (PartitionLocator[])locators);
                if (INFO) {
                    log.info((Object)("Notified metadata service: name=" + name + " was split into " + Arrays.toString(locators)));
                }
                this.resourceManager.setIndexPartitionGone(name, StaleLocatorReason.Split);
                Void void_ = null;
                return void_;
            }
            finally {
                this.updateEvent.end();
            }
        }
    }
}

