/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.search;

import com.bigdata.btree.DefaultTupleSerializer;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.IKeyBuilderFactory;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.btree.raba.codec.IRabaCoder;
import com.bigdata.io.ByteArrayBuffer;
import com.bigdata.search.ITermDocKey;
import com.bigdata.search.ITermDocRecord;
import com.bigdata.search.ITermDocVal;
import com.bigdata.search.ReadOnlyTermDocKey;
import com.bigdata.search.ReadOnlyTermDocRecord;
import com.bigdata.util.BytesUtil;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.log4j.Logger;
import org.apache.lucene.search.similarities.DefaultSimilarity;

public class FullTextIndexTupleSerializer<V extends Comparable<V>>
extends DefaultTupleSerializer<ITermDocKey<V>, ITermDocVal> {
    private static final transient Logger log = Logger.getLogger(FullTextIndexTupleSerializer.class);
    private boolean fieldsEnabled;
    private static final transient byte VERSION0 = 0;
    private static final transient byte VERSION = 0;

    public boolean isFieldsEnabled() {
        return this.fieldsEnabled;
    }

    public FullTextIndexTupleSerializer() {
    }

    public FullTextIndexTupleSerializer(IKeyBuilderFactory keyBuilderFactory, IRabaCoder leafKeysCoder, IRabaCoder leafValsCoder, boolean fieldsEnabled) {
        super(keyBuilderFactory, leafKeysCoder, leafValsCoder);
        this.fieldsEnabled = fieldsEnabled;
    }

    @Override
    public byte[] serializeKey(Object obj) {
        ITermDocKey entry = (ITermDocKey)obj;
        String termText = entry.getToken();
        double termWeight = entry.getLocalTermWeight();
        DefaultSimilarity similarity = new DefaultSimilarity();
        long termWeightCompact = similarity.encodeNormValue((float)termWeight);
        Object docId = entry.getDocId();
        IKeyBuilder keyBuilder = this.getKeyBuilder();
        keyBuilder.reset();
        keyBuilder.appendText(termText, true, false);
        keyBuilder.append(termWeightCompact);
        keyBuilder.append(docId);
        if (this.fieldsEnabled) {
            keyBuilder.append(entry.getFieldId());
        }
        byte[] key = keyBuilder.getKey();
        if (log.isDebugEnabled()) {
            log.debug((Object)("{" + termText + "," + docId + (this.fieldsEnabled ? "," + entry.getFieldId() : "") + "}, key=" + BytesUtil.toString((byte[])key)));
        }
        return key;
    }

    @Override
    public byte[] serializeVal(ITermDocVal obj) {
        return null;
    }

    @Override
    public ITermDocKey<V> deserializeKey(ITuple tuple) {
        return this.deserialize(tuple, true);
    }

    @Override
    public ITermDocRecord<V> deserialize(ITuple tuple) {
        return (ITermDocRecord)this.deserialize(tuple, false);
    }

    protected ITermDocKey<V> deserialize(ITuple tuple, boolean keyOnly) {
        ByteArrayBuffer kbuf = tuple.getKeyBuffer();
        int docIdOffset = kbuf.limit() - 8 - (this.fieldsEnabled ? 4 : 0);
        Comparable docId = Long.valueOf(KeyBuilder.decodeLong(kbuf.array(), docIdOffset));
        int fieldId = this.fieldsEnabled ? (int)KeyBuilder.decodeShort(kbuf.array(), kbuf.limit() - 4) : -1;
        int termWeightOffset = docIdOffset - 1;
        byte termWeightCompact = kbuf.getByte(termWeightOffset);
        DefaultSimilarity similarity = new DefaultSimilarity();
        double termWeight = similarity.decodeNormValue((long)termWeightCompact);
        if (keyOnly) {
            return new ReadOnlyTermDocKey<Comparable>(docId, fieldId, termWeight);
        }
        return new ReadOnlyTermDocRecord<Comparable>(null, docId, fieldId, termWeight);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        byte version = in.readByte();
        switch (version) {
            case 0: {
                break;
            }
            default: {
                throw new IOException("unknown version=" + version);
            }
        }
        this.fieldsEnabled = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeByte(0);
        out.writeBoolean(this.fieldsEnabled);
    }
}

