/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service;

import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.concurrent.LockManager;
import com.bigdata.concurrent.LockManagerTask;
import com.bigdata.config.LongValidator;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.Instrument;
import com.bigdata.journal.IDistributedTransactionService;
import com.bigdata.journal.RunState;
import com.bigdata.service.AbstractFederation;
import com.bigdata.service.AbstractTransactionService;
import com.bigdata.service.CommitTimeIndex;
import com.bigdata.service.IDataService;
import com.bigdata.service.ITxCommitProtocol;
import com.bigdata.util.concurrent.ExecutionExceptions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;

public abstract class DistributedTransactionService
extends AbstractTransactionService
implements IDistributedTransactionService {
    private final ConcurrentHashMap<Long, DistributedTxCommitTask> commitList = new ConcurrentHashMap();
    private final LockManager<String> indexLockManager = new LockManager(0, true);
    private final LockManager<UUID> dataServiceLockManager = new LockManager(0, true);
    protected final CommitTimeIndex commitTimeIndex;
    private final boolean isTransient;
    protected final File dataDir;
    private final long snapshotInterval;
    private volatile long lastCommitTime = 0L;
    protected static final String BASENAME = "commitTime";
    protected static final String EXT = ".snapshot";
    private long snapshotCount = 0L;
    private ScheduledFuture notifyFuture = null;
    private ScheduledFuture writeFuture = null;

    public DistributedTransactionService(Properties properties) {
        super(properties);
        if (properties.getProperty(Options.DATA_DIR) == null) {
            throw new RuntimeException("Required property: " + Options.DATA_DIR);
        }
        this.snapshotInterval = LongValidator.GTE_ZERO.parse(Options.SHAPSHOT_INTERVAL, properties.getProperty(Options.SHAPSHOT_INTERVAL, "300000"));
        if (log.isInfoEnabled()) {
            log.info((Object)(Options.SHAPSHOT_INTERVAL + "=" + this.snapshotInterval));
        }
        boolean bl = this.isTransient = this.snapshotInterval == 0L;
        if (this.isTransient) {
            this.dataDir = null;
        } else {
            this.dataDir = new File(properties.getProperty(Options.DATA_DIR));
            if (log.isInfoEnabled()) {
                log.info((Object)(Options.DATA_DIR + "=" + this.dataDir));
            }
        }
        this.commitTimeIndex = CommitTimeIndex.createTransient();
        this.setup();
        if (log.isInfoEnabled()) {
            log.info((Object)("lastCommitTime=" + this.lastCommitTime + ", #commitTimes=" + this.commitTimeIndex.getEntryCount()));
        }
    }

    private void setup() {
        if (this.isTransient) {
            this.lastCommitTime = 0L;
            return;
        }
        if (!this.dataDir.exists()) {
            if (!this.dataDir.mkdirs() && !this.dataDir.mkdirs()) {
                throw new RuntimeException("Could not create: " + this.dataDir);
            }
            this.lastCommitTime = 0L;
            return;
        }
        File file0 = new File(this.dataDir, "commitTime0.snapshot");
        File file1 = new File(this.dataDir, "commitTime1.snapshot");
        if (!file0.exists() && !file1.exists()) {
            log.warn((Object)("No commit time logs - assuming new service: dataDir=" + this.dataDir));
            this.lastCommitTime = 0L;
            return;
        }
        long time0 = file0.lastModified();
        long time1 = file1.lastModified();
        boolean isFile0 = time0 != 0L && time1 != 0L ? time0 > time1 : time0 != 0L;
        File file = isFile0 ? file0 : file1;
        this.snapshotCount = isFile0 ? 1L : 2L;
        try {
            long entryCount = SnapshotHelper.read(this.commitTimeIndex, file);
            log.warn((Object)("Read snapshot: entryCount=" + entryCount + ", file=" + file));
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not read file: " + file, ex);
        }
        this.lastCommitTime = this.commitTimeIndex.getEntryCount() == 0L ? 0L : this.commitTimeIndex.decodeKey(this.commitTimeIndex.keyAt(this.commitTimeIndex.getEntryCount() - 1L));
    }

    public void snapshot() {
        new SnapshotTask().run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DistributedTransactionService start() {
        this.lock.lock();
        try {
            super.start();
            this.addScheduledTasks();
            DistributedTransactionService distributedTransactionService = this;
            return distributedTransactionService;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void addScheduledTasks() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        AbstractFederation fed = this.getFederation();
        this.notifyFuture = fed.addScheduledTask(new NotifyReleaseTimeTask(), 60L, 60L, TimeUnit.SECONDS);
        if (this.snapshotInterval != 0L) {
            this.writeFuture = fed.addScheduledTask(new SnapshotTask(), this.snapshotInterval, this.snapshotInterval, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.lock.lock();
        try {
            switch (this.getRunState()) {
                case Shutdown: 
                case ShutdownNow: 
                case Halted: {
                    return;
                }
            }
            super.shutdown();
            if (this.notifyFuture != null) {
                this.notifyFuture.cancel(false);
            }
            if (this.writeFuture != null) {
                this.writeFuture.cancel(false);
            }
            if (this.snapshotInterval != 0L) {
                new SnapshotTask().run();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownNow() {
        this.lock.lock();
        try {
            switch (this.getRunState()) {
                case ShutdownNow: 
                case Halted: {
                    return;
                }
            }
            super.shutdownNow();
            if (this.notifyFuture != null) {
                this.notifyFuture.cancel(true);
            }
            if (this.writeFuture != null) {
                this.writeFuture.cancel(true);
            }
            if (this.snapshotInterval != 0L) {
                this.snapshot();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this.lock.lock();
        try {
            super.destroy();
            if (!this.isTransient) {
                new File(this.dataDir, "commitTime0.snapshot").delete();
                new File(this.dataDir, "commitTime1.snapshot").delete();
                this.dataDir.delete();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setReleaseTime(long releaseTime) {
        super.setReleaseTime(releaseTime);
        releaseTime = this.getReleaseTime();
        if (releaseTime > 0L) {
            CommitTimeIndex commitTimeIndex = this.commitTimeIndex;
            synchronized (commitTimeIndex) {
                long toKey = this.commitTimeIndex.find(releaseTime + 1L);
                ITupleIterator itr = this.commitTimeIndex.rangeIterator(0L, toKey, 0, 33, null);
                while (itr.hasNext()) {
                    itr.next();
                    itr.remove();
                }
            }
        }
    }

    protected ITxCommitProtocol[] getDataServices(UUID[] uuids) {
        return this.getFederation().getDataServices(uuids);
    }

    @Override
    protected void abortImpl(AbstractTransactionService.TxState state) throws Exception {
        if (!state.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        if (!state.isActive()) {
            throw new IllegalStateException();
        }
        if (state.isReadOnly()) {
            state.setRunState(RunState.Aborted);
            return;
        }
        UUID[] uuids = state.getDataServiceUUIDs();
        ITxCommitProtocol[] services = this.getDataServices(uuids);
        ArrayList<AbortTask> tasks = new ArrayList<AbortTask>(uuids.length);
        for (ITxCommitProtocol dataService : services) {
            tasks.add(new AbortTask(dataService, state));
        }
        List futures = this.getFederation().getExecutorService().invokeAll(tasks);
        LinkedList<Throwable> causes = null;
        for (Future f : futures) {
            try {
                f.get();
            }
            catch (Throwable t) {
                log.error((Object)t, t);
                if (causes == null) {
                    causes = new LinkedList<Throwable>();
                }
                causes.add(t);
            }
        }
        state.setRunState(RunState.Aborted);
        if (causes != null) {
            throw new ExecutionExceptions(state.toString(), causes);
        }
    }

    @Override
    protected long commitImpl(AbstractTransactionService.TxState state) throws Exception {
        if (state.isReadOnly() || state.getDataServiceCount() == 0) {
            state.setRunState(RunState.Committed);
            return 0L;
        }
        if (!state.isDistributedTx()) {
            return this.singlePhaseCommit(state);
        }
        LockManagerTask delegate = new LockManagerTask(this.indexLockManager, (Comparable[])state.getResources(), (Callable)new DistributedTxCommitTask(state));
        return (Long)delegate.call();
    }

    protected long singlePhaseCommit(AbstractTransactionService.TxState state) throws Exception {
        if (!state.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        UUID[] uuids = state.getDataServiceUUIDs();
        if (uuids.length != 1) {
            throw new AssertionError();
        }
        UUID serviceUUID = uuids[0];
        IDataService dataService = this.getFederation().getDataService(serviceUUID);
        try {
            long commitTime = dataService.singlePhaseCommit(state.tx);
            state.setRunState(RunState.Committed);
            return commitTime;
        }
        catch (Throwable t) {
            state.setRunState(RunState.Aborted);
            throw new RuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void declareResources(long tx, UUID dataServiceUUID, String[] resource) throws IllegalStateException {
        this.setupLoggingContext();
        this.lock.lock();
        try {
            switch (this.getRunState()) {
                case Shutdown: 
                case Running: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Service not available");
                }
            }
            if (dataServiceUUID == null) {
                throw new IllegalArgumentException();
            }
            if (resource == null) {
                throw new IllegalArgumentException();
            }
            AbstractTransactionService.TxState state = this.getTxState(tx);
            if (state == null) {
                throw new IllegalStateException("Unknown transaction");
            }
            state.lock.lock();
            try {
                if (state.isReadOnly()) {
                    throw new IllegalStateException("Read-only");
                }
                if (!state.isActive()) {
                    throw new IllegalStateException("Not active");
                }
                state.declareResources(dataServiceUUID, resource);
            }
            finally {
                state.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
            this.clearLoggingContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long prepared(long tx, UUID dataService) throws IOException, InterruptedException, BrokenBarrierException {
        DistributedTxCommitTask task = this.commitList.get(tx);
        if (task == null) {
            throw new IllegalStateException();
        }
        AbstractTransactionService.TxState state = task.state;
        state.lock.lock();
        try {
            if (!state.isStartedOn(dataService)) {
                throw new IllegalArgumentException();
            }
            task.preparedBarrier.await();
            if (state.isAborted()) {
                throw new InterruptedException();
            }
            long l = state.getCommitTime();
            return l;
        }
        finally {
            state.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean committed(long tx, UUID dataService) throws IOException, InterruptedException, BrokenBarrierException {
        DistributedTxCommitTask task = this.commitList.get(tx);
        if (task == null) {
            throw new IllegalStateException();
        }
        AbstractTransactionService.TxState state = task.state;
        state.lock.lock();
        try {
            if (!state.isStartedOn(dataService)) {
                throw new IllegalArgumentException();
            }
            task.committedBarrier.await();
            if (state.isAborted()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            state.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long findCommitTime(long timestamp) {
        CommitTimeIndex commitTimeIndex = this.commitTimeIndex;
        synchronized (commitTimeIndex) {
            return this.commitTimeIndex.find(timestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long findNextCommitTime(long commitTime) {
        CommitTimeIndex commitTimeIndex = this.commitTimeIndex;
        synchronized (commitTimeIndex) {
            return this.commitTimeIndex.findNext(commitTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void notifyCommit(long commitTime) {
        this.lock.lock();
        try {
            CommitTimeIndex commitTimeIndex = this.commitTimeIndex;
            synchronized (commitTimeIndex) {
                this.commitTimeIndex.add(commitTime);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("commitTime=" + commitTime + ", lastKnownCommitTime=" + this.lastCommitTime + (this.lastCommitTime < commitTime ? " WILL UPDATE" : "")));
                }
                if (this.lastCommitTime < commitTime) {
                    this.lastCommitTime = commitTime;
                    super.notifyCommit(commitTime);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final long getLastCommitTime() {
        return this.lastCommitTime;
    }

    @Override
    public CounterSet getCounters() {
        CounterSet countersRoot = super.getCounters();
        countersRoot.makePath("Index Lock Manager").attach(this.indexLockManager.getCounters());
        countersRoot.makePath("DataService Lock Manager").attach(this.dataServiceLockManager.getCounters());
        countersRoot.addCounter("snapshotCount", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(DistributedTransactionService.this.snapshotCount);
            }
        });
        countersRoot.addCounter("distributedCommitsInProgressCount", new Instrument<Integer>(){

            @Override
            protected void sample() {
                this.setValue(DistributedTransactionService.this.commitList.size());
            }
        });
        countersRoot.addCounter("commitTimesCount", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(DistributedTransactionService.this.commitTimeIndex.getEntryCount());
            }
        });
        countersRoot.addCounter("dataDir", new Instrument<String>(){

            @Override
            protected void sample() {
                this.setValue(DistributedTransactionService.this.dataDir.toString());
            }
        });
        return countersRoot;
    }

    protected class NotifyReleaseTimeTask
    implements Runnable {
        private long lastReleaseTime = 0L;

        protected NotifyReleaseTimeTask() {
        }

        @Override
        public void run() {
            try {
                long releaseTime = DistributedTransactionService.this.getReleaseTime();
                if (releaseTime == this.lastReleaseTime) {
                    return;
                }
                AbstractFederation fed = DistributedTransactionService.this.getFederation();
                UUID[] a = fed.getDataServiceUUIDs(0);
                IDataService[] services = DistributedTransactionService.this.getFederation().getDataServices(a);
                ArrayList<SetReleaseTimeTask> tasks = new ArrayList<SetReleaseTimeTask>(a.length);
                for (IDataService dataService : services) {
                    tasks.add(new SetReleaseTimeTask(dataService, releaseTime));
                }
                AbstractTransactionService.log.warn((Object)("Will set release time on " + a.length + " data services: releaseTime=" + releaseTime));
                List futures = DistributedTransactionService.this.getFederation().getExecutorService().invokeAll(tasks);
                for (Future f : futures) {
                    try {
                        f.get();
                    }
                    catch (Throwable t) {
                        AbstractTransactionService.log.error((Object)t.getLocalizedMessage(), t);
                    }
                }
                this.lastReleaseTime = releaseTime;
            }
            catch (Throwable t) {
                AbstractTransactionService.log.error((Object)t.getLocalizedMessage(), t);
            }
        }
    }

    private static class SetReleaseTimeTask
    implements Callable<Void> {
        final IDataService dataService;
        final long releaseTime;

        public SetReleaseTimeTask(IDataService dataService, long releaseTime) {
            if (dataService == null) {
                throw new IllegalArgumentException();
            }
            if (releaseTime <= 0L) {
                throw new IllegalArgumentException();
            }
            this.dataService = dataService;
            this.releaseTime = releaseTime;
        }

        @Override
        public Void call() throws Exception {
            this.dataService.setReleaseTime(this.releaseTime);
            return null;
        }
    }

    private class DistributedTxCommitTask
    implements Callable<Long> {
        private final AbstractTransactionService.TxState state;
        private final UUID[] uuids;
        private final ITxCommitProtocol[] services;
        private final int nservices;
        private long revisionTime;
        private long commitTime;
        final Thread commitThread;
        final Condition prepared;
        final Condition locksHeld;
        final Condition committed;
        CyclicBarrier preparedBarrier = null;
        CyclicBarrier committedBarrier = null;

        public DistributedTxCommitTask(AbstractTransactionService.TxState state) {
            if (state == null) {
                throw new IllegalArgumentException();
            }
            if (!state.lock.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException();
            }
            this.state = state;
            this.uuids = state.getDataServiceUUIDs();
            this.services = DistributedTransactionService.this.getDataServices(this.uuids);
            this.nservices = this.uuids.length;
            this.commitThread = Thread.currentThread();
            this.prepared = state.lock.newCondition();
            this.locksHeld = state.lock.newCondition();
            this.committed = state.lock.newCondition();
        }

        @Override
        public Long call() throws Exception {
            assert (this.commitThread == Thread.currentThread());
            return this.distributedCommit(this.state);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long distributedCommit(AbstractTransactionService.TxState state) throws Exception {
            if (!state.lock.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException();
            }
            this.revisionTime = DistributedTransactionService.this.nextTimestamp();
            DistributedTransactionService.this.commitList.put(state.tx, this);
            try {
                this.call2();
                long l = this.commitTime;
                return l;
            }
            finally {
                DistributedTransactionService.this.commitList.remove(state.tx);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void call2() throws Exception {
            Future<Void> taskRunnerFuture = null;
            try {
                this.setupPreparedBarrier();
                this.setupCommittedBarrier();
                taskRunnerFuture = DistributedTransactionService.this.getFederation().getExecutorService().submit(new TaskRunner());
                this.prepared.await();
                new LockManagerTask(DistributedTransactionService.this.dataServiceLockManager, (Comparable[])this.state.getDataServiceUUIDs(), (Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        if (!((DistributedTxCommitTask)DistributedTxCommitTask.this).state.lock.isHeldByCurrentThread()) {
                            throw new IllegalMonitorStateException();
                        }
                        DistributedTxCommitTask.this.locksHeld.signal();
                        DistributedTxCommitTask.this.committed.await();
                        return null;
                    }
                }).call();
                Void void_ = null;
                return void_;
            }
            finally {
                if (this.preparedBarrier != null) {
                    this.preparedBarrier.reset();
                }
                if (this.committedBarrier != null) {
                    this.committedBarrier.reset();
                }
                if (taskRunnerFuture != null) {
                    taskRunnerFuture.get();
                }
            }
        }

        private void setupPreparedBarrier() {
            this.preparedBarrier = new CyclicBarrier(this.nservices, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ((DistributedTxCommitTask)DistributedTxCommitTask.this).state.lock.lock();
                    try {
                        DistributedTxCommitTask.this.state.setRunState(RunState.Prepared);
                        DistributedTxCommitTask.this.prepared.signal();
                        try {
                            DistributedTxCommitTask.this.locksHeld.await();
                        }
                        catch (InterruptedException ex) {
                            AbstractTransactionService.log.warn((Object)"Interrupted", (Throwable)ex);
                            throw new RuntimeException(ex);
                        }
                        long commitTime = DistributedTransactionService.this.nextTimestamp();
                        DistributedTxCommitTask.this.commitTime = commitTime;
                        DistributedTxCommitTask.this.state.setCommitTime(commitTime);
                    }
                    finally {
                        ((DistributedTxCommitTask)DistributedTxCommitTask.this).state.lock.unlock();
                    }
                }
            });
        }

        protected void setupCommittedBarrier() {
            this.committedBarrier = new CyclicBarrier(this.nservices, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ((DistributedTxCommitTask)DistributedTxCommitTask.this).state.lock.lock();
                    try {
                        DistributedTxCommitTask.this.committed.signal();
                        DistributedTxCommitTask.this.state.setCommitTime(DistributedTxCommitTask.this.commitTime);
                        DistributedTxCommitTask.this.state.setRunState(RunState.Committed);
                    }
                    finally {
                        ((DistributedTxCommitTask)DistributedTxCommitTask.this).state.lock.unlock();
                    }
                }
            });
        }

        protected class PrepareTask
        implements Callable<Void> {
            final ITxCommitProtocol service;

            public PrepareTask(ITxCommitProtocol service) {
                this.service = service;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                try {
                    this.service.prepare(((DistributedTxCommitTask)DistributedTxCommitTask.this).state.tx, DistributedTxCommitTask.this.revisionTime);
                }
                catch (Throwable e) {
                    try {
                        AbstractTransactionService.log.error((Object)e.getLocalizedMessage(), e);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    ((DistributedTxCommitTask)DistributedTxCommitTask.this).state.lock.lock();
                    try {
                        DistributedTxCommitTask.this.state.setRunState(RunState.Aborted);
                    }
                    finally {
                        ((DistributedTxCommitTask)DistributedTxCommitTask.this).state.lock.unlock();
                    }
                    throw new RuntimeException(e);
                }
                return null;
            }
        }

        private class TaskRunner
        implements Callable<Void> {
            @Override
            public Void call() throws Exception {
                List futures;
                assert (DistributedTxCommitTask.this.commitThread != Thread.currentThread());
                assert (!((DistributedTxCommitTask)DistributedTxCommitTask.this).state.lock.isHeldByCurrentThread());
                ArrayList<PrepareTask> tasks = new ArrayList<PrepareTask>(DistributedTxCommitTask.this.nservices);
                for (ITxCommitProtocol dataService : DistributedTxCommitTask.this.services) {
                    tasks.add(new PrepareTask(dataService));
                }
                try {
                    futures = DistributedTransactionService.this.getFederation().getExecutorService().invokeAll(tasks);
                    assert (DistributedTxCommitTask.this.state.isComplete()) : DistributedTxCommitTask.access$500(DistributedTxCommitTask.this).toString();
                }
                catch (Throwable t) {
                    AbstractTransactionService.log.error((Object)t.getLocalizedMessage(), t);
                    DistributedTxCommitTask.this.state.setRunState(RunState.Aborted);
                    throw new RuntimeException(t);
                }
                LinkedList<Throwable> causes = null;
                for (Future f : futures) {
                    try {
                        f.get();
                    }
                    catch (Throwable t) {
                        if (causes == null) {
                            causes = new LinkedList<Throwable>();
                        }
                        causes.add(t);
                        AbstractTransactionService.log.error((Object)t.getLocalizedMessage(), t);
                    }
                }
                if (causes != null) {
                    int nfailed = causes.size();
                    DistributedTxCommitTask.this.state.setRunState(RunState.Aborted);
                    throw new ExecutionExceptions("Committer(s) failed: n=" + DistributedTxCommitTask.this.nservices + ", nfailed=" + nfailed, causes);
                }
                return null;
            }
        }
    }

    private static class AbortTask
    implements Callable<Void> {
        private final ITxCommitProtocol service;
        private final AbstractTransactionService.TxState state;

        public AbortTask(ITxCommitProtocol service, AbstractTransactionService.TxState state) {
            if (service == null) {
                throw new IllegalArgumentException();
            }
            if (state == null) {
                throw new IllegalArgumentException();
            }
            this.service = service;
            this.state = state;
        }

        @Override
        public Void call() throws Exception {
            this.service.abort(this.state.tx);
            return null;
        }
    }

    public static class SnapshotHelper {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static long read(CommitTimeIndex ndx, File file) throws IOException {
            try (FileInputStream is = new FileInputStream(file);){
                BufferedInputStream bis = new BufferedInputStream(is);
                DataInputStream dis = new DataInputStream(bis);
                long l = SnapshotHelper.read(ndx, dis);
                return l;
            }
        }

        public static long read(CommitTimeIndex ndx, DataInputStream is) throws IOException {
            long n = is.readLong();
            int i = 0;
            while ((long)i < n) {
                ndx.add(is.readLong());
                ++i;
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static long write(CommitTimeIndex ndx, File file) throws IOException {
            try (FileOutputStream os = new FileOutputStream(file);){
                BufferedOutputStream bos = new BufferedOutputStream(os);
                DataOutputStream dos = new DataOutputStream(bos);
                long entryCount = SnapshotHelper.write(ndx, dos);
                dos.flush();
                bos.flush();
                long l = entryCount;
                return l;
            }
        }

        public static long write(CommitTimeIndex ndx, DataOutputStream os) throws IOException {
            long entryCount = ndx.getEntryCount();
            os.writeLong(entryCount);
            ITupleIterator itr = ndx.rangeIterator();
            int n = 0;
            while (itr.hasNext()) {
                ITuple tuple = itr.next();
                long commitTime = ndx.decodeKey(tuple.getKey());
                os.writeLong(commitTime);
                ++n;
            }
            if ((long)n != entryCount) {
                throw new AssertionError();
            }
            return entryCount;
        }
    }

    private class SnapshotTask
    implements Runnable {
        private SnapshotTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (DistributedTransactionService.this.isTransient) {
                throw new RuntimeException("Service is transient");
            }
            DistributedTransactionService.this.lock.lock();
            try {
                long entryCount;
                long begin = System.currentTimeMillis();
                int i = (int)DistributedTransactionService.this.snapshotCount % 2;
                File file = new File(DistributedTransactionService.this.dataDir, DistributedTransactionService.BASENAME + i + DistributedTransactionService.EXT);
                if (!(DistributedTransactionService.this.dataDir.exists() || DistributedTransactionService.this.dataDir.mkdirs() || DistributedTransactionService.this.dataDir.mkdirs())) {
                    throw new RuntimeException("Could not create: " + DistributedTransactionService.this.dataDir);
                }
                CommitTimeIndex commitTimeIndex = DistributedTransactionService.this.commitTimeIndex;
                synchronized (commitTimeIndex) {
                    entryCount = SnapshotHelper.write(DistributedTransactionService.this.commitTimeIndex, file);
                }
                DistributedTransactionService.this.snapshotCount++;
                long elapsed = System.currentTimeMillis() - begin;
                AbstractTransactionService.log.warn((Object)("snapshot: snapshotCount=" + DistributedTransactionService.this.snapshotCount + ", entryCount=" + entryCount + ", file=" + file + ", elapsed=" + elapsed));
            }
            catch (Throwable t) {
                AbstractTransactionService.log.error((Object)t.getMessage(), t);
                return;
            }
            finally {
                DistributedTransactionService.this.lock.unlock();
            }
        }
    }

    public static interface Options
    extends AbstractTransactionService.Options {
        public static final String DATA_DIR = DistributedTransactionService.class.getName() + ".dataDir";
        public static final String SHAPSHOT_INTERVAL = DistributedTransactionService.class.getName() + ".snapshotInterval";
        public static final String DEFAULT_SHAPSHOT_INTERVAL = "300000";
    }
}

