/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service;

import com.bigdata.counters.CAT;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.Instrument;
import com.bigdata.io.ByteBufferInputStream;
import com.bigdata.io.ByteBufferOutputStream;
import com.bigdata.util.DaemonThreadFactory;
import com.bigdata.util.concurrent.ShutdownHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import org.apache.log4j.Logger;

public abstract class ResourceService {
    protected static final Logger log = Logger.getLogger(ResourceService.class);
    private final InetSocketAddress addr;
    private final ServerSocket ss;
    private volatile boolean open = false;
    public final Counters counters = new Counters();
    private final Lock lock = new ReentrantLock();
    private final Condition running = this.lock.newCondition();
    private final ExecutorService acceptService = Executors.newSingleThreadExecutor((ThreadFactory)new DaemonThreadFactory(this.getClass().getName() + ".acceptService"));
    private final ExecutorService requestService;

    public InetSocketAddress getAddr() {
        return this.addr;
    }

    public ResourceService(InetSocketAddress addr, int requestServicePoolSize) throws IOException {
        if (addr == null) {
            throw new IllegalArgumentException();
        }
        if (requestServicePoolSize < 0) {
            throw new IllegalArgumentException();
        }
        this.ss = new ServerSocket(addr.getPort(), 0, addr.getAddress());
        this.addr = new InetSocketAddress(addr.getAddress(), this.ss.getLocalPort());
        if (log.isInfoEnabled()) {
            log.info((Object)("Running on addr=" + this.addr));
        }
        this.requestService = requestServicePoolSize == 0 ? (ThreadPoolExecutor)Executors.newCachedThreadPool((ThreadFactory)new DaemonThreadFactory(this.getClass().getName() + ".requestService")) : (ThreadPoolExecutor)Executors.newFixedThreadPool(requestServicePoolSize, (ThreadFactory)new DaemonThreadFactory(this.getClass().getName() + ".requestService"));
        this.acceptService.submit(new AcceptTask());
    }

    protected void finalize() throws Throwable {
        this.shutdownNow();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitRunning(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        long begin = System.nanoTime();
        long nanos = unit.toNanos(timeout);
        long remaining = nanos;
        if (this.lock.tryLock(remaining, TimeUnit.NANOSECONDS)) {
            try {
                while (!this.open && this.running.await(remaining = nanos - (System.nanoTime() - begin), TimeUnit.NANOSECONDS)) {
                }
                if (this.open) {
                    return;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        throw new TimeoutException();
    }

    public boolean isOpen() {
        return this.open;
    }

    public synchronized void shutdown() {
        if (!this.isOpen()) {
            log.warn((Object)"Not running");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"");
        }
        this.acceptService.shutdownNow();
        try {
            new ShutdownHelper(this.requestService, 10L, TimeUnit.SECONDS){

                @Override
                public void logTimeout() {
                    log.warn((Object)("Awaiting request service termination: elapsed=" + TimeUnit.NANOSECONDS.toMillis(this.elapsed()) + "ms"));
                }
            };
        }
        catch (InterruptedException ex) {
            log.warn((Object)"Interrupted awaiting request service termination.");
        }
        this.open = false;
        try {
            this.ss.close();
        }
        catch (IOException e) {
            log.warn((Object)e);
        }
    }

    public synchronized void shutdownNow() {
        if (!this.isOpen()) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"");
        }
        this.acceptService.shutdownNow();
        this.requestService.shutdownNow();
        this.open = false;
        try {
            this.ss.close();
        }
        catch (IOException e) {
            log.warn((Object)e);
        }
    }

    protected abstract File getResource(UUID var1) throws Exception;

    protected abstract ByteBuffer getBuffer(UUID var1) throws Exception;

    public static class Counters {
        public final CAT requestCount = new CAT();
        public final CAT denyCount = new CAT();
        public final CAT notFoundCount = new CAT();
        public final CAT internalErrorCount = new CAT();
        public final CAT writeErrorCount = new CAT();
        public final CAT nwrites = new CAT();
        public final CAT bytesWritten = new CAT();
        public long maxWriteSize;
        private final Object maxWriteSizeLock = new Object();
        public final CAT elapsedWriteNanos = new CAT();
        private CounterSet root = null;

        public synchronized CounterSet getCounters() {
            if (this.root == null) {
                this.root = new CounterSet();
                CounterSet tmp = this.root.makePath("status");
                tmp.addCounter("Request Count", new Instrument<Long>(){

                    @Override
                    public void sample() {
                        this.setValue(Counters.this.requestCount.get());
                    }
                });
                tmp.addCounter("Deny Count", new Instrument<Long>(){

                    @Override
                    public void sample() {
                        this.setValue(Counters.this.denyCount.get());
                    }
                });
                tmp.addCounter("Not Found Count", new Instrument<Long>(){

                    @Override
                    public void sample() {
                        this.setValue(Counters.this.notFoundCount.get());
                    }
                });
                tmp.addCounter("Internal Error Count", new Instrument<Long>(){

                    @Override
                    public void sample() {
                        this.setValue(Counters.this.internalErrorCount.get());
                    }
                });
                tmp = this.root.makePath("writes");
                tmp.addCounter("nwrites", new Instrument<Long>(){

                    @Override
                    public void sample() {
                        this.setValue(Counters.this.nwrites.get());
                    }
                });
                tmp.addCounter("bytesWritten", new Instrument<Long>(){

                    @Override
                    public void sample() {
                        this.setValue(Counters.this.bytesWritten.get());
                    }
                });
                tmp.addCounter("writeSecs", new Instrument<Double>(){

                    @Override
                    public void sample() {
                        double writeSecs = (double)Counters.this.elapsedWriteNanos.get() / 1.0E9;
                        this.setValue(writeSecs);
                    }
                });
                tmp.addCounter("bytesWrittenPerSec", new Instrument<Double>(){

                    @Override
                    public void sample() {
                        double writeSecs = (double)Counters.this.elapsedWriteNanos.get() / 1.0E9;
                        double bytesWrittenPerSec = writeSecs == 0.0 ? 0.0 : (double)Counters.this.bytesWritten.get() / writeSecs;
                        this.setValue(bytesWrittenPerSec);
                    }
                });
                tmp.addCounter("maxWriteSize", new Instrument<Long>(){

                    @Override
                    public void sample() {
                        this.setValue(Counters.this.maxWriteSize);
                    }
                });
            }
            return this.root;
        }
    }

    public static class ReadBufferTask
    extends FetchResourceTask<UUID, ByteBuffer> {
        protected static final Logger log = Logger.getLogger(ReadResourceTask.class);
        final UUID id;
        final ByteBuffer outbuf;

        public ReadBufferTask(InetSocketAddress addr, UUID id, ByteBuffer outbuf) {
            super(addr);
            if (id == null) {
                throw new IllegalArgumentException();
            }
            if (outbuf == null) {
                throw new IllegalArgumentException();
            }
            this.id = id;
            this.outbuf = outbuf;
        }

        @Override
        public UUID logId() {
            return this.id;
        }

        @Override
        public ByteBuffer logResource() {
            return this.outbuf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ByteBuffer call() throws Exception {
            Socket s = null;
            ByteBuffer b = this.outbuf.duplicate();
            ByteBufferOutputStream os = new ByteBufferOutputStream(b);
            try {
                s = new Socket(this.addr.getAddress(), this.addr.getPort());
                DataOutputStream dos = new DataOutputStream(s.getOutputStream());
                dos.writeByte(ResourceTypeEnum.BUFFER.get());
                dos.writeLong(this.id.getMostSignificantBits());
                dos.writeLong(this.id.getLeastSignificantBits());
                dos.flush();
                BufferedInputStream is = new BufferedInputStream(s.getInputStream());
                this.transfer(is, os);
                b.flip();
                ByteBuffer byteBuffer = b;
                return byteBuffer;
            }
            finally {
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (Throwable t) {}
                try {
                    os.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    public static class ReadResourceTask
    extends FetchResourceTask<UUID, File> {
        protected static final Logger log = Logger.getLogger(ReadResourceTask.class);
        final UUID uuid;
        final File file;

        public ReadResourceTask(InetSocketAddress addr, UUID uuid, File file) {
            super(addr);
            if (uuid == null) {
                throw new IllegalArgumentException();
            }
            if (file == null) {
                throw new IllegalArgumentException();
            }
            this.uuid = uuid;
            this.file = file;
        }

        @Override
        public UUID logId() {
            return this.uuid;
        }

        @Override
        public File logResource() {
            return this.file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public File call() throws Exception {
            Socket s = null;
            FileOutputStream os = new FileOutputStream(this.file);
            try {
                FileLock fileLock;
                if (log.isInfoEnabled()) {
                    log.info((Object)("uuid=" + this.uuid + ", localFile=" + this.file));
                }
                if ((fileLock = os.getChannel().tryLock()) == null) {
                    throw new IOException("File is already locked: " + this.file);
                }
                if (os.getChannel().size() != 0L) {
                    throw new IOException("File not empty: " + this.file);
                }
                s = new Socket(this.addr.getAddress(), this.addr.getPort());
                DataOutputStream dos = new DataOutputStream(s.getOutputStream());
                dos.writeByte(ResourceTypeEnum.FILE.get());
                dos.writeLong(this.uuid.getMostSignificantBits());
                dos.writeLong(this.uuid.getLeastSignificantBits());
                dos.flush();
                BufferedInputStream is = new BufferedInputStream(s.getInputStream());
                this.transfer(is, os);
                File file = this.file;
                return file;
            }
            finally {
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (Throwable t) {}
                try {
                    os.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    public static abstract class FetchResourceTask<S, T>
    implements Callable<T> {
        final InetSocketAddress addr;

        protected FetchResourceTask(InetSocketAddress addr) {
            if (addr == null) {
                throw new IllegalArgumentException();
            }
            this.addr = addr;
        }

        abstract S logId();

        abstract T logResource();

        public void transfer(InputStream is, OutputStream os) throws Exception {
            long length;
            long begin = System.nanoTime();
            DataInputStream dis = new DataInputStream(is);
            StatusEnum e = StatusEnum.valueOf(dis.readByte());
            switch (e) {
                case OK: {
                    length = dis.readLong();
                    break;
                }
                default: {
                    throw new IOException(e.toString() + ", id:" + this.logId());
                }
            }
            long nread = 0L;
            int BUFSIZE = 2048;
            CheckedInputStream cis = new CheckedInputStream(is, new Adler32());
            BufferedOutputStream bos = new BufferedOutputStream(os);
            byte[] buff = new byte[2048];
            while (nread < length) {
                long remaining = length - nread;
                int len = remaining > 2048L ? 2048 : (int)remaining;
                int read = cis.read(buff, 0, len);
                if (read <= 0) {
                    throw new IOException("EOF? #read=" + nread + ", length=" + length + ",id=" + this.logId());
                }
                if ((nread += (long)read) > length) {
                    throw new IOException("EOF? #read=" + nread + ", length=" + length + ",id=" + this.logId());
                }
                bos.write(buff, 0, read);
            }
            bos.flush();
            long checksum = cis.getChecksum().getValue();
            DataInputStream dis2 = new DataInputStream(is);
            long expected = dis2.readLong();
            if (expected != checksum) {
                throw new IOException("checksum error: id=" + this.logId());
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("read " + nread + " bytes, resource=" + this.logResource() + ", checksum=" + checksum + ", id=" + this.logId() + ", elapsed=" + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - begin) + "ms"));
            }
        }
    }

    private static class SentErrorException
    extends RuntimeException {
        private static final long serialVersionUID = 0L;

        private SentErrorException() {
        }
    }

    private class RequestTask
    implements Runnable {
        private final Socket s;
        private boolean sentStatus = false;

        public RequestTask(Socket s) {
            this.s = s;
            ResourceService.this.counters.requestCount.increment();
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 32[CASE]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendError(StatusEnum e) throws SentErrorException, IOException {
            assert (e != null);
            assert (e != StatusEnum.OK);
            switch (e) {
                case OK: {
                    throw new AssertionError();
                }
                case DENY: {
                    ResourceService.this.counters.denyCount.increment();
                    break;
                }
                case NOT_FOUND: {
                    ResourceService.this.counters.notFoundCount.increment();
                    break;
                }
                case INTERNAL_ERROR: {
                    ResourceService.this.counters.internalErrorCount.increment();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (!this.sentStatus) {
                OutputStream os = this.s.getOutputStream();
                try {
                    os.write(new byte[]{e.get()});
                    os.flush();
                }
                finally {
                    this.sentStatus = true;
                    os.close();
                }
            }
            throw new SentErrorException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void sendFile(UUID uuid, File file) throws SentErrorException, IOException {
            FileInputStream fis;
            long length = file.length();
            if (log.isInfoEnabled()) {
                log.info((Object)("Sending " + file + ", length=" + length + ", uuid=" + uuid));
            }
            try {
                fis = new FileInputStream(file);
            }
            catch (IOException ex) {
                log.error((Object)("Sending " + file + ", length=" + length + ", uuid=" + uuid), (Throwable)ex);
                this.sendError(StatusEnum.INTERNAL_ERROR);
                return;
            }
            try {
                try {
                    FileLock fileLock = fis.getChannel().tryLock(0L, Long.MAX_VALUE, true);
                    if (fileLock == null) {
                        throw new IOException("Resource is locked: " + file);
                    }
                    if (!fileLock.isShared()) {
                        fileLock.release();
                    }
                }
                catch (OverlappingFileLockException ex) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Will proceed without lock: file=" + file + " : " + ex));
                    }
                }
                catch (IOException ex) {
                    log.error((Object)("Sending " + file + ", length=" + length + ", uuid=" + uuid), (Throwable)ex);
                    this.sendError(StatusEnum.INTERNAL_ERROR);
                    try {
                        fis.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    return;
                }
                this.sendResource(uuid, file, length, fis);
                ResourceService.this.counters.nwrites.increment();
            }
            catch (Exception ex) {
                ResourceService.this.counters.writeErrorCount.increment();
                log.warn((Object)ex, (Throwable)ex);
                return;
            }
            finally {
                try {
                    fis.close();
                }
                catch (Throwable t) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void sendBuffer(UUID uuid, ByteBuffer buffer) throws SentErrorException, IOException {
            ByteBuffer b = buffer.asReadOnlyBuffer();
            int remaining = buffer.remaining();
            if (log.isInfoEnabled()) {
                log.info((Object)("Sending " + b + ", length=" + remaining + ", uuid=" + uuid));
            }
            ByteBufferInputStream fis = new ByteBufferInputStream(b);
            try {
                this.sendResource(uuid, b, remaining, fis);
                ResourceService.this.counters.nwrites.increment();
            }
            catch (Exception ex) {
                ResourceService.this.counters.writeErrorCount.increment();
                log.warn((Object)ex, (Throwable)ex);
                return;
            }
            finally {
                try {
                    fis.close();
                }
                catch (Throwable t) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendResource(UUID uuid, Object resource, long length, InputStream is) throws IOException {
            assert (uuid != null);
            assert (resource != null);
            assert (length >= 0L);
            assert (is != null);
            assert (!this.sentStatus);
            long bytesWritten = 0L;
            long begin = System.nanoTime();
            OutputStream os = this.s.getOutputStream();
            try {
                int read;
                DataOutputStream dos = new DataOutputStream(os);
                dos.write(new byte[]{StatusEnum.OK.get()});
                dos.writeLong(length);
                dos.flush();
                bytesWritten += 9L;
                this.sentStatus = true;
                int BUFSIZE = 2048;
                CheckedInputStream cis = new CheckedInputStream(new BufferedInputStream(is), new Adler32());
                byte[] buff = new byte[2048];
                while ((read = cis.read(buff, 0, 2048)) > 0) {
                    os.write(buff, 0, read);
                    bytesWritten += (long)read;
                }
                long checksum = cis.getChecksum().getValue();
                DataOutputStream dos2 = new DataOutputStream(os);
                dos2.writeLong(checksum);
                bytesWritten += 8L;
                dos2.flush();
                os.flush();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Sent: uuid=" + uuid + ", resource=" + resource + ", length=" + length + ", checksum=" + checksum + ", elapsed=" + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - begin) + "ms"));
                }
            }
            finally {
                try {
                    os.close();
                }
                catch (Throwable t) {}
                ResourceService.this.counters.bytesWritten.add(bytesWritten);
                ResourceService.this.counters.elapsedWriteNanos.add(System.nanoTime() - begin);
                Object object = ResourceService.this.counters.maxWriteSizeLock;
                synchronized (object) {
                    ResourceService.this.counters.maxWriteSize = Math.max(ResourceService.this.counters.maxWriteSize, bytesWritten);
                }
            }
        }
    }

    public static enum ResourceTypeEnum {
        FILE(0),
        BUFFER(1);

        private final byte b;

        private ResourceTypeEnum(int b) {
            this.b = (byte)b;
        }

        public byte get() {
            return this.b;
        }

        public static ResourceTypeEnum valueOf(byte b) {
            switch (b) {
                case 0: {
                    return FILE;
                }
                case 1: {
                    return BUFFER;
                }
            }
            throw new IllegalArgumentException("Invalid byte: " + b);
        }
    }

    public static enum StatusEnum {
        OK(0),
        DENY(1),
        NOT_FOUND(2),
        INTERNAL_ERROR(3);

        private final byte b;

        private StatusEnum(int b) {
            this.b = (byte)b;
        }

        public byte get() {
            return this.b;
        }

        public static StatusEnum valueOf(byte b) {
            switch (b) {
                case 0: {
                    return OK;
                }
                case 1: {
                    return NOT_FOUND;
                }
                case 2: {
                    return INTERNAL_ERROR;
                }
            }
            throw new IllegalArgumentException("Invalid byte: " + b);
        }
    }

    private class AcceptTask
    implements Runnable {
        private AcceptTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ResourceService.this.lock.lock();
            try {
                ResourceService.this.open = true;
                ResourceService.this.running.signal();
            }
            finally {
                ResourceService.this.lock.unlock();
            }
            try {
                while (ResourceService.this.open) {
                    ResourceService.this.requestService.submit(new RequestTask(ResourceService.this.ss.accept()));
                }
            }
            catch (IOException ex) {
                if (!ResourceService.this.open) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"closed.");
                    }
                    return;
                }
                log.error((Object)ex);
            }
        }
    }
}

