/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.geospatial;

import com.bigdata.rdf.internal.gis.ICoordinate;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;

public interface GeoSpatial {
    public static final String CUSTOM_FIELDS_SEPARATOR = "#";
    public static final String NAMESPACE = "http://www.bigdata.com/rdf/geospatial#";
    @Deprecated
    public static final URI DEFAULT_DATATYPE = new URIImpl("http://www.bigdata.com/rdf/geospatial#geoSpatialLiteral");
    public static final String GEOSPATIAL_LITERAL_PREFIX_V1 = "http://www.bigdata.com/rdf/geospatial/literals/v1#";
    public static final String GEOSPATIAL_LITERAL_V1_LAT_LON = "http://www.bigdata.com/rdf/geospatial/literals/v1#lat-lon";
    public static final String GEOSPATIAL_LITERAL_V1_LAT_LON_TIME = "http://www.bigdata.com/rdf/geospatial/literals/v1#lat-lon-time";
    public static final URI DEFAULT_DATATYPE_LAT_LON = new URIImpl("http://www.bigdata.com/rdf/geospatial/literals/v1#lat-lon");
    public static final URI DEFAULT_DATATYPE_LAT_LON_TIME = new URIImpl("http://www.bigdata.com/rdf/geospatial/literals/v1#lat-lon-time");
    public static final URI SEARCH = new URIImpl("http://www.bigdata.com/rdf/geospatial#search");
    public static final URI SEARCH_DATATYPE = new URIImpl("http://www.bigdata.com/rdf/geospatial#searchDatatype");
    public static final URI PREDICATE = new URIImpl("http://www.bigdata.com/rdf/geospatial#predicate");
    public static final URI CONTEXT = new URIImpl("http://www.bigdata.com/rdf/geospatial#context");
    public static final URI SPATIAL_CIRCLE_CENTER = new URIImpl("http://www.bigdata.com/rdf/geospatial#spatialCircleCenter");
    public static final URI SPATIAL_CIRCLE_RADIUS = new URIImpl("http://www.bigdata.com/rdf/geospatial#spatialCircleRadius");
    public static final URI SPATIAL_RECTANGLE_SOUTH_WEST = new URIImpl("http://www.bigdata.com/rdf/geospatial#spatialRectangleSouthWest");
    public static final URI SPATIAL_RECTANGLE_NORTH_EAST = new URIImpl("http://www.bigdata.com/rdf/geospatial#spatialRectangleNorthEast");
    public static final URI SPATIAL_UNIT = new URIImpl("http://www.bigdata.com/rdf/geospatial#spatialUnit");
    public static final URI DISTANCE_VALUE = new URIImpl("http://www.bigdata.com/rdf/geospatial#distanceValue");
    public static final URI TIME_START = new URIImpl("http://www.bigdata.com/rdf/geospatial#timeStart");
    public static final URI TIME_END = new URIImpl("http://www.bigdata.com/rdf/geospatial#timeEnd");
    public static final URI COORD_SYSTEM = new URIImpl("http://www.bigdata.com/rdf/geospatial#coordSystem");
    public static final URI CUSTOM_FIELDS = new URIImpl("http://www.bigdata.com/rdf/geospatial#customFields");
    public static final URI CUSTOM_FIELDS_LOWER_BOUNDS = new URIImpl("http://www.bigdata.com/rdf/geospatial#customFieldsLowerBounds");
    public static final URI CUSTOM_FIELDS_UPPER_BOUNDS = new URIImpl("http://www.bigdata.com/rdf/geospatial#customFieldsUpperBounds");
    public static final URI LOCATION_VALUE = new URIImpl("http://www.bigdata.com/rdf/geospatial#locationValue");
    public static final URI TIME_VALUE = new URIImpl("http://www.bigdata.com/rdf/geospatial#timeValue");
    public static final URI LITERAL_VALUE = new URIImpl("http://www.bigdata.com/rdf/geospatial#literalValue");
    public static final URI LAT_VALUE = new URIImpl("http://www.bigdata.com/rdf/geospatial#latValue");
    public static final URI LON_VALUE = new URIImpl("http://www.bigdata.com/rdf/geospatial#lonValue");
    public static final URI COORD_SYSTEM_VALUE = new URIImpl("http://www.bigdata.com/rdf/geospatial#coordSystemValue");
    public static final URI CUSTOM_FIELDS_VALUES = new URIImpl("http://www.bigdata.com/rdf/geospatial#customFieldsValues");
    public static final URI LOCATION_AND_TIME_VALUE = new URIImpl("http://www.bigdata.com/rdf/geospatial#locationAndTimeValue");

    public static interface Options {
        public static final String GEO_FUNCTION = GeoSpatial.class.getName() + ".defaultGeoFunction";
        public static final String GEO_SPATIAL_UNIT = GeoSpatial.class.getName() + ".defaultSpatialUnit";
        public static final ICoordinate.UNITS DEFAULT_GEO_SPATIAL_UNIT = ICoordinate.UNITS.Kilometers;
    }

    public static enum GeoFunction {
        IN_CIRCLE("inCircle"),
        IN_RECTANGLE("inRectangle"),
        UNDEFINED("undefined");

        private String name;

        private GeoFunction(String name) {
            this.name = name;
        }

        public static GeoFunction forName(String name) {
            for (GeoFunction e : GeoFunction.values()) {
                if (!e.toString().equalsIgnoreCase(name)) continue;
                return e;
            }
            return null;
        }

        public String toString() {
            return this.name;
        }
    }
}

