/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.geospatial.impl;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.rdf.internal.gis.CoordinateDD;
import com.bigdata.rdf.internal.gis.CoordinateUtility;
import com.bigdata.rdf.internal.gis.ICoordinate;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.service.geospatial.GeoSpatial;
import com.bigdata.service.geospatial.GeoSpatialConfig;
import com.bigdata.service.geospatial.GeoSpatialDatatypeConfiguration;
import com.bigdata.service.geospatial.GeoSpatialDatatypeFieldConfiguration;
import com.bigdata.service.geospatial.GeoSpatialSearchException;
import com.bigdata.service.geospatial.IGeoSpatialQuery;
import com.bigdata.service.geospatial.impl.GeoSpatialUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.openrdf.model.URI;

public class GeoSpatialQuery
implements IGeoSpatialQuery {
    private static final Logger log = Logger.getLogger(GeoSpatialQuery.class);
    private final GeoSpatialConfig geoSpatialConfig;
    private final GeoSpatial.GeoFunction searchFunction;
    private final URI searchDatatype;
    private final IConstant<?> subject;
    private final TermNode predicate;
    private final TermNode context;
    private final GeoSpatialUtility.PointLatLon spatialCircleCenter;
    private final Double spatialCircleRadius;
    private final GeoSpatialUtility.PointLatLon spatialRectangleSouthWest;
    private final GeoSpatialUtility.PointLatLon spatialRectangleNorthEast;
    private final ICoordinate.UNITS spatialUnit;
    private final Long timeStart;
    private final Long timeEnd;
    private final Long coordSystem;
    private final Map<String, IGeoSpatialQuery.LowerAndUpperValue> customFieldsConstraints;
    private final IVariable<?> locationVar;
    private final IVariable<?> timeVar;
    private final IVariable<?> locationAndTimeVar;
    private final IVariable<?> latVar;
    private final IVariable<?> lonVar;
    private final IVariable<?> coordSystemVar;
    private final IVariable<?> customFieldsVar;
    private final IVariable<?> literalVar;
    private final IVariable<?> distanceVar;
    private final IBindingSet incomingBindings;
    final GeoSpatialDatatypeConfiguration datatypeConfig;
    CoordinateDD lowerBoundingBox = null;
    CoordinateDD upperBoundingBox = null;

    public GeoSpatialQuery(GeoSpatialConfig geoSpatialConfig, GeoSpatial.GeoFunction searchFunction, URI searchDatatype, IConstant<?> subject, TermNode predicate, TermNode context, GeoSpatialUtility.PointLatLon spatialCircleCenter, Double spatialCircleRadius, GeoSpatialUtility.PointLatLon spatialRectangleSouthWest, GeoSpatialUtility.PointLatLon spatialRectangleNorthEast, ICoordinate.UNITS spatialUnit, Long timeStart, Long timeEnd, Long coordSystem, Map<String, IGeoSpatialQuery.LowerAndUpperValue> customFieldsConstraints, IVariable<?> locationVar, IVariable<?> timeVar, IVariable<?> locationAndTimeVar, IVariable<?> latVar, IVariable<?> lonVar, IVariable<?> coordSystemVar, IVariable<?> customFieldsVar, IVariable<?> literalVar, IVariable<?> distanceVar, IBindingSet incomingBindings) {
        this.geoSpatialConfig = geoSpatialConfig;
        this.searchFunction = searchFunction;
        this.searchDatatype = searchDatatype;
        this.subject = subject;
        this.predicate = predicate;
        this.context = context;
        this.spatialCircleCenter = spatialCircleCenter;
        this.spatialCircleRadius = spatialCircleRadius;
        this.spatialRectangleSouthWest = spatialRectangleSouthWest;
        this.spatialRectangleNorthEast = spatialRectangleNorthEast;
        this.spatialUnit = spatialUnit;
        this.timeStart = timeStart;
        this.timeEnd = timeEnd;
        this.coordSystem = coordSystem;
        this.customFieldsConstraints = customFieldsConstraints;
        this.locationVar = locationVar;
        this.timeVar = timeVar;
        this.locationAndTimeVar = locationAndTimeVar;
        this.latVar = latVar;
        this.lonVar = lonVar;
        this.coordSystemVar = coordSystemVar;
        this.customFieldsVar = customFieldsVar;
        this.incomingBindings = incomingBindings;
        this.literalVar = literalVar;
        this.distanceVar = distanceVar;
        this.datatypeConfig = geoSpatialConfig.getConfigurationForDatatype(searchDatatype);
        if (this.datatypeConfig == null) {
            throw new GeoSpatialSearchException("Unknown datatype configuration for geospatial search query: " + searchDatatype);
        }
        this.assertConsistency();
        this.computeLowerAndUpperBoundingBoxIfNotSet();
    }

    private GeoSpatialQuery(GeoSpatialConfig geoSpatialConfig, GeoSpatial.GeoFunction searchFunction, URI searchDatatype, IConstant<?> subject, TermNode predicate, TermNode context, GeoSpatialUtility.PointLatLon spatialCircleCenter, Double spatialCircleRadius, GeoSpatialUtility.PointLatLon spatialRectangleSouthWest, GeoSpatialUtility.PointLatLon spatialRectangleNorthEast, ICoordinate.UNITS spatialUnit, Long timeStart, Long timeEnd, Long coordSystem, Map<String, IGeoSpatialQuery.LowerAndUpperValue> customFieldsConstraints, IVariable<?> locationVar, IVariable<?> timeVar, IVariable<?> locationAndTimeVar, IVariable<?> latVar, IVariable<?> lonVar, IVariable<?> coordSystemVar, IVariable<?> customFieldsVar, IVariable<?> literalVar, IVariable<?> distanceVar, IBindingSet incomingBindings, CoordinateDD lowerBoundingBox, CoordinateDD upperBoundingBox) {
        this(geoSpatialConfig, searchFunction, searchDatatype, subject, predicate, context, spatialCircleCenter, spatialCircleRadius, spatialRectangleSouthWest, spatialRectangleNorthEast, spatialUnit, timeStart, timeEnd, coordSystem, customFieldsConstraints, locationVar, timeVar, locationAndTimeVar, latVar, lonVar, coordSystemVar, customFieldsVar, literalVar, distanceVar, incomingBindings);
        this.lowerBoundingBox = lowerBoundingBox;
        this.upperBoundingBox = upperBoundingBox;
    }

    public static Map<String, IGeoSpatialQuery.LowerAndUpperValue> toValidatedCustomFieldsConstraints(String[] customFields, Object[] customFieldsLowerBounds, Object[] customFieldsUpperBounds) {
        HashMap<String, IGeoSpatialQuery.LowerAndUpperValue> customFieldsConstraints = new HashMap<String, IGeoSpatialQuery.LowerAndUpperValue>();
        if (customFields.length != customFieldsLowerBounds.length) {
            throw new GeoSpatialSearchException("Nr of custom fields = " + customFields.length + " differs from number of lower bounds = " + customFieldsLowerBounds.length);
        }
        if (customFields.length != customFieldsUpperBounds.length) {
            throw new GeoSpatialSearchException("Nr of custom fields = " + customFields.length + " differs from number of upper bounds = " + customFieldsUpperBounds.length);
        }
        for (int i = 0; i < customFields.length; ++i) {
            customFieldsConstraints.put(customFields[i], new IGeoSpatialQuery.LowerAndUpperValue(customFieldsLowerBounds[i], customFieldsUpperBounds[i]));
        }
        return customFieldsConstraints;
    }

    @Override
    public GeoSpatial.GeoFunction getSearchFunction() {
        return this.searchFunction;
    }

    @Override
    public URI getSearchDatatype() {
        return this.searchDatatype;
    }

    @Override
    public IConstant<?> getSubject() {
        return this.subject;
    }

    @Override
    public TermNode getPredicate() {
        return this.predicate;
    }

    @Override
    public TermNode getContext() {
        return this.context;
    }

    @Override
    public GeoSpatialUtility.PointLatLon getSpatialCircleCenter() {
        return this.spatialCircleCenter;
    }

    @Override
    public Double getSpatialCircleRadius() {
        return this.spatialCircleRadius;
    }

    @Override
    public GeoSpatialUtility.PointLatLon getSpatialRectangleSouthWest() {
        return this.spatialRectangleSouthWest;
    }

    @Override
    public GeoSpatialUtility.PointLatLon getSpatialRectangleNorthEast() {
        return this.spatialRectangleNorthEast;
    }

    @Override
    public ICoordinate.UNITS getSpatialUnit() {
        return this.spatialUnit;
    }

    @Override
    public Long getTimeStart() {
        return this.timeStart;
    }

    @Override
    public Long getTimeEnd() {
        return this.timeEnd;
    }

    @Override
    public Long getCoordSystem() {
        return this.coordSystem;
    }

    @Override
    public Map<String, IGeoSpatialQuery.LowerAndUpperValue> getCustomFieldsConstraints() {
        return this.customFieldsConstraints;
    }

    @Override
    public IVariable<?> getLocationVar() {
        return this.locationVar;
    }

    @Override
    public IVariable<?> getTimeVar() {
        return this.timeVar;
    }

    @Override
    public IVariable<?> getLatVar() {
        return this.latVar;
    }

    @Override
    public IVariable<?> getLonVar() {
        return this.lonVar;
    }

    @Override
    public IVariable<?> getCoordSystemVar() {
        return this.coordSystemVar;
    }

    @Override
    public IVariable<?> getCustomFieldsVar() {
        return this.customFieldsVar;
    }

    @Override
    public IVariable<?> getLocationAndTimeVar() {
        return this.locationAndTimeVar;
    }

    @Override
    public IVariable<?> getLiteralVar() {
        return this.literalVar;
    }

    @Override
    public IVariable<?> getDistanceVar() {
        return this.distanceVar;
    }

    @Override
    public IBindingSet getIncomingBindings() {
        return this.incomingBindings;
    }

    @Override
    public IGeoSpatialQuery.LowerAndUpperBound getLowerAndUpperBound() {
        if (!this.isNormalized()) {
            throw new AssertionError((Object)"Query must be normalized prior to extracting bounds");
        }
        int numDimensions = this.datatypeConfig.getNumDimensions();
        List<GeoSpatialDatatypeFieldConfiguration> fields = this.datatypeConfig.getFields();
        int latIdx = -1;
        int lonIdx = -1;
        Object[] lowerBound = new Object[numDimensions];
        Object[] upperBound = new Object[numDimensions];
        block7: for (int i = 0; i < numDimensions; ++i) {
            GeoSpatialDatatypeFieldConfiguration field = fields.get(i);
            switch (field.getServiceMapping()) {
                case LATITUDE: {
                    if (latIdx != -1) {
                        throw new AssertionError((Object)"Multiple latitude mappings for datatype in query.");
                    }
                    latIdx = i;
                    continue block7;
                }
                case LONGITUDE: {
                    if (lonIdx != -1) {
                        throw new AssertionError((Object)"Multiple longitude mappings for datatype in query.");
                    }
                    lonIdx = i;
                    continue block7;
                }
                case TIME: {
                    if (this.getTimeStart() == null) {
                        throw new GeoSpatialSearchException("Start time not specified in query, but required.");
                    }
                    if (this.getTimeEnd() == null) {
                        throw new GeoSpatialSearchException("End time not specified in query, but required.");
                    }
                    lowerBound[i] = this.getTimeStart();
                    upperBound[i] = this.getTimeEnd();
                    continue block7;
                }
                case COORD_SYSTEM: {
                    if (this.getCoordSystem() == null) {
                        throw new GeoSpatialSearchException("Coordinate system not specified in query, but required.");
                    }
                    lowerBound[i] = this.getCoordSystem();
                    upperBound[i] = this.getCoordSystem();
                    continue block7;
                }
                case CUSTOM: {
                    String customServiceMapping = field.getCustomServiceMapping();
                    if (!this.customFieldsConstraints.containsKey(customServiceMapping)) {
                        throw new GeoSpatialSearchException("Custom field " + customServiceMapping + " not specified in query, but required.");
                    }
                    IGeoSpatialQuery.LowerAndUpperValue v = this.customFieldsConstraints.get(customServiceMapping);
                    lowerBound[i] = v.lowerValue;
                    upperBound[i] = v.upperValue;
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("Cases not implemented");
                }
            }
        }
        if (latIdx != -1 && lonIdx != -1) {
            lowerBound[latIdx] = this.lowerBoundingBox.northSouth;
            lowerBound[lonIdx] = this.lowerBoundingBox.eastWest;
            upperBound[latIdx] = this.upperBoundingBox.northSouth;
            upperBound[lonIdx] = this.upperBoundingBox.eastWest;
        } else if (!(latIdx == -1 && lonIdx == -1 || latIdx != -1 && lonIdx != -1)) {
            throw new GeoSpatialSearchException("Latitude and longitude must either both be given or not given.");
        }
        return new IGeoSpatialQuery.LowerAndUpperBound(lowerBound, upperBound);
    }

    @Override
    public List<IGeoSpatialQuery> normalize() {
        if (!this.isSatisfiable()) {
            return new ArrayList<IGeoSpatialQuery>();
        }
        if (this.lowerBoundingBox != null && this.upperBoundingBox != null && this.lowerBoundingBox.eastWest > this.upperBoundingBox.eastWest) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Search rectangle upper left latitude (" + this.lowerBoundingBox.eastWest + ") is larger than rectangle lower righ latitude (" + this.upperBoundingBox.eastWest + ". Search will be split into two search windows."));
            }
            ArrayList<IGeoSpatialQuery> normalizedQueries = new ArrayList<IGeoSpatialQuery>(2);
            GeoSpatialQuery query1 = new GeoSpatialQuery(this.geoSpatialConfig, this.searchFunction, this.searchDatatype, this.subject, this.predicate, this.context, this.spatialCircleCenter, this.spatialCircleRadius, this.spatialRectangleSouthWest, this.spatialRectangleNorthEast, this.spatialUnit, this.timeStart, this.timeEnd, this.coordSystem, this.customFieldsConstraints, this.locationVar, this.timeVar, this.locationAndTimeVar, this.latVar, this.lonVar, this.coordSystemVar, this.customFieldsVar, this.literalVar, this.distanceVar, this.incomingBindings, new CoordinateDD(this.lowerBoundingBox.northSouth, Math.nextAfter(-180.0, 0.0)), new CoordinateDD(this.upperBoundingBox.northSouth, this.upperBoundingBox.eastWest));
            normalizedQueries.add(query1);
            GeoSpatialQuery query2 = new GeoSpatialQuery(this.geoSpatialConfig, this.searchFunction, this.searchDatatype, this.subject, this.predicate, this.context, this.spatialCircleCenter, this.spatialCircleRadius, this.spatialRectangleSouthWest, this.spatialRectangleNorthEast, this.spatialUnit, this.timeStart, this.timeEnd, this.coordSystem, this.customFieldsConstraints, this.locationVar, this.timeVar, this.locationAndTimeVar, this.latVar, this.lonVar, this.coordSystemVar, this.customFieldsVar, this.literalVar, this.distanceVar, this.incomingBindings, new CoordinateDD(this.lowerBoundingBox.northSouth, this.lowerBoundingBox.eastWest), new CoordinateDD(this.upperBoundingBox.northSouth, 180.0));
            normalizedQueries.add(query2);
            return normalizedQueries;
        }
        return Arrays.asList(this);
    }

    @Override
    public boolean isNormalized() {
        if (this.lowerBoundingBox != null && this.upperBoundingBox != null) {
            if (this.lowerBoundingBox.eastWest > this.upperBoundingBox.eastWest) {
                return false;
            }
            if (this.lowerBoundingBox.northSouth > this.upperBoundingBox.northSouth) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isSatisfiable() {
        if (this.lowerBoundingBox != null && this.upperBoundingBox != null && this.lowerBoundingBox.northSouth > this.upperBoundingBox.northSouth) {
            return false;
        }
        if (this.timeStart != null && this.timeEnd != null && this.timeStart > this.timeEnd) {
            return false;
        }
        Map<String, IGeoSpatialQuery.LowerAndUpperValue> cfcs = this.getCustomFieldsConstraints();
        for (String key : cfcs.keySet()) {
            IGeoSpatialQuery.LowerAndUpperValue val = cfcs.get(key);
            if (!GeoSpatialQuery.gt(val.lowerValue, val.upperValue)) continue;
            return false;
        }
        return true;
    }

    void assertConsistency() {
        if (this.predicate == null) {
            throw new GeoSpatialSearchException(GeoSpatial.PREDICATE + " must be bound but is null.");
        }
        if (this.searchDatatype == null) {
            throw new GeoSpatialSearchException(GeoSpatial.SEARCH_DATATYPE + " must be bound but is null.");
        }
        if (!(this.locationVar == null && this.locationAndTimeVar == null && this.latVar == null && this.lonVar == null && this.distanceVar == null || this.datatypeConfig.hasLat() && this.datatypeConfig.hasLon())) {
            throw new GeoSpatialSearchException("Requested extraction of geospatial coordinates (via " + GeoSpatial.LOCATION_AND_TIME_VALUE + ", " + GeoSpatial.LOCATION_AND_TIME_VALUE + ", " + GeoSpatial.LAT_VALUE + ", " + GeoSpatial.LON_VALUE + " or " + GeoSpatial.DISTANCE_VALUE + ")" + " but the index contains no geospatial coordinates. " + "Please remove the respective predicated from your query.");
        }
        if (this.timeVar != null && !this.datatypeConfig.hasTime()) {
            throw new GeoSpatialSearchException("Requested extraction of time via " + GeoSpatial.TIME_VALUE + " but index does not contain time component.");
        }
        if (this.locationAndTimeVar != null && !this.datatypeConfig.hasTime()) {
            throw new GeoSpatialSearchException("Requested extraction of time via " + GeoSpatial.LOCATION_AND_TIME_VALUE + " but index does not contain time component.");
        }
        if (this.coordSystemVar != null && !this.datatypeConfig.hasCoordSystem()) {
            throw new GeoSpatialSearchException("Requested extraction of coordinate system via " + GeoSpatial.COORD_SYSTEM_VALUE + " but index does not contain coordinate system component.");
        }
        if (this.customFieldsVar != null && !this.datatypeConfig.hasCustomFields()) {
            throw new GeoSpatialSearchException("Requested extraction of custom fields via " + GeoSpatial.CUSTOM_FIELDS_VALUES + " but index does not define any custom fields.");
        }
        Set<String> datatypeCustomFields = this.datatypeConfig.getCustomFieldsIdxs().keySet();
        if (!this.getCustomFieldsConstraints().keySet().containsAll(datatypeCustomFields) || !datatypeCustomFields.containsAll(this.getCustomFieldsConstraints().keySet())) {
            throw new GeoSpatialSearchException("The custom fields defined in the datatype (" + Arrays.toString(datatypeCustomFields.toArray()) + ") differs from the custom fields defined in the query (" + Arrays.toString(this.getCustomFieldsConstraints().keySet().toArray()) + "). " + "You need to specify the upper and lower bounds for all custom components of " + "the index using predicates " + GeoSpatial.CUSTOM_FIELDS + ", " + GeoSpatial.CUSTOM_FIELDS_LOWER_BOUNDS + ", and " + GeoSpatial.CUSTOM_FIELDS_UPPER_BOUNDS + ".");
        }
        switch (this.searchFunction) {
            case IN_CIRCLE: {
                if (!this.datatypeConfig.hasLat() || !this.datatypeConfig.hasLon()) {
                    throw new GeoSpatialSearchException("Search function inCircle used for datatype having no geospatial components.");
                }
                if (this.spatialCircleCenter == null) {
                    throw new GeoSpatialSearchException("Predicate " + GeoSpatial.SPATIAL_CIRCLE_CENTER + " not supported for search function inCircle.");
                }
                if (this.spatialCircleRadius == null) {
                    throw new GeoSpatialSearchException("Predicate " + GeoSpatial.SPATIAL_CIRCLE_RADIUS + " not supported for search function inCircle.");
                }
                if (this.spatialRectangleSouthWest != null) {
                    throw new GeoSpatialSearchException("Predicate " + GeoSpatial.SPATIAL_RECTANGLE_SOUTH_WEST + " not supported for search function inCircle.");
                }
                if (this.spatialRectangleNorthEast == null) break;
                throw new GeoSpatialSearchException("Predicate " + GeoSpatial.SPATIAL_RECTANGLE_NORTH_EAST + " not supported for search function inCircle.");
            }
            case IN_RECTANGLE: {
                if (!this.datatypeConfig.hasLat() || !this.datatypeConfig.hasLon()) {
                    throw new GeoSpatialSearchException("Search function inRectangle used for datatype having no geospatial components.");
                }
                if (this.spatialRectangleSouthWest == null) {
                    throw new GeoSpatialSearchException("Predicate " + GeoSpatial.SPATIAL_RECTANGLE_SOUTH_WEST + " not supported for search function inRectangle.");
                }
                if (this.spatialRectangleNorthEast == null) {
                    throw new GeoSpatialSearchException("Predicate " + GeoSpatial.SPATIAL_RECTANGLE_NORTH_EAST + " not supported for search function inRectangle.");
                }
                if (this.spatialCircleCenter != null) {
                    throw new GeoSpatialSearchException("Predicate " + GeoSpatial.SPATIAL_CIRCLE_CENTER + " not supported for search function inRectangle.");
                }
                if (this.spatialCircleRadius != null) {
                    throw new GeoSpatialSearchException("Predicate " + GeoSpatial.SPATIAL_CIRCLE_RADIUS + " not supported for search function inRectangle.");
                }
                if (this.distanceVar == null) break;
                throw new GeoSpatialSearchException("Predicate " + GeoSpatial.DISTANCE_VALUE + " not supported for search function inRectangle.");
            }
            case UNDEFINED: {
                if (this.datatypeConfig.hasLat() || this.datatypeConfig.hasLon()) {
                    throw new GeoSpatialSearchException("No search function given, but required since datatype has geospatial components.");
                }
                if (this.spatialCircleCenter != null) {
                    throw new GeoSpatialSearchException("Predicate " + GeoSpatial.SPATIAL_CIRCLE_CENTER + " must not be provided " + "for query against index without geospatial components.");
                }
                if (this.spatialCircleRadius != null) {
                    throw new GeoSpatialSearchException("Predicate " + GeoSpatial.SPATIAL_CIRCLE_RADIUS + " must not be provided " + "for query against index without geospatial components.");
                }
                if (this.spatialRectangleSouthWest != null) {
                    throw new GeoSpatialSearchException("Predicate " + GeoSpatial.SPATIAL_RECTANGLE_SOUTH_WEST + " must not be provided " + "for query against index without geospatial components.");
                }
                if (this.spatialRectangleNorthEast == null) break;
                throw new GeoSpatialSearchException("Predicate " + GeoSpatial.SPATIAL_RECTANGLE_NORTH_EAST + " must not be provided " + "for query against index without geospatial components.");
            }
            default: {
                throw new GeoSpatialSearchException("Unhandled search function: " + (Object)((Object)this.searchFunction));
            }
        }
        if (this.datatypeConfig.hasTime() && (this.timeStart == null || this.timeEnd == null)) {
            throw new GeoSpatialSearchException("Predicate " + GeoSpatial.TIME_START + " and " + GeoSpatial.TIME_END + " must be provided when querying index with time component");
        }
        if (!(this.timeStart == null && this.timeEnd == null || this.datatypeConfig.hasTime())) {
            throw new GeoSpatialSearchException("Predicate " + GeoSpatial.TIME_START + " or " + GeoSpatial.TIME_END + " specified in query, but datatype that is queried does not have a time component.");
        }
        if (this.datatypeConfig.hasCoordSystem() && this.coordSystem == null) {
            throw new GeoSpatialSearchException("Predicate " + GeoSpatial.COORD_SYSTEM + " must be provided when querying index with coordinate system component");
        }
        if (this.coordSystem != null && !this.datatypeConfig.hasCoordSystem()) {
            throw new GeoSpatialSearchException("Predicate " + GeoSpatial.COORD_SYSTEM + " specified in query, " + "but datatype that is queried does not have a coordinate system component.");
        }
    }

    @Override
    public GeoSpatialDatatypeConfiguration getDatatypeConfig() {
        return this.datatypeConfig;
    }

    private void computeLowerAndUpperBoundingBoxIfNotSet() {
        if (this.lowerBoundingBox != null && this.upperBoundingBox != null) {
            return;
        }
        int numDimensions = this.datatypeConfig.getNumDimensions();
        List<GeoSpatialDatatypeFieldConfiguration> fields = this.datatypeConfig.getFields();
        int latIdx = -1;
        int lonIdx = -1;
        block8: for (int i = 0; i < numDimensions; ++i) {
            GeoSpatialDatatypeFieldConfiguration field = fields.get(i);
            switch (field.getServiceMapping()) {
                case LATITUDE: {
                    if (latIdx != -1) {
                        throw new AssertionError((Object)"Multiple latitude mappings for datatype in query.");
                    }
                    latIdx = i;
                    continue block8;
                }
                case LONGITUDE: {
                    if (lonIdx != -1) {
                        throw new AssertionError((Object)"Multiple longitude mappings for datatype in query..");
                    }
                    lonIdx = i;
                    continue block8;
                }
            }
        }
        if (latIdx != -1 && lonIdx != -1) {
            switch (this.searchFunction) {
                case IN_CIRCLE: {
                    CoordinateDD centerPointDD = this.spatialCircleCenter.asCoordinateDD();
                    this.lowerBoundingBox = CoordinateUtility.boundingBoxSouthWest(centerPointDD, this.spatialCircleRadius, this.spatialUnit);
                    this.upperBoundingBox = CoordinateUtility.boundingBoxNorthEast(centerPointDD, this.spatialCircleRadius, this.spatialUnit);
                    break;
                }
                case IN_RECTANGLE: {
                    this.lowerBoundingBox = this.spatialRectangleSouthWest.asCoordinateDD();
                    this.upperBoundingBox = this.spatialRectangleNorthEast.asCoordinateDD();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Search function (geo:search) must be defined.");
                }
            }
        }
    }

    private static boolean gt(Object lower, Object upper) {
        if (lower instanceof Double && upper instanceof Double) {
            return (Double)lower > (Double)upper;
        }
        if (lower instanceof Long && upper instanceof Long) {
            return (Long)lower > (Long)upper;
        }
        throw new GeoSpatialSearchException("Incompatible types for lower and upper bound. Something's wrong in the implementation.");
    }
}

