/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.ndx;

import com.bigdata.btree.proc.AbstractKeyRangeIndexProcedure;
import com.bigdata.btree.proc.IKeyRangeIndexProcedure;
import com.bigdata.btree.proc.IResultHandler;
import com.bigdata.service.AbstractClient;
import com.bigdata.service.Split;
import com.bigdata.service.ndx.AbstractDataServiceProcedureTask;
import com.bigdata.service.ndx.ClientIndexView;
import com.bigdata.service.ndx.IScaleOutClientIndex;
import com.bigdata.service.ndx.IndexSyncRPCCounters;
import java.util.concurrent.atomic.AtomicInteger;

class KeyRangeDataServiceProcedureTask
extends AbstractDataServiceProcedureTask {
    final byte[] fromKey;
    final byte[] toKey;

    @Override
    protected int getElementCount() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyRangeDataServiceProcedureTask(IScaleOutClientIndex ndx, byte[] fromKey, byte[] toKey, long ts, Split split, IKeyRangeIndexProcedure proc, IResultHandler resultHandler) {
        super(ndx, ts, split, proc, resultHandler);
        this.fromKey = AbstractKeyRangeIndexProcedure.constrainFromKey(fromKey, split.pmd);
        this.toKey = AbstractKeyRangeIndexProcedure.constrainFromKey(toKey, split.pmd);
        IndexSyncRPCCounters indexSyncRPCCounters = this.taskCountersByIndex;
        synchronized (indexSyncRPCCounters) {
            ++this.taskCountersByIndex.keyRangeRequestCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void retry() throws Exception {
        IndexSyncRPCCounters indexSyncRPCCounters = this.taskCountersByIndex;
        synchronized (indexSyncRPCCounters) {
            ++this.taskCountersByIndex.redirectCount;
        }
        AtomicInteger recursionDepth = this.ndx.getRecursionDepth();
        int depth = recursionDepth.incrementAndGet();
        try {
            if (depth > ((AbstractClient)this.ndx.getFederation().getClient()).getMaxStaleLocatorRetries()) {
                throw new RuntimeException("Retry count exceeded: ntries=" + depth);
            }
            ((ClientIndexView)this.ndx).submit(this.ts, this.fromKey, this.toKey, (IKeyRangeIndexProcedure)this.proc, this.resultHandler);
        }
        finally {
            int tmp = recursionDepth.decrementAndGet();
            assert (tmp >= 0) : "depth=" + depth + ", tmp=" + tmp;
        }
    }
}

