/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.ndx.pipeline;

import com.bigdata.btree.keys.KVO;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedureConstructor;
import com.bigdata.btree.proc.IKeyArrayIndexProcedure;
import com.bigdata.btree.proc.IResultHandler;
import com.bigdata.mdi.PartitionLocator;
import com.bigdata.relation.accesspath.BlockingBuffer;
import com.bigdata.service.IDataService;
import com.bigdata.service.Split;
import com.bigdata.service.ndx.IScaleOutClientIndex;
import com.bigdata.service.ndx.pipeline.AbstractMasterTask;
import com.bigdata.service.ndx.pipeline.AbstractSubtaskStats;
import com.bigdata.service.ndx.pipeline.IDuplicateRemover;
import com.bigdata.service.ndx.pipeline.IndexAsyncWriteStats;
import com.bigdata.service.ndx.pipeline.IndexPartitionWriteStats;
import com.bigdata.service.ndx.pipeline.IndexPartitionWriteTask;
import java.util.LinkedList;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;

public abstract class IndexWriteTask<H extends IndexAsyncWriteStats<L, HS>, O, E extends KVO<O>, S extends IndexPartitionWriteTask, L extends PartitionLocator, HS extends IndexPartitionWriteStats, T extends IKeyArrayIndexProcedure, R, A>
extends AbstractMasterTask<H, E, S, L> {
    protected final IScaleOutClientIndex ndx;
    protected final int sinkQueueCapacity;
    protected final int sinkChunkSize;
    protected final long sinkChunkTimeoutNanos;
    protected final IResultHandler<R, A> resultHandler;
    protected final IDuplicateRemover<O> duplicateRemover;
    protected final AbstractKeyArrayIndexProcedureConstructor<T> ctor;

    public String toString() {
        return this.getClass().getName() + "{index=" + this.ndx.getName() + ", open=" + this.buffer.isOpen() + ", ctor=" + this.ctor + "}";
    }

    public IndexWriteTask(IScaleOutClientIndex ndx, long sinkIdleTimeoutNanos, long sinkPollTimeoutNanos, int sinkQueueCapacity, int sinkChunkSize, long sinkChunkTimeoutNanos, IDuplicateRemover<O> duplicateRemover, AbstractKeyArrayIndexProcedureConstructor<T> ctor, IResultHandler<R, A> resultHandler, H stats, BlockingBuffer<E[]> buffer) {
        super(stats, buffer, sinkIdleTimeoutNanos, sinkPollTimeoutNanos);
        if (ndx == null) {
            throw new IllegalArgumentException();
        }
        if (sinkQueueCapacity <= 0) {
            throw new IllegalArgumentException();
        }
        if (sinkChunkSize <= 0) {
            throw new IllegalArgumentException();
        }
        if (sinkChunkTimeoutNanos <= 0L) {
            throw new IllegalArgumentException();
        }
        if (ctor == null) {
            throw new IllegalArgumentException();
        }
        this.ndx = ndx;
        this.sinkQueueCapacity = sinkQueueCapacity;
        this.sinkChunkSize = sinkChunkSize;
        this.sinkChunkTimeoutNanos = sinkChunkTimeoutNanos;
        this.resultHandler = resultHandler;
        this.duplicateRemover = duplicateRemover;
        this.ctor = ctor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleChunk(E[] a, boolean reopen) throws InterruptedException {
        long begin = System.nanoTime();
        try {
            long beforeSplit = System.nanoTime();
            LinkedList<Split> splits = this.ndx.splitKeys(this.ndx.getTimestamp(), 0, a.length, (KVO[])a);
            long splitNanos = System.nanoTime() - beforeSplit;
            IndexAsyncWriteStats indexAsyncWriteStats = (IndexAsyncWriteStats)this.stats;
            synchronized (indexAsyncWriteStats) {
                ((IndexAsyncWriteStats)this.stats).elapsedSplitChunkNanos += splitNanos;
            }
            for (Split split : splits) {
                this.halted();
                this.addToOutputBuffer((PartitionLocator)split.pmd, a, split.fromIndex, split.toIndex, reopen);
            }
        }
        finally {
            IndexAsyncWriteStats indexAsyncWriteStats = (IndexAsyncWriteStats)this.stats;
            synchronized (indexAsyncWriteStats) {
                ((IndexAsyncWriteStats)this.stats).handledChunkCount.incrementAndGet();
                ((IndexAsyncWriteStats)this.stats).elapsedHandleChunkNanos += System.nanoTime() - begin;
            }
        }
    }

    @Override
    protected S newSubtask(L locator, BlockingBuffer<E[]> out) {
        IDataService dataService = this.ndx.getDataService((PartitionLocator)locator);
        if (dataService == null) {
            throw new RuntimeException("DataService not found: " + ((PartitionLocator)locator).getDataServiceUUID());
        }
        return (S)new IndexPartitionWriteTask(this, locator, dataService, out);
    }

    @Override
    protected BlockingBuffer<E[]> newSubtaskBuffer() {
        return new BlockingBuffer<E[]>(new LinkedBlockingDeque(this.sinkQueueCapacity), this.sinkChunkSize, this.sinkChunkTimeoutNanos, TimeUnit.NANOSECONDS, this.buffer.isOrdered());
    }

    @Override
    protected void submitSubtask(FutureTask<? extends AbstractSubtaskStats> subtask) {
        this.ndx.getFederation().getExecutorService().submit(subtask);
    }

    public static class M<T extends IKeyArrayIndexProcedure, O, R, A>
    extends IndexWriteTask<IndexAsyncWriteStats<PartitionLocator, IndexPartitionWriteStats>, O, KVO<O>, IndexPartitionWriteTask, PartitionLocator, IndexPartitionWriteStats, T, R, A> {
        public M(IScaleOutClientIndex ndx, long sinkIdleTimeoutNanos, long sinkPollTimeoutNanos, int sinkQueueCapacity, int sinkChunkSize, long sinkChunkTimeoutNanos, IDuplicateRemover<O> duplicateRemover, AbstractKeyArrayIndexProcedureConstructor<T> ctor, IResultHandler<R, A> resultHandler, IndexAsyncWriteStats<PartitionLocator, IndexPartitionWriteStats> stats, BlockingBuffer<KVO<O>[]> buffer) {
            super(ndx, sinkIdleTimeoutNanos, sinkPollTimeoutNanos, sinkQueueCapacity, sinkChunkSize, sinkChunkTimeoutNanos, duplicateRemover, ctor, resultHandler, stats, buffer);
        }
    }
}

