/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.sparse;

import com.bigdata.btree.IIndex;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.sparse.AbstractAtomicRowReadOrWrite;
import com.bigdata.sparse.AutoIncIntegerCounter;
import com.bigdata.sparse.AutoIncLongCounter;
import com.bigdata.sparse.INameFilter;
import com.bigdata.sparse.IPrecondition;
import com.bigdata.sparse.ITPV;
import com.bigdata.sparse.Schema;
import com.bigdata.sparse.SparseRowStore;
import com.bigdata.sparse.TPS;
import com.bigdata.sparse.TimestampChooser;
import com.bigdata.sparse.ValueType;
import com.bigdata.util.InnerCause;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class AtomicRowWriteRead
extends AbstractAtomicRowReadOrWrite {
    private static final long serialVersionUID = 7481235291210326044L;
    private static final Logger log = Logger.getLogger(AtomicRowWriteRead.class);
    private long writeTime;
    private IPrecondition precondition;
    private Map<String, Object> propertySet;

    @Override
    public final boolean isReadOnly() {
        return false;
    }

    public AtomicRowWriteRead() {
    }

    public AtomicRowWriteRead(Schema schema, Map<String, Object> propertySet, long fromTime, long toTime, long writeTime, INameFilter filter, IPrecondition precondition) {
        super(schema, propertySet.get(schema.getPrimaryKeyName()), fromTime, toTime, filter);
        SparseRowStore.assertWriteTime(writeTime);
        SparseRowStore.assertPropertyNames(propertySet);
        this.writeTime = writeTime;
        this.precondition = precondition;
        this.propertySet = propertySet;
    }

    @Override
    public TPS apply(IIndex ndx) {
        TPS tps;
        long writeTime = TimestampChooser.chooseTimestamp(ndx, this.writeTime);
        if (this.precondition != null && !this.precondition.accept(tps = AtomicRowWriteRead.atomicRead(ndx, this.schema, this.primaryKey, this.fromTime, this.toTime, writeTime, this.filter))) {
            if (log.isInfoEnabled()) {
                log.info((Object)("precondition failed: " + tps));
            }
            tps.setPreconditionOk(false);
            return tps;
        }
        this.atomicWrite(ndx, this.schema, this.primaryKey, this.propertySet, writeTime);
        try {
            return AtomicRowWriteRead.atomicRead(ndx, this.schema, this.primaryKey, this.fromTime, this.toTime, writeTime, this.filter);
        }
        catch (Throwable t) {
            if (!InnerCause.isInnerCause((Throwable)t, InterruptedException.class)) {
                log.error((Object)t, t);
            }
            throw new RuntimeException(t);
        }
    }

    protected void atomicWrite(IIndex ndx, Schema schema, Object primaryKey, Map<String, Object> propertySet, long writeTime) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Schema=" + schema + ", primaryKey=" + schema.getPrimaryKeyName() + ", value=" + primaryKey + ", ntuples=" + propertySet.size()));
        }
        IKeyBuilder keyBuilder = ndx.getIndexMetadata().getKeyBuilder();
        for (Map.Entry<String, Object> entry : propertySet.entrySet()) {
            String col = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof AutoIncIntegerCounter) {
                long counter = this.inc(ndx, schema, primaryKey, writeTime, col);
                if (counter == 0x80000000L) {
                    throw new UnsupportedOperationException("No Successor: " + col);
                }
                value = (int)counter;
            } else if (value instanceof AutoIncLongCounter) {
                long counter = this.inc(ndx, schema, primaryKey, writeTime, col);
                value = counter;
            }
            byte[] key = schema.getKey(keyBuilder, primaryKey, col, writeTime);
            byte[] val = ValueType.encode(value);
            ndx.insert(key, val);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("col=" + col + ", value=" + value));
        }
    }

    protected long inc(IIndex ndx, Schema schema, Object primaryKey, long timestamp, String col) {
        long counter = 0L;
        ITPV tpv = AtomicRowWriteRead.getCurrentValue(ndx, schema, primaryKey, col);
        if (tpv != null) {
            Object tmp = tpv.getValue();
            if (!(tmp instanceof Integer) && !(tmp instanceof Long)) {
                throw new UnsupportedOperationException("Unsupported value type: schema=" + schema + ", name=" + col + ", class=" + tmp.getClass());
            }
            counter = ((Number)tmp).longValue();
            if (counter == Long.MAX_VALUE) {
                throw new UnsupportedOperationException("No successor: " + col);
            }
            ++counter;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Auto-increment: name=" + col + ", counter=" + counter));
        }
        return counter;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.writeTime = in.readLong();
        this.precondition = (IPrecondition)in.readObject();
        this.propertySet = new TreeMap<String, Object>();
        int n = in.readInt();
        if (log.isInfoEnabled()) {
            log.info((Object)("Reading " + n + " property values"));
        }
        for (int i = 0; i < n; ++i) {
            String name = in.readUTF();
            Object value = in.readObject();
            this.propertySet.put(name, value);
            if (!log.isInfoEnabled()) continue;
            log.info((Object)("name=" + name + ", value=" + value));
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeLong(this.writeTime);
        out.writeObject(this.precondition);
        out.writeInt(this.propertySet.size());
        for (Map.Entry<String, Object> entry : this.propertySet.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeObject(entry.getValue());
        }
    }
}

