/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Depends {
    private static final Dep jini = new ApacheDep("river", "http://river.apache.org/");
    private static final Dep zookeeper = new ApacheDep("zookeeper", "http://hadoop.apache.org/zookeeper/");
    private static final Dep log4j = new ApacheDep("log4j", "http://logging.apache.org/log4j/1.2/");
    private static final Dep lucene = new ApacheDep("lucene", "http://lucene.apache.org/core/index.html");
    private static final Dep apacheCommonsCodec = new ApacheDep("commons-codec", "http://commons.apache.org/codec/");
    private static final Dep apacheCommonsFileUpload = new ApacheDep("commons-fileupload", "http://commons.apache.org/fileupload/");
    private static final Dep apacheCommonsIO = new ApacheDep("commons-io", "http://commons.apache.org/io/");
    private static final Dep apacheCommonsLogging = new ApacheDep("commons-logging", "http://commons.apache.org/logging/");
    private static final Dep apacheHttpClient = new ApacheDep("httpclient", "http://hc.apache.org/");
    private static final Dep apacheHttpClientCache = new ApacheDep("httpclient-cache", "http://hc.apache.org/");
    private static final Dep apacheHttpCore = new ApacheDep("httpcore", "http://hc.apache.org/");
    private static final Dep apacheHttpMime = new ApacheDep("httpmime", "http://hc.apache.org/");
    private static final Dep bigdataGanglia = new ApacheDep("bigdata-ganglia", "https://sourceforge.net/projects/bigdata/");
    private static final Dep colt = new Dep("colt", "http://acs.lbl.gov/software/colt/", "http://acs.lbl.gov/software/colt/license.html");
    private static final Dep dsiutils = new LGPL21Dep("dsiutils", "http://dsiutils.dsi.unimi.it/");
    private static final Dep fastutil = new Dep("fastutil", "http://fastutil.dsi.unimi.it/", "http://www.apache.org/licenses/LICENSE-2.0.html");
    private static final Dep highScaleLib = new Dep("high-scale-lib", "https://sourceforge.net/projects/high-scale-lib/", "http://creativecommons.org/licenses/publicdomain");
    private static final Dep flot = new Dep("flot", "http://code.google.com/p/flot/", "http://www.opensource.org/licenses/mit-license.php");
    private static final Dep jquery = new Dep("jquery", "http://jquery.com/", "https://github.com/jquery/jquery/blob/master/MIT-LICENSE.txt");
    private static final Dep slf4j = new Dep("slf4j", "http://www.slf4j.org/", "http://www.slf4j.org/license.html");
    private static final Dep sesame = new Dep("sesame", "http://www.openrdf.org/", "http://www.openrdf.org/download.jsp");
    private static final Dep semargl = new Dep("semargl", "http://semarglproject.org", "https://github.com/levkhomich/semargl/blob/master/LICENSE");
    private static final Dep icu = new Dep("ICU", "http://site.icu-project.org/", "http://source.icu-project.org/repos/icu/icu/trunk/license.html");
    private static final Dep nanohttp = new Dep("nanohttp", "http://elonen.iki.fi/code/nanohttpd/", "http://elonen.iki.fi/code/nanohttpd/#license");
    private static final Dep jetty = new Dep("jetty", "http://www.eclipse.org/jetty/", "http://www.apache.org/licenses/LICENSE-2.0.html");
    private static final Dep jsonld = new Dep("jsonld", "https://github.com/jsonld-java/jsonld-java/", "https://raw.githubusercontent.com/jsonld-java/jsonld-java/master/LICENCE");
    private static final Dep servletApi = new ApacheDep("servlet-api", "http://tomcat.apache.org");
    private static final Dep jacksonCore = new Dep("jackson-core", "http://wiki.fasterxml.com/JacksonHome", "http://www.apache.org/licenses/LICENSE-2.0.html");
    private static final Dep blueprintsCore = new Dep("blueprints-core", "https://github.com/tinkerpop/blueprints", "https://github.com/tinkerpop/blueprints/blob/master/LICENSE.txt");
    private static final Dep rexsterCore = new Dep("rexster-core", "https://github.com/tinkerpop/rexster", "https://github.com/tinkerpop/rexster/blob/master/LICENSE.txt");
    private static final Dep hamcrestCore = new Dep("hamcrest-core", "https://code.google.com/p/hamcrest/", "http://opensource.org/licenses/BSD-3-Clause");
    private static final Dep[] depends = new Dep[]{log4j, lucene, colt, dsiutils, fastutil, highScaleLib, apacheCommonsCodec, apacheCommonsFileUpload, apacheCommonsIO, apacheCommonsLogging, apacheHttpClient, apacheHttpClientCache, apacheHttpCore, apacheHttpMime, slf4j, sesame, semargl, icu, nanohttp, jetty, jsonld, servletApi, jacksonCore, blueprintsCore, rexsterCore, bigdataGanglia, jini, zookeeper, flot, jquery};

    public static final List<Dep> depends() {
        return Collections.unmodifiableList(Arrays.asList(depends));
    }

    static {
        Arrays.sort(depends, new OrderByName());
    }

    private static class LGPL21Dep
    extends Dep {
        public LGPL21Dep(String component, String projectURL) {
            super(component, projectURL, "http://www.gnu.org/licenses/lgpl-2.1.html");
        }
    }

    private static class ApacheDep
    extends Dep {
        public ApacheDep(String component, String projectURL) {
            super(component, projectURL, "http://www.apache.org/licenses/LICENSE-2.0.html");
        }
    }

    private static class Dep
    implements Dependency {
        private final String component;
        private final String projectURL;
        private final String licenseURL;

        public Dep(String component, String projectURL, String licenseURL) {
            if (component == null || projectURL == null || licenseURL == null) {
                throw new IllegalArgumentException();
            }
            this.component = component;
            this.projectURL = projectURL;
            this.licenseURL = licenseURL;
        }

        @Override
        public final String getName() {
            return this.component;
        }

        @Override
        public final String projectURL() {
            return this.projectURL;
        }

        @Override
        public final String licenseURL() {
            return this.licenseURL;
        }

        public String toString() {
            return "{name=" + this.component + ", project=" + this.projectURL + ", license=" + this.licenseURL + "}";
        }
    }

    private static class OrderByLicense
    implements Comparator<Dependency> {
        private OrderByLicense() {
        }

        @Override
        public int compare(Dependency o1, Dependency o2) {
            return o1.licenseURL().compareTo(o2.licenseURL());
        }
    }

    private static class OrderByName
    implements Comparator<Dependency> {
        private OrderByName() {
        }

        @Override
        public int compare(Dependency o1, Dependency o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    public static interface Dependency {
        public String getName();

        public String projectURL();

        public String licenseURL();
    }
}

