/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.scenario;

import org.apache.jena.ontology.OntDocumentManager;
import org.apache.jena.rdf.model.Model;
import uk.ac.cam.cares.jps.base.scenario.BucketHelper;
import uk.ac.cam.cares.jps.base.scenario.JPSContext;
import uk.ac.cam.cares.jps.base.scenario.ScenarioClient;

public class JenaReadHook
implements OntDocumentManager.ReadHook {
    private static OntDocumentManager.ReadHook originalReadHook = null;

    public static synchronized void prepareReadHook() {
        if (originalReadHook != null) {
            return;
        }
        OntDocumentManager manager = OntDocumentManager.getInstance();
        originalReadHook = manager.getReadHook();
        manager.setReadHook(new JenaReadHook());
    }

    @Override
    public String beforeRead(Model model, String source, OntDocumentManager odm) {
        String scenarioUrl = JPSContext.getScenarioUrl();
        if (BucketHelper.isBaseScenario(scenarioUrl)) {
            return originalReadHook.beforeRead(model, source, odm);
        }
        String redirectedSource = new ScenarioClient().getReadUrl(scenarioUrl, source).toString();
        return originalReadHook.beforeRead(model, redirectedSource, odm);
    }

    @Override
    public void afterRead(Model model, String source, OntDocumentManager odm) {
        originalReadHook.afterRead(model, source, odm);
    }
}

