/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.scenario;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import uk.ac.cam.cares.jps.base.config.AgentLocator;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;

public class ScenarioHelper {
    private static final String JPS_WORKING_DIR = AgentLocator.getPathToJpsWorkingDir();
    public static final String SCENARIO_COMP_URL = "/jps/scenario";

    public static String getJpsWorkingDir() {
        return JPS_WORKING_DIR;
    }

    public static String getScenarioWorkingDir() {
        return JPS_WORKING_DIR + "/JPS_SCENARIO/scenario";
    }

    public static String getScenarioPath(String scenarioName) {
        return "/jps/scenario/" + scenarioName;
    }

    public static String getScenarioBucket(String scenarioName) {
        String scenarioBucket = ScenarioHelper.getScenarioWorkingDir() + "/" + scenarioName;
        File directory = new File(scenarioBucket);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        return scenarioBucket;
    }

    public static String getHashedResource(String resource) {
        URI uri;
        String resourceWithoutHash = ScenarioHelper.cutHash(resource);
        try {
            uri = new URI(resourceWithoutHash);
        }
        catch (URISyntaxException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
        int hashedHost = uri.getHost().hashCode();
        return "" + hashedHost + uri.getPath();
    }

    public static String getFileNameWithinBucket(String resource, String scenarioBucket) {
        return scenarioBucket + "/" + ScenarioHelper.getHashedResource(resource);
    }

    public static String[] dividePath(String path) {
        String scenarioName = null;
        String operation = null;
        if (path == null || path.length() <= 1) {
            scenarioName = UUID.randomUUID().toString();
        } else {
            int index = (path = path.substring(1)).indexOf("/");
            if (index < 0) {
                scenarioName = path;
                operation = null;
            } else {
                scenarioName = path.substring(0, index);
                operation = path.substring(index);
            }
            int i = scenarioName.indexOf(".owl");
            if (i >= 0) {
                scenarioName = scenarioName.substring(0, i);
            }
            if (scenarioName.length() < 4) {
                throw new JPSRuntimeException("the length of the scenario name must be at least 4");
            }
        }
        return new String[]{scenarioName, operation};
    }

    public static String cutHash(String fileName) {
        int index = fileName.lastIndexOf(".owl#");
        if (index < 0) {
            return fileName;
        }
        return fileName.substring(0, index + 4);
    }
}

