/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.openrdf.query.resultio.TupleQueryResultParserFactory;
import org.openrdf.query.resultio.TupleQueryResultParserRegistry;
import org.openrdf.query.resultio.TupleQueryResultWriterFactory;
import org.openrdf.query.resultio.TupleQueryResultWriterRegistry;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParserFactory;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.RDFWriterFactory;
import org.openrdf.rio.RDFWriterRegistry;

public class ServiceProviderHook {
    private static final Logger log = Logger.getLogger(ServiceProviderHook.class);
    public static final String NTRIPLES_PARSER_FACTORY = "com.bigdata.rdf.rio.ntriples.BigdataNTriplesParserFactory";
    public static final String TURTLE_PARSER_FACTORY = "com.bigdata.rdf.rio.turtle.BigdataTurtleParserFactory";
    public static final String TURTLE_WRITER_FACTORY = "com.bigdata.rdf.rio.turtle.BigdataTurtleWriterFactory";
    public static final String JSON_WRITER_FACTORY = "com.bigdata.rdf.rio.json.BigdataSPARQLResultsJSONWriterFactory";
    public static final String JSON_CONSTRUCT_WRITER_FACTORY = "com.bigdata.rdf.rio.json.BigdataSPARQLResultsJSONWriterForConstructFactory";
    public static final String JSON_RESULT_PARSER_FACTORY = "com.bigdata.rdf.rio.json.BigdataSPARQLResultsJSONParserFactory";
    public static final String JSON_CONSTRUCT_PARSER_FACTORY = "com.bigdata.rdf.rio.json.BigdataSPARQLResultsJSONParserForConstructFactory";
    private static boolean loaded = false;
    public static final RDFFormat TURTLE_RDR = new RDFFormat("Turtle-RDR", Arrays.asList("application/x-turtle-RDR"), Charset.forName("UTF-8"), Arrays.asList("ttlx"), true, false);
    public static final RDFFormat NTRIPLES_RDR = new RDFFormat("N-Triples-RDR", "application/x-n-triples-RDR", Charset.forName("US-ASCII"), "ntx", false, false);
    public static final RDFFormat JSON_RDR = new RDFFormat("SPARQL/JSON", Arrays.asList("application/sparql-results+json", "application/json"), Charset.forName("UTF-8"), Arrays.asList("srj", "json"), false, true);

    public static synchronized void forceLoad() {
        if (loaded) {
            return;
        }
        log.warn((Object)"Running.");
        if (log.isInfoEnabled()) {
            for (RDFFormat f : RDFFormat.values()) {
                log.info((Object)("RDFFormat: before: " + f));
            }
            for (RDFFormat f : RDFParserRegistry.getInstance().getAll()) {
                log.info((Object)("RDFParserFactory: before: " + f));
            }
            for (RDFFormat f : RDFWriterRegistry.getInstance().getAll()) {
                log.info((Object)("RDFWriterFactory: before: " + f));
            }
            for (RDFFormat f : TupleQueryResultWriterRegistry.getInstance().getAll()) {
                log.info((Object)("TupleQueryResultWriterFactory: before: " + f));
            }
        }
        RDFFormat.register((RDFFormat)TURTLE_RDR);
        RDFFormat.register((RDFFormat)NTRIPLES_RDR);
        RDFFormat.register((RDFFormat)JSON_RDR);
        RDFParserRegistry r = RDFParserRegistry.getInstance();
        r.add((Object)((RDFParserFactory)ServiceProviderHook.getInstanceForClass(NTRIPLES_PARSER_FACTORY)));
        assert (r.has((Object)((RDFParserFactory)ServiceProviderHook.getInstanceForClass(NTRIPLES_PARSER_FACTORY)).getRDFFormat()));
        r.add((Object)((RDFParserFactory)ServiceProviderHook.getInstanceForClass(TURTLE_PARSER_FACTORY)));
        assert (r.has((Object)((RDFParserFactory)ServiceProviderHook.getInstanceForClass(TURTLE_PARSER_FACTORY)).getRDFFormat()));
        r.add((Object)((RDFParserFactory)ServiceProviderHook.getInstanceForClass(JSON_CONSTRUCT_PARSER_FACTORY)));
        r = TupleQueryResultWriterRegistry.getInstance();
        r.add((Object)((TupleQueryResultWriterFactory)ServiceProviderHook.getInstanceForClass(JSON_WRITER_FACTORY)));
        r = TupleQueryResultParserRegistry.getInstance();
        r.add((Object)((TupleQueryResultParserFactory)ServiceProviderHook.getInstanceForClass(JSON_RESULT_PARSER_FACTORY)));
        r = RDFWriterRegistry.getInstance();
        r.add((Object)((RDFWriterFactory)ServiceProviderHook.getInstanceForClass(TURTLE_WRITER_FACTORY)));
        r.add((Object)((RDFWriterFactory)ServiceProviderHook.getInstanceForClass(JSON_CONSTRUCT_WRITER_FACTORY)));
        if (log.isInfoEnabled()) {
            for (RDFFormat f : RDFFormat.values()) {
                log.info((Object)("RDFFormat: after: " + f));
            }
            for (RDFFormat f : RDFParserRegistry.getInstance().getAll()) {
                log.info((Object)("RDFParserFactory: after: " + f));
            }
            for (RDFFormat f : RDFWriterRegistry.getInstance().getAll()) {
                log.info((Object)("RDFWriterFactory: after: " + f));
            }
            for (RDFFormat f : TupleQueryResultWriterRegistry.getInstance().getAll()) {
                log.info((Object)("TupleQueryResultWriterFactory: after: " + f));
            }
        }
        loaded = true;
    }

    protected static Object getInstanceForClass(String className) {
        try {
            Class<?> c = Class.forName(className);
            Constructor<?> cons = c.getConstructor(new Class[0]);
            Object classInstance = cons.newInstance(new Object[0]);
            return classInstance;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(className + " is not found in the classpath.");
        }
    }

    static {
        ServiceProviderHook.forceLoad();
    }
}

