/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util;

public class PseudoRandom {
    private final int m_mask;
    private int m_next = 1;
    private final int m_max;
    private static final int[] s_masks = new int[]{3, 6, 12, 20, 48, 96, 184, 272, 576, 1280, 3232, 6912, 13568, 24576, 46080, 73728, 132096, 466944, 589824, 0x140000, 0x300000, 0x400000, 0xD80000, 0x1200000, 0x3880000, 0x7200000, 0x9000000, 0x14000000, 847249408, 0x48000000, -1560281088};

    public PseudoRandom(int range, int next) {
        this(range);
        if (next < 0 || next >= range) {
            throw new IllegalArgumentException();
        }
        this.m_next = next + 1;
    }

    public PseudoRandom(int range) {
        int m_mask = 0;
        for (int m = 0; m < s_masks.length; ++m) {
            if (s_masks[m] <= range) continue;
            m_mask = s_masks[m];
            break;
        }
        this.m_mask = m_mask;
        this.m_max = range;
    }

    public int next() {
        this.m_next = (this.m_next & 1) == 1 ? this.m_next >> 1 ^ this.m_mask : (this.m_next >>= 1);
        if (this.m_next > this.m_max) {
            return this.next();
        }
        return this.m_next - 1;
    }

    public int nextInt(int range) {
        if (range == 0) {
            return 0;
        }
        if (range < 0) {
            throw new IllegalArgumentException();
        }
        if (range > this.m_max) {
            throw new IllegalStateException("Range exceeds max range of generator");
        }
        return this.next() % range;
    }

    public int next(int prev) {
        if (prev < 0 || prev >= this.m_max) {
            throw new IllegalArgumentException();
        }
        this.m_next = prev + 1;
        return this.next();
    }

    public void nextBytes(byte[] key, int prev) {
        this.m_next = prev;
        this.nextBytes(key);
    }

    public void nextBytes(byte[] key) {
        for (int i = 0; i < key.length; ++i) {
            key[i] = (byte)this.next();
        }
    }
}

