/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ttl;

import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import org.apache.jena.graph.GraphEvents;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFErrorHandler;
import org.apache.jena.rdf.model.RDFReaderI;
import org.apache.jena.shared.JenaException;
import org.apache.jena.ttl.N3IRIResolver;
import org.apache.jena.util.FileUtils;
import org.slf4j.LoggerFactory;

public abstract class JenaReaderBase
implements RDFReaderI {
    protected RDFErrorHandler errorHandler = null;

    @Override
    public final void read(Model model, Reader r, String base) {
        this.checkReader(r);
        this.readImpl(model, r, base);
    }

    @Override
    public final void read(Model model, String url) {
        try {
            URLConnection conn = new URL(url).openConnection();
            String encoding = conn.getContentEncoding();
            if (encoding == null) {
                this.read(model, new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8), url);
            } else {
                LoggerFactory.getLogger(this.getClass()).warn("URL content is not UTF-8");
                this.read(model, new InputStreamReader(conn.getInputStream(), encoding), url);
            }
        }
        catch (JenaException e) {
            if (this.errorHandler == null) {
                throw e;
            }
            this.errorHandler.error(e);
        }
        catch (Exception ex) {
            if (this.errorHandler == null) {
                throw new JenaException(ex);
            }
            this.errorHandler.error(ex);
        }
    }

    @Override
    public final void read(Model model, InputStream in, String base) {
        this.readImpl(model, FileUtils.asBufferedUTF8(in), base);
    }

    @Override
    public final RDFErrorHandler setErrorHandler(RDFErrorHandler errHandler) {
        RDFErrorHandler old = this.errorHandler;
        this.errorHandler = errHandler;
        return old;
    }

    @Override
    public final Object setProperty(String propName, Object propValue) {
        return null;
    }

    protected void checkReader(Reader r) {
        FileReader f;
        if (r instanceof FileReader && (f = (FileReader)r).getEncoding().equalsIgnoreCase(StandardCharsets.UTF_8.name())) {
            LoggerFactory.getLogger(this.getClass()).warn("FileReader is not UTF-8");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readImpl(Model model, Reader reader, String base) {
        if (base != null) {
            base = N3IRIResolver.resolveGlobal(base);
        }
        try {
            model.notifyEvent(GraphEvents.startRead);
            this.readWorker(model, reader, base);
        }
        catch (JenaException e) {
            if (this.errorHandler == null) {
                throw e;
            }
            this.errorHandler.error(e);
        }
        catch (Exception ex) {
            if (this.errorHandler == null) {
                throw new JenaException(ex);
            }
            this.errorHandler.error(ex);
        }
        finally {
            model.notifyEvent(GraphEvents.finishRead);
        }
    }

    protected abstract void readWorker(Model var1, Reader var2, String var3) throws Exception;
}

