/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.function;

import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.function.Function;
import org.openrdf.query.algebra.evaluation.util.QueryEvaluationUtil;

public class DateTimeCast
implements Function {
    @Override
    public String getURI() {
        return XMLSchema.DATETIME.toString();
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException("xsd:dateTime cast requires exactly 1 argument, got " + args.length);
        }
        if (args[0] instanceof Literal) {
            Literal literal = (Literal)args[0];
            URI datatype = literal.getDatatype();
            if (QueryEvaluationUtil.isStringLiteral(literal)) {
                String dateTimeValue = XMLDatatypeUtil.collapseWhiteSpace((String)literal.getLabel());
                if (XMLDatatypeUtil.isValidDateTime((String)dateTimeValue)) {
                    return valueFactory.createLiteral(dateTimeValue, XMLSchema.DATETIME);
                }
            } else if (datatype != null) {
                if (datatype.equals((Object)XMLSchema.DATETIME)) {
                    return literal;
                }
                if (datatype.equals((Object)XMLSchema.DATE)) {
                    try {
                        XMLGregorianCalendar calValue = literal.calendarValue();
                        int year = calValue.getYear();
                        int month = calValue.getMonth();
                        int day = calValue.getDay();
                        int timezoneOffset = calValue.getTimezone();
                        if (Integer.MIN_VALUE != year && Integer.MIN_VALUE != month && Integer.MIN_VALUE != day) {
                            StringBuilder dtBuilder = new StringBuilder();
                            dtBuilder.append(year);
                            dtBuilder.append("-");
                            if (month < 10) {
                                dtBuilder.append("0");
                            }
                            dtBuilder.append(month);
                            dtBuilder.append("-");
                            if (day < 10) {
                                dtBuilder.append("0");
                            }
                            dtBuilder.append(day);
                            dtBuilder.append("T00:00:00");
                            if (Integer.MIN_VALUE != timezoneOffset) {
                                int minutes = Math.abs(timezoneOffset);
                                int hours = minutes / 60;
                                minutes -= hours * 60;
                                if (timezoneOffset > 0) {
                                    dtBuilder.append("+");
                                } else {
                                    dtBuilder.append("-");
                                }
                                if (hours < 10) {
                                    dtBuilder.append("0");
                                }
                                dtBuilder.append(hours);
                                dtBuilder.append(":");
                                if (minutes < 10) {
                                    dtBuilder.append("0");
                                }
                                dtBuilder.append(minutes);
                            }
                            return valueFactory.createLiteral(dtBuilder.toString(), XMLSchema.DATETIME);
                        }
                        throw new ValueExprEvaluationException("not a valid date value: " + literal);
                    }
                    catch (IllegalArgumentException e) {
                        throw new ValueExprEvaluationException("not a valid calendar value: " + literal);
                    }
                }
            }
        }
        throw new ValueExprEvaluationException("Invalid argument for xsd:dateTime cast: " + args[0]);
    }
}

