/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.function.datetime;

import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.vocabulary.FN;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.function.Function;

public class Day
implements Function {
    @Override
    public String getURI() {
        return FN.DAY_FROM_DATETIME.toString();
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException("DAY requires 1 argument, got " + args.length);
        }
        Value argValue = args[0];
        if (argValue instanceof Literal) {
            Literal literal = (Literal)argValue;
            URI datatype = literal.getDatatype();
            if (datatype != null && XMLDatatypeUtil.isCalendarDatatype((URI)datatype)) {
                try {
                    XMLGregorianCalendar calValue = literal.calendarValue();
                    int day = calValue.getDay();
                    if (Integer.MIN_VALUE != day) {
                        return valueFactory.createLiteral(String.valueOf(day), XMLSchema.INTEGER);
                    }
                    throw new ValueExprEvaluationException("can not determine day from value: " + argValue);
                }
                catch (IllegalArgumentException e) {
                    throw new ValueExprEvaluationException("illegal calendar value: " + argValue);
                }
            }
            throw new ValueExprEvaluationException("unexpected input value for function: " + argValue);
        }
        throw new ValueExprEvaluationException("unexpected input value for function: " + args[0]);
    }
}

