/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.obo12.parser;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.coode.owlapi.obo12.parser.AbstractTagValueHandler;
import org.coode.owlapi.obo12.parser.OBOConsumer;
import org.coode.owlapi.obo12.parser.OBOVocabulary;
import org.coode.owlapi.obo12.parser.SynonymScope;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntologyChange;

class SynonymTagValueHandler
extends AbstractTagValueHandler {
    public static final IRI SYNONYM_TYPE_IRI = OBOVocabulary.SYNONYM_TYPE.getIRI();
    public static final IRI XREF_IRI = OBOVocabulary.XREF.getIRI();
    private static final String TAG_NAME = OBOVocabulary.SYNONYM.toString();
    private static final Pattern VALUEPATTERN = Pattern.compile("\"([^\"]*)\"\\s*([^\\s]*)\\s*([^\\[\\s]+)?\\s*\\[([^\\]]*)\\]");
    private static final int VALUE_GROUP = 1;
    private static final int SCOPE_GROUP = 2;
    private static final int SYNONYM_TYPE_GROUP = 3;
    private static final int XREF_GROUP = 4;

    public SynonymTagValueHandler(OBOConsumer consumer) {
        super(TAG_NAME, consumer);
    }

    @Override
    public void handle(String currentId, String value, String qualifierBlock, String comment) {
        Matcher matcher = VALUEPATTERN.matcher(value);
        if (matcher.matches()) {
            OWLDataFactory df = this.getDataFactory();
            OWLAnnotationProperty property = this.getSynonymAnnotationProperty(matcher);
            HashSet<OWLAnnotation> annotations = new HashSet<OWLAnnotation>();
            annotations.addAll(this.getSynonymTypeAnnotations(matcher));
            annotations.addAll(this.getXRefAnnotations(matcher));
            OWLEntity subject = this.getConsumer().getCurrentEntity();
            String synonym = matcher.group(1);
            OWLLiteral synonymLiteral = df.getOWLLiteral(synonym);
            OWLAnnotationAssertionAxiom annoAssertion = df.getOWLAnnotationAssertionAxiom(property, (OWLAnnotationSubject)subject.getIRI(), (OWLAnnotationValue)synonymLiteral, annotations);
            this.applyChange((OWLOntologyChange)new AddAxiom(this.getOntology(), (OWLAxiom)annoAssertion));
        }
    }

    private Set<OWLAnnotation> getSynonymTypeAnnotations(Matcher matcher) {
        if (matcher.group(3) != null) {
            OWLAnnotation typeAnnotation = this.getSynonymTypeAnnotation(matcher);
            return Collections.singleton(typeAnnotation);
        }
        return Collections.emptySet();
    }

    private Set<OWLAnnotation> getXRefAnnotations(Matcher matcher) {
        HashSet<OWLAnnotation> annotations = new HashSet<OWLAnnotation>();
        String xrefs = matcher.group(4);
        if (xrefs != null) {
            StringTokenizer tokenizer = new StringTokenizer(xrefs, ",");
            while (tokenizer.hasMoreTokens()) {
                String xref = tokenizer.nextToken();
                OWLAnnotation xrefAnnotation = this.getConsumer().parseXRef(xref);
                annotations.add(xrefAnnotation);
            }
        }
        return annotations;
    }

    private OWLAnnotationProperty getSynonymAnnotationProperty(Matcher matcher) {
        String synonymScope = matcher.group(2);
        IRI annotationPropertyIRI = SynonymScope.BROAD.name().equals(synonymScope) ? this.getTagIRI(OBOVocabulary.BROAD_SYNONYM) : (SynonymScope.EXACT.name().equals(synonymScope) ? this.getTagIRI(OBOVocabulary.EXACT_SYNONYM) : (SynonymScope.NARROW.name().equals(synonymScope) ? this.getTagIRI(OBOVocabulary.NARROW_SYNONYM) : (SynonymScope.RELATED.name().equals(synonymScope) ? this.getTagIRI(OBOVocabulary.RELATED_SYNONYM) : this.getTagIRI(OBOVocabulary.SYNONYM))));
        return this.getDataFactory().getOWLAnnotationProperty(annotationPropertyIRI);
    }

    private OWLAnnotation getSynonymTypeAnnotation(Matcher matcher) {
        OWLDataFactory df = this.getDataFactory();
        String synonymType = matcher.group(3);
        return df.getOWLAnnotation(df.getOWLAnnotationProperty(SYNONYM_TYPE_IRI), (OWLAnnotationValue)df.getOWLLiteral(synonymType));
    }
}

