/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ganglia;

import com.bigdata.ganglia.GangliaMessageTypeEnum;
import com.bigdata.ganglia.GangliaMetadataMessage;
import com.bigdata.ganglia.GangliaSlopeEnum;
import com.bigdata.ganglia.IGangliaMetadataFactory;
import com.bigdata.ganglia.IGangliaMetadataMessage;
import java.util.Collections;
import java.util.Map;

public class DefaultMetadataFactory
implements IGangliaMetadataFactory {
    private final String defaultUnits;
    private final GangliaSlopeEnum defaultSlope;
    private final int defaultTMax;
    private final int defaultDMax;

    public DefaultMetadataFactory(String defaultUnits, GangliaSlopeEnum defaultSlope, int defaultTMax, int defaultDMax) {
        if (defaultUnits == null) {
            throw new IllegalArgumentException();
        }
        if (defaultSlope == null) {
            throw new IllegalArgumentException();
        }
        if (defaultTMax < 0) {
            throw new IllegalArgumentException();
        }
        if (defaultDMax < 0) {
            throw new IllegalArgumentException();
        }
        this.defaultUnits = defaultUnits;
        this.defaultSlope = defaultSlope;
        this.defaultTMax = defaultTMax;
        this.defaultDMax = defaultDMax;
    }

    @Override
    public IGangliaMetadataMessage newDecl(String hostName, String metricName, Object value) {
        int lastIndexOf = metricName.lastIndexOf(46);
        String groupName = lastIndexOf == -1 ? null : metricName.substring(0, lastIndexOf);
        String units = this.defaultUnits;
        GangliaSlopeEnum slope = this.defaultSlope;
        int tmax = this.defaultTMax;
        int dmax = this.defaultDMax;
        Map<String, String[]> extraValues = groupName == null ? Collections.emptyMap() : Collections.singletonMap("GROUP", new String[]{groupName});
        GangliaMessageTypeEnum metricType = GangliaMessageTypeEnum.forJavaValue(value);
        return new GangliaMetadataMessage(hostName, metricName, false, metricType, metricName, units, slope, tmax, dmax, extraValues);
    }

    @Override
    public IGangliaMetadataMessage resolve(IGangliaMetadataMessage decl) {
        return decl;
    }
}

