/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ganglia;

import com.bigdata.ganglia.GangliaMessageTypeEnum;
import com.bigdata.ganglia.IGangliaMessageEncoder;
import com.bigdata.ganglia.IGangliaMetadataMessage;
import com.bigdata.ganglia.IGangliaMetricMessage;
import com.bigdata.ganglia.IGangliaRequestMessage;
import com.bigdata.ganglia.util.UnsignedUtil;
import com.bigdata.ganglia.xdr.XDROutputBuffer;
import java.util.Map;

public class GangliaMessageEncoder31
implements IGangliaMessageEncoder {
    @Override
    public void writeRequest(XDROutputBuffer xdr, IGangliaRequestMessage msg) {
        xdr.reset();
        xdr.writeInt(GangliaMessageTypeEnum.REQUEST.value());
        xdr.writeString(msg.getHostName());
        xdr.writeString(msg.getMetricName());
        xdr.writeInt(msg.isSpoof() ? 1 : 0);
    }

    @Override
    public void writeMetadata(XDROutputBuffer xdr, IGangliaMetadataMessage decl) {
        xdr.reset();
        xdr.writeInt(GangliaMessageTypeEnum.METADATA.value());
        xdr.writeString(decl.getHostName());
        xdr.writeString(decl.getMetricName());
        xdr.writeInt(decl.isSpoof() ? 1 : 0);
        xdr.writeString(decl.getMetricType().getGType());
        xdr.writeString(decl.getMetricName());
        xdr.writeString(decl.getUnits());
        xdr.writeInt(decl.getSlope().value());
        xdr.writeInt(decl.getTMax());
        xdr.writeInt(decl.getDMax());
        Map<String, String[]> extraValues = decl.getExtraValues();
        xdr.writeInt(extraValues.size());
        for (Map.Entry<String, String[]> e : extraValues.entrySet()) {
            for (String name : e.getValue()) {
                xdr.writeString(e.getKey());
                xdr.writeString(name);
            }
        }
    }

    @Override
    public void writeMetric(XDROutputBuffer xdr, IGangliaMetadataMessage decl, IGangliaMetricMessage msg) {
        xdr.reset();
        GangliaMessageTypeEnum metricType = decl.getMetricType();
        xdr.writeInt(metricType.value());
        xdr.writeString(msg.getHostName());
        xdr.writeString(msg.getMetricName());
        xdr.writeInt(msg.isSpoof() ? 1 : 0);
        xdr.writeString(msg.getFormat());
        switch (metricType) {
            case DOUBLE: {
                xdr.writeDouble(msg.getNumericValue().doubleValue());
                break;
            }
            case FLOAT: {
                xdr.writeFloat(msg.getNumericValue().floatValue());
                break;
            }
            case INT16: {
                xdr.writeShort(msg.getNumericValue().shortValue());
                break;
            }
            case INT32: {
                xdr.writeInt(msg.getNumericValue().intValue());
                break;
            }
            case STRING: {
                xdr.writeString(msg.getStringValue());
                break;
            }
            case UINT16: {
                int v = msg.getNumericValue().intValue();
                if (v < 0) {
                    throw new RuntimeException("Negative integer for uint16 value: " + v + ", decl=" + decl + ", msg=" + msg);
                }
                if (v > 65535) {
                    throw new RuntimeException("Signed integer exceeds uint16 range: " + v + ", decl=" + decl + ", msg=" + msg);
                }
                int x = UnsignedUtil.encode(v);
                xdr.writeShort((short)x);
                break;
            }
            case UINT32: {
                long v = msg.getNumericValue().longValue();
                if (v < 0L) {
                    throw new RuntimeException("Negative long for uint32 value: " + v + ", decl=" + decl + ", msg=" + msg);
                }
                if (v > 0xFFFFFFFFL) {
                    throw new RuntimeException("Signed long exceeds uint32 range: " + v + ", decl=" + decl + ", msg=" + msg);
                }
                long x = UnsignedUtil.encode(v);
                xdr.writeInt((int)x);
                break;
            }
            default: {
                throw new UnsupportedOperationException("metricType=" + (Object)((Object)metricType) + ", metric=" + msg);
            }
        }
    }
}

