/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ganglia;

import java.util.HashMap;
import java.util.Map;

public enum GangliaMessageTypeEnum {
    METADATA(128, false, null, null, null),
    UINT16(129, true, "uint16", "%hu", null),
    INT16(130, true, "int16", "%hi", new Class[]{Short.class}),
    INT32(131, true, "int32", "%i", new Class[]{Integer.class}),
    UINT32(132, true, "uint32", "%u", null),
    STRING(133, true, "string", "%s", new Class[]{String.class}),
    FLOAT(134, true, "float", "%f", new Class[]{Float.class}),
    DOUBLE(135, true, "double", "%lf", new Class[]{Double.class, Long.class}),
    REQUEST(136, false, null, null, null);

    private final int v;
    private final boolean isMetric;
    private final String gtype;
    private final String format;
    private final Class<?>[] javaClasses;
    private static final Map<String, GangliaMessageTypeEnum> gtype2Enum;
    private static final Map<Class<?>, GangliaMessageTypeEnum> javaClass2Enum;

    private GangliaMessageTypeEnum(int v, boolean isMetric, String gtype, String format, Class<?>[] javaClasses) {
        this.v = v;
        this.isMetric = isMetric;
        this.gtype = gtype;
        this.format = format;
        this.javaClasses = javaClasses;
    }

    public int value() {
        return this.v;
    }

    public boolean isMetric() {
        return this.isMetric;
    }

    public String getGType() {
        return this.gtype;
    }

    public String getFormat() {
        return this.format;
    }

    public boolean isNumeric() {
        switch (this) {
            case DOUBLE: 
            case FLOAT: 
            case INT16: 
            case INT32: 
            case UINT16: 
            case UINT32: {
                return true;
            }
            case STRING: {
                return false;
            }
            case METADATA: 
            case REQUEST: {
                return false;
            }
        }
        throw new AssertionError();
    }

    public static GangliaMessageTypeEnum valueOf(int v) {
        switch (v) {
            case 128: {
                return METADATA;
            }
            case 129: {
                return UINT16;
            }
            case 130: {
                return INT16;
            }
            case 131: {
                return INT32;
            }
            case 132: {
                return UINT32;
            }
            case 133: {
                return STRING;
            }
            case 134: {
                return FLOAT;
            }
            case 135: {
                return DOUBLE;
            }
            case 136: {
                return REQUEST;
            }
        }
        throw new IllegalArgumentException("value=" + v);
    }

    public static GangliaMessageTypeEnum fromGType(String metricType) {
        GangliaMessageTypeEnum e = gtype2Enum.get(metricType);
        if (e == null) {
            throw new IllegalArgumentException("metricType=" + metricType);
        }
        return e;
    }

    public static GangliaMessageTypeEnum forJavaValue(Object value) {
        if (value == null) {
            throw new UnsupportedOperationException();
        }
        Class<?> cls = value.getClass();
        GangliaMessageTypeEnum e = javaClass2Enum.get(cls);
        if (e == null) {
            throw new IllegalArgumentException();
        }
        return e;
    }

    static {
        gtype2Enum = new HashMap<String, GangliaMessageTypeEnum>();
        javaClass2Enum = new HashMap();
        for (GangliaMessageTypeEnum e : GangliaMessageTypeEnum.values()) {
            gtype2Enum.put(e.getGType(), e);
            if (e.javaClasses == null) continue;
            for (Class<?> cls : e.javaClasses) {
                javaClass2Enum.put(cls, e);
            }
        }
    }
}

