/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.storage.system;

import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.dboe.storage.DatabaseRDF;
import org.apache.jena.dboe.storage.StoragePrefixes;
import org.apache.jena.dboe.storage.StorageRDF;
import org.apache.jena.dboe.storage.prefixes.PrefixesDboeFactory;
import org.apache.jena.dboe.storage.prefixes.StoragePrefixMap;
import org.apache.jena.dboe.storage.prefixes.StoragePrefixesView;
import org.apache.jena.dboe.storage.system.GraphViewStorage;
import org.apache.jena.dboe.transaction.txn.IteratorTxnTracker;
import org.apache.jena.dboe.transaction.txn.TransactionalSystem;
import org.apache.jena.dboe.transaction.txn.TxnId;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.shared.AddDeniedException;
import org.apache.jena.shared.DeleteDeniedException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphBaseFind;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;

public class DatasetGraphStorage
extends DatasetGraphBaseFind
implements DatabaseRDF {
    private final Transactional txn;
    private final StorageRDF storage;
    private final StoragePrefixes prefixes;
    private final PrefixMap prefixMap;

    public void begin() {
        this.txn.begin();
    }

    public void begin(TxnType txnType) {
        this.txn.begin(txnType);
    }

    public void begin(ReadWrite mode) {
        this.txn.begin(mode);
    }

    public boolean promote(Transactional.Promote mode) {
        return this.txn.promote(mode);
    }

    public void commit() {
        this.txn.commit();
    }

    public void abort() {
        this.txn.abort();
    }

    public boolean isInTransaction() {
        return this.txn.isInTransaction();
    }

    public void end() {
        this.txn.end();
    }

    public ReadWrite transactionMode() {
        return this.txn.transactionMode();
    }

    public TxnType transactionType() {
        return this.txn.transactionType();
    }

    public boolean supportsTransactions() {
        return true;
    }

    public boolean supportsTransactionAbort() {
        return false;
    }

    public DatasetGraphStorage(StorageRDF storage, StoragePrefixes prefixes, Transactional transactional) {
        this.storage = storage;
        this.prefixes = prefixes;
        StoragePrefixMap spm = StoragePrefixesView.viewDataset(prefixes);
        this.prefixMap = PrefixesDboeFactory.newPrefixMap(spm);
        this.txn = transactional;
    }

    @Override
    public StorageRDF getData() {
        return this.storage;
    }

    @Override
    public StoragePrefixes getStoragePrefixes() {
        return this.prefixes;
    }

    @Override
    public Transactional getTransactional() {
        return this.txn;
    }

    public PrefixMap prefixes() {
        return this.prefixMap;
    }

    public Iterator<Node> listGraphNodes() {
        Iterator iter = this.findNG(null, null, null, null);
        return Iter.iter((Iterator)iter).map(Quad::getGraph).distinct();
    }

    private <T> Iterator<T> isolate(Iterator<T> iterator) {
        if (this.txn.isInTransaction() && this.txn instanceof TransactionalSystem) {
            TransactionalSystem txnSystem = (TransactionalSystem)this.txn;
            TxnId txnId = txnSystem.getThreadTransaction().getTxnId();
            return new IteratorTxnTracker(iterator, txnSystem, txnId);
        }
        return Iter.iterator(iterator);
    }

    private Iterator<Triple> findStorage(Node s, Node p, Node o) {
        return this.isolate(this.storage.find(s, p, o));
    }

    private Iterator<Quad> findStorage(Node g, Node s, Node p, Node o) {
        return this.isolate(this.storage.find(g, s, p, o));
    }

    protected Iterator<Quad> findInDftGraph(Node s, Node p, Node o) {
        return Iter.map(this.findStorage(s, p, o), t -> Quad.create((Node)Quad.defaultGraphIRI, (Triple)t));
    }

    protected Iterator<Quad> findInSpecificNamedGraph(Node g, Node s, Node p, Node o) {
        return this.findStorage(g, s, p, o);
    }

    protected Iterator<Quad> findInAnyNamedGraphs(Node s, Node p, Node o) {
        return this.findStorage(Node.ANY, s, p, o);
    }

    public Graph getDefaultGraph() {
        return GraphViewStorage.createDefaultGraphStorage((DatasetGraph)this, this.prefixes);
    }

    public Graph getUnionGraph() {
        return GraphViewStorage.createUnionGraphStorage((DatasetGraph)this, this.prefixes);
    }

    public Graph getGraph(Node graphNode) {
        return GraphViewStorage.createNamedGraphStorage((DatasetGraph)this, graphNode, this.prefixes);
    }

    public void add(Quad quad) {
        if (Quad.isDefaultGraph((Node)quad.getGraph())) {
            this.storage.add(quad.getSubject(), quad.getPredicate(), quad.getObject());
        } else {
            this.storage.add(quad);
        }
    }

    public void delete(Quad quad) {
        if (Quad.isDefaultGraph((Node)quad.getGraph())) {
            this.storage.delete(quad.getSubject(), quad.getPredicate(), quad.getObject());
        } else {
            this.storage.delete(quad);
        }
    }

    public void add(Node g, Node s, Node p, Node o) {
        if (Quad.isUnionGraph((Node)g)) {
            throw new AddDeniedException("Can't add to the union graph");
        }
        if (g == null || Quad.isDefaultGraph((Node)g)) {
            this.storage.add(s, p, o);
        } else {
            this.storage.add(g, s, p, o);
        }
    }

    public void delete(Node g, Node s, Node p, Node o) {
        if (Quad.isUnionGraph((Node)g)) {
            throw new DeleteDeniedException("Can't remove from the union graph");
        }
        if (g == null || Quad.isDefaultGraph((Node)g)) {
            this.storage.delete(s, p, o);
        } else {
            this.storage.delete(g, s, p, o);
        }
    }

    public void addGraph(Node graphName, Graph graph) {
        graph.find(null, null, null).forEachRemaining(t -> this.add(graphName, t.getSubject(), t.getPredicate(), t.getObject()));
        graph.getPrefixMapping().getNsPrefixMap().forEach((p, u) -> this.prefixes.add(graphName, (String)p, (String)u));
    }

    public void removeGraph(Node graphName) {
        this.storage.removeAll(graphName, Node.ANY, Node.ANY, Node.ANY);
        this.prefixes.deleteAll(graphName);
    }
}

