/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.algebra;

import java.util.ArrayList;
import java.util.List;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.sail.rdbms.algebra.base.RdbmsQueryModelNodeBase;
import org.openrdf.sail.rdbms.algebra.base.RdbmsQueryModelVisitorBase;
import org.openrdf.sail.rdbms.algebra.base.SqlExpr;

public class SqlCase
extends RdbmsQueryModelNodeBase
implements SqlExpr {
    private List<Entry> entries = new ArrayList<Entry>();

    public void when(SqlExpr condition, SqlExpr expr) {
        this.entries.add(new Entry(condition, expr));
        condition.setParentNode(this);
        expr.setParentNode(this);
    }

    public List<Entry> getEntries() {
        return new ArrayList<Entry>(this.entries);
    }

    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        for (Entry e : this.entries) {
            e.getCondition().visit(visitor);
            e.getResult().visit(visitor);
        }
    }

    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        for (Entry e : this.entries) {
            if (e.getCondition() == current) {
                e.setCondition((SqlExpr)replacement);
                continue;
            }
            if (e.getResult() != current) continue;
            e.setResult((SqlExpr)replacement);
        }
    }

    @Override
    public SqlCase clone() {
        SqlCase clone = (SqlCase)super.clone();
        clone.entries = new ArrayList<Entry>();
        for (Entry e : this.entries) {
            clone.when(e.getCondition().clone(), e.getResult().clone());
        }
        return clone;
    }

    @Override
    public <X extends Exception> void visit(RdbmsQueryModelVisitorBase<X> visitor) throws X {
        visitor.meet(this);
    }

    public void removeEntry(Entry e) {
        this.entries.remove(e);
    }

    public void truncateEntries(Entry e) {
        int idx = this.entries.indexOf(e) + 1;
        if (idx < this.entries.size()) {
            this.entries = this.entries.subList(0, idx);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entries == null ? 0 : this.entries.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SqlCase other = (SqlCase)obj;
        return !(this.entries == null ? other.entries != null : !this.entries.equals(other.entries));
    }

    public class Entry {
        private SqlExpr condition;
        private SqlExpr result;

        public Entry(SqlExpr condition, SqlExpr result) {
            this.condition = condition;
            this.result = result;
        }

        public SqlExpr getCondition() {
            return this.condition;
        }

        public void setCondition(SqlExpr condition) {
            this.condition = condition;
            condition.setParentNode(SqlCase.this);
        }

        public SqlExpr getResult() {
            return this.result;
        }

        public void setResult(SqlExpr result) {
            this.result = result;
            result.setParentNode(SqlCase.this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.condition == null ? 0 : this.condition.hashCode());
            result = 31 * result + (this.result == null ? 0 : this.result.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            if (this.condition == null ? other.condition != null : !this.condition.equals(other.condition)) {
                return false;
            }
            return !(this.result == null ? other.result != null : !this.result.equals(other.result));
        }
    }
}

