/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.iteration;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.evaluation.QueryBindingSet;
import org.openrdf.sail.rdbms.RdbmsValueFactory;
import org.openrdf.sail.rdbms.algebra.ColumnVar;
import org.openrdf.sail.rdbms.exceptions.RdbmsQueryEvaluationException;
import org.openrdf.sail.rdbms.iteration.base.RdbmIterationBase;
import org.openrdf.sail.rdbms.model.RdbmsResource;
import org.openrdf.sail.rdbms.model.RdbmsValue;
import org.openrdf.sail.rdbms.schema.IdSequence;

public class RdbmsBindingIteration
extends RdbmIterationBase<BindingSet, QueryEvaluationException> {
    private BindingSet bindings;
    private Collection<ColumnVar> projections;
    private RdbmsValueFactory vf;
    private IdSequence ids;

    public RdbmsBindingIteration(PreparedStatement stmt) throws SQLException {
        super(stmt);
    }

    public void setBindings(BindingSet bindings) {
        this.bindings = bindings;
    }

    public void setProjections(Collection<ColumnVar> proj) {
        this.projections = proj;
    }

    public void setValueFactory(RdbmsValueFactory vf) {
        this.vf = vf;
    }

    public void setIdSequence(IdSequence ids) {
        this.ids = ids;
    }

    @Override
    protected BindingSet convert(ResultSet rs) throws SQLException {
        QueryBindingSet result = new QueryBindingSet(this.bindings);
        for (ColumnVar var : this.projections) {
            String name = var.getName();
            if (var == null || result.hasBinding(name)) continue;
            Value value = var.getValue();
            if (value == null) {
                value = this.createValue(rs, var.getIndex() + 1);
            }
            if (value == null) continue;
            result.addBinding(var.getName(), value);
        }
        return result;
    }

    @Override
    protected QueryEvaluationException convertSQLException(SQLException e) {
        return new RdbmsQueryEvaluationException(e);
    }

    private RdbmsResource createResource(ResultSet rs, int index) throws SQLException {
        Number id = this.ids.idOf(rs.getLong(index));
        if (id.longValue() == 0L) {
            return null;
        }
        return this.vf.getRdbmsResource(id, rs.getString(index + 1));
    }

    private RdbmsValue createValue(ResultSet rs, int index) throws SQLException {
        Number id = this.ids.idOf(rs.getLong(index));
        if (this.ids.isLiteral(id)) {
            String label = rs.getString(index + 1);
            String language = rs.getString(index + 2);
            String datatype = rs.getString(index + 3);
            return this.vf.getRdbmsLiteral(id, label, language, datatype);
        }
        return this.createResource(rs, index);
    }
}

