/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.schema;

import java.sql.SQLException;
import org.openrdf.sail.helpers.DefaultSailChangedEvent;
import org.openrdf.sail.rdbms.schema.Batch;
import org.openrdf.sail.rdbms.schema.TripleTable;

public class TripleBatch
extends Batch {
    public static int total_rows;
    public static int total_st;
    public static int total_wait;
    private TripleTable table;
    private DefaultSailChangedEvent sailChangedEvent;

    public void setTable(TripleTable table) {
        assert (table != null);
        this.table = table;
    }

    public void setSailChangedEvent(DefaultSailChangedEvent sailChangedEvent) {
        this.sailChangedEvent = sailChangedEvent;
    }

    @Override
    public boolean isReady() {
        return this.table.isReady();
    }

    @Override
    public synchronized int flush() throws SQLException {
        this.table.blockUntilReady();
        long start = System.currentTimeMillis();
        int count = super.flush();
        long end = System.currentTimeMillis();
        total_rows += count;
        total_st += 2;
        total_wait = (int)((long)total_wait + (end - start));
        if (count > 0) {
            this.sailChangedEvent.setStatementsAdded(true);
        }
        return count;
    }
}

