/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph.specifics;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.graph.EdgeSetFactory;
import org.jgrapht.graph.specifics.ArrayUnenforcedSetEdgeSetFactory;
import org.jgrapht.graph.specifics.Specifics;
import org.jgrapht.graph.specifics.UndirectedEdgeContainer;
import org.jgrapht.util.ArrayUnenforcedSet;

public class UndirectedSpecifics<V, E>
implements Specifics<V, E>,
Serializable {
    private static final long serialVersionUID = 4206026440450450992L;
    protected Graph<V, E> graph;
    protected Map<V, UndirectedEdgeContainer<V, E>> vertexMap;
    protected EdgeSetFactory<V, E> edgeSetFactory;

    @Deprecated
    public UndirectedSpecifics(Graph<V, E> graph) {
        this(graph, new LinkedHashMap(), new ArrayUnenforcedSetEdgeSetFactory());
    }

    @Deprecated
    public UndirectedSpecifics(Graph<V, E> graph, Map<V, UndirectedEdgeContainer<V, E>> vertexMap) {
        this(graph, vertexMap, new ArrayUnenforcedSetEdgeSetFactory());
    }

    public UndirectedSpecifics(Graph<V, E> graph, Map<V, UndirectedEdgeContainer<V, E>> vertexMap, EdgeSetFactory<V, E> edgeSetFactory) {
        this.graph = Objects.requireNonNull(graph);
        this.vertexMap = Objects.requireNonNull(vertexMap);
        this.edgeSetFactory = Objects.requireNonNull(edgeSetFactory);
    }

    @Override
    public boolean addVertex(V v) {
        UndirectedEdgeContainer<V, E> ec = this.vertexMap.get(v);
        if (ec == null) {
            this.vertexMap.put((UndirectedEdgeContainer<V, E>)v, (UndirectedEdgeContainer<UndirectedEdgeContainer<V, E>, E>)new UndirectedEdgeContainer<V, E>(this.edgeSetFactory, v));
            return true;
        }
        return false;
    }

    @Override
    public Set<V> getVertexSet() {
        return this.vertexMap.keySet();
    }

    @Override
    public Set<E> getAllEdges(V sourceVertex, V targetVertex) {
        ArrayUnenforcedSet edges = null;
        if (this.graph.containsVertex(sourceVertex) && this.graph.containsVertex(targetVertex)) {
            edges = new ArrayUnenforcedSet();
            for (Object e : this.getEdgeContainer(sourceVertex).vertexEdges) {
                boolean equal = this.isEqualsStraightOrInverted(sourceVertex, targetVertex, e);
                if (!equal) continue;
                edges.add(e);
            }
        }
        return edges;
    }

    @Override
    public E getEdge(V sourceVertex, V targetVertex) {
        if (this.graph.containsVertex(sourceVertex) && this.graph.containsVertex(targetVertex)) {
            for (Object e : this.getEdgeContainer(sourceVertex).vertexEdges) {
                boolean equal = this.isEqualsStraightOrInverted(sourceVertex, targetVertex, e);
                if (!equal) continue;
                return e;
            }
        }
        return null;
    }

    private boolean isEqualsStraightOrInverted(Object sourceVertex, Object targetVertex, E e) {
        boolean equalStraight = sourceVertex.equals(this.graph.getEdgeSource(e)) && targetVertex.equals(this.graph.getEdgeTarget(e));
        boolean equalInverted = sourceVertex.equals(this.graph.getEdgeTarget(e)) && targetVertex.equals(this.graph.getEdgeSource(e));
        return equalStraight || equalInverted;
    }

    @Override
    public void addEdgeToTouchingVertices(E e) {
        V source = this.graph.getEdgeSource(e);
        V target = this.graph.getEdgeTarget(e);
        this.getEdgeContainer(source).addEdge(e);
        if (!source.equals(target)) {
            this.getEdgeContainer(target).addEdge(e);
        }
    }

    @Override
    public int degreeOf(V vertex) {
        if (this.graph.getType().isAllowingSelfLoops()) {
            int degree = 0;
            Set edges = this.getEdgeContainer(vertex).vertexEdges;
            for (Object e : edges) {
                if (this.graph.getEdgeSource(e).equals(this.graph.getEdgeTarget(e))) {
                    degree += 2;
                    continue;
                }
                ++degree;
            }
            return degree;
        }
        return this.getEdgeContainer(vertex).edgeCount();
    }

    @Override
    public Set<E> edgesOf(V vertex) {
        return this.getEdgeContainer(vertex).getUnmodifiableVertexEdges();
    }

    @Override
    public int inDegreeOf(V vertex) {
        return this.degreeOf(vertex);
    }

    @Override
    public Set<E> incomingEdgesOf(V vertex) {
        return this.getEdgeContainer(vertex).getUnmodifiableVertexEdges();
    }

    @Override
    public int outDegreeOf(V vertex) {
        return this.degreeOf(vertex);
    }

    @Override
    public Set<E> outgoingEdgesOf(V vertex) {
        return this.getEdgeContainer(vertex).getUnmodifiableVertexEdges();
    }

    @Override
    public void removeEdgeFromTouchingVertices(E e) {
        V source = this.graph.getEdgeSource(e);
        V target = this.graph.getEdgeTarget(e);
        this.getEdgeContainer(source).removeEdge(e);
        if (!source.equals(target)) {
            this.getEdgeContainer(target).removeEdge(e);
        }
    }

    protected UndirectedEdgeContainer<V, E> getEdgeContainer(V vertex) {
        UndirectedEdgeContainer<V, E> ec = this.vertexMap.get(vertex);
        if (ec == null) {
            ec = new UndirectedEdgeContainer<V, E>(this.edgeSetFactory, vertex);
            this.vertexMap.put((UndirectedEdgeContainer<V, E>)vertex, (UndirectedEdgeContainer<UndirectedEdgeContainer<V, E>, E>)ec);
        }
        return ec;
    }
}

