/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sparql;

import info.aduna.io.MavenUtil;
import java.io.File;
import java.util.Map;
import org.openrdf.http.client.HTTPClient;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.base.RepositoryBase;
import org.openrdf.repository.sparql.SPARQLConnection;

public class SPARQLRepository
extends RepositoryBase {
    private static final String APP_NAME = "OpenRDF.org SPARQLConnection";
    private static final String VERSION = MavenUtil.loadVersion((String)"org.openrdf.sesame", (String)"sesame-repository-sparql", (String)"devel");
    private final HTTPClient httpClient;

    public SPARQLRepository(String endpointUrl) {
        this(endpointUrl, endpointUrl);
    }

    public SPARQLRepository(String queryEndpointUrl, String updateEndpointUrl) {
        if (queryEndpointUrl == null || updateEndpointUrl == null) {
            throw new IllegalArgumentException("endpoint URL may not be null.");
        }
        this.httpClient = this.createHTTPClient();
        this.httpClient.setValueFactory((ValueFactory)ValueFactoryImpl.getInstance());
        this.httpClient.setPreferredTupleQueryResultFormat(TupleQueryResultFormat.SPARQL);
        this.httpClient.setQueryURL(queryEndpointUrl);
        this.httpClient.setUpdateURL(updateEndpointUrl);
    }

    protected HTTPClient createHTTPClient() {
        return new HTTPClient();
    }

    public RepositoryConnection getConnection() throws RepositoryException {
        if (!this.isInitialized()) {
            throw new RepositoryException("SPARQLRepository not initialized.");
        }
        return new SPARQLConnection(this);
    }

    public File getDataDir() {
        return null;
    }

    public ValueFactory getValueFactory() {
        return ValueFactoryImpl.getInstance();
    }

    protected void initializeInternal() throws RepositoryException {
        this.httpClient.initialize();
    }

    public boolean isWritable() throws RepositoryException {
        return false;
    }

    public void setDataDir(File dataDir) {
    }

    protected HTTPClient getHTTPClient() {
        return this.httpClient;
    }

    public void setUsernameAndPassword(String username, String password) {
        this.httpClient.setUsernameAndPassword(username, password);
    }

    protected void shutDownInternal() throws RepositoryException {
        this.httpClient.shutDown();
    }

    public String toString() {
        return this.getHTTPClient().getQueryURL();
    }

    public Map<String, String> getAdditionalHttpHeaders() {
        return this.getHTTPClient().getAdditionalHttpHeaders();
    }

    public void setAdditionalHttpHeaders(Map<String, String> additionalHttpHeaders) {
        this.getHTTPClient().setAdditionalHttpHeaders(additionalHttpHeaders);
    }
}

