/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.AbstractBindingSet;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.impl.SimpleBinding;
import org.eclipse.rdf4j.util.iterators.ConvertingIterator;

public class QueryBindingSet
extends AbstractBindingSet {
    private static final long serialVersionUID = -2010715346095527301L;
    private final Map<String, Value> bindings;

    public QueryBindingSet() {
        this(8);
    }

    public QueryBindingSet(int capacity) {
        this.bindings = new HashMap<String, Value>(capacity * 2);
    }

    public QueryBindingSet(BindingSet bindingSet) {
        this(bindingSet.size());
        this.addAll(bindingSet);
    }

    public void addAll(BindingSet bindingSet) {
        if (bindingSet instanceof QueryBindingSet) {
            this.bindings.putAll(((QueryBindingSet)bindingSet).bindings);
        } else {
            for (Binding binding : bindingSet) {
                this.addBinding(binding);
            }
        }
    }

    public void addBinding(Binding binding) {
        this.addBinding(binding.getName(), binding.getValue());
    }

    public void addBinding(String name, Value value) {
        assert (!this.bindings.containsKey(name)) : "variable already bound: " + name;
        this.setBinding(name, value);
    }

    public void setBinding(Binding binding) {
        this.setBinding(binding.getName(), binding.getValue());
    }

    public void setBinding(String name, Value value) {
        this.bindings.put(name, value);
    }

    public void removeBinding(String name) {
        this.bindings.remove(name);
    }

    public void removeAll(Collection<String> bindingNames) {
        this.bindings.keySet().removeAll(bindingNames);
    }

    public void retainAll(Collection<String> bindingNames) {
        this.bindings.keySet().retainAll(bindingNames);
    }

    public Set<String> getBindingNames() {
        return this.bindings.keySet();
    }

    public Value getValue(String bindingName) {
        return this.bindings.get(bindingName);
    }

    public Binding getBinding(String bindingName) {
        Value value = this.getValue(bindingName);
        if (value != null) {
            return new SimpleBinding(bindingName, value);
        }
        return null;
    }

    public boolean hasBinding(String bindingName) {
        return this.bindings.containsKey(bindingName);
    }

    public Iterator<Binding> iterator() {
        Iterator entries = this.bindings.entrySet().stream().filter(entry -> entry.getValue() != null).iterator();
        return new ConvertingIterator<Map.Entry<String, Value>, Binding>(entries){

            protected Binding convert(Map.Entry<String, Value> entry) {
                return new SimpleBinding(entry.getKey(), entry.getValue());
            }
        };
    }

    public int size() {
        return this.bindings.size();
    }

    public boolean equals(Object other) {
        if (other instanceof QueryBindingSet) {
            return this.bindings.equals(((QueryBindingSet)((Object)other)).bindings);
        }
        return super.equals(other);
    }
}

