/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfs.assembler;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.exceptions.AssemblerException;
import org.apache.jena.graph.Graph;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdfs.DatasetGraphRDFS;
import org.apache.jena.rdfs.RDFSFactory;
import org.apache.jena.rdfs.SetupRDFS;
import org.apache.jena.rdfs.assembler.VocabRDFS;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.assembler.DatasetAssembler;
import org.apache.jena.sparql.util.graph.GraphUtils;

public class DatasetRDFSAssembler
extends DatasetAssembler {
    public static Resource getType() {
        return VocabRDFS.tDatasetRDFS;
    }

    @Override
    public DatasetGraph createDataset(Assembler a, Resource root2) {
        DatasetGraph base = super.createBaseDataset(root2, VocabRDFS.pDataset);
        if (base == null) {
            throw new AssemblerException(root2, "Required base dataset missing: " + VocabRDFS.pDataset);
        }
        String schemaFile = GraphUtils.getAsStringValue(root2, VocabRDFS.pRdfsSchemaFile);
        if (schemaFile == null) {
            throw new AssemblerException(root2, "Required property missing: " + VocabRDFS.pRdfsSchemaFile);
        }
        Graph schema = RDFDataMgr.loadGraph(schemaFile);
        SetupRDFS setup = RDFSFactory.setupRDFS(schema);
        DatasetGraphRDFS dsg = new DatasetGraphRDFS(base, setup);
        return dsg;
    }
}

