/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.adapters;

import java.io.InputStream;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.stream.Locator;
import org.apache.jena.riot.system.stream.LocatorFile;
import org.apache.jena.riot.system.stream.LocatorHTTP;
import org.apache.jena.riot.system.stream.LocatorZip;
import org.apache.jena.util.LocationMapper;
import org.apache.jena.util.LocatorClassLoader;
import org.apache.jena.util.LocatorURL;
import org.apache.jena.util.TypedStream;

class AdapterLib {
    AdapterLib() {
    }

    public static TypedStream convert(TypedInputStream in) {
        return new TypedStream((InputStream)in, in.getContentType(), in.getCharset());
    }

    public static org.apache.jena.riot.system.stream.LocationMapper copyConvert(LocationMapper locMap) {
        if (locMap == null) {
            return null;
        }
        org.apache.jena.riot.system.stream.LocationMapper lmap2 = new org.apache.jena.riot.system.stream.LocationMapper();
        locMap.listAltEntries().forEachRemaining(k -> lmap2.addAltEntry((String)k, locMap.getAltEntry(k)));
        locMap.listAltPrefixes().forEachRemaining(k -> lmap2.addAltPrefix((String)k, locMap.getAltPrefix(k)));
        return lmap2;
    }

    public static Locator convert(org.apache.jena.util.Locator oldloc) {
        if (oldloc instanceof org.apache.jena.util.LocatorFile) {
            org.apache.jena.util.LocatorFile lFile = (org.apache.jena.util.LocatorFile)oldloc;
            return new LocatorFile(lFile.getDir());
        }
        if (oldloc instanceof LocatorClassLoader) {
            LocatorClassLoader classLoc = (LocatorClassLoader)oldloc;
            return new org.apache.jena.riot.system.stream.LocatorClassLoader(classLoc.getClassLoader());
        }
        if (oldloc instanceof LocatorURL) {
            return new LocatorHTTP();
        }
        if (oldloc instanceof org.apache.jena.util.LocatorZip) {
            org.apache.jena.util.LocatorZip zipLoc = (org.apache.jena.util.LocatorZip)oldloc;
            return new LocatorZip(zipLoc.getZipFileName());
        }
        throw new RiotException("Unrecognized Locator: " + Lib.className((Object)oldloc));
    }
}

