/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.process;

import java.util.function.Function;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFWrapper;
import org.apache.jena.sparql.core.Quad;

public class StreamRDFApplyObject
extends StreamRDFWrapper {
    private final Function<Node, Node> function;

    public StreamRDFApplyObject(StreamRDF other, Function<Node, Node> function) {
        super(other);
        this.function = function;
    }

    @Override
    public void triple(Triple triple) {
        Node obj2;
        Node obj = triple.getObject();
        if (obj != (obj2 = this.function.apply(obj))) {
            triple = Triple.create((Node)triple.getSubject(), (Node)triple.getPredicate(), (Node)obj2);
        }
        super.triple(triple);
    }

    @Override
    public void quad(Quad quad) {
        Node obj2;
        Node obj = quad.getObject();
        if (obj != (obj2 = this.function.apply(obj))) {
            quad = Quad.create(quad.getGraph(), quad.getSubject(), quad.getPredicate(), obj2);
        }
        super.quad(quad);
    }
}

