/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.lib.RDFTerm2Json;

public class JsonIterator
implements Iterator<JsonObject> {
    private final QueryIterator queryIterator;
    private final List<String> resultVars;

    public JsonIterator(QueryIterator queryIterator, List<String> resultVars) {
        this.queryIterator = queryIterator;
        this.resultVars = Collections.unmodifiableList(resultVars);
    }

    @Override
    public boolean hasNext() {
        if (this.queryIterator == null) {
            return false;
        }
        boolean r = this.queryIterator.hasNext();
        if (!r) {
            this.close();
        }
        return r;
    }

    @Override
    public JsonObject next() {
        if (this.queryIterator == null) {
            throw new NoSuchElementException(this.getClass() + ".next");
        }
        try {
            Binding binding = (Binding)this.queryIterator.next();
            JsonObject jsonObject = new JsonObject();
            for (String resultVar : this.resultVars) {
                Node n = binding.get(Var.alloc(resultVar));
                JsonValue value = RDFTerm2Json.fromNode(n);
                jsonObject.put(resultVar, value);
            }
            return jsonObject;
        }
        catch (NoSuchElementException ex) {
            this.close();
            throw ex;
        }
    }

    private void close() {
        this.queryIterator.close();
    }
}

