/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse.builders;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.path.P_Alt;
import org.apache.jena.sparql.path.P_Distinct;
import org.apache.jena.sparql.path.P_FixedLength;
import org.apache.jena.sparql.path.P_Inverse;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.P_Mod;
import org.apache.jena.sparql.path.P_Multi;
import org.apache.jena.sparql.path.P_NegPropSet;
import org.apache.jena.sparql.path.P_OneOrMore1;
import org.apache.jena.sparql.path.P_OneOrMoreN;
import org.apache.jena.sparql.path.P_Path0;
import org.apache.jena.sparql.path.P_ReverseLink;
import org.apache.jena.sparql.path.P_Seq;
import org.apache.jena.sparql.path.P_Shortest;
import org.apache.jena.sparql.path.P_ZeroOrMore1;
import org.apache.jena.sparql.path.P_ZeroOrMoreN;
import org.apache.jena.sparql.path.P_ZeroOrOne;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.ItemList;
import org.apache.jena.sparql.sse.ItemLocation;
import org.apache.jena.sparql.sse.builders.BuilderLib;
import org.apache.jena.sparql.sse.builders.BuilderNode;

public class BuilderPath {
    protected Map<String, Build> dispatch = new HashMap<String, Build>();
    protected final Build buildPath = new Build(){

        @Override
        public Path make(ItemList list) {
            BuilderLib.checkLength(2, list, "path: Exactly one element");
            Item item = list.get(1);
            return BuilderPath.this.build(item);
        }
    };
    protected final Build buildNotOneOf = new Build(){

        @Override
        public Path make(ItemList list) {
            BuilderLib.checkLengthAtLeast(1, list, "path: negative property set: must be at least one element");
            P_NegPropSet pNegClass = new P_NegPropSet();
            for (int i = 1; i < list.size(); ++i) {
                Item item = list.get(i);
                Path p = BuilderPath.this.build(item);
                if (!(p instanceof P_Path0)) {
                    BuilderLib.broken(item, "Not a property or reverse property");
                }
                pNegClass.add((P_Path0)p);
            }
            return pNegClass;
        }
    };
    protected final Build buildSeq = new Build(){

        @Override
        public Path make(ItemList list) {
            BuilderLib.checkLength(3, 3, list, "path seq: wanted 2 arguments");
            Path left = BuilderPath.this.build(list, 1);
            Path right = BuilderPath.this.build(list, 2);
            return new P_Seq(left, right);
        }
    };
    protected final Build buildAlt = new Build(){

        @Override
        public Path make(ItemList list) {
            BuilderLib.checkLength(3, 3, list, "path alt: wanted 2 arguments");
            Path left = BuilderPath.this.build(list, 1);
            Path right = BuilderPath.this.build(list, 2);
            return new P_Alt(left, right);
        }
    };
    protected final Build buildMod = new Build(){

        @Override
        public Path make(ItemList list) {
            BuilderLib.checkLength(4, 4, list, "path mod: wanted 3 arguments");
            long min2 = BuilderPath.modInt(list.get(1));
            long max2 = BuilderPath.modInt(list.get(2));
            Path path = BuilderPath.this.build(list, 3);
            return new P_Mod(path, min2, max2);
        }
    };
    protected final Build buildFixedLength = new Build(){

        @Override
        public Path make(ItemList list) {
            BuilderLib.checkLength(3, 3, list, "path fixed repeat: wanted 2 arguments");
            long count = BuilderPath.modInt(list.get(1));
            Path path = BuilderPath.this.build(list, 2);
            return new P_FixedLength(path, count);
        }
    };
    protected final Build buildDistinct = new Build(){

        @Override
        public Path make(ItemList list) {
            BuilderLib.checkLength(2, 2, list, "path distinct: wanted 1 argument");
            Path path = BuilderPath.this.build(list, 1);
            return new P_Distinct(path);
        }
    };
    protected final Build buildMulti = new Build(){

        @Override
        public Path make(ItemList list) {
            BuilderLib.checkLength(2, 2, list, "path multi : wanted 1 argument");
            Path path = BuilderPath.this.build(list, 1);
            return new P_Multi(path);
        }
    };
    protected final Build buildShortest = new Build(){

        @Override
        public Path make(ItemList list) {
            BuilderLib.checkLength(2, 2, list, "path shortest : wanted 1 argument");
            Path path = BuilderPath.this.build(list, 1);
            return new P_Shortest(path);
        }
    };
    protected final Build buildZeroOrMore1 = new Build(){

        @Override
        public Path make(ItemList list) {
            BuilderLib.checkLength(2, 2, list, "path ZeroOrMore1: wanted 1 argument");
            Path path = BuilderPath.this.build(list, 1);
            return new P_ZeroOrMore1(path);
        }
    };
    protected final Build buildZeroOrMoreN = new Build(){

        @Override
        public Path make(ItemList list) {
            BuilderLib.checkLength(2, 2, list, "path ZeroOrMoreN: wanted 1 argument");
            Path path = BuilderPath.this.build(list, 1);
            return new P_ZeroOrMoreN(path);
        }
    };
    protected final Build buildZeroOrOne = new Build(){

        @Override
        public Path make(ItemList list) {
            BuilderLib.checkLength(2, 2, list, "path ZeroOrOne: wanted 1 argument");
            Path path = BuilderPath.this.build(list, 1);
            return new P_ZeroOrOne(path);
        }
    };
    protected final Build buildOneOrMore1 = new Build(){

        @Override
        public Path make(ItemList list) {
            BuilderLib.checkLength(2, 2, list, "path OneOrMore: wanted 1 argument");
            Path path = BuilderPath.this.build(list, 1);
            return new P_OneOrMore1(path);
        }
    };
    protected final Build buildOneOrMoreN = new Build(){

        @Override
        public Path make(ItemList list) {
            BuilderLib.checkLength(2, 2, list, "path OneOrMore: wanted 1 argument");
            Path path = BuilderPath.this.build(list, 1);
            return new P_OneOrMoreN(path);
        }
    };
    protected final Build buildReverse = new Build(){

        @Override
        public Path make(ItemList list) {
            BuilderLib.checkLength(2, 2, list, "path reverse: wanted 1 argument");
            Path path = BuilderPath.this.build(list, 1);
            return new P_Inverse(path);
        }
    };
    protected final Build buildLink = new Build(){

        @Override
        public Path make(ItemList list) {
            BuilderLib.checkLength(2, 2, list, "path link: wanted 1 argument");
            return new P_Link(list.get(1).getNode());
        }
    };
    protected final Build buildRev = new Build(){

        @Override
        public Path make(ItemList list) {
            BuilderLib.checkLength(2, 2, list, "path reverse link: wanted 1 argument");
            return new P_ReverseLink(list.get(1).getNode());
        }
    };

    public static Path buildPath(Item item) {
        BuilderPath bob = new BuilderPath();
        return bob.build(item);
    }

    public static TriplePath buildTriplePath(ItemList list) {
        if (list.size() != 3 && list.size() != 4) {
            BuilderLib.broken((ItemLocation)list, "Not a triple path", list);
        }
        if (list.size() == 4) {
            if (!list.get(0).isSymbol("path")) {
                BuilderLib.broken(list, "Not a triple path");
            }
            list = list.cdr();
        }
        Node s = BuilderNode.buildNode(list.get(0));
        Path p = BuilderPath.buildPath(list.get(1));
        Node o = BuilderNode.buildNode(list.get(2));
        return new TriplePath(s, p, o);
    }

    private BuilderPath() {
        this.dispatch.put("path", this.buildPath);
        this.dispatch.put("seq", this.buildSeq);
        this.dispatch.put("alt", this.buildAlt);
        this.dispatch.put("mod", this.buildMod);
        this.dispatch.put("pathN", this.buildFixedLength);
        this.dispatch.put("distinct", this.buildDistinct);
        this.dispatch.put("multi", this.buildMulti);
        this.dispatch.put("shortest", this.buildShortest);
        this.dispatch.put("path?", this.buildZeroOrOne);
        this.dispatch.put("path*", this.buildZeroOrMore1);
        this.dispatch.put("pathN*", this.buildZeroOrMoreN);
        this.dispatch.put("path+", this.buildOneOrMore1);
        this.dispatch.put("pathN+", this.buildOneOrMoreN);
        this.dispatch.put("reverse", this.buildReverse);
        this.dispatch.put("rev", this.buildRev);
        this.dispatch.put("link", this.buildLink);
        this.dispatch.put("notoneof", this.buildNotOneOf);
    }

    private Path build(Item item) {
        if (item.isNode()) {
            if (item.getNode().isURI()) {
                return new P_Link(item.getNode());
            }
            BuilderLib.broken(item, "Attempt to build path from a plain node");
        }
        if (item.isSymbol()) {
            BuilderLib.broken(item, "Attempt to build path from a bare symbol");
        }
        return this.build(item.getList());
    }

    private Path build(ItemList list) {
        Item head = list.get(0);
        if (!head.isSymbol()) {
            return this.build(head);
        }
        String tag = head.getSymbol();
        Build bob = this.findBuild(tag);
        if (bob != null) {
            return bob.make(list);
        }
        BuilderLib.broken(head, "Unrecognized path operation: " + tag);
        return null;
    }

    protected Build findBuild(String str2) {
        for (String key : this.dispatch.keySet()) {
            if (!str2.equalsIgnoreCase(key)) continue;
            return this.dispatch.get(key);
        }
        return null;
    }

    protected Path build(ItemList list, int idx) {
        return this.build(list.get(idx));
    }

    static long modInt(Item item) {
        if (item.isDefault()) {
            return -1L;
        }
        return BuilderNode.buildLong(item);
    }

    static interface Build {
        public Path make(ItemList var1);
    }
}

