# coding: utf-8

"""
    Readarr

    Readarr API docs  # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel
from readarr.models.add_author_options import AddAuthorOptions
from readarr.models.author_statistics_resource import AuthorStatisticsResource
from readarr.models.author_status_type import AuthorStatusType
from readarr.models.book import Book
from readarr.models.links import Links
from readarr.models.media_cover import MediaCover
from readarr.models.ratings import Ratings

class AuthorResource(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    id: Optional[int]
    author_metadata_id: Optional[int]
    status: Optional[AuthorStatusType]
    ended: Optional[bool]
    author_name: Optional[str]
    author_name_last_first: Optional[str]
    foreign_author_id: Optional[str]
    title_slug: Optional[str]
    overview: Optional[str]
    disambiguation: Optional[str]
    links: Optional[List]
    next_book: Optional[Book]
    last_book: Optional[Book]
    images: Optional[List]
    remote_poster: Optional[str]
    path: Optional[str]
    quality_profile_id: Optional[int]
    metadata_profile_id: Optional[int]
    monitored: Optional[bool]
    root_folder_path: Optional[str]
    genres: Optional[List]
    clean_name: Optional[str]
    sort_name: Optional[str]
    sort_name_last_first: Optional[str]
    tags: Optional[List]
    added: Optional[datetime]
    add_options: Optional[AddAuthorOptions]
    ratings: Optional[Ratings]
    statistics: Optional[AuthorStatisticsResource]
    __properties = ["id", "authorMetadataId", "status", "ended", "authorName", "authorNameLastFirst", "foreignAuthorId", "titleSlug", "overview", "disambiguation", "links", "nextBook", "lastBook", "images", "remotePoster", "path", "qualityProfileId", "metadataProfileId", "monitored", "rootFolderPath", "genres", "cleanName", "sortName", "sortNameLastFirst", "tags", "added", "addOptions", "ratings", "statistics"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True
        alias_generator = lambda x: x.split("_")[0] + "".join(word.capitalize() for word in x.split("_")[1:])

    def __getitem__(self, item):
        return getattr(self, item)

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AuthorResource:
        """Create an instance of AuthorResource from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "ended",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # override the default output from pydantic by calling `to_dict()` of next_book
        if self.next_book:
            _dict['nextBook'] = self.next_book.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_book
        if self.last_book:
            _dict['lastBook'] = self.last_book.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in images (list)
        _items = []
        if self.images:
            for _item in self.images:
                if _item:
                    _items.append(_item.to_dict())
            _dict['images'] = _items
        # override the default output from pydantic by calling `to_dict()` of add_options
        if self.add_options:
            _dict['addOptions'] = self.add_options.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ratings
        if self.ratings:
            _dict['ratings'] = self.ratings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of statistics
        if self.statistics:
            _dict['statistics'] = self.statistics.to_dict()
        # set to None if author_name (nullable) is None
        if self.author_name is None:
            _dict['authorName'] = None

        # set to None if author_name_last_first (nullable) is None
        if self.author_name_last_first is None:
            _dict['authorNameLastFirst'] = None

        # set to None if foreign_author_id (nullable) is None
        if self.foreign_author_id is None:
            _dict['foreignAuthorId'] = None

        # set to None if title_slug (nullable) is None
        if self.title_slug is None:
            _dict['titleSlug'] = None

        # set to None if overview (nullable) is None
        if self.overview is None:
            _dict['overview'] = None

        # set to None if disambiguation (nullable) is None
        if self.disambiguation is None:
            _dict['disambiguation'] = None

        # set to None if links (nullable) is None
        if self.links is None:
            _dict['links'] = None

        # set to None if images (nullable) is None
        if self.images is None:
            _dict['images'] = None

        # set to None if remote_poster (nullable) is None
        if self.remote_poster is None:
            _dict['remotePoster'] = None

        # set to None if path (nullable) is None
        if self.path is None:
            _dict['path'] = None

        # set to None if root_folder_path (nullable) is None
        if self.root_folder_path is None:
            _dict['rootFolderPath'] = None

        # set to None if genres (nullable) is None
        if self.genres is None:
            _dict['genres'] = None

        # set to None if clean_name (nullable) is None
        if self.clean_name is None:
            _dict['cleanName'] = None

        # set to None if sort_name (nullable) is None
        if self.sort_name is None:
            _dict['sortName'] = None

        # set to None if sort_name_last_first (nullable) is None
        if self.sort_name_last_first is None:
            _dict['sortNameLastFirst'] = None

        # set to None if tags (nullable) is None
        if self.tags is None:
            _dict['tags'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AuthorResource:
        """Create an instance of AuthorResource from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AuthorResource.parse_obj(obj)

        _obj = AuthorResource.parse_obj({
            "id": obj.get("id"),
            "author_metadata_id": obj.get("authorMetadataId"),
            "status": obj.get("status"),
            "ended": obj.get("ended"),
            "author_name": obj.get("authorName"),
            "author_name_last_first": obj.get("authorNameLastFirst"),
            "foreign_author_id": obj.get("foreignAuthorId"),
            "title_slug": obj.get("titleSlug"),
            "overview": obj.get("overview"),
            "disambiguation": obj.get("disambiguation"),
            "links": [Links.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None,
            "next_book": Book.from_dict(obj.get("nextBook")) if obj.get("nextBook") is not None else None,
            "last_book": Book.from_dict(obj.get("lastBook")) if obj.get("lastBook") is not None else None,
            "images": [MediaCover.from_dict(_item) for _item in obj.get("images")] if obj.get("images") is not None else None,
            "remote_poster": obj.get("remotePoster"),
            "path": obj.get("path"),
            "quality_profile_id": obj.get("qualityProfileId"),
            "metadata_profile_id": obj.get("metadataProfileId"),
            "monitored": obj.get("monitored"),
            "root_folder_path": obj.get("rootFolderPath"),
            "genres": obj.get("genres"),
            "clean_name": obj.get("cleanName"),
            "sort_name": obj.get("sortName"),
            "sort_name_last_first": obj.get("sortNameLastFirst"),
            "tags": obj.get("tags"),
            "added": obj.get("added"),
            "add_options": AddAuthorOptions.from_dict(obj.get("addOptions")) if obj.get("addOptions") is not None else None,
            "ratings": Ratings.from_dict(obj.get("ratings")) if obj.get("ratings") is not None else None,
            "statistics": AuthorStatisticsResource.from_dict(obj.get("statistics")) if obj.get("statistics") is not None else None
        })
        return _obj

