# coding: utf-8

"""
    Readarr

    Readarr API docs  # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel
from readarr.models.add_book_options import AddBookOptions
from readarr.models.author_metadata_lazy_loaded import AuthorMetadataLazyLoaded
from readarr.models.links import Links
from readarr.models.ratings import Ratings

class Book(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    id: Optional[int]
    author_metadata_id: Optional[int]
    foreign_book_id: Optional[str]
    title_slug: Optional[str]
    title: Optional[str]
    release_date: Optional[datetime]
    links: Optional[List]
    genres: Optional[List]
    ratings: Optional[Ratings]
    clean_title: Optional[str]
    monitored: Optional[bool]
    any_edition_ok: Optional[bool]
    last_info_sync: Optional[datetime]
    added: Optional[datetime]
    add_options: Optional[AddBookOptions]
    author_metadata: Optional[AuthorMetadataLazyLoaded]
    author: Optional[AuthorLazyLoaded]
    editions: Optional[EditionListLazyLoaded]
    book_files: Optional[BookFileListLazyLoaded]
    series_links: Optional[SeriesBookLinkListLazyLoaded]
    __properties = ["id", "authorMetadataId", "foreignBookId", "titleSlug", "title", "releaseDate", "links", "genres", "ratings", "cleanTitle", "monitored", "anyEditionOk", "lastInfoSync", "added", "addOptions", "authorMetadata", "author", "editions", "bookFiles", "seriesLinks"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True
        alias_generator = lambda x: x.split("_")[0] + "".join(word.capitalize() for word in x.split("_")[1:])

    def __getitem__(self, item):
        return getattr(self, item)

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Book:
        """Create an instance of Book from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # override the default output from pydantic by calling `to_dict()` of ratings
        if self.ratings:
            _dict['ratings'] = self.ratings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of add_options
        if self.add_options:
            _dict['addOptions'] = self.add_options.to_dict()
        # override the default output from pydantic by calling `to_dict()` of author_metadata
        if self.author_metadata:
            _dict['authorMetadata'] = self.author_metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of author
        if self.author:
            _dict['author'] = self.author.to_dict()
        # override the default output from pydantic by calling `to_dict()` of editions
        if self.editions:
            _dict['editions'] = self.editions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of book_files
        if self.book_files:
            _dict['bookFiles'] = self.book_files.to_dict()
        # override the default output from pydantic by calling `to_dict()` of series_links
        if self.series_links:
            _dict['seriesLinks'] = self.series_links.to_dict()
        # set to None if foreign_book_id (nullable) is None
        if self.foreign_book_id is None:
            _dict['foreignBookId'] = None

        # set to None if title_slug (nullable) is None
        if self.title_slug is None:
            _dict['titleSlug'] = None

        # set to None if title (nullable) is None
        if self.title is None:
            _dict['title'] = None

        # set to None if release_date (nullable) is None
        if self.release_date is None:
            _dict['releaseDate'] = None

        # set to None if links (nullable) is None
        if self.links is None:
            _dict['links'] = None

        # set to None if genres (nullable) is None
        if self.genres is None:
            _dict['genres'] = None

        # set to None if clean_title (nullable) is None
        if self.clean_title is None:
            _dict['cleanTitle'] = None

        # set to None if last_info_sync (nullable) is None
        if self.last_info_sync is None:
            _dict['lastInfoSync'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Book:
        """Create an instance of Book from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Book.parse_obj(obj)

        _obj = Book.parse_obj({
            "id": obj.get("id"),
            "author_metadata_id": obj.get("authorMetadataId"),
            "foreign_book_id": obj.get("foreignBookId"),
            "title_slug": obj.get("titleSlug"),
            "title": obj.get("title"),
            "release_date": obj.get("releaseDate"),
            "links": [Links.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None,
            "genres": obj.get("genres"),
            "ratings": Ratings.from_dict(obj.get("ratings")) if obj.get("ratings") is not None else None,
            "clean_title": obj.get("cleanTitle"),
            "monitored": obj.get("monitored"),
            "any_edition_ok": obj.get("anyEditionOk"),
            "last_info_sync": obj.get("lastInfoSync"),
            "added": obj.get("added"),
            "add_options": AddBookOptions.from_dict(obj.get("addOptions")) if obj.get("addOptions") is not None else None,
            "author_metadata": AuthorMetadataLazyLoaded.from_dict(obj.get("authorMetadata")) if obj.get("authorMetadata") is not None else None,
            "author": AuthorLazyLoaded.from_dict(obj.get("author")) if obj.get("author") is not None else None,
            "editions": EditionListLazyLoaded.from_dict(obj.get("editions")) if obj.get("editions") is not None else None,
            "book_files": BookFileListLazyLoaded.from_dict(obj.get("bookFiles")) if obj.get("bookFiles") is not None else None,
            "series_links": SeriesBookLinkListLazyLoaded.from_dict(obj.get("seriesLinks")) if obj.get("seriesLinks") is not None else None
        })
        return _obj

