# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['text_dedup']

package_data = \
{'': ['*']}

install_requires = \
['datasets>=2.4.0,<3.0.0',
 'datasketch>=1.5.8,<2.0.0',
 'networkit>=10.0,<11.0',
 'numpy>=1.23.2,<2.0.0',
 'pybloom-live>=4.0.0,<5.0.0',
 'rich>=12.5.1,<13.0.0',
 'scipy==1.9.1',
 'tqdm>=4.64.1,<5.0.0',
 'xxhash>=3.0.0,<4.0.0']

setup_kwargs = {
    'name': 'text-dedup',
    'version': '0.3.0',
    'description': 'All-in-one text deduplication',
    'long_description': '\n# text-dedup\n\nA collection of data deduplication scripts.\n\n\n\n![GitHub](https://img.shields.io/github/license/ChenghaoMou/text-dedup) [![Codacy Badge](https://app.codacy.com/project/badge/Grade/cc66178e49d24908ac1fb2b2dbe4e5b3)](https://www.codacy.com/gh/ChenghaoMou/text-dedup/dashboard?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=ChenghaoMou/text-dedup&amp;utm_campaign=Badge_Grade) [![Codacy Badge](https://app.codacy.com/project/badge/Coverage/cc66178e49d24908ac1fb2b2dbe4e5b3)](https://www.codacy.com/gh/ChenghaoMou/text-dedup/dashboard?utm_source=github.com&utm_medium=referral&utm_content=ChenghaoMou/text-dedup&utm_campaign=Badge_Coverage)\n## Features\n\n- Ready to use and modify single script for each method:\n    - MinHash + MinHashLSH\n    - SimHash\n    - SuffixArray Substring\n    - Bloom Filter\n    - Exact Hash\n\n## Acknowledgements\n\n - [Datasketch](https://github.com/ekzhu/datasketch) (MIT)\n - [simhash-py](https://github.com/seomoz/simhash-py/tree/master/simhash) and [simhash-cpp](https://github.com/seomoz/simhash-cpp) (MIT)\n - [Deduplicating Training Data Makes Language Models Better](https://github.com/google-research/deduplicate-text-datasets) (Apache 2.0)\n - [BigScience](https://github.com/bigscience-workshop) (Apache 2.0)\n - [BigCode](https://github.com/bigcode-project) (Apache 2.0)\n\n\n## Quick Examples\n\nIn this section, we are going to deduplicate one dataset: `gl` subset of `oscar-corpus/OSCAR-2201`.\n\n### Suffix Array Substring Exact Deduplication\n```bash\n# input\npython -m text_dedup.suffix_array \\\n    --path "oscar-corpus/OSCAR-2201" \\\n    --name "gl" \\\n    --split "train" \\\n    --cache_dir "./cache" \\\n    --output_dir "output/suffix_array" \\\n    --index_name "lsh.pkl" \\\n    --graph_name "graph.networkit" \\\n    --dedup_name "oscar_gl_dedup" \\\n    --column "text" \\\n    --google_repo_path "/Users/chenghao/Downloads/Projects/text-dedup/deduplicate-text-datasets"\n\n# output\nINFO     All                           : 131.93s\nINFO     Loading                       : 4.36s\nINFO     Preprocessing                 : 4.81s\nINFO     Suffix Array                  : 101.79s\nINFO     Collect                       : 5.17s\nINFO     Restore                       : 0.27s\nINFO     Deduplicate                   : 13.00s\nINFO     Saving                        : 2.52s\nINFO     Before                        : 180332342 bytes (88803)\nINFO     After                         : 97646271 bytes (40404)\nINFO     Output                        : output/suffix_array/oscar_gl_dedup\n```\n\n### MinHash Near Deduplication\n```bash\n# input\npython -m text_dedup.minhash \\\n    --path "oscar-corpus/OSCAR-2201" \\\n    --name "gl" \\\n    --split "train" \\\n    --cache_dir "./cache" \\\n    --output_dir "output/minhash" \\\n    --index_name "lsh.pkl" \\\n    --graph_name "graph.networkit" \\\n    --dedup_name "oscar_gl_dedup" \\\n    --column "text" \\\n    --ngram 1 \\\n    --num_perm 128 \\\n    --threshold 0.8 \\\n    --seed 42\n\n# output\nINFO     All                           : 52.73s\nINFO     Loading                       : 5.32s\nINFO     Minhash                       : 12.82s\nINFO     Index                         : 8.54s\nINFO     Save Index                    : 3.86s\nINFO     Query                         : 4.49s\nINFO     Clustering                    : 17.47s\nINFO     Deduplicate                   : 0.05s\nINFO     Save                          : 0.04s\nINFO     Before                        : 88803\nINFO     After                         : 43971\nINFO     Index                         : output/minhash/lsh.pkl\nINFO     Graph                         : output/minhash/graph.networkit\nINFO     Output                        : output/minhash/oscar_gl_dedup\n```\n\n### SimHash Near Deduplication\n```bash\n# input\npython -m text_dedup.simhash \\\n    --path "oscar-corpus/OSCAR-2201" \\\n    --name "gl" \\\n    --split "train" \\\n    --cache_dir "./cache" \\\n    --output_dir "output/simhash" \\\n    --index_name "index.pkl" \\\n    --graph_name "graph.networkit" \\\n    --dedup_name "oscar_gl_dedup" \\\n    --column "text" \\\n    --ngram 6 \\\n    --bit_diff 3 \\\n    --num_bucket 4\n\n# output\nINFO     All                           : 39.88s\nINFO     Loading                       : 4.45s\nINFO     Simhash                       : 1.91s\nINFO     Index                         : 5.23s\nINFO     Save Index                    : 1.44s\nINFO     Query                         : 6.57s\nINFO     Clustering                    : 16.42s\nINFO     Deduplicate                   : 0.72s\nINFO     Save                          : 3.11s\nINFO     Before                        : 88803\nINFO     After                         : 46659\nINFO     Index                         : output/simhash/index.pkl\nINFO     Graph                         : output/simhash/graph.networkit\nINFO     Output                        : output/simhash/oscar_gl_dedup\n```\n\n### Exact Hash Exact Deduplication\n```bash\n# input\npython -m text_dedup.exact_hash \\\n    --path "oscar-corpus/OSCAR-2201" \\\n    --name "gl" \\\n    --split "train" \\\n    --cache_dir "./cache" \\\n    --output_dir "output/exact_hash" \\\n    --dedup_name "oscar_gl_dedup" \\\n    --column "text"\n\n# output\nINFO     All                           : 5.34s\nINFO     Loading                       : 4.48s\nINFO     Processing                    : 0.73s\nINFO     Filtering                     : 0.07s\nINFO     Saving                        : 0.05s\nINFO     Before                        : 88803\nINFO     After                         : 47049\n```\n\n### Bloom Filter Exact Deduplication\n```bash\n# input\npython -m text_dedup.bloom_filter \\\n    --path "oscar-corpus/OSCAR-2201" \\\n    --name "gl" \\\n    --split "train" \\\n    --cache_dir "./cache" \\\n    --output_dir "output/bloom_filter" \\\n    --dedup_name "oscar_gl_dedup" \\\n    --error_rate 1e-5 \\\n    --column "text"\n\n# output\nINFO     All                           : 10.69s\nINFO     Loading                       : 4.44s\nINFO     Processing                    : 6.13s\nINFO     Filtering                     : 0.07s\nINFO     Saving                        : 0.05s\nINFO     Before                        : 88803\nINFO     After                         : 47045\n```\n\n\n## Documentation\n\n- [ ] TODO\n## Roadmap\n\n-   [ ] Memory benchmark for streaming processing\n-   [ ] Speed benchmark for in-memory processing\n-   [ ] Inter-dataset deduplication\n-   [ ] Rewrite suffix array in Python\n-   [ ] A collections of deduplication methods used in papers/datasets/projects\n-   [ ] SuperMinHash, ProbMinHash, TreeMinHash, BagMinHash, [Optimal Densification for Fast and Accurate Minwise Hashing](https://arxiv.org/abs/1703.04664), [Fast Similarity Sketching](https://arxiv.org/abs/1704.04370)\n## FAQ\n\n### Why use scripts instead of OOD classes and functions?\n\nEarly versions of the code uses object-oriented design for hashing and indexing, which was very difficult because different methods share little to no abstraction. In order to complie something that is useful, a lot of the wrapper code was used, and that actually increased the overhead of using this library. Additionally, deduplicating is often a one-time thing in data preprocessing pipeline, there isn\'t really a need for inline access.\n\n\n### Why license change?\n\nBecause the google repo is licensed under Apache 2.0, I have to update from MIT. Util that part of code is completely re-implemented, Apache 2.0. will be the license I use.\n\n\n## License\n\n[Apache 2.0](https://duckduckgo.com/l/?uddg=https%3A%2F%2Fwww.apache.org%2Flicenses%2FLICENSE%2D2.0.html&rut=617d395c7a807de85e5707aca1f765e5b69a1627ed84c0aefa950e54e00a3094)\n',
    'author': 'Chenghao Mou',
    'author_email': 'mouchenghao@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<3.12',
}


setup(**setup_kwargs)
