Module parameters
   integer :: N, max_residual_terms = 24, generalized_departure(8, 2)
   real(8), dimension(21, 21, 4) :: red_params
   real(8), dimension(21, 21) :: Bv, Gv, Bt, Gt
   real(8), dimension(21, 24) :: noik, toik
   integer, dimension(21, 24) :: doik, coik
   integer, dimension(21) :: Kpol, Kexp
   real(8), dimension(21, 21) :: Fij
   real(8), dimension(21, 21, 12) :: tij, nij, ethaij, epsij, betaij, gammaij
   integer, dimension(21, 21, 12) :: dij
   integer, dimension(21, 21) :: Kpolij, Kexpij
   real(8), dimension(21) :: T_c, rho_c, M
   integer :: tmp1(3), tmp2(14) ! This variables are used to define indexes for repeated terms
   real(8), dimension(21, 12) :: n0i, th0i
   real(8) :: R, eps = 1d-10

End Module

Subroutine get_params()
   use parameters
   integer :: i, j, k
   R = 8.314472d0
   N = 21

   T_c(1) = 190.564d0
   T_c(2) = 126.192d0
   T_c(3) = 304.1282d0
   T_c(4) = 305.322d0
   T_c(5) = 369.825d0
   T_c(6) = 425.125d0
   T_c(7) = 407.817d0
   T_c(8) = 469.7d0
   T_c(9) = 460.35d0
   T_c(10) = 507.82d0
   T_c(11) = 540.13d0
   T_c(12) = 569.32d0
   T_c(13) = 594.55d0
   T_c(14) = 617.7d0
   T_c(15) = 33.19d0
   T_c(16) = 154.595d0
   T_c(17) = 132.86d0
   T_c(18) = 647.096d0
   T_c(19) = 373.1d0
   T_c(20) = 5.1953d0
   T_c(21) = 150.687d0

   rho_c(1) = 10.139342719d0
   rho_c(2) = 11.1839d0
   rho_c(3) = 10.624978698d0
   rho_c(4) = 6.870854540d0
   rho_c(5) = 5.000043088d0
   rho_c(6) = 3.920016792d0
   rho_c(7) = 3.860142940d0
   rho_c(8) = 3.215577588d0
   rho_c(9) = 3.271d0
   rho_c(10) = 2.705877875d0
   rho_c(11) = 2.315324434d0
   rho_c(12) = 2.056404127d0
   rho_c(13) = 1.81d0
   rho_c(14) = 1.64d0
   rho_c(15) = 14.94d0
   rho_c(16) = 13.63d0
   rho_c(17) = 10.85d0
   rho_c(18) = 17.873716090d0
   rho_c(19) = 10.19d0
   rho_c(20) = 17.399d0
   rho_c(21) = 13.407429659d0

   M(1) = 16.04246d0
   M(2) = 28.0134d0
   M(3) = 44.0095d0
   M(4) = 30.06904d0
   M(5) = 44.09562d0
   M(6) = 58.1222d0
   M(7) = 58.1222d0
   M(8) = 72.14878d0
   M(9) = 72.14878d0
   M(10) = 86.17536d0
   M(11) = 100.20194d0
   M(12) = 114.22852d0
   M(13) = 128.2551d0
   M(14) = 142.28168d0
   M(15) = 2.01588d0
   M(16) = 31.9988d0
   M(17) = 28.0101d0
   M(18) = 18.01528d0
   M(19) = 34.08088d0
   M(20) = 4.002602d0
   M(21) = 39.948d0

   Fij(1, 2) = 1.0d0
   Fij(1, 3) = 1.0d0
   Fij(1, 4) = 1.0d0
   Fij(1, 5) = 1.0d0
   Fij(1, 6) = 1.0d0
   Fij(1, 7) = 0.771035405688d0
   Fij(1, 15) = 1.0d0
   Fij(2, 3) = 1.0d0
   Fij(2, 4) = 1.0d0
   Fij(4, 5) = 0.130424765150d0
   Fij(4, 6) = 0.281570073085d0
   Fij(4, 7) = 0.260632376098d0
   Fij(5, 6) = 0.312572600489d-1
   Fij(5, 7) = - 0.551609771024d-1
   Fij(6, 7) = - 0.551240293009d-1

   red_params(1, 2, :) = (/ 0.998721377d0, 1.013950311d0, 0.998098830d0, 0.979273013d0 /)
   red_params(1, 3, :) = (/ 0.999518072d0, 1.002806594d0, 1.022624490d0, 0.975665369d0 /)
   red_params(1, 4, :) = (/ 0.997547866d0, 1.006617867d0, 0.996336508d0, 1.049707697d0 /)
   red_params(1, 5, :) = (/ 1.004827070d0, 1.038470657d0, 0.989680305d0, 1.098655531d0 /)
   red_params(1, 6, :) = (/ 0.979105972d0, 1.045375122d0, 0.994174910d0, 1.171607691d0 /)
   red_params(1, 7, :) = (/ 1.011240388d0, 1.054319053d0, 0.980315756d0, 1.161117729d0 /)
   red_params(1, 8, :) = (/ 0.948330120d0, 1.124508039d0, 0.992127525d0, 1.249173968d0 /)
   red_params(1, 9, :) = (/ 1.0d0, 1.343685343d0, 1.0d0, 1.188899743d0 /)
   red_params(1, 10, :) = (/ 0.958015294d0, 1.052643846d0, 0.981844797d0, 1.330570181d0 /)
   red_params(1, 11, :) = (/ 0.962050831d0, 1.156655935d0, 0.977431529d0, 1.379850328d0 /)
   red_params(1, 12, :) = (/ 0.994740603d0, 1.116549372d0, 0.957473785d0, 1.449245409d0 /)
   red_params(1, 13, :) = (/ 1.002852287d0, 1.141895355d0, 0.947716769d0, 1.528532478d0 /)
   red_params(1, 14, :) = (/ 1.033086292d0, 1.146089637d0, 0.937777823d0, 1.568231489d0 /)
   red_params(1, 15, :) = (/ 1.0d0, 1.018702573d0, 1.0d0, 1.352643115d0 /)
   red_params(1, 16, :) = (/ 1.0d0, 1.0d0, 1.0d0, 0.950000000d0 /)
   red_params(1, 17, :) = (/ 0.997340772d0, 1.006102927d0, 0.987411732d0, 0.987473033d0 /)
   red_params(1, 18, :) = (/ 1.012783169d0, 1.585018334d0, 1.063333913d0, 0.775810513d0 /)
   red_params(1, 19, :) = (/ 1.012599087d0, 1.040161207d0, 1.011090031d0, 0.961155729d0 /)
   red_params(1, 20, :) = (/ 1.0d0, 0.881405683d0, 1.0d0, 3.159776855d0 /)
   red_params(1, 21, :) = (/ 1.034630259d0, 1.014678542d0, 0.990954281d0, 0.989843388d0 /)
   red_params(2, 3, :) = (/ 0.977794634d0, 1.047578256d0, 1.005894529d0, 1.107654104d0 /)
   red_params(2, 4, :) = (/ 0.978880168d0, 1.042352891d0, 1.007671428d0, 1.098650964d0 /)
   red_params(2, 5, :) = (/ 0.974424681d0, 1.081025408d0, 1.002677329d0, 1.201264026d0 /)
   red_params(2, 6, :) = (/ 0.996082610d0, 1.146949309d0, 0.994515234d0, 1.304886838d0 /)
   red_params(2, 7, :) = (/ 0.986415830d0, 1.100576129d0, 0.992868130d0, 1.284462634d0 /)
   red_params(2, 8, :) = (/ 1.0d0, 1.078877166d0, 1.0d0, 1.419029041d0 /)
   red_params(2, 9, :) = (/ 1.0d0, 1.154135439d0, 1.0d0, 1.381770770d0 /)
   red_params(2, 10, :) = (/ 1.0d0, 1.195952177d0, 1.0d0, 1.472607971d0 /)
   red_params(2, 11, :) = (/ 1.0d0, 1.404554090d0, 1.0d0, 1.520975334d0 /)
   red_params(2, 12, :) = (/ 1.0d0, 1.186067025d0, 1.0d0, 1.733280051d0 /)
   red_params(2, 13, :) = (/ 1.0d0, 1.100405929d0, 0.956379450d0, 1.749119996d0 /)
   red_params(2, 14, :) = (/ 1.0d0, 1.0d0, 0.957934447d0, 1.822157123d0 /)
   red_params(2, 15, :) = (/ 0.972532065d0, 0.970115357d0, 0.946134337d0, 1.175696583d0 /)
   red_params(2, 17, :) = (/ 1.0d0, 1.008690943d0, 1.0d0, 0.993425388d0 /)
   red_params(2, 18, :) = (/ 1.0d0, 1.094749685d0, 1.0d0, 0.968808467d0 /)
   red_params(2, 16, :) = (/ 0.999521770d0, 0.997082328d0, 0.997190589d0, 0.995157044d0 /)
   red_params(2, 19, :) = (/ 0.910394249d0, 1.256844157d0, 1.004692366d0, 0.960174200d0 /)
   red_params(2, 20, :) = (/ 0.969501055d0, 0.932629867d0, 0.692868765d0, 1.471831580d0 /)
   red_params(2, 21, :) = (/ 1.004166412d0, 1.002212182d0, 0.999069843d0, 0.990034831d0 /)
   red_params(3, 4, :) = (/ 1.002525718d0, 1.032876701d0, 1.013871147d0, 0.900949530d0 /)
   red_params(3, 5, :) = (/ 0.996898004d0, 1.047596298d0, 1.033620538d0, 0.908772477d0 /)
   red_params(3, 6, :) = (/ 1.174760923d0, 1.222437324d0, 1.018171004d0, 0.911498231d0 /)
   red_params(3, 7, :) = (/ 1.076551882d0, 1.081909003d0, 1.023339824d0, 0.929982936d0 /)
   red_params(3, 8, :) = (/ 1.024311498d0, 1.068406078d0, 1.027000795d0, 0.979217302d0 /)
   red_params(3, 9, :) = (/ 1.060793104d0, 1.116793198d0, 1.019180957d0, 0.961218039d0 /)
   red_params(3, 10, :) = (/ 1.0d0, 0.851343711d0, 1.0d0, 1.038675574d0 /)
   red_params(3, 11, :) = (/ 1.205469976d0, 1.164585914d0, 1.011806317d0, 1.046169823d0 /)
   red_params(3, 12, :) = (/ 1.026169373d0, 1.104043935d0, 1.029690780d0, 1.074455386d0 /)
   red_params(3, 13, :) = (/ 1.0d0, 0.973386152d0, 1.007688620d0, 1.140671202d0 /)
   red_params(3, 14, :) = (/ 1.000151132d0, 1.183394668d0, 1.020028790d0, 1.145512213d0 /)
   red_params(3, 15, :) = (/ 0.904142159d0, 1.152792550d0, 0.942320195d0, 1.782924792d0 /)
   red_params(3, 16, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(3, 17, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(3, 18, :) = (/ 0.949055959d0, 1.542328793d0, 0.997372205d0, 0.775453996d0 /)
   red_params(3, 19, :) = (/ 0.906630564d0, 1.024085837d0, 1.016034583d0, 0.926018880d0 /)
   red_params(3, 20, :) = (/ 0.846647561d0, 0.864141549d0, 0.768377630d0, 3.207456948d0 /)
   red_params(3, 21, :) = (/ 1.008392428d0, 1.029205465d0, 0.996512863d0, 1.050971635d0 /)
   red_params(4, 5, :) = (/ 0.997607277d0, 1.003034720d0, 0.996199694d0, 1.014730190d0 /)
   red_params(4, 6, :) = (/ 0.999157205d0, 1.006179146d0, 0.999130554d0, 1.034832749d0 /)
   red_params(4, 7, :) = (/ 1.0d0, 1.006616886d0, 1.0d0, 1.033283811d0 /)
   red_params(4, 8, :) = (/ 0.993851009d0, 1.026085655d0, 0.998688946d0, 1.066665676d0 /)
   red_params(4, 9, :) = (/ 1.0d0, 1.045439935d0, 1.0d0, 1.021150247d0 /)
   red_params(4, 10, :) = (/ 1.0d0, 1.169701102d0, 1.0d0, 1.092177796d0 /)
   red_params(4, 11, :) = (/ 1.0d0, 1.057666085d0, 1.0d0, 1.134532014d0 /)
   red_params(4, 12, :) = (/ 1.007469726d0, 1.071917985d0, 0.984068272d0, 1.168636194d0 /)
   red_params(4, 13, :) = (/ 1.0d0, 1.143534730d0, 1.0d0, 1.056033030d0 /)
   red_params(4, 14, :) = (/ 0.995676258d0, 1.098361281d0, 0.970918061d0, 1.237191558d0 /)
   red_params(4, 15, :) = (/ 0.925367171d0, 1.106072040d0, 0.932969831d0, 1.902008495d0 /)
   red_params(4, 16, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(4, 17, :) = (/ 1.0d0, 1.201417898d0, 1.0d0, 1.069224728d0 /)
   red_params(4, 18, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(4, 19, :) = (/ 1.010817909d0, 1.030988277d0, 0.990197354d0, 0.902736660d0 /)
   red_params(4, 20, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(4, 21, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(5, 6, :) = (/ 0.999795868d0, 1.003264179d0, 1.000310289d0, 1.007392782d0 /)
   red_params(5, 7, :) = (/ 0.999243146d0, 1.001156119d0, 0.998012298d0, 1.005250774d0 /)
   red_params(5, 8, :) = (/ 1.044919431d0, 1.019921513d0, 0.996484021d0, 1.008344412d0 /)
   red_params(5, 9, :) = (/ 1.040459289d0, 0.999432118d0, 0.994364425d0, 1.003269500d0 /)
   red_params(5, 10, :) = (/ 1.0d0, 1.057872566d0, 1.0d0, 1.025657518d0 /)
   red_params(5, 11, :) = (/ 1.0d0, 1.079648053d0, 1.0d0, 1.050044169d0 /)
   red_params(5, 12, :) = (/ 1.0d0, 1.102764612d0, 1.0d0, 1.063694129d0 /)
   red_params(5, 13, :) = (/ 1.0d0, 1.199769134d0, 1.0d0, 1.109973833d0 /)
   red_params(5, 14, :) = (/ 0.984104227d0, 1.053040574d0, 0.985331233d0, 1.140905252d0 /)
   red_params(5, 15, :) = (/ 1.0d0, 1.074006110d0, 1.0d0, 2.308215191d0 /)
   red_params(5, 16, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(5, 17, :) = (/ 1.0d0, 1.108143673d0, 1.0d0, 1.197564208d0 /)
   red_params(5, 18, :) = (/ 1.0d0, 1.011759763d0, 1.0d0, 0.600340961d0 /)
   red_params(5, 19, :) = (/ 0.936811219d0, 1.010593999d0, 0.992573556d0, 0.905829247d0 /)
   red_params(5, 20, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(5, 21, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(6, 7, :) = (/ 1.000880464d0, 1.000414440d0, 1.000077547d0, 1.001432824d0 /)
   red_params(6, 8, :) = (/ 1.0d0, 1.018159650d0, 1.0d0, 1.002143640d0 /)
   red_params(6, 9, :) = (/ 1.0d0, 1.002728434d0, 1.0d0, 1.000792201d0 /)
   red_params(6, 10, :) = (/ 1.0d0, 1.034995284d0, 1.0d0, 1.009157060d0 /)
   red_params(6, 11, :) = (/ 1.0d0, 1.019174227d0, 1.0d0, 1.021283378d0 /)
   red_params(6, 12, :) = (/ 1.0d0, 1.046905515d0, 1.0d0, 1.033180106d0 /)
   red_params(6, 13, :) = (/ 1.0d0, 1.049219137d0, 1.0d0, 1.014096448d0 /)
   red_params(6, 14, :) = (/ 0.976951968d0, 1.027845529d0, 0.993688386d0, 1.076466918d0 /)
   red_params(6, 15, :) = (/ 1.0d0, 1.232939523d0, 1.0d0, 2.509259945d0 /)
   red_params(6, 16, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(6, 17, :) = (/ 1.0d0, 1.084740904d0, 1.0d0, 1.173916162d0 /)
   red_params(6, 18, :) = (/ 1.0d0, 1.223638763d0, 1.0d0, 0.615512682d0 /)
   red_params(6, 19, :) = (/ 0.908113163d0, 1.033366041d0, 0.985962886d0, 0.926156602d0 /)
   red_params(6, 20, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(6, 21, :) = (/ 1.0d0, 1.214638734d0, 1.0d0, 1.245039498d0 /)
   red_params(7, 8, :) = (/ 1.0d0, 1.002779804d0, 1.0d0, 1.002495889d0 /)
   red_params(7, 9, :) = (/ 1.0d0, 1.002284353d0, 1.0d0, 1.001835788d0 /)
   red_params(7, 10, :) = (/ 1.0d0, 1.010493989d0, 1.0d0, 1.006018054d0 /)
   red_params(7, 11, :) = (/ 1.0d0, 1.021668316d0, 1.0d0, 1.009885760d0 /)
   red_params(7, 12, :) = (/ 1.0d0, 1.032807063d0, 1.0d0, 1.013945424d0 /)
   red_params(7, 13, :) = (/ 1.0d0, 1.047298475d0, 1.0d0, 1.017817492d0 /)
   red_params(7, 14, :) = (/ 1.0d0, 1.060243344d0, 1.0d0, 1.021624748d0 /)
   red_params(7, 15, :) = (/ 1.0d0, 1.147595688d0, 1.0d0, 1.895305393d0 /)
   red_params(7, 16, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(7, 17, :) = (/ 1.0d0, 1.087272232d0, 1.0d0, 1.161390082d0 /)
   red_params(7, 18, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(7, 19, :) = (/ 1.012994431d0, 0.988591117d0, 0.974550548d0, 0.937130844d0 /)
   red_params(7, 20, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(7, 21, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(8, 9, :) = (/ 1.0d0, 1.000024335d0, 1.0d0, 1.000050537d0 /)
   red_params(8, 10, :) = (/ 1.0d0, 1.002480637d0, 1.0d0, 1.000761237d0 /)
   red_params(8, 11, :) = (/ 1.0d0, 1.008972412d0, 1.0d0, 1.002441051d0 /)
   red_params(8, 12, :) = (/ 1.0d0, 1.069223964d0, 1.0d0, 1.016422347d0 /)
   red_params(8, 13, :) = (/ 1.0d0, 1.034910633d0, 1.0d0, 1.103421755d0 /)
   red_params(8, 14, :) = (/ 1.0d0, 1.016370338d0, 1.0d0, 1.049035838d0 /)
   red_params(8, 15, :) = (/ 1.0d0, 1.188334783d0, 1.0d0, 2.013859174d0 /)
   red_params(8, 16, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(8, 17, :) = (/ 1.0d0, 1.119954454d0, 1.0d0, 1.206043295d0 /)
   red_params(8, 18, :) = (/ 1.0d0, 0.956677310d0, 1.0d0, 0.447666011d0 /)
   red_params(8, 19, :) = (/ 0.984613203d0, 1.076539234d0, 0.962006651d0, 0.959065662d0 /)
   red_params(8, 20, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(8, 21, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(9, 10, :) = (/ 1.0d0, 1.002995876d0, 1.0d0, 1.001204174d0 /)
   red_params(9, 11, :) = (/ 1.0d0, 1.009928206d0, 1.0d0, 1.003194615d0 /)
   red_params(9, 12, :) = (/ 1.0d0, 1.017880545d0, 1.0d0, 1.005647480d0 /)
   red_params(9, 13, :) = (/ 1.0d0, 1.028994325d0, 1.0d0, 1.008191499d0 /)
   red_params(9, 14, :) = (/ 1.0d0, 1.039372957d0, 1.0d0, 1.010825138d0 /)
   red_params(9, 15, :) = (/ 1.0d0, 1.184340443d0, 1.0d0, 1.996386669d0 /)
   red_params(9, 16, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(9, 17, :) = (/ 1.0d0, 1.116694577d0, 1.0d0, 1.199326059d0 /)
   red_params(9, 18, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(9, 19, :) = (/ 1.0d0, 0.835763343d0, 1.0d0, 0.982651529d0 /)
   red_params(9, 20, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(9, 21, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(10, 11, :) = (/ 1.0d0, 1.001508227d0, 1.0d0, 0.999762786d0 /)
   red_params(10, 12, :) = (/ 1.0d0, 1.006268954d0, 1.0d0, 1.001633952d0 /)
   red_params(10, 13, :) = (/ 1.0d0, 1.020761680d0, 1.0d0, 1.055369591d0 /)
   red_params(10, 14, :) = (/ 1.001516371d0, 1.013511439d0, 0.997641010d0, 1.028939539d0 /)
   red_params(10, 15, :) = (/ 1.0d0, 1.243461678d0, 1.0d0, 3.021197546d0 /)
   red_params(10, 16, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(10, 17, :) = (/ 1.0d0, 1.155145836d0, 1.0d0, 1.233272781d0 /)
   red_params(10, 18, :) = (/ 1.0d0, 1.170217596d0, 1.0d0, 0.569681333d0 /)
   red_params(10, 19, :) = (/ 0.754473958d0, 1.339283552d0, 0.985891113d0, 0.956075596d0 /)
   red_params(10, 20, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(10, 21, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(11, 12, :) = (/ 1.0d0, 1.006767176d0, 1.0d0, 0.998793111d0 /)
   red_params(11, 13, :) = (/ 1.0d0, 1.001370076d0, 1.0d0, 1.001150096d0 /)
   red_params(11, 14, :) = (/ 1.0d0, 1.002972346d0, 1.0d0, 1.002229938d0 /)
   red_params(11, 15, :) = (/ 1.0d0, 1.159131722d0, 1.0d0, 3.169143057d0 /)
   red_params(11, 16, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(11, 17, :) = (/ 1.0d0, 1.190354273d0, 1.0d0, 1.256123503d0 /)
   red_params(11, 18, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(11, 19, :) = (/ 0.828967164d0, 1.087956749d0, 0.988937417d0, 1.013453092d0 /)
   red_params(11, 20, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(11, 21, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(12, 13, :) = (/ 1.0d0, 1.001357085d0, 1.0d0, 1.000235044d0 /)
   red_params(12, 14, :) = (/ 1.0d0, 1.002553544d0, 1.0d0, 1.007186267d0 /)
   red_params(12, 15, :) = (/ 1.0d0, 1.305249405d0, 1.0d0, 2.191555216d0 /)
   red_params(12, 16, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(12, 17, :) = (/ 1.0d0, 1.219206702d0, 1.0d0, 1.276565536d0 /)
   red_params(12, 18, :) = (/ 1.0d0, 0.599484191d0, 1.0d0, 0.662072469d0 /)
   red_params(12, 19, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(12, 20, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(12, 21, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(13, 14, :) = (/ 1.0d0, 1.000810520d0, 1.0d0, 1.000182392d0 /)
   red_params(13, 15, :) = (/ 1.0d0, 1.342647661d0, 1.0d0, 2.234354040d0 /)
   red_params(13, 16, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(13, 17, :) = (/ 1.0d0, 1.252151449d0, 1.0d0, 1.294070556d0 /)
   red_params(13, 18, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(13, 19, :) = (/ 1.0d0, 1.082905109d0, 1.0d0, 1.086557826d0 /)
   red_params(13, 20, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(13, 21, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(14, 15, :) = (/ 1.695358382d0, 1.120233729d0, 1.064818089d0, 3.786003724d0 /)
   red_params(14, 16, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(14, 17, :) = (/ 1.0d0, 0.870184960d0, 1.049594632d0, 1.803567587d0 /)
   red_params(14, 18, :) = (/ 1.0d0, 0.551405318d0, 0.897162268d0, 0.740416402d0 /)
   red_params(14, 19, :) = (/ 0.975187766d0, 1.171714677d0, 0.973091413d0, 1.103693489d0 /)
   red_params(14, 20, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(14, 21, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(15, 16, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(15, 17, :) = (/ 1.0d0, 1.121416201d0, 1.0d0, 1.377504607d0 /)
   red_params(15, 18, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(15, 19, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(15, 20, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(15, 21, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(16, 17, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(16, 18, :) = (/ 1.0d0, 1.143174289d0, 1.0d0, 0.964767932d0 /)
   red_params(16, 19, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(16, 20, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(16, 21, :) = (/ 0.999746847d0, 0.993907223d0, 1.000023103d0, 0.990430423d0 /)
   red_params(17, 18, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(17, 19, :) = (/ 0.795660392d0, 1.101731308d0, 1.025536736d0, 1.022749748d0 /)
   red_params(17, 20, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(17, 21, :) = (/ 1.0d0, 1.159720623d0, 1.0d0, 0.954215746d0 /)
   red_params(18, 19, :) = (/ 1.0d0, 1.014832832d0, 1.0d0, 0.940587083d0 /)
   red_params(18, 20, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(18, 21, :) = (/ 1.0d0, 1.038993495d0, 1.0d0, 1.070941866d0 /)
   red_params(19, 20, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(19, 21, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)
   red_params(20, 21, :) = (/ 1.0d0, 1.0d0, 1.0d0, 1.0d0 /)

   do i = 1, N - 1
   do j = i + 1, N
      Bv(i, j) = red_params(i, j, 1)
      Gv(i, j) = red_params(i, j, 2)
      Bt(i, j) = red_params(i, j, 3)
      Gt(i, j) = red_params(i, j, 4)
   end do
   end do

   noik(1, 1) = 0.57335704239162d0
   noik(1, 2) = - 0.16760687523730d1
   noik(1, 3) = 0.23405291834916d0
   noik(1, 4) = - 0.21947376343441d0
   noik(1, 5) = 0.16369201404128d-1
   noik(1, 6) = 0.15004406389280d-1
   noik(1, 7) = 0.98990489492918d-1
   noik(1, 8) = 0.58382770929055d0
   noik(1, 9) = - 0.74786867560390d0
   noik(1, 10) = 0.30033302857974d0
   noik(1, 11) = 0.20985543806568d0
   noik(1, 12) = - 0.18590151133061d-1
   noik(1, 13) = - 0.15782558339049d0
   noik(1, 14) = 0.12716735220791d0
   noik(1, 15) = - 0.32019743894346d-1
   noik(1, 16) = - 0.68049729364536d-1
   noik(1, 17) = 0.24291412853736d-1
   noik(1, 18) = 0.51440451639444d-2
   noik(1, 19) = - 0.19084949733532d-1
   noik(1, 20) = 0.55229677241291d-2
   noik(1, 21) = - 0.44197392976085d-2
   noik(1, 22) = 0.40061416708429d-1
   noik(1, 23) = - 0.33752085907575d-1
   noik(1, 24) = - 0.25127658213357d-2

   noik(2, 1) = 0.59889711801201d0
   noik(2, 2) = - 0.16941557480731d1
   noik(2, 3) = 0.24579736191718d0
   noik(2, 4) = - 0.23722456755175d0
   noik(2, 5) = 0.17954918715141d-1
   noik(2, 6) = 0.14592875720215d-1
   noik(2, 7) = 0.10008065936206d0
   noik(2, 8) = 0.73157115385532d0
   noik(2, 9) = - 0.88372272336366d0
   noik(2, 10) = 0.31887660246708d0
   noik(2, 11) = 0.20766491728799d0
   noik(2, 12) = - 0.19379315454158d-1
   noik(2, 13) = - 0.16936641554983d0
   noik(2, 14) = 0.13546846041701d0
   noik(2, 15) = - 0.33066712095307d-1
   noik(2, 16) = - 0.60690817018557d-1
   noik(2, 17) = 0.12797548292871d-1
   noik(2, 18) = 0.58743664107299d-2
   noik(2, 19) = - 0.18451951971969d-1
   noik(2, 20) = 0.47226622042472d-2
   noik(2, 21) = - 0.52024079680599d-2
   noik(2, 22) = 0.43563505956635d-1
   noik(2, 23) = - 0.36251690750939d-1
   noik(2, 24) = - 0.28974026866543d-2

   noik(3, 1) = 0.52646564804653d0
   noik(3, 2) = - 0.14995725042592d1
   noik(3, 3) = 0.27329786733782d0
   noik(3, 4) = 0.12949500022786d0
   noik(3, 5) = 0.15404088341841d0
   noik(3, 6) = - 0.58186950946814d0
   noik(3, 7) = - 0.18022494838296d0
   noik(3, 8) = - 0.95389904072812d-1
   noik(3, 9) = - 0.80486819317679d-2
   noik(3, 10) = - 0.35547751273090d-1
   noik(3, 11) = - 0.28079014882405d0
   noik(3, 12) = - 0.82435890081677d-1
   noik(3, 13) = 0.10832427979006d-1
   noik(3, 14) = - 0.67073993161097d-2
   noik(3, 15) = - 0.46827907600524d-2
   noik(3, 16) = - 0.28359911832177d-1
   noik(3, 17) = 0.19500174744098d-1
   noik(3, 18) = - 0.21609137507166d0
   noik(3, 19) = 0.43772794926972d0
   noik(3, 20) = - 0.22130790113593d0
   noik(3, 21) = 0.15190189957331d-1
   noik(3, 22) = - 0.15380948953300d-1

   noik(4, 1) = 0.63596780450714d0
   noik(4, 2) = - 0.17377981785459d1
   noik(4, 3) = 0.28914060926272d0
   noik(4, 4) = - 0.33714276845694d0
   noik(4, 5) = 0.22405964699561d-1
   noik(4, 6) = 0.15715424886913d-1
   noik(4, 7) = 0.11450634253745
   noik(4, 8) = 0.10612049379745d1
   noik(4, 9) = - 0.12855224439423d1
   noik(4, 10) = 0.39414630777652d0
   noik(4, 11) = 0.31390924682041d0
   noik(4, 12) = - 0.21592277117247d-1
   noik(4, 13) = - 0.21723666564905d0
   noik(4, 14) = - 0.28999574439489d0
   noik(4, 15) = 0.42321173025732d0
   noik(4, 16) = 0.46434100259260d-1
   noik(4, 17) = - 0.13138398329741d0
   noik(4, 18) = 0.11492850364368d-1
   noik(4, 19) = - 0.33387688429909d-1
   noik(4, 20) = 0.15183171583644d-1
   noik(4, 21) = - 0.47610805647657d-2
   noik(4, 22) = 0.46917166277885d-1
   noik(4, 23) = - 0.39401755804649d-1
   noik(4, 24) = - 0.32569956247611d-2

   noik(5, 1) = 0.10403973107358d1
   noik(5, 2) = - 0.28318404081403d1
   noik(5, 3) = 0.84393809606294d0
   noik(5, 4) = - 0.76559591850023d-1
   noik(5, 5) = 0.94697373057280d-1
   noik(5, 6) = 0.24796475497006d-3
   noik(5, 7) = 0.27743760422870d0
   noik(5, 8) = - 0.43846000648377d-1
   noik(5, 9) = - 0.26991064784350d0
   noik(5, 10) = - 0.69313413089860d-1
   noik(5, 11) = - 0.29632145981653d-1
   noik(5, 12) = 0.14040126751380d-1

   noik(6, 1) = 0.10626277411455d1
   noik(6, 2) = - 0.28620951828350d1
   noik(6, 3) = 0.88738233403777d0
   noik(6, 4) = - 0.12570581155345d0
   noik(6, 5) = 0.10286308708106d0
   noik(6, 6) = 0.25358040602654d-3
   noik(6, 7) = 0.32325200233982d0
   noik(6, 8) = - 0.37950761057432d-1
   noik(6, 9) = - 0.32534802014452d0
   noik(6, 10) = - 0.79050969051011d-1
   noik(6, 11) = - 0.20636720547775d-1
   noik(6, 12) = 0.57053809334750d-2

   noik(7, 1) = 0.10429331589100d1
   noik(7, 2) = - 0.28184272548892d1
   noik(7, 3) = 0.86176232397850d0
   noik(7, 4) = - 0.10613619452487d0
   noik(7, 5) = 0.98615749302134d-1
   noik(7, 6) = 0.23948208682322d-3
   noik(7, 7) = 0.30330004856950d0
   noik(7, 8) = - 0.41598156135099d-1
   noik(7, 9) = - 0.29991937470058d0
   noik(7, 10) = - 0.80369342764109d-1
   noik(7, 11) = - 0.29761373251151d-1
   noik(7, 12) = 0.13059630303140d-1

   noik(8, 1) = 0.10968643098001d1
   noik(8, 2) = - 0.29988888298061d1
   noik(8, 3) = 0.99516886799212d0
   noik(8, 4) = - 0.16170708558539d0
   noik(8, 5) = 0.11334460072775d0
   noik(8, 6) = 0.26760595150748d-3
   noik(8, 7) = 0.40979881986931d0
   noik(8, 8) = - 0.40876423083075d-1
   noik(8, 9) = - 0.38169482469447d0
   noik(8, 10) = - 0.10931956843993d0
   noik(8, 11) = - 0.32073223327990d-1
   noik(8, 12) = 0.16877016216975d-1

   noik(9, 1) = 0.10963d1
   noik(9, 2) = - 0.30402d1
   noik(9, 3) = 0.10317d1
   noik(9, 4) = - 0.15410d0
   noik(9, 5) = 0.11535d0
   noik(9, 6) = 0.29809d-3
   noik(9, 7) = 0.39571d0
   noik(9, 8) = - 0.45881d-1
   noik(9, 9) = - 0.35804d0
   noik(9, 10) = - 0.10107d0
   noik(9, 11) = - 0.35484d-1
   noik(9, 12) = 0.18156d-1

   noik(10, 1) = 0.10553238013661d1
   noik(10, 2) = - 0.26120615890629d1
   noik(10, 3) = 0.76613882967260d0
   noik(10, 4) = - 0.29770320622459d0
   noik(10, 5) = 0.11879907733358d0
   noik(10, 6) = 0.27922861062617d-3
   noik(10, 7) = 0.46347589844105d0
   noik(10, 8) = 0.11433196980297d-1
   noik(10, 9) = - 0.48256968738131d0
   noik(10, 10) = - 0.93750558924659d-1
   noik(10, 11) = - 0.67273247155994d-2
   noik(10, 12) = - 0.51141583585428d-2

   noik(11, 1) = 0.10543747645262d1
   noik(11, 2) = - 0.26500681506144d1
   noik(11, 3) = 0.81730047827543d0
   noik(11, 4) = - 0.30451391253428d0
   noik(11, 5) = 0.12253868710800d0
   noik(11, 6) = 0.27266472743928d-3
   noik(11, 7) = 0.49865825681670d0
   noik(11, 8) = - 0.71432815084176d-3
   noik(11, 9) = - 0.54236895525450d0
   noik(11, 10) = - 0.13801821610756d0
   noik(11, 11) = - 0.61595287380011d-2
   noik(11, 12) = 0.48602510393022d-3

   noik(12, 1) = 0.10722544875633d1
   noik(12, 2) = - 0.24632951172003d1
   noik(12, 3) = 0.65386674054928d0
   noik(12, 4) = - 0.36324974085628d0
   noik(12, 5) = 0.12713269626764d0
   noik(12, 6) = 0.30713572777930d-3
   noik(12, 7) = 0.52656856987540d0
   noik(12, 8) = 0.19362862857653d-1
   noik(12, 9) = - 0.58939426849155d0
   noik(12, 10) = - 0.14069963991934d0
   noik(12, 11) = - 0.78966330500036d-2
   noik(12, 12) = 0.33036597968109d-2

   noik(13, 1) = 0.11151d1
   noik(13, 2) = - 0.27020d1
   noik(13, 3) = 0.83416d0
   noik(13, 4) = - 0.38828d0
   noik(13, 5) = 0.13760d0
   noik(13, 6) = 0.28185d-3
   noik(13, 7) = 0.62037d0
   noik(13, 8) = 0.15847d-1
   noik(13, 9) = - 0.61726d0
   noik(13, 10) = - 0.15043d0
   noik(13, 11) = - 0.12982d-1
   noik(13, 12) = 0.44325d-2

   noik(14, 1) = 0.10461d1
   noik(14, 2) = - 0.24807d1
   noik(14, 3) = 0.74372d0
   noik(14, 4) = - 0.52579d0
   noik(14, 5) = 0.15315d0
   noik(14, 6) = 0.32865d-3
   noik(14, 7) = 0.84178d0
   noik(14, 8) = 0.55424d-1
   noik(14, 9) = - 0.73555d0
   noik(14, 10) = - 0.18507d0
   noik(14, 11) = - 0.20775d-1
   noik(14, 12) = 0.12335d-1

   noik(15, 1) = 0.53579928451252d1
   noik(15, 2) = - 0.62050252530595d1
   noik(15, 3) = 0.13830241327086d0
   noik(15, 4) = - 0.71397954896129d-1
   noik(15, 5) = 0.15474053959733d-1
   noik(15, 6) = - 0.14976806405771d0
   noik(15, 7) = - 0.26368723988451d-1
   noik(15, 8) = 0.56681303156066d-1
   noik(15, 9) = - 0.60063958030436d-1
   noik(15, 10) = - 0.45043942027132d0
   noik(15, 11) = 0.42478840244500d0
   noik(15, 12) = - 0.21997640827139d-1
   noik(15, 13) = - 0.10499521374530d-1
   noik(15, 14) = - 0.28955902866816d-2

   noik(16, 1) = 0.88878286369701d0
   noik(16, 2) = - 0.24879433312148d1
   noik(16, 3) = 0.59750190775886d0
   noik(16, 4) = 0.96501817061881d-2
   noik(16, 5) = 0.71970428712770d-1
   noik(16, 6) = 0.22337443000195d-3
   noik(16, 7) = 0.18558686391474d0
   noik(16, 8) = - 0.38129368035760d-1
   noik(16, 9) = - 0.15352245383006d0
   noik(16, 10) = - 0.26726814910919d-1
   noik(16, 11) = - 0.25675298677127d-1
   noik(16, 12) = 0.95714302123668d-2

   noik(17, 1) = 0.90554d0
   noik(17, 2) = - 0.24515d1
   noik(17, 3) = 0.53149d0
   noik(17, 4) = 0.24173d-1
   noik(17, 5) = 0.72156d-1
   noik(17, 6) = 0.18818d-3
   noik(17, 7) = 0.19405d0
   noik(17, 8) = - 0.43268d-1
   noik(17, 9) = - 0.12778d0
   noik(17, 10) = - 0.27896d-1
   noik(17, 11) = - 0.34154d-1
   noik(17, 12) = 0.16329d-1

   noik(18, 1) = 0.82728408749586d0
   noik(18, 2) = - 0.18602220416584d1
   noik(18, 3) = - 0.11199009613744d1
   noik(18, 4) = 0.15635753976056d0
   noik(18, 5) = 0.87375844859025d0
   noik(18, 6) = - 0.36674403715731d0
   noik(18, 7) = 0.53987893432436d-1
   noik(18, 8) = 0.10957690214499d1
   noik(18, 9) = 0.53213037828563d-1
   noik(18, 10) = 0.13050533930825d-1
   noik(18, 11) = - 0.41079520434476d0
   noik(18, 12) = 0.14637443344120d0
   noik(18, 13) = - 0.55726838623719d-1
   noik(18, 14) = - 0.11201774143800d-1
   noik(18, 15) = - 0.66062758068099d-2
   noik(18, 16) = 0.46918522004538d-2

   noik(19, 1) = 0.87641d0
   noik(19, 2) = - 0.20367d1
   noik(19, 3) = 0.21634d0
   noik(19, 4) = - 0.50199d-1
   noik(19, 5) = 0.66994d-1
   noik(19, 6) = 0.19076d-3
   noik(19, 7) = 0.20227d0
   noik(19, 8) = - 0.45348d-2
   noik(19, 9) = - 0.22230d0
   noik(19, 10) = - 0.34714d-1
   noik(19, 11) = - 0.14885d-1
   noik(19, 12) = 0.74154d-2

   noik(20, 1) = - 0.45579024006737d0
   noik(20, 2) = 0.12516390754925d1
   noik(20, 3) = - 0.15438231650621d1
   noik(20, 4) = 0.20467489707221d-1
   noik(20, 5) = - 0.34476212380781d0
   noik(20, 6) = - 0.20858459512787d-1
   noik(20, 7) = 0.16227414711778d-1
   noik(20, 8) = - 0.57471818200892d-1
   noik(20, 9) = 0.19462416430715d-1
   noik(20, 10) = - 0.33295680123020d-1
   noik(20, 11) = - 0.10863577372367d-1
   noik(20, 12) = - 0.22173365245954d-1

   noik(21, 1) = 0.85095714803969d0
   noik(21, 2) = - 0.24003222943480d1
   noik(21, 3) = 0.54127841476466d0
   noik(21, 4) = 0.16919770692538d-1
   noik(21, 5) = 0.68825965019035d-1
   noik(21, 6) = 0.21428032815338d-3
   noik(21, 7) = 0.17429895321992d0
   noik(21, 8) = - 0.33654495604194d-1
   noik(21, 9) = - 0.13526799857691d0
   noik(21, 10) = - 0.16387350791552d-1
   noik(21, 11) = - 0.24987666851475d-1
   noik(21, 12) = 0.88769204815709d-2

   coik(3, 5) = 1
   coik(3, 6) = 1
   coik(3, 7) = 1
   coik(3, 8) = 1
   coik(3, 9) = 1
   coik(3, 10) = 1
   coik(3, 11) = 2
   coik(3, 12) = 2
   coik(3, 13) = 3
   coik(3, 14) = 3
   coik(3, 15) = 3
   coik(3, 16) = 3
   coik(3, 17) = 3
   coik(3, 18) = 5
   coik(3, 19) = 5
   coik(3, 20) = 5
   coik(3, 21) = 6
   coik(3, 22) = 6

   coik(15, 6) = 1
   coik(15, 7) = 1
   coik(15, 8) = 1
   coik(15, 9) = 1
   coik(15, 10) = 2
   coik(15, 11) = 2
   coik(15, 12) = 3
   coik(15, 13) = 3
   coik(15, 14) = 5

   coik(18, 8) = 1
   coik(18, 9) = 1
   coik(18, 10) = 1
   coik(18, 11) = 2
   coik(18, 12) = 2
   coik(18, 13) = 2
   coik(18, 14) = 3
   coik(18, 15) = 5
   coik(18, 16) = 5

   coik(20, 5) = 1
   coik(20, 6) = 1
   coik(20, 7) = 1
   coik(20, 8) = 1
   coik(20, 9) = 1
   coik(20, 10) = 2
   coik(20, 11) = 3
   coik(20, 12) = 3

   tmp1 = (/ 1, 2, 4 /)

   do i = 1, size(tmp1)
      k = tmp1(i)
      doik(k, 1) = 1
      doik(k, 2) = 1
      doik(k, 3) = 2
      doik(k, 4) = 2
      doik(k, 5) = 4
      doik(k, 6) = 4
      doik(k, 7) = 1
      doik(k, 8) = 1
      doik(k, 9) = 1
      doik(k, 10) = 2
      doik(k, 11) = 3
      doik(k, 12) = 6
      doik(k, 13) = 2
      doik(k, 14) = 3
      doik(k, 15) = 3
      doik(k, 16) = 4
      doik(k, 17) = 4
      doik(k, 18) = 2
      doik(k, 19) = 3
      doik(k, 20) = 4
      doik(k, 21) = 5
      doik(k, 22) = 6
      doik(k, 23) = 6
      doik(k, 24) = 7

      toik(k, 1) = 0.125d0
      toik(k, 2) = 1.125d0
      toik(k, 3) = 0.375d0
      toik(k, 4) = 1.125d0
      toik(k, 5) = 0.625d0
      toik(k, 6) = 1.500d0
      toik(k, 7) = 0.625d0
      toik(k, 8) = 2.625d0
      toik(k, 9) = 2.750d0
      toik(k, 10) = 2.125d0
      toik(k, 11) = 2.000d0
      toik(k, 12) = 1.750d0
      toik(k, 13) = 4.500d0
      toik(k, 14) = 4.750d0
      toik(k, 15) = 5.000d0
      toik(k, 16) = 4.000d0
      toik(k, 17) = 4.500d0
      toik(k, 18) = 7.500d0
      toik(k, 19) = 14.000d0
      toik(k, 20) = 11.500d0
      toik(k, 21) = 26.000d0
      toik(k, 22) = 28.000d0
      toik(k, 23) = 30.000d0
      toik(k, 24) = 16.000d0

      coik(k, 7) = 1
      coik(k, 8) = 1
      coik(k, 9) = 1
      coik(k, 10) = 1
      coik(k, 11) = 1
      coik(k, 12) = 1
      coik(k, 13) = 2
      coik(k, 14) = 2
      coik(k, 15) = 2
      coik(k, 16) = 2
      coik(k, 17) = 2
      coik(k, 18) = 3
      coik(k, 19) = 3
      coik(k, 20) = 3
      coik(k, 21) = 6
      coik(k, 22) = 6
      coik(k, 23) = 6
      coik(k, 24) = 6

      Kpol(k) = 6
      Kexp(k) = 18

   end do

   tmp2 = (/ 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 17, 19, 21 /)

   do i = 1, size(tmp2)
      k = tmp2(i)

      coik(k, 7) = 1
      coik(k, 8) = 1
      coik(k, 9) = 2
      coik(k, 10) = 2
      coik(k, 11) = 3
      coik(k, 12) = 3

      doik(k, 1) = 1
      doik(k, 2) = 1
      doik(k, 3) = 1
      doik(k, 4) = 2
      doik(k, 5) = 3
      doik(k, 6) = 7
      doik(k, 7) = 2
      doik(k, 8) = 5
      doik(k, 9) = 1
      doik(k, 10) = 4
      doik(k, 11) = 3
      doik(k, 12) = 4

      toik(k, 1) = 0.250d0
      toik(k, 2) = 1.125d0
      toik(k, 3) = 1.500d0
      toik(k, 4) = 1.375d0
      toik(k, 5) = 0.250d0
      toik(k, 6) = 0.875d0
      toik(k, 7) = 0.625d0
      toik(k, 8) = 1.750d0
      toik(k, 9) = 3.625d0
      toik(k, 10) = 3.625d0
      toik(k, 11) = 14.500d0
      toik(k, 12) = 12.000d0

      Kpol(k) = 6
      Kexp(k) = 6

   end do

   Kpol(3) = 4
   Kexp(3) = 18

   Kpol(15) = 5
   Kexp(15) = 9

   Kpol(18) = 7
   Kexp(18) = 9

   Kpol(20) = 4
   Kexp(20) = 8

   doik(20, 1) = 1
   doik(20, 2) = 1
   doik(20, 3) = 1
   doik(20, 4) = 4
   doik(20, 5) = 1
   doik(20, 6) = 3
   doik(20, 7) = 5
   doik(20, 8) = 5
   doik(20, 9) = 5
   doik(20, 10) = 2
   doik(20, 11) = 1
   doik(20, 12) = 2

   toik(20, 1) = 0.000d0
   toik(20, 2) = 0.125d0
   toik(20, 3) = 0.750d0
   toik(20, 4) = 1.000d0
   toik(20, 5) = 0.750d0
   toik(20, 6) = 2.625d0
   toik(20, 7) = 0.125d0
   toik(20, 8) = 1.250d0
   toik(20, 9) = 2.000d0
   toik(20, 10) = 1.000d0
   toik(20, 11) = 4.500d0
   toik(20, 12) = 5.000d0

   doik(18, 1) = 1
   doik(18, 2) = 1
   doik(18, 3) = 1
   doik(18, 4) = 2
   doik(18, 5) = 2
   doik(18, 6) = 3
   doik(18, 7) = 4
   doik(18, 8) = 1
   doik(18, 9) = 5
   doik(18, 10) = 5
   doik(18, 11) = 1
   doik(18, 12) = 2
   doik(18, 13) = 4
   doik(18, 14) = 4
   doik(18, 15) = 1
   doik(18, 16) = 1

   toik(18, 1) = 0.500d0
   toik(18, 2) = 1.250d0
   toik(18, 3) = 1.875d0
   toik(18, 4) = 0.125d0
   toik(18, 5) = 1.500d0
   toik(18, 6) = 1.000d0
   toik(18, 7) = 0.750d0
   toik(18, 8) = 1.500d0
   toik(18, 9) = 0.625d0
   toik(18, 10) = 2.625d0
   toik(18, 11) = 5.000d0
   toik(18, 12) = 4.000d0
   toik(18, 13) = 4.500d0
   toik(18, 14) = 3.000d0
   toik(18, 15) = 4.000d0
   toik(18, 16) = 6.000d0

   doik(15, 1) = 1
   doik(15, 2) = 1
   doik(15, 3) = 2
   doik(15, 4) = 2
   doik(15, 5) = 4
   doik(15, 6) = 1
   doik(15, 7) = 5
   doik(15, 8) = 5
   doik(15, 9) = 5
   doik(15, 10) = 1
   doik(15, 11) = 1
   doik(15, 12) = 2
   doik(15, 13) = 5
   doik(15, 14) = 1

   toik(15, 1) = 0.500d0
   toik(15, 2) = 0.625d0
   toik(15, 3) = 0.375d0
   toik(15, 4) = 0.625d0
   toik(15, 5) = 1.125d0
   toik(15, 6) = 2.625d0
   toik(15, 7) = 0.000d0
   toik(15, 8) = 0.250d0
   toik(15, 9) = 1.375d0
   toik(15, 10) = 4.000d0
   toik(15, 11) = 4.250d0
   toik(15, 12) = 5.000d0
   toik(15, 13) = 8.000d0
   toik(15, 14) = 8.000d0

   doik(3, 1) = 1
   doik(3, 2) = 1
   doik(3, 3) = 2
   doik(3, 4) = 3
   doik(3, 5) = 3
   doik(3, 6) = 3
   doik(3, 7) = 4
   doik(3, 8) = 5
   doik(3, 9) = 6
   doik(3, 10) = 6
   doik(3, 11) = 1
   doik(3, 12) = 4
   doik(3, 13) = 1
   doik(3, 14) = 1
   doik(3, 15) = 3
   doik(3, 16) = 3
   doik(3, 17) = 4
   doik(3, 18) = 5
   doik(3, 19) = 5
   doik(3, 20) = 5
   doik(3, 21) = 5
   doik(3, 22) = 5

   toik(3, 1) = 0.000d0
   toik(3, 2) = 1.250d0
   toik(3, 3) = 1.625d0
   toik(3, 4) = 0.375d0
   toik(3, 5) = 0.375d0
   toik(3, 6) = 1.375d0
   toik(3, 7) = 1.125d0
   toik(3, 8) = 1.375d0
   toik(3, 9) = 0.125d0
   toik(3, 10) = 1.625d0
   toik(3, 11) = 3.750d0
   toik(3, 12) = 3.500d0
   toik(3, 13) = 7.500d0
   toik(3, 14) = 8.000d0
   toik(3, 15) = 6.000d0
   toik(3, 16) = 16.000d0
   toik(3, 17) = 11.000d0
   toik(3, 18) = 24.000d0
   toik(3, 19) = 26.000d0
   toik(3, 20) = 28.000d0
   toik(3, 21) = 24.000d0
   toik(3, 22) = 26.000d0

! Departure function parameters

   dij(1, 2, 1) = 1
   dij(1, 2, 2) = 4
   dij(1, 2, 3) = 1
   dij(1, 2, 4) = 2
   dij(1, 2, 5) = 2
   dij(1, 2, 6) = 2
   dij(1, 2, 7) = 2
   dij(1, 2, 8) = 2
   dij(1, 2, 9) = 3

   tij(1, 2, 1) = 0.000d0
   tij(1, 2, 2) = 1.850d0
   tij(1, 2, 3) = 7.850d0
   tij(1, 2, 4) = 5.400d0
   tij(1, 2, 5) = 0.000d0
   tij(1, 2, 6) = 0.750d0
   tij(1, 2, 7) = 2.800d0
   tij(1, 2, 8) = 4.450d0
   tij(1, 2, 9) = 4.250d0

   nij(1, 2, 1) = - 0.98038985517335d-2
   nij(1, 2, 2) = 0.42487270143005d-3
   nij(1, 2, 3) = - 0.34800214576142d-1
   nij(1, 2, 4) = - 0.13333813013896d0
   nij(1, 2, 5) = - 0.11993694974627d-1
   nij(1, 2, 6) = 0.69243379775168d-1
   nij(1, 2, 7) = - 0.31022508148249d0
   nij(1, 2, 8) = 0.24495491753226d0
   nij(1, 2, 9) = 0.22369816716981d0

   ethaij(1, 2, 3) = 1.000d0
   ethaij(1, 2, 4) = 1.000d0
   ethaij(1, 2, 5) = 0.250d0
   ethaij(1, 2, 6) = 0.000d0
   ethaij(1, 2, 7) = 0.000d0
   ethaij(1, 2, 8) = 0.000d0
   ethaij(1, 2, 9) = 0.000d0

   epsij(1, 2, 3) = 0.5d0
   epsij(1, 2, 4) = 0.5d0
   epsij(1, 2, 5) = 0.5d0
   epsij(1, 2, 6) = 0.5d0
   epsij(1, 2, 7) = 0.5d0
   epsij(1, 2, 8) = 0.5d0
   epsij(1, 2, 9) = 0.5d0

   betaij(1, 2, 3) = 1.000d0
   betaij(1, 2, 4) = 1.000d0
   betaij(1, 2, 5) = 2.500d0
   betaij(1, 2, 6) = 3.000d0
   betaij(1, 2, 7) = 3.000d0
   betaij(1, 2, 8) = 3.000d0
   betaij(1, 2, 9) = 3.000d0

   gammaij(1, 2, 3) = 0.5d0
   gammaij(1, 2, 4) = 0.5d0
   gammaij(1, 2, 5) = 0.5d0
   gammaij(1, 2, 6) = 0.5d0
   gammaij(1, 2, 7) = 0.5d0
   gammaij(1, 2, 8) = 0.5d0
   gammaij(1, 2, 9) = 0.5d0

   dij(1, 3, 1) = 1
   dij(1, 3, 2) = 2
   dij(1, 3, 3) = 3
   dij(1, 3, 4) = 1
   dij(1, 3, 5) = 2
   dij(1, 3, 6) = 3

   tij(1, 3, 1) = 2.600d0
   tij(1, 3, 2) = 1.950d0
   tij(1, 3, 3) = 0.000d0
   tij(1, 3, 4) = 3.950d0
   tij(1, 3, 5) = 7.950d0
   tij(1, 3, 6) = 8.000d0

   nij(1, 3, 1) = - 0.10859387354942d0
   nij(1, 3, 2) = 0.80228576727389d-1
   nij(1, 3, 3) = - 0.93303985115717d-2
   nij(1, 3, 4) = 0.40989274005848d-1
   nij(1, 3, 5) = - 0.24338019772494d0
   nij(1, 3, 6) = 0.23855347281124d0

   ethaij(1, 3, 4) = 1.000d0
   ethaij(1, 3, 5) = 0.500d0
   ethaij(1, 3, 6) = 0.000d0

   epsij(1, 3, 4) = 0.5d0
   epsij(1, 3, 5) = 0.5d0
   epsij(1, 3, 6) = 0.5d0

   betaij(1, 3, 4) = 1.000d0
   betaij(1, 3, 5) = 2.000d0
   betaij(1, 3, 6) = 3.000d0

   gammaij(1, 3, 4) = 0.5d0
   gammaij(1, 3, 5) = 0.5d0
   gammaij(1, 3, 6) = 0.5d0

   dij(1, 4, 1) = 3
   dij(1, 4, 2) = 4
   dij(1, 4, 3) = 1
   dij(1, 4, 4) = 2
   dij(1, 4, 5) = 2
   dij(1, 4, 6) = 2
   dij(1, 4, 7) = 2
   dij(1, 4, 8) = 2
   dij(1, 4, 9) = 2
   dij(1, 4, 10) = 3
   dij(1, 4, 11) = 3
   dij(1, 4, 12) = 3

   tij(1, 4, 1) = 0.650d0
   tij(1, 4, 2) = 1.550d0
   tij(1, 4, 3) = 3.100d0
   tij(1, 4, 4) = 5.900d0
   tij(1, 4, 5) = 7.050d0
   tij(1, 4, 6) = 3.350d0
   tij(1, 4, 7) = 1.200d0
   tij(1, 4, 8) = 5.800d0
   tij(1, 4, 9) = 2.700d0
   tij(1, 4, 10) = 0.450d0
   tij(1, 4, 11) = 0.550d0
   tij(1, 4, 12) = 1.950d0

   nij(1, 4, 1) = - 0.80926050298746d-3
   nij(1, 4, 2) = - 0.75381925080059d-3
   nij(1, 4, 3) = - 0.41618768891219d-1
   nij(1, 4, 4) = - 0.23452173681569d0
   nij(1, 4, 5) = 0.14003840584586d0
   nij(1, 4, 6) = 0.63281744807738d-1
   nij(1, 4, 7) = - 0.34660425848809d-1
   nij(1, 4, 8) = - 0.23918747334251d0
   nij(1, 4, 9) = 0.19855255066891d-2
   nij(1, 4, 10) = 0.61777746171555d1
   nij(1, 4, 11) = - 0.69575358271105d1
   nij(1, 4, 12) = 0.10630185306388d1

   ethaij(1, 4, 3) = 1.000d0
   ethaij(1, 4, 4) = 1.000d0
   ethaij(1, 4, 5) = 1.000d0
   ethaij(1, 4, 6) = 0.875d0
   ethaij(1, 4, 7) = 0.750d0
   ethaij(1, 4, 8) = 0.500d0
   ethaij(1, 4, 9) = 0.000d0
   ethaij(1, 4, 10) = 0.000d0
   ethaij(1, 4, 11) = 0.000d0
   ethaij(1, 4, 12) = 0.000d0

   epsij(1, 4, 3) = 0.5d0
   epsij(1, 4, 4) = 0.5d0
   epsij(1, 4, 5) = 0.5d0
   epsij(1, 4, 6) = 0.5d0
   epsij(1, 4, 7) = 0.5d0
   epsij(1, 4, 8) = 0.5d0
   epsij(1, 4, 9) = 0.5d0
   epsij(1, 4, 10) = 0.5d0
   epsij(1, 4, 11) = 0.5d0
   epsij(1, 4, 12) = 0.5d0

   betaij(1, 4, 3) = 1.000d0
   betaij(1, 4, 4) = 1.000d0
   betaij(1, 4, 5) = 1.000d0
   betaij(1, 4, 6) = 1.250d0
   betaij(1, 4, 7) = 1.500d0
   betaij(1, 4, 8) = 2.000d0
   betaij(1, 4, 9) = 3.000d0
   betaij(1, 4, 10) = 3.000d0
   betaij(1, 4, 11) = 3.000d0
   betaij(1, 4, 12) = 3.000d0

   gammaij(1, 4, 3) = 0.5d0
   gammaij(1, 4, 4) = 0.5d0
   gammaij(1, 4, 5) = 0.5d0
   gammaij(1, 4, 6) = 0.5d0
   gammaij(1, 4, 7) = 0.5d0
   gammaij(1, 4, 8) = 0.5d0
   gammaij(1, 4, 9) = 0.5d0
   gammaij(1, 4, 10) = 0.5d0
   gammaij(1, 4, 11) = 0.5d0
   gammaij(1, 4, 12) = 0.5d0

   dij(1, 5, 1) = 3
   dij(1, 5, 2) = 3
   dij(1, 5, 3) = 4
   dij(1, 5, 4) = 4
   dij(1, 5, 5) = 4
   dij(1, 5, 6) = 1
   dij(1, 5, 7) = 1
   dij(1, 5, 8) = 1
   dij(1, 5, 9) = 2

   tij(1, 5, 1) = 1.850d0
   tij(1, 5, 2) = 3.950d0
   tij(1, 5, 3) = 0.000d0
   tij(1, 5, 4) = 1.850d0
   tij(1, 5, 5) = 3.850d0
   tij(1, 5, 6) = 5.250d0
   tij(1, 5, 7) = 3.850d0
   tij(1, 5, 8) = 0.200d0
   tij(1, 5, 9) = 6.500d0

   nij(1, 5, 1) = 0.13746429958576d-1
   nij(1, 5, 2) = - 0.74425012129552d-2
   nij(1, 5, 3) = - 0.45516600213685d-2
   nij(1, 5, 4) = - 0.54546603350237d-2
   nij(1, 5, 5) = 0.23682016824471d-2
   nij(1, 5, 6) = 0.18007763721438d0
   nij(1, 5, 7) = - 0.44773942932486d0
   nij(1, 5, 8) = 0.19327374888200d-1
   nij(1, 5, 9) = - 0.30632197804624d0

   ethaij(1, 5, 6) = 0.250d0
   ethaij(1, 5, 7) = 0.250d0
   ethaij(1, 5, 8) = 0.000d0
   ethaij(1, 5, 9) = 0.000d0

   epsij(1, 5, 6) = 0.5d0
   epsij(1, 5, 7) = 0.5d0
   epsij(1, 5, 8) = 0.5d0
   epsij(1, 5, 9) = 0.5d0

   betaij(1, 5, 6) = 0.750d0
   betaij(1, 5, 7) = 1.000d0
   betaij(1, 5, 8) = 2.000d0
   betaij(1, 5, 9) = 3.000d0

   gammaij(1, 5, 6) = 0.5d0
   gammaij(1, 5, 7) = 0.5d0
   gammaij(1, 5, 8) = 0.5d0
   gammaij(1, 5, 9) = 0.5d0

   dij(2, 3, 1) = 2
   dij(2, 3, 2) = 3
   dij(2, 3, 3) = 1
   dij(2, 3, 4) = 1
   dij(2, 3, 5) = 1
   dij(2, 3, 6) = 2

   tij(2, 3, 1) = 1.850d0
   tij(2, 3, 2) = 1.400d0
   tij(2, 3, 3) = 3.200d0
   tij(2, 3, 4) = 2.500d0
   tij(2, 3, 5) = 8.000d0
   tij(2, 3, 6) = 3.750d0

   nij(2, 3, 1) = 0.28661625028399d0
   nij(2, 3, 2) = - 0.10919833861247d0
   nij(2, 3, 3) = - 0.11374032082270d1
   nij(2, 3, 4) = 0.76580544237358d0
   nij(2, 3, 5) = 0.42638000926819d-2
   nij(2, 3, 6) = 0.17673538204534d0

   ethaij(2, 3, 3) = 0.250d0
   ethaij(2, 3, 4) = 0.250d0
   ethaij(2, 3, 5) = 0.000d0
   ethaij(2, 3, 6) = 0.000d0

   epsij(2, 3, 3) = 0.5d0
   epsij(2, 3, 4) = 0.5d0
   epsij(2, 3, 5) = 0.5d0
   epsij(2, 3, 6) = 0.5d0

   betaij(2, 3, 3) = 0.750d0
   betaij(2, 3, 4) = 1.000d0
   betaij(2, 3, 5) = 2.000d0
   betaij(2, 3, 6) = 3.000d0

   gammaij(2, 3, 3) = 0.5d0
   gammaij(2, 3, 4) = 0.5d0
   gammaij(2, 3, 5) = 0.5d0
   gammaij(2, 3, 6) = 0.5d0

   dij(2, 4, 1) = 2
   dij(2, 4, 2) = 2
   dij(2, 4, 3) = 3
   dij(2, 4, 4) = 1
   dij(2, 4, 5) = 2
   dij(2, 4, 6) = 2

   tij(2, 4, 1) = 0.000d0
   tij(2, 4, 2) = 0.050d0
   tij(2, 4, 3) = 0.000d0
   tij(2, 4, 4) = 3.650d0
   tij(2, 4, 5) = 4.900d0
   tij(2, 4, 6) = 4.450d0

   nij(2, 4, 1) = - 0.47376518126608d0
   nij(2, 4, 2) = 0.48961193461001d0
   nij(2, 4, 3) = - 0.57011062090535d-2
   nij(2, 4, 4) = - 0.19966820041320d0
   nij(2, 4, 5) = - 0.69411103101723d0
   nij(2, 4, 6) = 0.69226192739021d0

   ethaij(2, 4, 4) = 1.000d0
   ethaij(2, 4, 5) = 1.000d0
   ethaij(2, 4, 6) = 0.875d0

   epsij(2, 4, 4) = 0.5d0
   epsij(2, 4, 5) = 0.5d0
   epsij(2, 4, 6) = 0.5d0

   betaij(2, 4, 4) = 1.000d0
   betaij(2, 4, 5) = 1.000d0
   betaij(2, 4, 6) = 1.250d0

   gammaij(2, 4, 4) = 0.5d0
   gammaij(2, 4, 5) = 0.5d0
   gammaij(2, 4, 6) = 0.5d0

   dij(1, 15, 1) = 1
   dij(1, 15, 2) = 3
   dij(1, 15, 3) = 3
   dij(1, 15, 4) = 4

   tij(1, 15, 1) = 2.000d0
   tij(1, 15, 2) = - 1.000d0
   tij(1, 15, 3) = 1.750d0
   tij(1, 15, 4) = 1.400d0

   nij(1, 15, 1) = - 0.25157134971934d0
   nij(1, 15, 2) = - 0.62203841111983d-2
   nij(1, 15, 3) = 0.88850315184396d-1
   nij(1, 15, 4) = - 0.35592212573239d-1

   generalized_departure(1, :) = (/ 1, 6 /)
   generalized_departure(2, :) = (/ 1, 7 /)
   generalized_departure(3, :) = (/ 4, 5 /)
   generalized_departure(4, :) = (/ 4, 6 /)
   generalized_departure(5, :) = (/ 4, 7 /)
   generalized_departure(6, :) = (/ 5, 6 /)
   generalized_departure(7, :) = (/ 5, 7 /)
   generalized_departure(8, :) = (/ 6, 7 /)

   do k = 1, 8
      i = generalized_departure(k, 1)
      j = generalized_departure(k, 2)

      dij(i, j, 1) = 1
      dij(i, j, 2) = 1
      dij(i, j, 3) = 1
      dij(i, j, 4) = 2
      dij(i, j, 5) = 2
      dij(i, j, 6) = 3
      dij(i, j, 7) = 3
      dij(i, j, 8) = 4
      dij(i, j, 9) = 4
      dij(i, j, 10) = 4

      tij(i, j, 1) = 1.000d0
      tij(i, j, 2) = 1.550d0
      tij(i, j, 3) = 1.700d0
      tij(i, j, 4) = 0.250d0
      tij(i, j, 5) = 1.350d0
      tij(i, j, 6) = 0.000d0
      tij(i, j, 7) = 1.250d0
      tij(i, j, 8) = 0.000d0
      tij(i, j, 9) = 0.700d0
      tij(i, j, 10) = 5.400d0

      nij(i, j, 1) = 0.25574776844118d1
      nij(i, j, 2) = - 0.79846357136353d1
      nij(i, j, 3) = 0.47859131465806d1
      nij(i, j, 4) = - 0.73265392369587
      nij(i, j, 5) = 0.13805471345312d1
      nij(i, j, 6) = 0.28349603476365d0
      nij(i, j, 7) = - 0.49087385940425d0
      nij(i, j, 8) = - 0.10291888921447d0
      nij(i, j, 9) = 0.11836314681968d0
      nij(i, j, 10) = 0.55527385721943d-4

      Kpolij(i, j) = 10
      Kexpij(i, j) = 0

   end do

   KPolij(1, 2) = 2
   KExpij(1, 2) = 7

   KPolij(1, 3) = 3
   KExpij(1, 3) = 3

   KPolij(1, 4) = 2
   KExpij(1, 4) = 10

   KPolij(1, 5) = 5
   KExpij(1, 5) = 4

   KPolij(2, 3) = 2
   KExpij(2, 3) = 4

   KPolij(2, 4) = 3
   KExpij(2, 4) = 3

   KPolij(1, 15) = 4
   KExpij(1, 15) = 0

   n0i(1, 1) = 19.597508817d0
   n0i(1, 2) = - 83.959667892d0
   n0i(1, 3) = 3.00088d0
   n0i(1, 4) = 0.76315d0
   n0i(1, 5) = 0.00460d0
   n0i(1, 6) = 8.74432d0
   n0i(1, 7) = - 4.46921d0

   n0i(2, 1) = 11.083407489d0
   n0i(2, 2) = - 22.202102428d0
   n0i(2, 3) = 2.50031d0
   n0i(2, 4) = 0.13732d0
   n0i(2, 5) = - 0.14660d0
   n0i(2, 6) = 0.90066d0
   n0i(2, 7) = 0.0d0

   n0i(3, 1) = 11.925152758d0
   n0i(3, 2) = - 16.118762264d0
   n0i(3, 3) = 2.50002d0
   n0i(3, 4) = 2.04452d0
   n0i(3, 5) = - 1.06044d0
   n0i(3, 6) = 2.03366d0
   n0i(3, 7) = 0.01393d0

   n0i(4, 1) = 24.675437527d0
   n0i(4, 2) = - 77.425313760d0
   n0i(4, 3) = 3.00263d0
   n0i(4, 4) = 4.33939d0
   n0i(4, 5) = 1.23722d0
   n0i(4, 6) = 13.19740d0
   n0i(4, 7) = - 6.01989d0

   n0i(5, 1) = 31.602908195d0
   n0i(5, 2) = - 84.463284382d0
   n0i(5, 3) = 3.02939d0
   n0i(5, 4) = 6.60569d0
   n0i(5, 5) = 3.19700d0
   n0i(5, 6) = 19.19210d0
   n0i(5, 7) = - 8.37267d0

   n0i(6, 1) = 20.884143364d0
   n0i(6, 2) = - 91.638478026d0
   n0i(6, 3) = 3.33944d0
   n0i(6, 4) = 9.44893d0
   n0i(6, 5) = 6.89406d0
   n0i(6, 6) = 24.46180d0
   n0i(6, 7) = 14.78240d0

   n0i(7, 1) = 20.413726078d0
   n0i(7, 2) = - 94.467620036d0
   n0i(7, 3) = 3.06714d0
   n0i(7, 4) = 8.97575d0
   n0i(7, 5) = 5.25156d0
   n0i(7, 6) = 25.14230d0
   n0i(7, 7) = 16.13880d0

   n0i(8, 1) = 14.536611217d0
   n0i(8, 2) = - 89.919548319d0
   n0i(8, 3) = 3.00000d0
   n0i(8, 4) = 8.95043d0
   n0i(8, 5) = 21.83600d0
   n0i(8, 6) = 33.40320d0
   n0i(8, 7) = 0.0d0

   n0i(9, 1) = 15.449907693d0
   n0i(9, 2) = - 101.298172792d0
   n0i(9, 3) = 3.00000d0
   n0i(9, 4) = 11.76180d0
   n0i(9, 5) = 20.11010d0
   n0i(9, 6) = 33.16880d0
   n0i(9, 7) = 0.0d0

   n0i(10, 1) = 14.345969349d0
   n0i(10, 2) = - 96.165722367d0
   n0i(10, 3) = 3.00000d0
   n0i(10, 4) = 11.69770d0
   n0i(10, 5) = 26.81420d0
   n0i(10, 6) = 38.61640d0
   n0i(10, 7) = 0.0d0

   n0i(11, 1) = 15.063786601d0
   n0i(11, 2) = - 97.345252349d0
   n0i(11, 3) = 3.00000d0
   n0i(11, 4) = 13.72660d0
   n0i(11, 5) = 30.47070d0
   n0i(11, 6) = 43.55610d0
   n0i(11, 7) = 0.0d0

   n0i(12, 1) = 15.864687161d0
   n0i(12, 2) = - 97.370667555d0
   n0i(12, 3) = 3.00000d0
   n0i(12, 4) = 15.68650d0
   n0i(12, 5) = 33.80290d0
   n0i(12, 6) = 48.17310d0
   n0i(12, 7) = 0.0d0

   n0i(13, 1) = 16.313913248d0
   n0i(13, 2) = - 102.160247463d0
   n0i(13, 3) = 3.00000d0
   n0i(13, 4) = 18.02410d0
   n0i(13, 5) = 38.12350d0
   n0i(13, 6) = 53.34150d0
   n0i(13, 7) = 0.0d0

   n0i(14, 1) = 15.870791919d0
   n0i(14, 2) = - 108.858547525d0
   n0i(14, 3) = 3.00000d0
   n0i(14, 4) = 21.00690d0
   n0i(14, 5) = 43.49310d0
   n0i(14, 6) = 58.36570d0
   n0i(14, 7) = 0.0d0

   n0i(15, 1) = 13.796443393d0
   n0i(15, 2) = - 175.864487294d0
   n0i(15, 3) = 1.47906d0
   n0i(15, 4) = 0.95806d0
   n0i(15, 5) = 0.45444d0
   n0i(15, 6) = 1.56039d0
   n0i(15, 7) = 1.37560d0

   n0i(16, 1) = 10.001843586d0
   n0i(16, 2) = - 14.996095135d0
   n0i(16, 3) = 2.50146d0
   n0i(16, 4) = 1.07558d0
   n0i(16, 5) = 1.01334d0
   n0i(16, 6) = 0.0d0
   n0i(16, 7) = 0.0d0

   n0i(17, 1) = 10.813340744d0
   n0i(17, 2) = - 19.834733959d0
   n0i(17, 3) = 2.50055d0
   n0i(17, 4) = 1.02865d0
   n0i(17, 5) = 0.00493d0
   n0i(17, 6) = 0.0d0
   n0i(17, 7) = 0.0d0

   n0i(18, 1) = 8.203520690d0
   n0i(18, 2) = - 11.996306443d0
   n0i(18, 3) = 3.00392d0
   n0i(18, 4) = 0.01059d0
   n0i(18, 5) = 0.98763d0
   n0i(18, 6) = 3.06904d0
   n0i(18, 7) = 0.0d0

   n0i(19, 1) = 9.336197742d0
   n0i(19, 2) = - 16.266508995d0
   n0i(19, 3) = 3.00000d0
   n0i(19, 4) = 3.11942d0
   n0i(19, 5) = 1.00243d0
   n0i(19, 6) = 0.0d0
   n0i(19, 7) = 0.0d0

   n0i(20, 1) = 13.628409737d0
   n0i(20, 2) = - 143.470759602d0
   n0i(20, 3) = 1.50000d0
   n0i(20, 4) = 0.0d0
   n0i(20, 5) = 0.0d0
   n0i(20, 6) = 0.0d0
   n0i(20, 7) = 0.0d0

   n0i(21, 1) = 8.316631500d0
   n0i(21, 2) = - 4.946502600d0
   n0i(21, 3) = 1.50000d0
   n0i(21, 4) = 0.0d0
   n0i(21, 5) = 0.0d0
   n0i(21, 6) = 0.0d0
   n0i(21, 7) = 0.0d0

   th0i(1, 4) = 4.306474465d0
   th0i(1, 5) = 0.936220902d0
   th0i(1, 6) = 5.577233895d0
   th0i(1, 7) = 5.722644361d0
   th0i(2, 4) = 5.251822620d0
   th0i(2, 5) = - 5.393067706d0
   th0i(2, 6) = 13.788988208d0
   th0i(2, 7) = 0.0d0
   th0i(3, 4) = 3.022758166d0
   th0i(3, 5) = - 2.844425476d0
   th0i(3, 6) = 1.589964364d0
   th0i(3, 7) = 1.121596090d0
   th0i(4, 4) = 1.831882406d0
   th0i(4, 5) = 0.731306621d0
   th0i(4, 6) = 3.378007481d0
   th0i(4, 7) = 3.508721939d0
   th0i(5, 4) = 1.297521801d0
   th0i(5, 5) = 0.543210978d0
   th0i(5, 6) = 2.583146083d0
   th0i(5, 7) = 2.777773271d0
   th0i(6, 4) = 1.101487798d0
   th0i(6, 5) = 0.431957660d0
   th0i(6, 6) = 4.502440459d0
   th0i(6, 7) = 2.124516319d0
   th0i(7, 4) = 1.074673199d0
   th0i(7, 5) = 0.485556021d0
   th0i(7, 6) = 4.671261865d0
   th0i(7, 7) = 2.191583480d0
   th0i(8, 4) = 0.380391739d0
   th0i(8, 5) = 1.789520971d0
   th0i(8, 6) = 3.777411113d0
   th0i(8, 7) = 0.0d0
   th0i(9, 4) = 0.635392636d0
   th0i(9, 5) = 1.977271641d0
   th0i(9, 6) = 4.169371131d0
   th0i(9, 7) = 0.0d0
   th0i(10, 4) = 0.359036667d0
   th0i(10, 5) = 1.691951873d0
   th0i(10, 6) = 3.596924107d0
   th0i(10, 7) = 0.0d0
   th0i(11, 4) = 0.314348398d0
   th0i(11, 5) = 1.548136560d0
   th0i(11, 6) = 3.259326458d0
   th0i(11, 7) = 0.0d0
   th0i(12, 4) = 0.279143540d0
   th0i(12, 5) = 1.431644769d0
   th0i(12, 6) = 2.973845992d0
   th0i(12, 7) = 0.0d0
   th0i(13, 4) = 0.263819696d0
   th0i(13, 5) = 1.370586158d0
   th0i(13, 6) = 2.848860483d0
   th0i(13, 7) = 0.0d0
   th0i(14, 4) = 0.267034159d0
   th0i(14, 5) = 1.353835195d0
   th0i(14, 6) = 2.833479035d0
   th0i(14, 7) = 0.0d0
   th0i(15, 4) = 6.891654113d0
   th0i(15, 5) = 9.847634830d0
   th0i(15, 6) = 49.765290750d0
   th0i(15, 7) = 50.367279301d0
   th0i(16, 4) = 14.461722565d0
   th0i(16, 5) = 7.223325463d0
   th0i(16, 6) = 0.0d0
   th0i(16, 7) = 0.0d0
   th0i(17, 4) = 11.669802800d0
   th0i(17, 5) = 5.302762306d0
   th0i(17, 6) = 0.0d0
   th0i(17, 7) = 0.0d0
   th0i(18, 4) = 0.415386589d0
   th0i(18, 5) = 1.763895929d0
   th0i(18, 6) = 3.874803739d0
   th0i(18, 7) = 0.0d0
   th0i(19, 4) = 4.914580541d0
   th0i(19, 5) = 2.270653980d0
   th0i(19, 6) = 0.0d0
   th0i(19, 7) = 0.0d0
   th0i(20, 4) = 0.0d0
   th0i(20, 5) = 0.0d0
   th0i(20, 6) = 0.0d0
   th0i(20, 7) = 0.0d0
   th0i(21, 4) = 0.0d0
   th0i(21, 5) = 0.0d0
   th0i(21, 6) = 0.0d0
   th0i(21, 7) = 0.0d0
End Subroutine get_params
