# -*- coding: utf-8 -*-
#
# This file is part of SENAITE.PATIENT.
#
# SENAITE.PATIENT is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the Free
# Software Foundation, version 2.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
# details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc., 51
# Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#
# Copyright 2020-2025 by it's authors.
# Some rights reserved, see README and LICENSE.

from zope.i18nmessageid import MessageFactory
from senaite.patient.catalog import PATIENT_CATALOG  # noqa

_ = MessageFactory("senaite.patient")

PRODUCT_NAME = "senaite.patient"

DEFAULT_ROLES = ("Manager", )

DEFAULT_TYPES = ("PatientFolder", "Patient", )

AUTO_ID_MARKER = "-- autogenerated --"

SEXES = (
    ("m", _(u"sex_male", default=u"Male")),
    ("f", _(u"sex_female", default=u"Female")),
    ("", _(u"sex_not_specified", default=u"Not specified")),
)

GENDERS = (
    ("m", _(u"gender_man", default=u"Man")),
    ("f", _(u"gender_woman", default=u"Woman")),
    ("t", _(u"gender_trans", default=u"Transgender")),
    ("d", _(u"gender_diverse", default=u"Diverse")),
    ("", _(u"gender_not_specified", default=u"Not Specified")),
)

NAME_ENTRY_MODES = (
    ("parts", _(
        u"name_entry_mode_first_middle_last",
        default=u"First + middle + last")
     ),
    ("first_last", _(
        u"name_entry_mode_first_last",
        default=u"First + last")
     ),
    ("full", _(
        u"name_entry_mode_fullname",
        default=u"Fullname")
     ),
)


IDENTIFIERS = (
    (u"patient_id", _(u"Patient ID")),
    (u"passport_id", _(u"Passport ID")),
    (u"national_id", _(u"National ID")),
    (u"driver_id", _(u"Driver ID")),
    (u"voter_id", _(u"Voter ID")),
)

# https://hl7.org/fhir/us/core/ValueSet-omb-race-category.html#expansion
RACES = (
    (u"1002-5", u"American Indian or Alaska Native"),
    (u"2028-9", u"Asian"),
    (u"2054-5", u"Black or African American"),
    (u"2076-8", u"Native Hawaiian or Other Pacific Islander"),
    (u"2106-3", u"White"),
    (u"2131-1", u"Other Race"),
    (u"ASKU", _(u"race_asked_unknown", default=u"Asked but unknown")),
    (u"UNK", _(u"race_unknown", default=u"Unknown")),
)

# https://hl7.org/fhir/us/core/ValueSet-detailed-ethnicity.html#expansion
ETHNICITIES = (
    (u"2137-8", u"Spaniard"),
    (u"2138-6", u"Andalusian"),
    (u"2139-4", u"Asturian"),
    (u"2140-2", u"Castillian"),
    (u"2141-0", u"Catalonian"),
    (u"2142-8", u"Belearic Islander"),
    (u"2143-6", u"Gallego"),
    (u"2144-4", u"Valencian"),
    (u"2145-1", u"Canarian"),
    (u"2146-9", u"Spanish Basque"),
    (u"2148-5", u"Mexican"),
    (u"2149-3", u"Mexican American"),
    (u"2150-1", u"Mexicano"),
    (u"2151-9", u"Chicano"),
    (u"2152-7", u"La Raza"),
    (u"2153-5", u"Mexican American Indian"),
    (u"2155-0", u"Central American"),
    (u"2156-8", u"Costa Rican"),
    (u"2157-6", u"Guatemalan"),
    (u"2158-4", u"Honduran"),
    (u"2159-2", u"Nicaraguan"),
    (u"2160-0", u"Panamanian"),
    (u"2161-8", u"Salvadoran"),
    (u"2162-6", u"Central American Indian"),
    (u"2163-4", u"Canal Zone"),
    (u"2165-9", u"South American"),
    (u"2166-7", u"Argentinean"),
    (u"2167-5", u"Bolivian"),
    (u"2168-3", u"Chilean"),
    (u"2169-1", u"Colombian"),
    (u"2170-9", u"Ecuadorian"),
    (u"2171-7", u"Paraguayan"),
    (u"2172-5", u"Peruvian"),
    (u"2173-3", u"Uruguayan"),
    (u"2174-1", u"Venezuelan"),
    (u"2175-8", u"South American Indian"),
    (u"2176-6", u"Criollo"),
    (u"2178-2", u"Latin American"),
    (u"2180-8", u"Puerto Rican"),
    (u"2182-4", u"Cuban"),
    (u"2184-0", u"Dominican"),
    (u"ASKU", _(u"ethnicity_asked_unknown", default=u"Asked but unknown")),
    (u"OTH", _(u"ethnicity_other", default="Other")),
    (u"UNK", _(u"ethnicity_unknown", default=u"Unknown")),
)


# http://hl7.org/fhir/R4/valueset-marital-status.html
MARITAL_STATUSES = (
    (u"A", _(u"marital_annulled", default=u"Annulled")),
    (u"D", _(u"marital_divorced", default=u"Divorced")),
    (u"I", _(u"marital_interlocutory", default=u"Interlocutory")),
    (u"L", _(u"marital_legally_separated", default=u"Legally Separated")),
    (u"M", _(u"marital_married", default=u"Married")),
    (u"C", _(u"marital_common_law", default=u"Common Law")),
    (u"P", _(u"marital_polygamous", default=u"Polygamous")),
    (u"T", _(u"marital_domestic_partner", default=u"Domestic partner")),
    (u"U", _(u"marital_unmarried", default=u"Unmarried")),
    (u"S", _(u"marital_never_married", default=u"Never Married")),
    (u"W", _(u"marital_widowed", default=u"Widowed")),
    (u"UNK", _(u"marital_unknown", default=u"Unknown")),
)
