# QUANTCONNECT.COM - Democratizing Finance, Empowering Individuals.
# Lean CLI v1.0. Copyright 2021 QuantConnect Corporation.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from typing import List

import click

from lean.container import container
from lean.models.api import QCFullOrganization
from lean.models.products.base import Product, ProductDetails

_variables = {
    "Fred.CBOE.VIXOnGoogle": "VXGOGCLS",
    "Fred.CBOE.VXD": "VXDCLS",
    "Fred.CBOE.VIXOnGoldmanSachs": "VXGSCLS",
    "Fred.CBOE.VIXOnIBM": "VXIBMCLS",
    "Fred.CBOE.VIXOnAmazon": "VXAZNCLS",
    "Fred.CBOE.VXO": "VXOCLS",
    "Fred.CBOE.VXN": "VXNCLS",
    "Fred.CBOE.TenYearTreasuryNoteVolatilityFutures": "VXTYN",
    "Fred.CBOE.RVX": "RVXCLS",
    "Fred.CBOE.SP500ThreeMonthVolatilityIndex": "VXVCLS",
    "Fred.CBOE.VIXOnApple": "VXAPLCLS",
    "Fred.CBOE.GoldMinersETFVolatilityIndex": "VXGDXCLS",
    "Fred.CBOE.ChinaETFVolatilityIndex": "VXFXICLS",
    "Fred.CBOE.BrazilETFVolatilityIndex": "VXEWZCLS",
    "Fred.CBOE.EmergingMarketsETFVolatilityIndex": "VXEEMCLS",
    "Fred.CBOE.EuroCurrencyETFVolatilityIndex": "EVZCLS",
    "Fred.CBOE.GoldETFVolatilityIndex": "GVZCLS",
    "Fred.CBOE.CrudeOilETFVolatilityIndex": "OVXCLS",
    "Fred.CBOE.SilverETFVolatilityIndex": "VXSLVCLS",
    "Fred.CBOE.EnergySectorETFVolatilityIndex": "VXXLECLS",
    "Fred.CBOE.VIX": "VIXCLS",
    "Fred.CentralBankInterventions.JapaneseBankPurchasesOfDmEuroAgainstJpy": "JPINTDDMEJPY",
    "Fred.CentralBankInterventions.JapaneseBankPurchasesOfUsdAgainstDm": "JPINTDEXR",
    "Fred.CentralBankInterventions.JapaneseBankPurchasesOfUsdAgainstRupiah": "JPINTDUSDRP",
    "Fred.CentralBankInterventions.USInterventionInMarketTransactionsInTheJpyUsd": "USINTDMRKTJPY",
    "Fred.CentralBankInterventions.USInterventionWithCustomerTransactionsInOtherCurrencies": "USINTDCSOTH",
    "Fred.CentralBankInterventions.USInterventionWithCustomerTransactionsInTheJpyUsd": "USINTDCSJPY",
    "Fred.CentralBankInterventions.USInterventionWithCustomerTransactionsInTheDemUsdEuro": "USINTDCSDM",
    "Fred.CentralBankInterventions.USInterventionInMarketTransactionsInOtherCurrencies": "USINTDMRKTOTH",
    "Fred.CentralBankInterventions.CentralBankOfTurkeyPurchasesOfUsd": "TRINTDEXR",
    "Fred.CentralBankInterventions.JapaneseBankPurchasesOfUsdAgainstJpy": "JPINTDUSDJPY",
    "Fred.CentralBankInterventions.USInterventionInMarketTransactionsInTheDemUsdEuro": "USINTDMRKTDM",
    "Fred.CentralBankInterventions.SwissNationalBankPurchasesOfDemAgainstChfMillionsOfDem": "CHINTDCHFDM",
    "Fred.CentralBankInterventions.SwissNationalBankPurchasesOfUsdAgainstDem": "CHINTDUSDDM",
    "Fred.CentralBankInterventions.SwissNationalBankPurchasesOfUsdAgainstJpy": "CHINTDUSDJPY",
    "Fred.CentralBankInterventions.SwissNationalBankPurchasesOfUsdAgainstChf": "CHINTDCHFUSD",
    "Fred.CentralBankInterventions.BancoDeMexicoPurchaseOnTheUsd": "MEXINTDUSD",
    "Fred.CommercialPaper.ThreeMonthAANonfinancialCommercialPaperRate": "DCPN3M",
    "Fred.CommercialPaper.OneMonthAANonfinancialCommercialPaperRate": "DCPN30",
    "Fred.CommercialPaper.TwoMonthAANonfinancialCommercialPaperRate": "DCPN2M",
    "Fred.CommercialPaper.ThreeMonthAAFinancialCommercialPaperRate": "DCPF3M",
    "Fred.CommercialPaper.TwoMonthAAFinancialCommercialPaperRate": "DCPF2M",
    "Fred.CommercialPaper.OneMonthAAFinancialCommercialPaperRate": "DCPF1M",
    "Fred.CommercialPaper.NumberOfIssuesWithMaturityBetween1and4DaysUsedForA2P2Nonfinancial": "NONFIN14A2P2VOL",
    "Fred.CommercialPaper.NumberOfIssuesWithMaturityBetween5and9DaysUsedForA2P2Nonfinancial": "NONFIN59A2P2VOL",
    "Fred.CommercialPaper.TotalValueOfIssuesWithMaturityBetween5and9DaysUsedForA2P2Nonfinancial": "NONFIN59A2P2AMT",
    "Fred.CommercialPaper.NumberOfIssuesWithMaturityBetween41and80DaysUsedForAANonfinancial": "NONFIN4180AAVOL",
    "Fred.CommercialPaper.TotalValueOfIssuesWithMaturityGreaterThan80DaysUsedForAAAssetBacked": "ABGT80AAAMT",
    "Fred.CommercialPaper.TotalValueOfIssuesWithMaturityBetween41and80DaysUsedForAANonfinancial": "NONFIN4180AAAMT",
    "Fred.CommercialPaper.NumberOfIssuesWithMaturityBetween41and80DaysUsedForA2P2Nonfinancial": "NONFIN4180A2P2VOL",
    "Fred.CommercialPaper.TotalValueOfIssuesWithMaturityBetween41and80DaysUsedForA2P2Nonfinancial": "NONFIN4180A2P2AMT",
    "Fred.CommercialPaper.NumberOfIssuesWithMaturityBetween21and40DaysUsedForAANonfinancial": "NONFIN2140AAVOL",
    "Fred.CommercialPaper.TotalValueOfIssuesWithMaturityBetween21and40DaysUsedForAANonfinancial": "NONFIN2140AAAMT",
    "Fred.CommercialPaper.NumberOfIssuesWithMaturityBetween21and40DaysUsedForA2P2Nonfinancial": "NONFIN2140A2P2VOL",
    "Fred.CommercialPaper.TotalValueOfIssuesWithMaturityBetween21and40DaysUsedForA2P2Nonfinancial": "NONFIN2140A2P2AMT",
    "Fred.CommercialPaper.NumberOfIssuesWithMaturityBetween1and4DaysUsedForAANonfinancial": "NONFIN14AAVOL",
    "Fred.CommercialPaper.NumberOfIssuesWithMaturityBetween10And20DaysUsedForA2P2Nonfinancial": "NONFIN1020A2P2VOL",
    "Fred.CommercialPaper.TotalValueOfIssuesWithMaturityBetween10And20DaysUsedForAANonfinancial": "NONFIN1020AAAMT",
    "Fred.CommercialPaper.TotalValueOfIssuesWithMaturityBetween21and40DaysUsedForAAAssetBacked": "AB2140AAAMT",
    "Fred.CommercialPaper.NumberOfIssuesWithMaturityBetween10And20DaysUsedForAANonfinancial": "NONFIN1020AAVOL",
    "Fred.CommercialPaper.TotalValueOfIssuesWithMaturityBetween1and4DaysUsedForA2P2Nonfinancial": "NONFIN14A2P2AMT",
    "Fred.CommercialPaper.TotalValueOfIssuesWithMaturityBetween1and4DaysUsedForAANonfinancial": "NONFIN14AAAMT",
    "Fred.CommercialPaper.TotalValueofCommercialPaperIssueswithaMaturityBetween1and4Days": "MKT14MKTAMT",
    "Fred.CommercialPaper.TotalValueOfIssuesWithMaturityBetween10And20DaysUsedForA2P2Nonfinancial": "NONFIN1020A2P2AMT",
    "Fred.CommercialPaper.NumberOfIssuesWithMaturityGreaterThan80DaysUsedForAAFinancial": "FINGT80AAVOL",
    "Fred.CommercialPaper.NumberOfIssuesWithMaturityBetween10And20DaysUsedForAAFinancial": "FIN1020AAVOL",
    "Fred.CommercialPaper.TotalValueOfIssuesWithMaturityBetween1and4DaysUsedForAAFinancial": "FIN14AAAMT",
    "Fred.CommercialPaper.NumberOfIssuesWithMaturityBetween1and4DaysUsedForAAFinancial": "FIN14AAVOL",
    "Fred.CommercialPaper.TotalValueofCommercialPaperIssueswithaMaturityBetween10And20Days": "MKT1020MKTAMT",
    "Fred.CommercialPaper.NumberofCommercialPaperIssueswithaMaturityBetween10And20Days": "MKT1020MKTVOL",
    "Fred.CommercialPaper.TotalValueOfIssuesWithMaturityBetween21and40DaysUsedForAAFinancial": "FIN2140AAAMT",
    "Fred.CommercialPaper.NumberofCommercialPaperIssueswithaMaturityBetween1and4Days": "MKT14MKTVOL",
    "Fred.CommercialPaper.TotalValueofIssuersofCommercialPaperwithaMaturityBetween21and40Days": "MKT2140MKTAMT",
    "Fred.CommercialPaper.NumberofCommercialPaperIssueswithaMaturityBetween21and40Days": "MKT2140MKTVOL",
    "Fred.CommercialPaper.NumberOfIssuesWithMaturityBetween21and40DaysUsedForAAFinancial": "FIN2140AAVOL",
    "Fred.CommercialPaper.TotalValueofIssuersofCommercialPaperwithaMaturityBetween41and80Days": "MKT4180MKTAMT",
    "Fred.CommercialPaper.TotalValueOfIssuesWithMaturityBetween5and9DaysUsedForAANonfinancial": "NONFIN59AAAMT",
    "Fred.CommercialPaper.NumberofCommercialPaperIssueswithaMaturityBetween41and80Days": "MKT4180MKTVOL",
    "Fred.CommercialPaper.NumberofCommercialPaperIssueswithaMaturityBetween5and9Days": "MKT59MKTVOL",
    "Fred.CommercialPaper.TotalValueofIssuersofCommercialPaperwithaMaturityGreaterThan80Days": "MKTGT80MKTAMT",
    "Fred.CommercialPaper.NumberofCommercialPaperIssueswithaMaturityGreaterThan80Days": "MKTGT80MKTVOL",
    "Fred.CommercialPaper.TotalValueOfIssuesWithMaturityBetween41and80DaysUsedForAAFinancial": "FIN4180AAAMT",
    "Fred.CommercialPaper.NumberOfIssuesWithMaturityBetween41and80DaysUsedForAAFinancial": "FIN4180AAVOL",
    "Fred.CommercialPaper.TotalValueOfIssuesWithMaturityBetween41and80DaysUsedForAAAssetBacked": "AB4180AAAMT",
    "Fred.CommercialPaper.TotalValueOfIssuesWithMaturityBetween5and9DaysUsedForAAFinancial": "FIN59AAAMT",
    "Fred.CommercialPaper.NumberOfIssuesWithMaturityBetween5and9DaysUsedForAAFinancial": "FIN59AAVOL",
    "Fred.CommercialPaper.TotalValueOfIssuesWithMaturityGreaterThan80DaysUsedForAAFinancial": "FINGT80AAAMT",
    "Fred.CommercialPaper.TotalValueOfIssuesWithMaturityBetween10And20DaysUsedForAAFinancial": "FIN1020AAAMT",
    "Fred.CommercialPaper.NumberOfIssuesWithMaturityBetween21and40DaysUsedForAAAssetBacked": "AB2140AAVOL",
    "Fred.CommercialPaper.TotalValueofIssuersofCommercialPaperwithaMaturityBetween5and9Days": "MKT59MKTAMT",
    "Fred.CommercialPaper.NumberOfIssuesWithMaturityGreaterThan80DaysUsedForAAAssetBacked": "ABGT80AAVOL",
    "Fred.CommercialPaper.NumberOfIssuesWithMaturityBetween5and9DaysUsedForAANonfinancial": "NONFIN59AAVOL",
    "Fred.CommercialPaper.FifteenDayAAAssetbackedCommercialPaperInterestRate": "RIFSPPAAAD15NB",
    "Fred.CommercialPaper.TotalValueOfIssuesWithMaturityBetween5and9DaysUsedForAAAssetBacked": "AB59AAAMT",
    "Fred.CommercialPaper.NumberOfIssuesWithMaturityBetween41and80DaysUsedForAAAssetBacked": "AB4180AAVOL",
    "Fred.CommercialPaper.FifteenDayA2P2NonfinancialCommercialPaperInterestRate": "RIFSPPNA2P2D15NB",
    "Fred.CommercialPaper.SevenDayA2P2NonfinancialCommercialPaperInterestRate": "RIFSPPNA2P2D07NB",
    "Fred.CommercialPaper.OvernightA2P2NonfinancialCommercialPaperInterestRate": "RIFSPPNA2P2D01NB",
    "Fred.CommercialPaper.NinetyDayAAFinancialCommercialPaperInterestRate": "RIFSPPFAAD90NB",
    "Fred.CommercialPaper.OvernightAAAssetbackedCommercialPaperInterestRate": "RIFSPPAAAD01NB",
    "Fred.CommercialPaper.Three0DayA2P2NonfinancialCommercialPaperInterestRate": "RIFSPPNA2P2D30NB",
    "Fred.CommercialPaper.SixtyDayAAFinancialCommercialPaperInterestRate": "RIFSPPFAAD60NB",
    "Fred.CommercialPaper.Three0DayAAFinancialCommercialPaperInterestRate": "RIFSPPFAAD30NB",
    "Fred.CommercialPaper.TotalValueOfIssuesWithMaturityGreaterThan80DaysUsedForA2P2Nonfinancial": "NONFINGT80A2P2AMT",
    "Fred.CommercialPaper.Three0DayAAAssetbackedCommercialPaperInterestRate": "RIFSPPAAAD30NB",
    "Fred.CommercialPaper.SixtyDayAAAssetbackedCommercialPaperInterestRate": "RIFSPPAAAD60NB",
    "Fred.CommercialPaper.NinetyDayAAAssetbackedCommercialPaperInterestRate": "RIFSPPAAAD90NB",
    "Fred.CommercialPaper.FifteenDayAAFinancialCommercialPaperInterestRate": "RIFSPPFAAD15NB",
    "Fred.CommercialPaper.SevenDayAAFinancialCommercialPaperInterestRate": "RIFSPPFAAD07NB",
    "Fred.CommercialPaper.SevenDayAAAssetbackedCommercialPaperInterestRate": "RIFSPPAAAD07NB",
    "Fred.CommercialPaper.OvernightAAFinancialCommercialPaperInterestRate": "RIFSPPFAAD01NB",
    "Fred.CommercialPaper.SixtyDayA2P2NonfinancialCommercialPaperInterestRate": "RIFSPPNA2P2D60NB",
    "Fred.CommercialPaper.NumberOfIssuesWithMaturityBetween5and9DaysUsedForAAAssetBacked": "AB59AAVOL",
    "Fred.CommercialPaper.NumberOfIssuesWithMaturityBetween1and4DaysUsedForAAAssetBacked": "AB14AAVOL",
    "Fred.CommercialPaper.NumberOfIssuesWithMaturityGreaterThan80DaysUsedForA2P2Nonfinancial": "NONFINGT80A2P2VOL",
    "Fred.CommercialPaper.TotalValueOfIssuesWithMaturityBetween1and4DaysUsedForAAAssetBacked": "AB14AAAMT",
    "Fred.CommercialPaper.NinetyDayA2P2NonfinancialCommercialPaperInterestRate": "RIFSPPNA2P2D90NB",
    "Fred.CommercialPaper.NumberOfIssuesWithMaturityBetween10And20DaysUsedForAAAssetBacked": "AB1020AAVOL",
    "Fred.CommercialPaper.TotalValueOfIssuesWithMaturityGreaterThan80DaysUsedForAANonfinancial": "NONFINGT80AAAMT",
    "Fred.CommercialPaper.OvernightAANonfinancialCommercialPaperInterestRate": "RIFSPPNAAD01NB",
    "Fred.CommercialPaper.TotalValueOfIssuesWithMaturityBetween10And20DaysUsedForAAAssetBacked": "AB1020AAAMT",
    "Fred.CommercialPaper.SevenDayAANonfinancialCommercialPaperInterestRate": "RIFSPPNAAD07NB",
    "Fred.CommercialPaper.NinetyDayAANonfinancialCommercialPaperInterestRate": "RIFSPPNAAD90NB",
    "Fred.CommercialPaper.FifteenDayAANonfinancialCommercialPaperInterestRate": "RIFSPPNAAD15NB",
    "Fred.CommercialPaper.Three0DayAANonfinancialCommercialPaperInterestRate": "RIFSPPNAAD30NB",
    "Fred.CommercialPaper.SixtyDayAANonfinancialCommercialPaperInterestRate": "RIFSPPNAAD60NB",
    "Fred.CommercialPaper.NumberOfIssuesWithMaturityGreaterThan80DaysUsedForAANonfinancial": "NONFINGT80AAVOL",
    "Fred.CommercialPaper.ThreeMonthCommercialPaperMinusFederalFundsRate": "CPFF",
    "Fred.ICEBofAML.AAAAEmergingMarketsCorporatePlusSubIndexTotalReturnIndexValue": "BAMLEM1BRRAAA2ACRPITRIV",
    "Fred.ICEBofAML.AAAAUSEmergingMarketsLiquidCorporatePlusSubIndexTotalReturnIndexValue": "BAMLEM1RAAA2ALCRPIUSTRIV",
    "Fred.ICEBofAML.AsiaEmergingMarketsCorporatePlusSubIndexTotalReturnIndexValue": "BAMLEMRACRPIASIATRIV",
    "Fred.ICEBofAML.AsiaUSEmergingMarketsLiquidCorporatePlusSubIndexTotalReturnIndexValue": "BAMLEMALLCRPIASIAUSTRIV",
    "Fred.ICEBofAML.BandLowerEmergingMarketsCorporatePlusSubIndexTotalReturnIndexValue": "BAMLEM4BRRBLCRPITRIV",
    "Fred.ICEBofAML.BandLowerUSEmergingMarketsLiquidCorporatePlusSubIndexTotalReturnIndexValue": "BAMLEM4RBLLCRPIUSTRIV",
    "Fred.ICEBofAML.BBEmergingMarketsCorporatePlusSubIndexTotalReturnIndexValue": "BAMLEM3BRRBBCRPITRIV",
    "Fred.ICEBofAML.BBUSEmergingMarketsLiquidCorporatePlusSubIndexTotalReturnIndexValue": "BAMLEM3RBBLCRPIUSTRIV",
    "Fred.ICEBofAML.BBBEmergingMarketsCorporatePlusSubIndexTotalReturnIndexValue": "BAMLEM2BRRBBBCRPITRIV",
    "Fred.ICEBofAML.BBBUSEmergingMarketsLiquidCorporatePlusSubIndexTotalReturnIndexValue": "BAMLEM2RBBBLCRPIUSTRIV",
    "Fred.ICEBofAML.CrossoverEmergingMarketsCorporatePlusSubIndexTotalReturnIndexValue": "BAMLEM5BCOCRPITRIV",
    "Fred.ICEBofAML.CrossoverUSEmergingMarketsLiquidCorporatePlusSubIndexTotalReturnIndexValue": "BAMLEMXOCOLCRPIUSTRIV",
    "Fred.ICEBofAML.EmergingMarketsCorporatePlusIndexTotalReturnIndexValue": "BAMLEMCBPITRIV",
    "Fred.ICEBofAML.EuroEmergingMarketsCorporatePlusSubIndexTotalReturnIndexValue": "BAMLEMEBCRPIETRIV",
    "Fred.ICEBofAML.EMEAEmergingMarketsCorporatePlusSubIndexTotalReturnIndexValue": "BAMLEMRECRPIEMEATRIV",
    "Fred.ICEBofAML.EMEAUSEmergingMarketsLiquidCorporatePlusSubIndexTotalReturnIndexValue": "BAMLEMELLCRPIEMEAUSTRIV",
    "Fred.ICEBofAML.FinancialEmergingMarketsCorporatePlusSubIndexTotalReturnIndexValue": "BAMLEMFSFCRPITRIV",
    "Fred.ICEBofAML.FinancialUSEmergingMarketsLiquidCorporatePlusSubIndexTotalReturnIndexValue": "BAMLEMFLFLCRPIUSTRIV",
    "Fred.ICEBofAML.HighGradeEmergingMarketsCorporatePlusSubIndexTotalReturnIndexValue": "BAMLEMIBHGCRPITRIV",
    "Fred.ICEBofAML.HighGradeUSEmergingMarketsLiquidCorporatePlusSubIndexTotalReturnIndexValue": "BAMLEMHGHGLCRPIUSTRIV",
    "Fred.ICEBofAML.HighYieldEmergingMarketsCorporatePlusSubIndexTotalReturnIndexValue": "BAMLEMHBHYCRPITRIV",
    "Fred.ICEBofAML.HighYieldUSEmergingMarketsLiquidCorporatePlusSubIndexTotalReturnIndexValue": "BAMLEMHYHYLCRPIUSTRIV",
    "Fred.ICEBofAML.LatinAmericaEmergingMarketsCorporatePlusSubIndexTotalReturnIndexValue": "BAMLEMRLCRPILATRIV",
    "Fred.ICEBofAML.LatinAmericaUSEmergingMarketsLiquidCorporatePlusSubIndexTotalReturnIndexValue": "BAMLEMLLLCRPILAUSTRIV",
    "Fred.ICEBofAML.NonFinancialEmergingMarketsCorporatePlusSubIndexTotalReturnIndexValue": "BAMLEMNSNFCRPITRIV",
    "Fred.ICEBofAML.NonFinancialUSEmergingMarketsLiquidCorporatePlusSubIndexTotalReturnIndexValue": "BAMLEMNFNFLCRPIUSTRIV",
    "Fred.ICEBofAML.USCorporateMasterOptionAdjustedSpread": "BAMLC0A0CM",
    "Fred.ICEBofAML.USHighYieldMasterIIOptionAdjustedSpread": "BAMLH0A0HYM2",
    "Fred.ICEBofAML.USCorporate1To3YearOptionAdjustedSpread": "BAMLC1A0C13Y",
    "Fred.ICEBofAML.USCorporate10To15YearOptionAdjustedSpread": "BAMLC7A0C1015Y",
    "Fred.ICEBofAML.USCorporateMoreThan15YearOptionAdjustedSpread": "BAMLC8A0C15PY",
    "Fred.ICEBofAML.USCorporate3To5YearOptionAdjustedSpread": "BAMLC2A0C35Y",
    "Fred.ICEBofAML.USCorporate5To7YearOptionAdjustedSpread": "BAMLC3A0C57Y",
    "Fred.ICEBofAML.USCorporate7To10YearOptionAdjustedSpread": "BAMLC4A0C710Y",
    "Fred.ICEBofAML.PublicSectorIssuersUSEmergingMarketsLiquidCorporatePlusSubIndexTotalReturnIndexValue": "BAMLEMPUPUBSLCRPIUSTRIV",
    "Fred.ICEBofAML.USEmergingMarketsCorporatePlusSubIndexTotalReturnIndexValue": "BAMLEMUBCRPIUSTRIV",
    "Fred.ICEBofAML.USEmergingMarketsLiquidCorporatePlusIndexTotalReturnIndexValue": "BAMLEMCLLCRPIUSTRIV",
    "Fred.ICEBofAML.EuroHighYieldIndexTotalReturnIndexValue": "BAMLHE00EHYITRIV",
    "Fred.ICEBofAML.USCorp1To3YearsTotalReturnIndexValue": "BAMLCC1A013YTRIV",
    "Fred.ICEBofAML.USCorp10To15TotalReturnIndexValue": "BAMLCC7A01015YTRIV",
    "Fred.ICEBofAML.USCorpMoreThan15YearsTotalReturnIndexValue": "BAMLCC8A015PYTRIV",
    "Fred.ICEBofAML.USCorpeTo5YearsTotalReturnIndexValue": "BAMLCC2A035YTRIV",
    "Fred.ICEBofAML.USCorp5To7YearsTotalReturnIndexValue": "BAMLCC3A057YTRIV",
    "Fred.ICEBofAML.USCorporate7To10YearsTotalReturnIndexValue": "BAMLCC4A0710YTRIV",
    "Fred.ICEBofAML.USCorpATotalReturnIndexValue": "BAMLCC0A3ATRIV",
    "Fred.ICEBofAML.USCorpAATotalReturnIndexValue": "BAMLCC0A2AATRIV",
    "Fred.ICEBofAML.USCorpAAATotalReturnIndexValue": "BAMLCC0A1AAATRIV",
    "Fred.ICEBofAML.USHighYieldBTotalReturnIndexValue": "BAMLHYH0A2BTRIV",
    "Fred.ICEBofAML.USHighYieldBBTotalReturnIndexValue": "BAMLHYH0A1BBTRIV",
    "Fred.ICEBofAML.USCorpBBBTotalReturnIndexValue": "BAMLCC0A4BBBTRIV",
    "Fred.ICEBofAML.USHighYieldCCCorBelowTotalReturnIndexValue": "BAMLHYH0A3CMTRIV",
    "Fred.ICEBofAML.USCorpMasterTotalReturnIndexValue": "BAMLCC0A0CMTRIV",
    "Fred.ICEBofAML.USHighYieldMasterIITotalReturnIndexValue": "BAMLHYH0A0HYM2TRIV",
    "Fred.ICEBofAML.AAAAEmergingMarketsCorporatePlusSubIndexOptionAdjustedSpread": "BAMLEM1BRRAAA2ACRPIOAS",
    "Fred.ICEBofAML.AAAAUSEmergingMarketsLiquidCorporatePlusSubIndexOptionAdjustedSpread": "BAMLEM1RAAA2ALCRPIUSOAS",
    "Fred.ICEBofAML.AsiaEmergingMarketsCorporatePlusSubIndexOptionAdjustedSpread": "BAMLEMRACRPIASIAOAS",
    "Fred.ICEBofAML.AsiaUSEmergingMarketsLiquidCorporatePlusSubIndexOptionAdjustedSpread": "BAMLEMALLCRPIASIAUSOAS",
    "Fred.ICEBofAML.BandLowerEmergingMarketsCorporatePlusSubIndexOptionAdjustedSpread": "BAMLEM4BRRBLCRPIOAS",
    "Fred.ICEBofAML.BandLowerUSEmergingMarketsLiquidCorporatePlusSubIndexOptionAdjustedSpread": "BAMLEM4RBLLCRPIUSOAS",
    "Fred.ICEBofAML.BBEmergingMarketsCorporatePlusSubIndexOptionAdjustedSpread": "BAMLEM3BRRBBCRPIOAS",
    "Fred.ICEBofAML.BBUSEmergingMarketsLiquidCorporatePlusSubIndexOptionAdjustedSpread": "BAMLEM3RBBLCRPIUSOAS",
    "Fred.ICEBofAML.BBBEmergingMarketsCorporatePlusSubIndexOptionAdjustedSpread": "BAMLEM2BRRBBBCRPIOAS",
    "Fred.ICEBofAML.BBBUSEmergingMarketsLiquidCorporatePlusSubIndexOptionAdjustedSpread": "BAMLEM2RBBBLCRPIUSOAS",
    "Fred.ICEBofAML.CrossoverEmergingMarketsCorporatePlusSubIndexOptionAdjustedSpread": "BAMLEM5BCOCRPIOAS",
    "Fred.ICEBofAML.CrossoverUSEmergingMarketsLiquidCorporatePlusSubIndexOptionAdjustedSpread": "BAMLEMXOCOLCRPIUSOAS",
    "Fred.ICEBofAML.EmergingMarketsCorporatePlusIndexOptionAdjustedSpread": "BAMLEMCBPIOAS",
    "Fred.ICEBofAML.EuroEmergingMarketsCorporatePlusSubIndexOptionAdjustedSpread": "BAMLEMEBCRPIEOAS",
    "Fred.ICEBofAML.EMEAEmergingMarketsCorporatePlusSubIndexOptionAdjustedSpread": "BAMLEMRECRPIEMEAOAS",
    "Fred.ICEBofAML.EMEAUSEmergingMarketsLiquidCorporatePlusSubIndexOptionAdjustedSpread": "BAMLEMELLCRPIEMEAUSOAS",
    "Fred.ICEBofAML.FinancialEmergingMarketsCorporatePlusSubIndexOptionAdjustedSpread": "BAMLEMFSFCRPIOAS",
    "Fred.ICEBofAML.FinancialUSEmergingMarketsLiquidCorporatePlusSubIndexOptionAdjustedSpread": "BAMLEMFLFLCRPIUSOAS",
    "Fred.ICEBofAML.HighGradeEmergingMarketsCorporatePlusSubIndexOptionAdjustedSpread": "BAMLEMIBHGCRPIOAS",
    "Fred.ICEBofAML.HighGradeUSEmergingMarketsLiquidCorporatePlusSubIndexOptionAdjustedSpread": "BAMLEMHGHGLCRPIUSOAS",
    "Fred.ICEBofAML.HighYieldEmergingMarketsCorporatePlusSubIndexOptionAdjustedSpread": "BAMLEMHBHYCRPIOAS",
    "Fred.ICEBofAML.HighYieldUSEmergingMarketsLiquidCorporatePlusSubIndexOptionAdjustedSpread": "BAMLEMHYHYLCRPIUSOAS",
    "Fred.ICEBofAML.LatinAmericaEmergingMarketsCorporatePlusSubIndexOptionAdjustedSpread": "BAMLEMRLCRPILAOAS",
    "Fred.ICEBofAML.LatinAmericaUSEmergingMarketsLiquidCorporatePlusSubIndexOptionAdjustedSpread": "BAMLEMLLLCRPILAUSOAS",
    "Fred.ICEBofAML.NonFinancialEmergingMarketsCorporatePlusSubIndexOptionAdjustedSpread": "BAMLEMNSNFCRPIOAS",
    "Fred.ICEBofAML.NonFinancialUSEmergingMarketsLiquidCorporatePlusSubIndexOptionAdjustedSpread": "BAMLEMNFNFLCRPIUSOAS",
    "Fred.ICEBofAML.PublicSectorIssuersUSEmergingMarketsLiquidCorporatePlusSubIndexOptionAdjustedSpread": "BAMLEMPUPUBSLCRPIUSOAS",
    "Fred.ICEBofAML.USEmergingMarketsCorporatePlusSubIndexOptionAdjustedSpread": "BAMLEMUBCRPIUSOAS",
    "Fred.ICEBofAML.USEmergingMarketsLiquidCorporatePlusIndexOptionAdjustedSpread": "BAMLEMCLLCRPIUSOAS",
    "Fred.ICEBofAML.EuroHighYieldIndexOptionAdjustedSpread": "BAMLHE00EHYIOAS",
    "Fred.ICEBofAML.USCorporateAOptionAdjustedSpread": "BAMLC0A3CA",
    "Fred.ICEBofAML.USCorporateAAOptionAdjustedSpread": "BAMLC0A2CAA",
    "Fred.ICEBofAML.USCorporateAAAOptionAdjustedSpread": "BAMLC0A1CAAA",
    "Fred.ICEBofAML.USHighYieldBOptionAdjustedSpread": "BAMLH0A2HYB",
    "Fred.ICEBofAML.USHighYieldBBOptionAdjustedSpread": "BAMLH0A1HYBB",
    "Fred.ICEBofAML.USCorporateBBBOptionAdjustedSpread": "BAMLC0A4CBBB",
    "Fred.ICEBofAML.USHighYieldCCCorBelowOptionAdjustedSpread": "BAMLH0A3HYC",
    "Fred.ICEBofAML.AAAAEmergingMarketsCorporatePlusSubIndexEffectiveYield": "BAMLEM1BRRAAA2ACRPIEY",
    "Fred.ICEBofAML.AAAAUSEmergingMarketsLiquidCorporatePlusSubIndexEffectiveYield": "BAMLEM1RAAA2ALCRPIUSEY",
    "Fred.ICEBofAML.AsiaEmergingMarketsCorporatePlusSubIndexEffectiveYield": "BAMLEMRACRPIASIAEY",
    "Fred.ICEBofAML.AsiaUSEmergingMarketsLiquidCorporatePlusSubIndexEffectiveYield": "BAMLEMALLCRPIASIAUSEY",
    "Fred.ICEBofAML.BandLowerEmergingMarketsCorporatePlusSubIndexEffectiveYield": "BAMLEM4BRRBLCRPIEY",
    "Fred.ICEBofAML.BandLowerUSEmergingMarketsLiquidCorporatePlusSubIndexEffectiveYield": "BAMLEM4RBLLCRPIUSEY",
    "Fred.ICEBofAML.BBEmergingMarketsCorporatePlusSubIndexEffectiveYield": "BAMLEM3BRRBBCRPIEY",
    "Fred.ICEBofAML.BBUSEmergingMarketsLiquidCorporatePlusSubIndexEffectiveYield": "BAMLEM3RBBLCRPIUSEY",
    "Fred.ICEBofAML.BBBEmergingMarketsCorporatePlusSubIndexEffectiveYield": "BAMLEM2BRRBBBCRPIEY",
    "Fred.ICEBofAML.BBBUSEmergingMarketsLiquidCorporatePlusSubIndexEffectiveYield": "BAMLEM2RBBBLCRPIUSEY",
    "Fred.ICEBofAML.CrossoverEmergingMarketsCorporatePlusSubIndexEffectiveYield": "BAMLEM5BCOCRPIEY",
    "Fred.ICEBofAML.CrossoverUSEmergingMarketsLiquidCorporatePlusSubIndexEffectiveYield": "BAMLEMXOCOLCRPIUSEY",
    "Fred.ICEBofAML.EmergingMarketsCorporatePlusIndexEffectiveYield": "BAMLEMCBPIEY",
    "Fred.ICEBofAML.EuroEmergingMarketsCorporatePlusSubIndexEffectiveYield": "BAMLEMEBCRPIEEY",
    "Fred.ICEBofAML.EuroHighYieldIndexEffectiveYield": "BAMLHE00EHYIEY",
    "Fred.ICEBofAML.EMEAEmergingMarketsCorporatePlusSubIndexEffectiveYield": "BAMLEMRECRPIEMEAEY",
    "Fred.ICEBofAML.EMEAUSEmergingMarketsLiquidCorporatePlusSubIndexEffectiveYield": "BAMLEMELLCRPIEMEAUSEY",
    "Fred.ICEBofAML.FinancialEmergingMarketsCorporatePlusSubIndexEffectiveYield": "BAMLEMFSFCRPIEY",
    "Fred.ICEBofAML.FinancialUSEmergingMarketsLiquidCorporatePlusSubIndexEffectiveYield": "BAMLEMFLFLCRPIUSEY",
    "Fred.ICEBofAML.HighGradeEmergingMarketsCorporatePlusSubIndexEffectiveYield": "BAMLEMIBHGCRPIEY",
    "Fred.ICEBofAML.HighGradeUSEmergingMarketsLiquidCorporatePlusSubIndexEffectiveYield": "BAMLEMHGHGLCRPIUSEY",
    "Fred.ICEBofAML.HighYieldEmergingMarketsCorporatePlusSubIndexEffectiveYield": "BAMLEMHBHYCRPIEY",
    "Fred.ICEBofAML.HighYieldUSEmergingMarketsLiquidCorporatePlusSubIndexEffectiveYield": "BAMLEMHYHYLCRPIUSEY",
    "Fred.ICEBofAML.LatinAmericaEmergingMarketsCorporatePlusSubIndexEffectiveYield": "BAMLEMRLCRPILAEY",
    "Fred.ICEBofAML.LatinAmericaUSEmergingMarketsLiquidCorporatePlusSubIndexEffectiveYield": "BAMLEMLLLCRPILAUSEY",
    "Fred.ICEBofAML.NonFinancialEmergingMarketsCorporatePlusSubIndexEffectiveYield": "BAMLEMNSNFCRPIEY",
    "Fred.ICEBofAML.NonFinancialUSEmergingMarketsLiquidCorporatePlusSubIndexEffectiveYield": "BAMLEMNFNFLCRPIUSEY",
    "Fred.ICEBofAML.PublicSectorIssuersUSEmergingMarketsLiquidCorporatePlusSubIndexEffectiveYield": "BAMLEMPUPUBSLCRPIUSEY",
    "Fred.ICEBofAML.USCorporate1ThreeYearEffectiveYield": "BAMLC1A0C13YEY",
    "Fred.ICEBofAML.USCorporate10To15YearEffectiveYield": "BAMLC7A0C1015YEY",
    "Fred.ICEBofAML.USCorporateMoreThan15YearEffectiveYield": "BAMLC8A0C15PYEY",
    "Fred.ICEBofAML.USCorporate3To5YearEffectiveYield": "BAMLC2A0C35YEY",
    "Fred.ICEBofAML.USCorporate5To7YearEffectiveYield": "BAMLC3A0C57YEY",
    "Fred.ICEBofAML.USCorporate7To10YearEffectiveYield": "BAMLC4A0C710YEY",
    "Fred.ICEBofAML.USCorporateAEffectiveYield": "BAMLC0A3CAEY",
    "Fred.ICEBofAML.USCorporateAAEffectiveYield": "BAMLC0A2CAAEY",
    "Fred.ICEBofAML.USCorporateAAAEffectiveYield": "BAMLC0A1CAAAEY",
    "Fred.ICEBofAML.USHighYieldBEffectiveYield": "BAMLH0A2HYBEY",
    "Fred.ICEBofAML.USHighYieldBBEffectiveYield": "BAMLH0A1HYBBEY",
    "Fred.ICEBofAML.USCorporateBBBEffectiveYield": "BAMLC0A4CBBBEY",
    "Fred.ICEBofAML.USHighYieldCCCorBelowEffectiveYield": "BAMLH0A3HYCEY",
    "Fred.ICEBofAML.USCorporateMasterEffectiveYield": "BAMLC0A0CMEY",
    "Fred.ICEBofAML.USEmergingMarketsCorporatePlusSubIndexEffectiveYield": "BAMLEMUBCRPIUSEY",
    "Fred.ICEBofAML.USEmergingMarketsLiquidCorporatePlusIndexEffectiveYield": "BAMLEMCLLCRPIUSEY",
    "Fred.ICEBofAML.USHighYieldMasterIIEffectiveYield": "BAMLH0A0HYM2EY",
    "Fred.ICEBofAML.AAAAEmergingMarketsCorporatePlusSubIndexSemiAnnualYieldtoWorst": "BAMLEM1BRRAAA2ACRPISYTW",
    "Fred.ICEBofAML.AAAAUSEmergingMarketsLiquidCorporatePlusSubIndexSemiAnnualYieldtoWorst": "BAMLEM1RAAA2ALCRPIUSSYTW",
    "Fred.ICEBofAML.AsiaEmergingMarketsCorporatePlusSubIndexSemiAnnualYieldtoWorst": "BAMLEMRACRPIASIASYTW",
    "Fred.ICEBofAML.AsiaUSEmergingMarketsLiquidCorporatePlusSubIndexSemiAnnualYieldtoWorst": "BAMLEMALLCRPIASIAUSSYTW",
    "Fred.ICEBofAML.BandLowerEmergingMarketsCorporatePlusSubIndexSemiAnnualYieldtoWorst": "BAMLEM4BRRBLCRPISYTW",
    "Fred.ICEBofAML.BandLowerUSEmergingMarketsLiquidCorporatePlusSubIndexSemiAnnualYieldtoWorst": "BAMLEM4RBLLCRPIUSSYTW",
    "Fred.ICEBofAML.BBEmergingMarketsCorporatePlusSubIndexSemiAnnualYieldtoWorst": "BAMLEM3BRRBBCRPISYTW",
    "Fred.ICEBofAML.BBUSEmergingMarketsLiquidCorporatePlusSubIndexSemiAnnualYieldtoWorst": "BAMLEM3RBBLCRPIUSSYTW",
    "Fred.ICEBofAML.BBBEmergingMarketsCorporatePlusSubIndexSemiAnnualYieldtoWorst": "BAMLEM2BRRBBBCRPISYTW",
    "Fred.ICEBofAML.BBBUSEmergingMarketsLiquidCorporatePlusSubIndexSemiAnnualYieldtoWorst": "BAMLEM2RBBBLCRPIUSSYTW",
    "Fred.ICEBofAML.CrossoverEmergingMarketsCorporatePlusSubIndexSemiAnnualYieldtoWorst": "BAMLEM5BCOCRPISYTW",
    "Fred.ICEBofAML.CrossoverUSEmergingMarketsLiquidCorporatePlusSubIndexSemiAnnualYieldtoWorst": "BAMLEMXOCOLCRPIUSSYTW",
    "Fred.ICEBofAML.EmergingMarketsCorporatePlusIndexSemiAnnualYieldtoWorst": "BAMLEMCBPISYTW",
    "Fred.ICEBofAML.EuroEmergingMarketsCorporatePlusSubIndexSemiAnnualYieldtoWorst": "BAMLEMEBCRPIESYTW",
    "Fred.ICEBofAML.EuroHighYieldIndexSemiAnnualYieldtoWorst": "BAMLHE00EHYISYTW",
    "Fred.ICEBofAML.EMEAEmergingMarketsCorporatePlusSubIndexSemiAnnualYieldtoWorst": "BAMLEMRECRPIEMEASYTW",
    "Fred.ICEBofAML.EMEAUSEmergingMarketsLiquidCorporatePlusSubIndexSemiAnnualYieldtoWorst": "BAMLEMELLCRPIEMEAUSSYTW",
    "Fred.ICEBofAML.FinancialEmergingMarketsCorporatePlusSubIndexSemiAnnualYieldtoWorst": "BAMLEMFSFCRPISYTW",
    "Fred.ICEBofAML.FinancialUSEmergingMarketsLiquidCorporatePlusSubIndexSemiAnnualYieldtoWorst": "BAMLEMFLFLCRPIUSSYTW",
    "Fred.ICEBofAML.HighGradeEmergingMarketsCorporatePlusSubIndexSemiAnnualYieldtoWorst": "BAMLEMIBHGCRPISYTW",
    "Fred.ICEBofAML.HighGradeUSEmergingMarketsLiquidCorporatePlusSubIndexSemiAnnualYieldtoWorst": "BAMLEMHGHGLCRPIUSSYTW",
    "Fred.ICEBofAML.HighYieldEmergingMarketsCorporatePlusSubIndexSemiAnnualYieldtoWorst": "BAMLEMHBHYCRPISYTW",
    "Fred.ICEBofAML.HighYieldUSEmergingMarketsLiquidCorporatePlusSubIndexSemiAnnualYieldtoWorst": "BAMLEMHYHYLCRPIUSSYTW",
    "Fred.ICEBofAML.LatinAmericaEmergingMarketsCorporatePlusSubIndexSemiAnnualYieldtoWorst": "BAMLEMRLCRPILASYTW",
    "Fred.ICEBofAML.LatinAmericaUSEmergingMarketsLiquidCorporatePlusSubIndexSemiAnnualYieldtoWorst": "BAMLEMLLLCRPILAUSSYTW",
    "Fred.ICEBofAML.NonFinancialEmergingMarketsCorporatePlusSubIndexSemiAnnualYieldtoWorst": "BAMLEMNSNFCRPISYTW",
    "Fred.ICEBofAML.NonFinancialUSEmergingMarketsLiquidCorporatePlusSubIndexSemiAnnualYieldtoWorst": "BAMLEMNFNFLCRPIUSSYTW",
    "Fred.ICEBofAML.PrivateSectorIssuersEmergingMarketsCorporatePlusSubIndexSemiAnnualYieldtoWorst": "BAMLEMPTPRVICRPISYTW",
    "Fred.ICEBofAML.PrivateSectorIssuersUSEmergingMarketsLiquidCorporatePlusSubIndexSemiAnnualYieldtoWorst": "BAMLEMPVPRIVSLCRPIUSSYTW",
    "Fred.ICEBofAML.PublicSectorIssuersEmergingMarketsCorporatePlusSubIndexSemiAnnualYieldtoWorst": "BAMLEMPBPUBSICRPISYTW",
    "Fred.ICEBofAML.PublicSectorIssuersUSEmergingMarketsLiquidCorporatePlusSubIndexSemiAnnualYieldtoWorst": "BAMLEMPUPUBSLCRPIUSSYTW",
    "Fred.ICEBofAML.USCorporate1To3YearSemiAnnualYieldtoWorst": "BAMLC1A0C13YSYTW",
    "Fred.ICEBofAML.USCorporate10To15YearSemiAnnualYieldtoWorst": "BAMLC7A0C1015YSYTW",
    "Fred.ICEBofAML.USCorporateMoreThan15YearSemiAnnualYieldtoWorst": "BAMLC8A0C15PYSYTW",
    "Fred.ICEBofAML.USCorporate3To5YearSemiAnnualYieldtoWorst": "BAMLC2A0C35YSYTW",
    "Fred.ICEBofAML.USCorporate5To7YearSemiAnnualYieldtoWorst": "BAMLC3A0C57YSYTW",
    "Fred.ICEBofAML.USCorporate7To10YearSemiAnnualYieldtoWorst": "BAMLC4A0C710YSYTW",
    "Fred.ICEBofAML.USCorporateASemiAnnualYieldtoWorst": "BAMLC0A3CASYTW",
    "Fred.ICEBofAML.USCorporateAASemiAnnualYieldtoWorst": "BAMLC0A2CAASYTW",
    "Fred.ICEBofAML.USCorporateAAASemiAnnualYieldtoWorst": "BAMLC0A1CAAASYTW",
    "Fred.ICEBofAML.USHighYieldBSemiAnnualYieldtoWorst": "BAMLH0A2HYBSYTW",
    "Fred.ICEBofAML.USHighYieldBBSemiAnnualYieldtoWorst": "BAMLH0A1HYBBSYTW",
    "Fred.ICEBofAML.USCorporateBBBSemiAnnualYieldtoWorst": "BAMLC0A4CBBBSYTW",
    "Fred.ICEBofAML.USHighYieldCCCorBelowSemiAnnualYieldtoWorst": "BAMLH0A3HYCSYTW",
    "Fred.ICEBofAML.USCorporateMasterSemiAnnualYieldtoWorst": "BAMLC0A0CMSYTW",
    "Fred.ICEBofAML.USEmergingMarketsCorporatePlusSubIndexSemiAnnualYieldtoWorst": "BAMLEMUBCRPIUSSYTW",
    "Fred.ICEBofAML.USEmergingMarketsLiquidCorporatePlusIndexSemiAnnualYieldtoWorst": "BAMLEMCLLCRPIUSSYTW",
    "Fred.ICEBofAML.USHighYieldMasterIISemiAnnualYieldtoWorst": "BAMLH0A0HYM2SYTW",
    "Fred.LIBOR.SpotNextBasedOnSwissFranc": "CHFONTD156N",
    "Fred.LIBOR.SpotNextBasedOnJapaneseYen": "JPYONTD156N",
    "Fred.LIBOR.SixMonthBasedOnJapaneseYen": "JPY6MTD156N",
    "Fred.LIBOR.ThreeMonthBasedOnJapaneseYen": "JPY3MTD156N",
    "Fred.LIBOR.SixMonthBasedOnUSD": "USD6MTD156N",
    "Fred.LIBOR.OneMonthBasedOnJapaneseYen": "JPY1MTD156N",
    "Fred.LIBOR.TwelveMonthBasedOnJapaneseYen": "JPY12MD156N",
    "Fred.LIBOR.TwelveMonthBasedOnBritishPound": "GBP12MD156N",
    "Fred.LIBOR.OneMonthBasedOnBritishPound": "GBP1MTD156N",
    "Fred.LIBOR.OneWeekBasedOnBritishPound": "GBP1WKD156N",
    "Fred.LIBOR.TwoMonthBasedOnBritishPound": "GBP2MTD156N",
    "Fred.LIBOR.ThreeMonthBasedOnBritishPound": "GBP3MTD156N",
    "Fred.LIBOR.OneWeekBasedOnJapaneseYen": "JPY1WKD156N",
    "Fred.LIBOR.TwoMonthBasedOnJapaneseYen": "JPY2MTD156N",
    "Fred.LIBOR.SixMonthBasedOnSwissFranc": "CHF6MTD156N",
    "Fred.LIBOR.ThreeMonthBasedOnSwissFranc": "CHF3MTD156N",
    "Fred.LIBOR.OneMonthBasedOnUSD": "USD1MTD156N",
    "Fred.LIBOR.TwelveMonthBasedOnSwissFranc": "CHF12MD156N",
    "Fred.LIBOR.TwelveMonthBasedOnUSD": "USD12MD156N",
    "Fred.LIBOR.OneMonthBasedOnSwissFranc": "CHF1MTD156N",
    "Fred.LIBOR.OneWeekBasedOnSwissFranc": "CHF1WKD156N",
    "Fred.LIBOR.TwoMonthBasedOnSwissFranc": "CHF2MTD156N",
    "Fred.LIBOR.TwelveMonthBasedOnEuro": "EUR12MD156N",
    "Fred.LIBOR.SixMonthBasedOnBritishPound": "GBP6MTD156N",
    "Fred.LIBOR.OneMonthBasedOnEuro": "EUR1MTD156N",
    "Fred.LIBOR.TwoMonthBasedOnEuro": "EUR2MTD156N",
    "Fred.LIBOR.ThreeMonthBasedOnEuro": "EUR3MTD156N",
    "Fred.LIBOR.SixMonthBasedOnEuro": "EUR6MTD156N",
    "Fred.LIBOR.OvernightBasedOnEuro": "EURONTD156N",
    "Fred.LIBOR.OneWeekBasedOnUSD": "USD1WKD156N",
    "Fred.LIBOR.TwoMonthBasedOnUSD": "USD2MTD156N",
    "Fred.LIBOR.ThreeMonthBasedOnUSD": "USD3MTD156N",
    "Fred.LIBOR.OvernightBasedOnUSD": "USDONTD156N",
    "Fred.LIBOR.OneWeekBasedOnEuro": "EUR1WKD156N",
    "Fred.LIBOR.OvernightBasedOnBritishPound": "GBPONTD156N",
    "Fred.OECDRecessionIndicators.FourBigEuropeanCountriesFromPeakThroughTheTrough": "4BIGEURORECDM",
    "Fred.OECDRecessionIndicators.AustraliaFromPeakThroughTheTrough": "AUSRECDM",
    "Fred.OECDRecessionIndicators.AustriaFromPeakThroughTheTrough": "AUTRECDM",
    "Fred.OECDRecessionIndicators.BelgiumFromPeakThroughTheTrough": "BELRECDM",
    "Fred.OECDRecessionIndicators.BrazilFromPeakThroughTheTrough": "BRARECDM",
    "Fred.OECDRecessionIndicators.CanadaFromPeakThroughTheTrough": "CANRECDM",
    "Fred.OECDRecessionIndicators.SwitzerlandFromPeakThroughTheTrough": "CHERECDM",
    "Fred.OECDRecessionIndicators.ChileFromPeakThroughTheTrough": "CHLRECDM",
    "Fred.OECDRecessionIndicators.ChinaFromPeakThroughTheTrough": "CHNRECDM",
    "Fred.OECDRecessionIndicators.CzechRepublicFromPeakThroughTheTrough": "CZERECDM",
    "Fred.OECDRecessionIndicators.GermanyFromPeakThroughTheTrough": "DEURECDM",
    "Fred.OECDRecessionIndicators.DenmarkFromPeakThroughTheTrough": "DNKRECDM",
    "Fred.OECDRecessionIndicators.SpainFromPeakThroughTheTrough": "ESPRECDM",
    "Fred.OECDRecessionIndicators.EstoniaFromPeakThroughTheTrough": "ESTRECDM",
    "Fred.OECDRecessionIndicators.EuroAreaFromPeakThroughTheTrough": "EURORECDM",
    "Fred.OECDRecessionIndicators.FinlandFromPeakThroughTheTrough": "FINRECDM",
    "Fred.OECDRecessionIndicators.FranceFromPeakThroughTheTrough": "FRARECDM",
    "Fred.OECDRecessionIndicators.UnitedKingdomFromPeakThroughTheTrough": "GBRRECDM",
    "Fred.OECDRecessionIndicators.GreeceFromPeakThroughTheTrough": "GRCRECDM",
    "Fred.OECDRecessionIndicators.HungaryFromPeakThroughTheTrough": "HUNRECDM",
    "Fred.OECDRecessionIndicators.IndonesiaFromPeakThroughTheTrough": "IDNRECDM",
    "Fred.OECDRecessionIndicators.IndiaFromPeakThroughTheTrough": "INDRECDM",
    "Fred.OECDRecessionIndicators.IrelandFromPeakThroughTheTrough": "IRLRECDM",
    "Fred.OECDRecessionIndicators.IsraelFromPeakThroughTheTrough": "ISRRECDM",
    "Fred.OECDRecessionIndicators.ItalyFromPeakThroughTheTrough": "ITARECDM",
    "Fred.OECDRecessionIndicators.JapanFromPeakThroughTheTrough": "JPNRECDM",
    "Fred.OECDRecessionIndicators.KoreaFromPeakThroughTheTrough": "KORRECDM",
    "Fred.OECDRecessionIndicators.LuxembourgFromPeakThroughTheTrough": "LUXRECDM",
    "Fred.OECDRecessionIndicators.MajorFiveAsiaFromPeakThroughTheTrough": "MAJOR5ASIARECDM",
    "Fred.OECDRecessionIndicators.MexicoFromPeakThroughTheTrough": "MEXRECDM",
    "Fred.OECDRecessionIndicators.MajorSevenCountriesFromPeakThroughTheTrough": "MSCRECDM",
    "Fred.OECDRecessionIndicators.NAFTAAreaFromPeakThroughTheTrough": "NAFTARECDM",
    "Fred.OECDRecessionIndicators.NetherlandsFromPeakThroughTheTrough": "NDLRECDM",
    "Fred.OECDRecessionIndicators.NorwayFromPeakThroughTheTrough": "NORRECDM",
    "Fred.OECDRecessionIndicators.NewZealandFromPeakThroughTheTrough": "NZLRECDM",
    "Fred.OECDRecessionIndicators.OECDEuropeFromPeakThroughTheTrough": "OECDEUROPERECDM",
    "Fred.OECDRecessionIndicators.OECDAndNonmemberEconomiesFromPeakThroughTheTrough": "OECDNMERECDM",
    "Fred.OECDRecessionIndicators.OECDTotalAreaFromPeakThroughTheTrough": "OECDRECDM",
    "Fred.OECDRecessionIndicators.PolandFromPeakThroughTheTrough": "POLRECDM",
    "Fred.OECDRecessionIndicators.PortugalFromPeakThroughTheTrough": "PRTRECDM",
    "Fred.OECDRecessionIndicators.RussianFederationFromPeakThroughTheTrough": "RUSRECDM",
    "Fred.OECDRecessionIndicators.SlovakRepublicFromPeakThroughTheTrough": "SVKRECDM",
    "Fred.OECDRecessionIndicators.SloveniaFromPeakThroughTheTrough": "SVNRECDM",
    "Fred.OECDRecessionIndicators.SwedenFromPeakThroughTheTrough": "SWERECDM",
    "Fred.OECDRecessionIndicators.TurkeyFromPeakThroughTheTrough": "TURRECDM",
    "Fred.OECDRecessionIndicators.UnitedStatesFromPeakThroughTheTrough": "USARECDM",
    "Fred.OECDRecessionIndicators.SouthAfricaFromPeakThroughTheTrough": "ZAFRECDM",
    "Fred.OECDRecessionIndicators.FourBigEuropeanCountriesFromPeriodFollowingPeakThroughTheTrough": "4BIGEURORECD",
    "Fred.OECDRecessionIndicators.AustraliaFromPeriodFollowingPeakThroughTheTrough": "AUSRECD",
    "Fred.OECDRecessionIndicators.AustriaFromPeriodFollowingPeakThroughTheTrough": "AUTRECD",
    "Fred.OECDRecessionIndicators.BelgiumFromPeriodFollowingPeakThroughTheTrough": "BELRECD",
    "Fred.OECDRecessionIndicators.BrazilFromPeriodFollowingPeakThroughTheTrough": "BRARECD",
    "Fred.OECDRecessionIndicators.CanadaFromPeriodFollowingPeakThroughTheTrough": "CANRECD",
    "Fred.OECDRecessionIndicators.SwitzerlandFromPeriodFollowingPeakThroughTheTrough": "CHERECD",
    "Fred.OECDRecessionIndicators.ChileFromPeriodFollowingPeakThroughTheTrough": "CHLRECD",
    "Fred.OECDRecessionIndicators.ChinaFromPeriodFollowingPeakThroughTheTrough": "CHNRECD",
    "Fred.OECDRecessionIndicators.CzechRepublicFromPeriodFollowingPeakThroughTheTrough": "CZERECD",
    "Fred.OECDRecessionIndicators.GermanyFromPeriodFollowingPeakThroughTheTrough": "DEURECD",
    "Fred.OECDRecessionIndicators.DenmarkFromPeriodFollowingPeakThroughTheTrough": "DNKRECD",
    "Fred.OECDRecessionIndicators.SpainFromPeriodFollowingPeakThroughTheTrough": "ESPRECD",
    "Fred.OECDRecessionIndicators.EstoniaFromPeriodFollowingPeakThroughTheTrough": "ESTRECD",
    "Fred.OECDRecessionIndicators.EuroAreaFromPeriodFollowingPeakThroughTheTrough": "EURORECD",
    "Fred.OECDRecessionIndicators.FinlandFromPeriodFollowingPeakThroughTheTrough": "FINRECD",
    "Fred.OECDRecessionIndicators.FranceFromPeriodFollowingPeakThroughTheTrough": "FRARECD",
    "Fred.OECDRecessionIndicators.UnitedKingdomFromPeriodFollowingPeakThroughTheTrough": "GBRRECD",
    "Fred.OECDRecessionIndicators.GreeceFromPeriodFollowingPeakThroughTheTrough": "GRCRECD",
    "Fred.OECDRecessionIndicators.HungaryFromPeriodFollowingPeakThroughTheTrough": "HUNRECD",
    "Fred.OECDRecessionIndicators.IndonesiaFromPeriodFollowingPeakThroughTheTrough": "IDNRECD",
    "Fred.OECDRecessionIndicators.IndiaFromPeriodFollowingPeakThroughTheTrough": "INDRECD",
    "Fred.OECDRecessionIndicators.IrelandFromPeriodFollowingPeakThroughTheTrough": "IRLRECD",
    "Fred.OECDRecessionIndicators.IsraelFromPeriodFollowingPeakThroughTheTrough": "ISRRECD",
    "Fred.OECDRecessionIndicators.ItalyFromPeriodFollowingPeakThroughTheTrough": "ITARECD",
    "Fred.OECDRecessionIndicators.JapanFromPeriodFollowingPeakThroughTheTrough": "JPNRECD",
    "Fred.OECDRecessionIndicators.KoreaFromPeriodFollowingPeakThroughTheTrough": "KORRECD",
    "Fred.OECDRecessionIndicators.LuxembourgFromPeriodFollowingPeakThroughTheTrough": "LUXRECD",
    "Fred.OECDRecessionIndicators.MajorFiveAsiaFromPeriodFollowingPeakThroughTheTrough": "MAJOR5ASIARECD",
    "Fred.OECDRecessionIndicators.MexicoFromPeriodFollowingPeakThroughTheTrough": "MEXRECD",
    "Fred.OECDRecessionIndicators.MajorSevenCountriesFromPeriodFollowingPeakThroughTheTrough": "MSCRECD",
    "Fred.OECDRecessionIndicators.NAFTAAreaFromPeriodFollowingPeakThroughTheTrough": "NAFTARECD",
    "Fred.OECDRecessionIndicators.NetherlandsFromPeriodFollowingPeakThroughTheTrough": "NDLRECD",
    "Fred.OECDRecessionIndicators.NorwayFromPeriodFollowingPeakThroughTheTrough": "NORRECD",
    "Fred.OECDRecessionIndicators.NewZealandFromPeriodFollowingPeakThroughTheTrough": "NZLRECD",
    "Fred.OECDRecessionIndicators.OECDEuropeFromPeriodFollowingPeakThroughTheTrough": "OECDEUROPERECD",
    "Fred.OECDRecessionIndicators.OECDandNonmemberEconomiesFromPeriodFollowingPeakThroughTheTrough": "OECDNMERECD",
    "Fred.OECDRecessionIndicators.OECDTotalAreaFromPeriodFollowingPeakThroughTheTrough": "OECDRECD",
    "Fred.OECDRecessionIndicators.PolandFromPeriodFollowingPeakThroughTheTrough": "POLRECD",
    "Fred.OECDRecessionIndicators.PortugalFromPeriodFollowingPeakThroughTheTrough": "PRTRECD",
    "Fred.OECDRecessionIndicators.RussianFederationFromPeriodFollowingPeakThroughTheTrough": "RUSRECD",
    "Fred.OECDRecessionIndicators.SlovakRepublicFromPeriodFollowingPeakThroughTheTrough": "SVKRECD",
    "Fred.OECDRecessionIndicators.SloveniaFromPeriodFollowingPeakThroughTheTrough": "SVNRECD",
    "Fred.OECDRecessionIndicators.SwedenFromPeriodFollowingPeakThroughTheTrough": "SWERECD",
    "Fred.OECDRecessionIndicators.TurkeyFromPeriodFollowingPeakThroughTheTrough": "TURRECD",
    "Fred.OECDRecessionIndicators.UnitedStatesFromPeriodFollowingPeakThroughTheTrough": "USARECD",
    "Fred.OECDRecessionIndicators.SouthAfricaFromPeriodFollowingPeakThroughTheTrough": "ZAFRECD",
    "Fred.OECDRecessionIndicators.FourBigEuropeanCountriesFromPeakThroughThePeriodPrecedingtheTrough": "4BIGEURORECDP",
    "Fred.OECDRecessionIndicators.AustraliaFromPeakThroughThePeriodPrecedingtheTrough": "AUSRECDP",
    "Fred.OECDRecessionIndicators.AustriaFromPeakThroughThePeriodPrecedingtheTrough": "AUTRECDP",
    "Fred.OECDRecessionIndicators.BelgiumFromPeakThroughThePeriodPrecedingtheTrough": "BELRECDP",
    "Fred.OECDRecessionIndicators.BrazilFromPeakThroughThePeriodPrecedingtheTrough": "BRARECDP",
    "Fred.OECDRecessionIndicators.CanadaFromPeakThroughThePeriodPrecedingtheTrough": "CANRECDP",
    "Fred.OECDRecessionIndicators.SwitzerlandFromPeakThroughThePeriodPrecedingtheTrough": "CHERECDP",
    "Fred.OECDRecessionIndicators.ChileFromPeakThroughThePeriodPrecedingtheTrough": "CHLRECDP",
    "Fred.OECDRecessionIndicators.ChinaFromPeakThroughThePeriodPrecedingtheTrough": "CHNRECDP",
    "Fred.OECDRecessionIndicators.CzechRepublicFromPeakThroughThePeriodPrecedingtheTrough": "CZERECDP",
    "Fred.OECDRecessionIndicators.GermanyFromPeakThroughThePeriodPrecedingtheTrough": "DEURECDP",
    "Fred.OECDRecessionIndicators.DenmarkFromPeakThroughThePeriodPrecedingtheTrough": "DNKRECDP",
    "Fred.OECDRecessionIndicators.SpainFromPeakThroughThePeriodPrecedingtheTrough": "ESPRECDP",
    "Fred.OECDRecessionIndicators.EstoniaFromPeakThroughThePeriodPrecedingtheTrough": "ESTRECDP",
    "Fred.OECDRecessionIndicators.EuroAreaFromPeakThroughThePeriodPrecedingtheTrough": "EURORECDP",
    "Fred.OECDRecessionIndicators.FinlandFromPeakThroughThePeriodPrecedingtheTrough": "FINRECDP",
    "Fred.OECDRecessionIndicators.FranceFromPeakThroughThePeriodPrecedingtheTrough": "FRARECDP",
    "Fred.OECDRecessionIndicators.UnitedKingdomFromPeakThroughThePeriodPrecedingtheTrough": "GBRRECDP",
    "Fred.OECDRecessionIndicators.GreeceFromPeakThroughThePeriodPrecedingtheTrough": "GRCRECDP",
    "Fred.OECDRecessionIndicators.HungaryFromPeakThroughThePeriodPrecedingtheTrough": "HUNRECDP",
    "Fred.OECDRecessionIndicators.IndonesiaFromPeakThroughThePeriodPrecedingtheTrough": "IDNRECDP",
    "Fred.OECDRecessionIndicators.IndiaFromPeakThroughThePeriodPrecedingtheTrough": "INDRECDP",
    "Fred.OECDRecessionIndicators.IrelandFromPeakThroughThePeriodPrecedingtheTrough": "IRLRECDP",
    "Fred.OECDRecessionIndicators.IsraelFromPeakThroughThePeriodPrecedingtheTrough": "ISRRECDP",
    "Fred.OECDRecessionIndicators.ItalyFromPeakThroughThePeriodPrecedingtheTrough": "ITARECDP",
    "Fred.OECDRecessionIndicators.JapanFromPeakThroughThePeriodPrecedingtheTrough": "JPNRECDP",
    "Fred.OECDRecessionIndicators.KoreaFromPeakThroughThePeriodPrecedingtheTrough": "KORRECDP",
    "Fred.OECDRecessionIndicators.LuxembourgFromPeakThroughThePeriodPrecedingtheTrough": "LUXRECDP",
    "Fred.OECDRecessionIndicators.MajorFiveAsiaFromPeakThroughThePeriodPrecedingtheTrough": "MAJOR5ASIARECDP",
    "Fred.OECDRecessionIndicators.MexicoFromPeakThroughThePeriodPrecedingtheTrough": "MEXRECDP",
    "Fred.OECDRecessionIndicators.MajorSevenCountriesFromPeakThroughThePeriodPrecedingtheTrough": "MSCRECDP",
    "Fred.OECDRecessionIndicators.NAFTAAreaFromPeakThroughThePeriodPrecedingtheTrough": "NAFTARECDP",
    "Fred.OECDRecessionIndicators.NetherlandsFromPeakThroughThePeriodPrecedingtheTrough": "NDLRECDP",
    "Fred.OECDRecessionIndicators.NorwayFromPeakThroughThePeriodPrecedingtheTrough": "NORRECDP",
    "Fred.OECDRecessionIndicators.NewZealandFromPeakThroughThePeriodPrecedingtheTrough": "NZLRECDP",
    "Fred.OECDRecessionIndicators.OECDEuropeFromPeakThroughThePeriodPrecedingtheTrough": "OECDEUROPERECDP",
    "Fred.OECDRecessionIndicators.OECDandNonmemberEconomiesFromPeakThroughThePeriodPrecedingtheTrough": "OECDNMERECDP",
    "Fred.OECDRecessionIndicators.OECDTotalAreaFromPeakThroughThePeriodPrecedingtheTrough": "OECDRECDP",
    "Fred.OECDRecessionIndicators.PolandFromPeakThroughThePeriodPrecedingtheTrough": "POLRECDP",
    "Fred.OECDRecessionIndicators.PortugalFromPeakThroughThePeriodPrecedingtheTrough": "PRTRECDP",
    "Fred.OECDRecessionIndicators.RussianFederationFromPeakThroughThePeriodPrecedingtheTrough": "RUSRECDP",
    "Fred.OECDRecessionIndicators.SlovakRepublicFromPeakThroughThePeriodPrecedingtheTrough": "SVKRECDP",
    "Fred.OECDRecessionIndicators.SloveniaFromPeakThroughThePeriodPrecedingtheTrough": "SVNRECDP",
    "Fred.OECDRecessionIndicators.SwedenFromPeakThroughThePeriodPrecedingtheTrough": "SWERECDP",
    "Fred.OECDRecessionIndicators.TurkeyFromPeakThroughThePeriodPrecedingtheTrough": "TURRECDP",
    "Fred.OECDRecessionIndicators.UnitedStatesFromPeakThroughThePeriodPrecedingtheTrough": "USARECDP",
    "Fred.OECDRecessionIndicators.SouthAfricaFromPeakThroughThePeriodPrecedingtheTrough": "ZAFRECDP",
    "Fred.TradeWeightedIndexes.MajorCurrenciesGoods": "DTWEXM",
    "Fred.TradeWeightedIndexes.OtherImportantTradingPartnersGoods": "DTWEXO",
    "Fred.TradeWeightedIndexes.BroadGoods": "DTWEXB",
    "Fred.TradeWeightedIndexes.AdvancedForeignEconomiesGoodsAndServices": "DTWEXAFEGS",
    "Fred.TradeWeightedIndexes.BroadGoodsAndServices": "DTWEXBGS",
    "Fred.TradeWeightedIndexes.EmergingMarketsEconomiesGoodsAndServices": "DTWEXEMEGS",
    "Fred.Wilshire.USSmallCapValuePrice": "WILLSMLCAPVALPR",
    "Fred.Wilshire.Price2500": "WILL2500PR",
    "Fred.Wilshire.Price4500": "WILL4500PR",
    "Fred.Wilshire.ValuePrice2500": "WILL2500PRVAL",
    "Fred.Wilshire.GrowthPrice2500": "WILL2500PRGR",
    "Fred.Wilshire.USSmallCapPrice": "WILLSMLCAPPR",
    "Fred.Wilshire.Price5000": "WILL5000PR",
    "Fred.Wilshire.USSmallCapGrowthPrice": "WILLSMLCAPGRPR",
    "Fred.Wilshire.USMidCapValuePrice": "WILLMIDCAPVALPR",
    "Fred.Wilshire.USRealEstateSecuritiesPrice": "WILLRESIPR",
    "Fred.Wilshire.USLargeCapPrice": "WILLLRGCAPPR",
    "Fred.Wilshire.USMidCapPrice": "WILLMIDCAPPR",
    "Fred.Wilshire.USMidCapGrowthPrice": "WILLMIDCAPGRPR",
    "Fred.Wilshire.USMicroCapPrice": "WILLMICROCAPPR",
    "Fred.Wilshire.USRealEstateInvestmentTrustPrice": "WILLREITPR",
    "Fred.Wilshire.USLargeCapValuePrice": "WILLLRGCAPVALPR",
    "Fred.Wilshire.USLargeCapGrowthPrice": "WILLLRGCAPGRPR",
    "Fred.Wilshire.FullCapPrice5000": "WILL5000PRFC",
    "Fred.Wilshire.USMidCapValue": "WILLMIDCAPVAL",
    "Fred.Wilshire.USMidCapGrowth": "WILLMIDCAPGR",
    "Fred.Wilshire.USMidCap": "WILLMIDCAP",
    "Fred.Wilshire.USRealEstateSecurities": "WILLRESIND",
    "Fred.Wilshire.Index4500": "WILL4500IND",
    "Fred.Wilshire.Index5000": "WILL5000IND",
    "Fred.Wilshire.USLargeCapGrowth": "WILLLRGCAPGR",
    "Fred.Wilshire.USMicroCap": "WILLMICROCAP",
    "Fred.Wilshire.Value2500": "WILL2500INDVAL",
    "Fred.Wilshire.USSmallCapGrowth": "WILLSMLCAPGR",
    "Fred.Wilshire.USSmallCapValue": "WILLSMLCAPVAL",
    "Fred.Wilshire.USLargeCapValue": "WILLLRGCAPVAL",
    "Fred.Wilshire.USRealEstateInvestmentTrust": "WILLREITIND",
    "Fred.Wilshire.Index2500": "WILL2500IND",
    "Fred.Wilshire.USSmallCap": "WILLSMLCAP",
    "Fred.Wilshire.USLargeCap": "WILLLRGCAP",
    "Fred.Wilshire.Growth2500": "WILL2500INDGR",
    "Fred.Wilshire.TotalMarketFullCap5000": "WILL5000INDFC"
}


class FREDProduct(Product):
    """The FREDProduct class supports downloading FRED data with the `lean data download` command."""

    def __init__(self, series_id: str) -> None:
        super().__init__()

        self._series_id = series_id

    @classmethod
    def get_product_name(cls) -> str:
        return "Federal Reserve Economics Data"

    @classmethod
    def build(cls, organization: QCFullOrganization) -> List[Product]:
        logger = container.logger()
        logger.info(
            "See the available data at https://www.quantconnect.com/docs/alternative-data/federal-reserve-economic-data#Federal-Reserve-Economic-Data-Fred-Datasets")
        logger.info("You can provide the id of the data in two different ways:")
        logger.info("1. Using the name of the variable passed to AddData(Fred, <variable>).")
        logger.info("   Example: Fred.CBOE.VIXOnGoogle")
        logger.info("2. Using the series id used by FRED.")
        logger.info("   Example: VXGOGCLS")

        api_client = container.api_client()

        while True:
            given_data_id = click.prompt("Enter the id of the data")

            if given_data_id in _variables:
                data_id = _variables[given_data_id]
            else:
                data_id = given_data_id

            if len(api_client.data.list_files(f"alternative/fred/{data_id.lower()}.csv")) > 0:
                return [FREDProduct(data_id)]

            logger.info(f"Error: we have no data for {given_data_id}")

    def get_details(self) -> ProductDetails:
        return ProductDetails(data_type=self.get_product_name(),
                              ticker=self._series_id.upper(),
                              market="-",
                              resolution="Daily",
                              date_range="All available data")

    def _get_data_files(self) -> List[str]:
        return [f"alternative/fred/{self._series_id.lower()}.csv"]
