# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['prowler',
 'prowler.compliance.aws',
 'prowler.compliance.azure',
 'prowler.config',
 'prowler.lib',
 'prowler.lib.check',
 'prowler.lib.cli',
 'prowler.lib.outputs',
 'prowler.lib.scan_filters',
 'prowler.lib.utils',
 'prowler.providers.aws',
 'prowler.providers.aws.lib',
 'prowler.providers.aws.lib.allowlist',
 'prowler.providers.aws.lib.arn',
 'prowler.providers.aws.lib.audit_info',
 'prowler.providers.aws.lib.quick_inventory',
 'prowler.providers.aws.lib.security_hub',
 'prowler.providers.aws.services',
 'prowler.providers.aws.services.accessanalyzer',
 'prowler.providers.aws.services.accessanalyzer.accessanalyzer_enabled',
 'prowler.providers.aws.services.accessanalyzer.accessanalyzer_enabled_without_findings',
 'prowler.providers.aws.services.account',
 'prowler.providers.aws.services.account.account_maintain_current_contact_details',
 'prowler.providers.aws.services.account.account_security_contact_information_is_registered',
 'prowler.providers.aws.services.account.account_security_questions_are_registered_in_the_aws_account',
 'prowler.providers.aws.services.acm',
 'prowler.providers.aws.services.acm.acm_certificates_expiration_check',
 'prowler.providers.aws.services.acm.acm_certificates_transparency_logs_enabled',
 'prowler.providers.aws.services.apigateway',
 'prowler.providers.aws.services.apigateway.apigateway_authorizers_enabled',
 'prowler.providers.aws.services.apigateway.apigateway_client_certificate_enabled',
 'prowler.providers.aws.services.apigateway.apigateway_endpoint_public',
 'prowler.providers.aws.services.apigateway.apigateway_logging_enabled',
 'prowler.providers.aws.services.apigateway.apigateway_waf_acl_attached',
 'prowler.providers.aws.services.apigatewayv2',
 'prowler.providers.aws.services.apigatewayv2.apigatewayv2_access_logging_enabled',
 'prowler.providers.aws.services.apigatewayv2.apigatewayv2_authorizers_enabled',
 'prowler.providers.aws.services.appstream',
 'prowler.providers.aws.services.appstream.appstream_fleet_default_internet_access_disabled',
 'prowler.providers.aws.services.appstream.appstream_fleet_maximum_session_duration',
 'prowler.providers.aws.services.appstream.appstream_fleet_session_disconnect_timeout',
 'prowler.providers.aws.services.appstream.appstream_fleet_session_idle_disconnect_timeout',
 'prowler.providers.aws.services.autoscaling',
 'prowler.providers.aws.services.autoscaling.autoscaling_find_secrets_ec2_launch_configuration',
 'prowler.providers.aws.services.awslambda',
 'prowler.providers.aws.services.awslambda.awslambda_function_invoke_api_operations_cloudtrail_logging_enabled',
 'prowler.providers.aws.services.awslambda.awslambda_function_no_secrets_in_code',
 'prowler.providers.aws.services.awslambda.awslambda_function_no_secrets_in_variables',
 'prowler.providers.aws.services.awslambda.awslambda_function_not_publicly_accessible',
 'prowler.providers.aws.services.awslambda.awslambda_function_url_cors_policy',
 'prowler.providers.aws.services.awslambda.awslambda_function_url_public',
 'prowler.providers.aws.services.awslambda.awslambda_function_using_supported_runtimes',
 'prowler.providers.aws.services.cloudformation',
 'prowler.providers.aws.services.cloudformation.cloudformation_outputs_find_secrets',
 'prowler.providers.aws.services.cloudformation.cloudformation_stacks_termination_protection_enabled',
 'prowler.providers.aws.services.cloudfront',
 'prowler.providers.aws.services.cloudfront.cloudfront_distributions_field_level_encryption_enabled',
 'prowler.providers.aws.services.cloudfront.cloudfront_distributions_geo_restrictions_enabled',
 'prowler.providers.aws.services.cloudfront.cloudfront_distributions_https_enabled',
 'prowler.providers.aws.services.cloudfront.cloudfront_distributions_logging_enabled',
 'prowler.providers.aws.services.cloudfront.cloudfront_distributions_using_deprecated_ssl_protocols',
 'prowler.providers.aws.services.cloudfront.cloudfront_distributions_using_waf',
 'prowler.providers.aws.services.cloudtrail',
 'prowler.providers.aws.services.cloudtrail.cloudtrail_cloudwatch_logging_enabled',
 'prowler.providers.aws.services.cloudtrail.cloudtrail_kms_encryption_enabled',
 'prowler.providers.aws.services.cloudtrail.cloudtrail_log_file_validation_enabled',
 'prowler.providers.aws.services.cloudtrail.cloudtrail_logs_s3_bucket_access_logging_enabled',
 'prowler.providers.aws.services.cloudtrail.cloudtrail_logs_s3_bucket_is_not_publicly_accessible',
 'prowler.providers.aws.services.cloudtrail.cloudtrail_multi_region_enabled',
 'prowler.providers.aws.services.cloudtrail.cloudtrail_s3_dataevents_read_enabled',
 'prowler.providers.aws.services.cloudtrail.cloudtrail_s3_dataevents_write_enabled',
 'prowler.providers.aws.services.cloudwatch',
 'prowler.providers.aws.services.cloudwatch.cloudwatch_changes_to_network_acls_alarm_configured',
 'prowler.providers.aws.services.cloudwatch.cloudwatch_changes_to_network_gateways_alarm_configured',
 'prowler.providers.aws.services.cloudwatch.cloudwatch_changes_to_network_route_tables_alarm_configured',
 'prowler.providers.aws.services.cloudwatch.cloudwatch_changes_to_vpcs_alarm_configured',
 'prowler.providers.aws.services.cloudwatch.cloudwatch_cross_account_sharing_disabled',
 'prowler.providers.aws.services.cloudwatch.cloudwatch_log_group_kms_encryption_enabled',
 'prowler.providers.aws.services.cloudwatch.cloudwatch_log_group_retention_policy_specific_days_enabled',
 'prowler.providers.aws.services.cloudwatch.cloudwatch_log_metric_filter_and_alarm_for_aws_config_configuration_changes_enabled',
 'prowler.providers.aws.services.cloudwatch.cloudwatch_log_metric_filter_and_alarm_for_cloudtrail_configuration_changes_enabled',
 'prowler.providers.aws.services.cloudwatch.cloudwatch_log_metric_filter_authentication_failures',
 'prowler.providers.aws.services.cloudwatch.cloudwatch_log_metric_filter_aws_organizations_changes',
 'prowler.providers.aws.services.cloudwatch.cloudwatch_log_metric_filter_disable_or_scheduled_deletion_of_kms_cmk',
 'prowler.providers.aws.services.cloudwatch.cloudwatch_log_metric_filter_for_s3_bucket_policy_changes',
 'prowler.providers.aws.services.cloudwatch.cloudwatch_log_metric_filter_policy_changes',
 'prowler.providers.aws.services.cloudwatch.cloudwatch_log_metric_filter_root_usage',
 'prowler.providers.aws.services.cloudwatch.cloudwatch_log_metric_filter_security_group_changes',
 'prowler.providers.aws.services.cloudwatch.cloudwatch_log_metric_filter_sign_in_without_mfa',
 'prowler.providers.aws.services.cloudwatch.cloudwatch_log_metric_filter_unauthorized_api_calls',
 'prowler.providers.aws.services.codeartifact',
 'prowler.providers.aws.services.codeartifact.codeartifact_packages_external_public_publishing_disabled',
 'prowler.providers.aws.services.codebuild',
 'prowler.providers.aws.services.codebuild.codebuild_project_older_90_days',
 'prowler.providers.aws.services.codebuild.codebuild_project_user_controlled_buildspec',
 'prowler.providers.aws.services.config',
 'prowler.providers.aws.services.config.config_recorder_all_regions_enabled',
 'prowler.providers.aws.services.directoryservice',
 'prowler.providers.aws.services.directoryservice.directoryservice_directory_log_forwarding_enabled',
 'prowler.providers.aws.services.directoryservice.directoryservice_directory_monitor_notifications',
 'prowler.providers.aws.services.directoryservice.directoryservice_directory_snapshots_limit',
 'prowler.providers.aws.services.directoryservice.directoryservice_ldap_certificate_expiration',
 'prowler.providers.aws.services.directoryservice.directoryservice_radius_server_security_protocol',
 'prowler.providers.aws.services.directoryservice.directoryservice_supported_mfa_radius_enabled',
 'prowler.providers.aws.services.dynamodb',
 'prowler.providers.aws.services.dynamodb.dynamodb_accelerator_cluster_encryption_enabled',
 'prowler.providers.aws.services.dynamodb.dynamodb_tables_kms_cmk_encryption_enabled',
 'prowler.providers.aws.services.dynamodb.dynamodb_tables_pitr_enabled',
 'prowler.providers.aws.services.ec2',
 'prowler.providers.aws.services.ec2.ec2_ami_public',
 'prowler.providers.aws.services.ec2.ec2_ebs_default_encryption',
 'prowler.providers.aws.services.ec2.ec2_ebs_public_snapshot',
 'prowler.providers.aws.services.ec2.ec2_ebs_snapshots_encrypted',
 'prowler.providers.aws.services.ec2.ec2_ebs_volume_encryption',
 'prowler.providers.aws.services.ec2.ec2_elastic_ip_shodan',
 'prowler.providers.aws.services.ec2.ec2_elastic_ip_unassgined',
 'prowler.providers.aws.services.ec2.ec2_instance_imdsv2_enabled',
 'prowler.providers.aws.services.ec2.ec2_instance_internet_facing_with_instance_profile',
 'prowler.providers.aws.services.ec2.ec2_instance_managed_by_ssm',
 'prowler.providers.aws.services.ec2.ec2_instance_older_than_specific_days',
 'prowler.providers.aws.services.ec2.ec2_instance_profile_attached',
 'prowler.providers.aws.services.ec2.ec2_instance_public_ip',
 'prowler.providers.aws.services.ec2.ec2_instance_secrets_user_data',
 'prowler.providers.aws.services.ec2.ec2_networkacl_allow_ingress_any_port',
 'prowler.providers.aws.services.ec2.ec2_networkacl_allow_ingress_tcp_port_22',
 'prowler.providers.aws.services.ec2.ec2_networkacl_allow_ingress_tcp_port_3389',
 'prowler.providers.aws.services.ec2.ec2_securitygroup_allow_ingress_from_internet_to_any_port',
 'prowler.providers.aws.services.ec2.ec2_securitygroup_allow_ingress_from_internet_to_port_mongodb_27017_27018',
 'prowler.providers.aws.services.ec2.ec2_securitygroup_allow_ingress_from_internet_to_tcp_ftp_port_20_21',
 'prowler.providers.aws.services.ec2.ec2_securitygroup_allow_ingress_from_internet_to_tcp_port_22',
 'prowler.providers.aws.services.ec2.ec2_securitygroup_allow_ingress_from_internet_to_tcp_port_3389',
 'prowler.providers.aws.services.ec2.ec2_securitygroup_allow_ingress_from_internet_to_tcp_port_cassandra_7199_9160_8888',
 'prowler.providers.aws.services.ec2.ec2_securitygroup_allow_ingress_from_internet_to_tcp_port_elasticsearch_kibana_9200_9300_5601',
 'prowler.providers.aws.services.ec2.ec2_securitygroup_allow_ingress_from_internet_to_tcp_port_kafka_9092',
 'prowler.providers.aws.services.ec2.ec2_securitygroup_allow_ingress_from_internet_to_tcp_port_memcached_11211',
 'prowler.providers.aws.services.ec2.ec2_securitygroup_allow_ingress_from_internet_to_tcp_port_mysql_3306',
 'prowler.providers.aws.services.ec2.ec2_securitygroup_allow_ingress_from_internet_to_tcp_port_oracle_1521_2483',
 'prowler.providers.aws.services.ec2.ec2_securitygroup_allow_ingress_from_internet_to_tcp_port_postgres_5432',
 'prowler.providers.aws.services.ec2.ec2_securitygroup_allow_ingress_from_internet_to_tcp_port_redis_6379',
 'prowler.providers.aws.services.ec2.ec2_securitygroup_allow_ingress_from_internet_to_tcp_port_sql_server_1433_1434',
 'prowler.providers.aws.services.ec2.ec2_securitygroup_allow_ingress_from_internet_to_tcp_port_telnet_23',
 'prowler.providers.aws.services.ec2.ec2_securitygroup_allow_wide_open_public_ipv4',
 'prowler.providers.aws.services.ec2.ec2_securitygroup_default_restrict_traffic',
 'prowler.providers.aws.services.ec2.ec2_securitygroup_from_launch_wizard',
 'prowler.providers.aws.services.ec2.ec2_securitygroup_in_use_without_ingress_filtering',
 'prowler.providers.aws.services.ec2.ec2_securitygroup_not_used',
 'prowler.providers.aws.services.ec2.ec2_securitygroup_with_many_ingress_egress_rules',
 'prowler.providers.aws.services.ec2.lib',
 'prowler.providers.aws.services.ecr',
 'prowler.providers.aws.services.ecr.ecr_repositories_lifecycle_policy_enabled',
 'prowler.providers.aws.services.ecr.ecr_repositories_not_publicly_accessible',
 'prowler.providers.aws.services.ecr.ecr_repositories_scan_images_on_push_enabled',
 'prowler.providers.aws.services.ecr.ecr_repositories_scan_vulnerabilities_in_latest_image',
 'prowler.providers.aws.services.ecs',
 'prowler.providers.aws.services.ecs.ecs_task_definitions_no_environment_secrets',
 'prowler.providers.aws.services.efs',
 'prowler.providers.aws.services.efs.efs_encryption_at_rest_enabled',
 'prowler.providers.aws.services.efs.efs_have_backup_enabled',
 'prowler.providers.aws.services.efs.efs_not_publicly_accessible',
 'prowler.providers.aws.services.eks',
 'prowler.providers.aws.services.eks.eks_cluster_kms_cmk_encryption_in_secrets_enabled',
 'prowler.providers.aws.services.eks.eks_control_plane_endpoint_access_restricted',
 'prowler.providers.aws.services.eks.eks_control_plane_logging_all_types_enabled',
 'prowler.providers.aws.services.eks.eks_endpoints_not_publicly_accessible',
 'prowler.providers.aws.services.elb',
 'prowler.providers.aws.services.elb.elb_insecure_ssl_ciphers',
 'prowler.providers.aws.services.elb.elb_internet_facing',
 'prowler.providers.aws.services.elb.elb_logging_enabled',
 'prowler.providers.aws.services.elb.elb_ssl_listeners',
 'prowler.providers.aws.services.elbv2',
 'prowler.providers.aws.services.elbv2.elbv2_deletion_protection',
 'prowler.providers.aws.services.elbv2.elbv2_desync_mitigation_mode',
 'prowler.providers.aws.services.elbv2.elbv2_insecure_ssl_ciphers',
 'prowler.providers.aws.services.elbv2.elbv2_internet_facing',
 'prowler.providers.aws.services.elbv2.elbv2_listeners_underneath',
 'prowler.providers.aws.services.elbv2.elbv2_logging_enabled',
 'prowler.providers.aws.services.elbv2.elbv2_request_smugling',
 'prowler.providers.aws.services.elbv2.elbv2_ssl_listeners',
 'prowler.providers.aws.services.elbv2.elbv2_waf_acl_attached',
 'prowler.providers.aws.services.emr',
 'prowler.providers.aws.services.emr.emr_cluster_account_public_block_enabled',
 'prowler.providers.aws.services.emr.emr_cluster_master_nodes_no_public_ip',
 'prowler.providers.aws.services.emr.emr_cluster_publicly_accesible',
 'prowler.providers.aws.services.glacier',
 'prowler.providers.aws.services.glacier.glacier_vaults_policy_public_access',
 'prowler.providers.aws.services.globalaccelerator',
 'prowler.providers.aws.services.glue',
 'prowler.providers.aws.services.glue.glue_data_catalogs_connection_passwords_encryption_enabled',
 'prowler.providers.aws.services.glue.glue_data_catalogs_metadata_encryption_enabled',
 'prowler.providers.aws.services.glue.glue_database_connections_ssl_enabled',
 'prowler.providers.aws.services.glue.glue_development_endpoints_cloudwatch_logs_encryption_enabled',
 'prowler.providers.aws.services.glue.glue_development_endpoints_job_bookmark_encryption_enabled',
 'prowler.providers.aws.services.glue.glue_development_endpoints_s3_encryption_enabled',
 'prowler.providers.aws.services.glue.glue_etl_jobs_amazon_s3_encryption_enabled',
 'prowler.providers.aws.services.glue.glue_etl_jobs_cloudwatch_logs_encryption_enabled',
 'prowler.providers.aws.services.glue.glue_etl_jobs_job_bookmark_encryption_enabled',
 'prowler.providers.aws.services.guardduty',
 'prowler.providers.aws.services.guardduty.guardduty_is_enabled',
 'prowler.providers.aws.services.guardduty.guardduty_no_high_severity_findings',
 'prowler.providers.aws.services.iam',
 'prowler.providers.aws.services.iam.iam_administrator_access_with_mfa',
 'prowler.providers.aws.services.iam.iam_avoid_root_usage',
 'prowler.providers.aws.services.iam.iam_check_saml_providers_sts',
 'prowler.providers.aws.services.iam.iam_disable_30_days_credentials',
 'prowler.providers.aws.services.iam.iam_disable_45_days_credentials',
 'prowler.providers.aws.services.iam.iam_disable_90_days_credentials',
 'prowler.providers.aws.services.iam.iam_no_custom_policy_permissive_role_assumption',
 'prowler.providers.aws.services.iam.iam_no_expired_server_certificates_stored',
 'prowler.providers.aws.services.iam.iam_no_root_access_key',
 'prowler.providers.aws.services.iam.iam_password_policy_expires_passwords_within_90_days_or_less',
 'prowler.providers.aws.services.iam.iam_password_policy_lowercase',
 'prowler.providers.aws.services.iam.iam_password_policy_minimum_length_14',
 'prowler.providers.aws.services.iam.iam_password_policy_number',
 'prowler.providers.aws.services.iam.iam_password_policy_reuse_24',
 'prowler.providers.aws.services.iam.iam_password_policy_symbol',
 'prowler.providers.aws.services.iam.iam_password_policy_uppercase',
 'prowler.providers.aws.services.iam.iam_policy_allows_privilege_escalation',
 'prowler.providers.aws.services.iam.iam_policy_attached_only_to_group_or_roles',
 'prowler.providers.aws.services.iam.iam_policy_no_administrative_privileges',
 'prowler.providers.aws.services.iam.iam_role_cross_service_confused_deputy_prevention',
 'prowler.providers.aws.services.iam.iam_root_hardware_mfa_enabled',
 'prowler.providers.aws.services.iam.iam_root_mfa_enabled',
 'prowler.providers.aws.services.iam.iam_rotate_access_key_90_days',
 'prowler.providers.aws.services.iam.iam_support_role_created',
 'prowler.providers.aws.services.iam.iam_user_hardware_mfa_enabled',
 'prowler.providers.aws.services.iam.iam_user_mfa_enabled_console_access',
 'prowler.providers.aws.services.iam.iam_user_no_setup_initial_access_key',
 'prowler.providers.aws.services.iam.iam_user_two_active_access_key',
 'prowler.providers.aws.services.kms',
 'prowler.providers.aws.services.kms.kms_cmk_are_used',
 'prowler.providers.aws.services.kms.kms_cmk_rotation_enabled',
 'prowler.providers.aws.services.kms.kms_key_not_publicly_accessible',
 'prowler.providers.aws.services.macie',
 'prowler.providers.aws.services.macie.macie_is_enabled',
 'prowler.providers.aws.services.opensearch',
 'prowler.providers.aws.services.opensearch.opensearch_service_domains_audit_logging_enabled',
 'prowler.providers.aws.services.opensearch.opensearch_service_domains_cloudwatch_logging_enabled',
 'prowler.providers.aws.services.opensearch.opensearch_service_domains_encryption_at_rest_enabled',
 'prowler.providers.aws.services.opensearch.opensearch_service_domains_https_communications_enforced',
 'prowler.providers.aws.services.opensearch.opensearch_service_domains_internal_user_database_enabled',
 'prowler.providers.aws.services.opensearch.opensearch_service_domains_node_to_node_encryption_enabled',
 'prowler.providers.aws.services.opensearch.opensearch_service_domains_not_publicly_accessible',
 'prowler.providers.aws.services.opensearch.opensearch_service_domains_updated_to_the_latest_service_software_version',
 'prowler.providers.aws.services.opensearch.opensearch_service_domains_use_cognito_authentication_for_kibana',
 'prowler.providers.aws.services.rds',
 'prowler.providers.aws.services.rds.rds_instance_backup_enabled',
 'prowler.providers.aws.services.rds.rds_instance_deletion_protection',
 'prowler.providers.aws.services.rds.rds_instance_enhanced_monitoring_enabled',
 'prowler.providers.aws.services.rds.rds_instance_integration_cloudwatch_logs',
 'prowler.providers.aws.services.rds.rds_instance_minor_version_upgrade_enabled',
 'prowler.providers.aws.services.rds.rds_instance_multi_az',
 'prowler.providers.aws.services.rds.rds_instance_no_public_access',
 'prowler.providers.aws.services.rds.rds_instance_storage_encrypted',
 'prowler.providers.aws.services.rds.rds_snapshots_public_access',
 'prowler.providers.aws.services.redshift',
 'prowler.providers.aws.services.redshift.redshift_cluster_audit_logging',
 'prowler.providers.aws.services.redshift.redshift_cluster_automated_snapshot',
 'prowler.providers.aws.services.redshift.redshift_cluster_automatic_upgrades',
 'prowler.providers.aws.services.redshift.redshift_cluster_public_access',
 'prowler.providers.aws.services.route53',
 'prowler.providers.aws.services.route53.route53_domains_privacy_protection_enabled',
 'prowler.providers.aws.services.route53.route53_domains_transferlock_enabled',
 'prowler.providers.aws.services.route53.route53_public_hosted_zones_cloudwatch_logging_enabled',
 'prowler.providers.aws.services.s3',
 'prowler.providers.aws.services.s3.s3_account_level_public_access_blocks',
 'prowler.providers.aws.services.s3.s3_bucket_acl_prohibited',
 'prowler.providers.aws.services.s3.s3_bucket_default_encryption',
 'prowler.providers.aws.services.s3.s3_bucket_no_mfa_delete',
 'prowler.providers.aws.services.s3.s3_bucket_object_versioning',
 'prowler.providers.aws.services.s3.s3_bucket_policy_public_write_access',
 'prowler.providers.aws.services.s3.s3_bucket_public_access',
 'prowler.providers.aws.services.s3.s3_bucket_secure_transport_policy',
 'prowler.providers.aws.services.s3.s3_bucket_server_access_logging_enabled',
 'prowler.providers.aws.services.sagemaker',
 'prowler.providers.aws.services.sagemaker.sagemaker_models_network_isolation_enabled',
 'prowler.providers.aws.services.sagemaker.sagemaker_models_vpc_settings_configured',
 'prowler.providers.aws.services.sagemaker.sagemaker_notebook_instance_encryption_enabled',
 'prowler.providers.aws.services.sagemaker.sagemaker_notebook_instance_root_access_disabled',
 'prowler.providers.aws.services.sagemaker.sagemaker_notebook_instance_vpc_settings_configured',
 'prowler.providers.aws.services.sagemaker.sagemaker_notebook_instance_without_direct_internet_access_configured',
 'prowler.providers.aws.services.sagemaker.sagemaker_training_jobs_intercontainer_encryption_enabled',
 'prowler.providers.aws.services.sagemaker.sagemaker_training_jobs_network_isolation_enabled',
 'prowler.providers.aws.services.sagemaker.sagemaker_training_jobs_volume_and_output_encryption_enabled',
 'prowler.providers.aws.services.sagemaker.sagemaker_training_jobs_vpc_settings_configured',
 'prowler.providers.aws.services.secretsmanager',
 'prowler.providers.aws.services.secretsmanager.secretsmanager_automatic_rotation_enabled',
 'prowler.providers.aws.services.securityhub',
 'prowler.providers.aws.services.securityhub.securityhub_enabled',
 'prowler.providers.aws.services.shield',
 'prowler.providers.aws.services.shield.shield_advanced_protection_in_associated_elastic_ips',
 'prowler.providers.aws.services.shield.shield_advanced_protection_in_classic_load_balancers',
 'prowler.providers.aws.services.shield.shield_advanced_protection_in_cloudfront_distributions',
 'prowler.providers.aws.services.shield.shield_advanced_protection_in_global_accelerators',
 'prowler.providers.aws.services.shield.shield_advanced_protection_in_internet_facing_load_balancers',
 'prowler.providers.aws.services.shield.shield_advanced_protection_in_route53_hosted_zones',
 'prowler.providers.aws.services.sns',
 'prowler.providers.aws.services.sns.sns_topics_kms_encryption_at_rest_enabled',
 'prowler.providers.aws.services.sns.sns_topics_not_publicly_accessible',
 'prowler.providers.aws.services.sqs',
 'prowler.providers.aws.services.sqs.sqs_queues_not_publicly_accessible',
 'prowler.providers.aws.services.sqs.sqs_queues_server_side_encryption_enabled',
 'prowler.providers.aws.services.ssm',
 'prowler.providers.aws.services.ssm.ssm_document_secrets',
 'prowler.providers.aws.services.ssm.ssm_documents_set_as_public',
 'prowler.providers.aws.services.ssm.ssm_managed_compliant_patching',
 'prowler.providers.aws.services.trustedadvisor',
 'prowler.providers.aws.services.trustedadvisor.trustedadvisor_errors_and_warnings',
 'prowler.providers.aws.services.vpc',
 'prowler.providers.aws.services.vpc.vpc_endpoint_connections_trust_boundaries',
 'prowler.providers.aws.services.vpc.vpc_endpoint_services_allowed_principals_trust_boundaries',
 'prowler.providers.aws.services.vpc.vpc_flow_logs_enabled',
 'prowler.providers.aws.services.vpc.vpc_peering_routing_tables_with_least_privilege',
 'prowler.providers.aws.services.waf',
 'prowler.providers.aws.services.wafv2',
 'prowler.providers.aws.services.workspaces',
 'prowler.providers.aws.services.workspaces.workspaces_volume_encryption_enabled',
 'prowler.providers.azure',
 'prowler.providers.azure.lib.audit_info',
 'prowler.providers.azure.services.defender',
 'prowler.providers.azure.services.defender.defender_ensure_defender_for_app_services_is_on',
 'prowler.providers.azure.services.defender.defender_ensure_defender_for_arm_is_on',
 'prowler.providers.azure.services.defender.defender_ensure_defender_for_azure_sql_databases_is_on',
 'prowler.providers.azure.services.defender.defender_ensure_defender_for_containers_is_on',
 'prowler.providers.azure.services.defender.defender_ensure_defender_for_cosmosdb_is_on',
 'prowler.providers.azure.services.defender.defender_ensure_defender_for_databases_is_on',
 'prowler.providers.azure.services.defender.defender_ensure_defender_for_dns_is_on',
 'prowler.providers.azure.services.defender.defender_ensure_defender_for_keyvault_is_on',
 'prowler.providers.azure.services.defender.defender_ensure_defender_for_os_relational_databases_is_on',
 'prowler.providers.azure.services.defender.defender_ensure_defender_for_server_is_on',
 'prowler.providers.azure.services.defender.defender_ensure_defender_for_sql_servers_is_on',
 'prowler.providers.azure.services.defender.defender_ensure_defender_for_storage_is_on',
 'prowler.providers.azure.services.iam',
 'prowler.providers.azure.services.iam.iam_subscription_roles_owner_custom_not_created',
 'prowler.providers.azure.services.storage',
 'prowler.providers.azure.services.storage.storage_blob_public_access_level_is_disabled',
 'prowler.providers.azure.services.storage.storage_default_network_access_rule_is_denied',
 'prowler.providers.azure.services.storage.storage_ensure_azure_services_are_trusted_to_access_is_enabled',
 'prowler.providers.azure.services.storage.storage_ensure_encryption_with_customer_managed_keys',
 'prowler.providers.azure.services.storage.storage_ensure_minimum_tls_version_12',
 'prowler.providers.azure.services.storage.storage_infrastructure_encryption_is_enabled',
 'prowler.providers.azure.services.storage.storage_secure_transfer_required_is_enabled',
 'prowler.providers.common']

package_data = \
{'': ['*'],
 'prowler.providers.aws.services.autoscaling.autoscaling_find_secrets_ec2_launch_configuration': ['fixtures/*'],
 'prowler.providers.aws.services.ec2.ec2_instance_secrets_user_data': ['fixtures/*']}

install_requires = \
['alive-progress==3.0.1',
 'arnparse==0.0.2',
 'azure-identity==1.12.0',
 'azure-mgmt-authorization==3.0.0',
 'azure-mgmt-security==3.0.0',
 'azure-mgmt-storage==21.0.0',
 'azure-mgmt-subscription==3.1.1',
 'azure-storage-blob==12.15.0',
 'boto3==1.26.79',
 'botocore==1.29.79',
 'colorama==0.4.6',
 'detect-secrets==1.4.0',
 'msgraph-core==0.2.2',
 'pydantic==1.10.5',
 'schema==0.7.5',
 'shodan==1.28.0',
 'tabulate==0.9.0']

extras_require = \
{'docs': ['mkdocs==1.4.2', 'mkdocs-material==9.0.14']}

entry_points = \
{'console_scripts': ['prowler = prowler.__main__:prowler']}

setup_kwargs = {
    'name': 'prowler-cloud',
    'version': '3.2.4',
    'description': 'Prowler is an Open Source security tool to perform Cloud Security best practices assessments, audits, incident response, continuous monitoring, hardening and forensics readiness. It contains more than 240 controls covering CIS, PCI-DSS, ISO27001, GDPR, HIPAA, FFIEC, SOC2, AWS FTR, ENS and custom security frameworks.',
    'long_description': '<p align="center">\n  <img align="center" src="https://github.com/prowler-cloud/prowler/blob/62c1ce73bbcdd6b9e5ba03dfcae26dfd165defd9/docs/img/prowler-pro-dark.png?raw=True#gh-dark-mode-only" width="150" height="36">\n  <img align="center" src="https://github.com/prowler-cloud/prowler/blob/62c1ce73bbcdd6b9e5ba03dfcae26dfd165defd9/docs/img/prowler-pro-light.png?raw=True#gh-light-mode-only" width="15%" height="15%">\n</p>\n<p align="center">\n  <b><i>See all the things you and your team can do with ProwlerPro at <a href="https://prowler.pro">prowler.pro</a></i></b>\n</p>\n<hr>\n<p align="center">\n  <img src="https://user-images.githubusercontent.com/3985464/113734260-7ba06900-96fb-11eb-82bc-d4f68a1e2710.png" />\n</p>\n<p align="center">\n  <a href="https://join.slack.com/t/prowler-workspace/shared_invite/zt-1hix76xsl-2uq222JIXrC7Q8It~9ZNog"><img alt="Slack Shield" src="https://img.shields.io/badge/slack-prowler-brightgreen.svg?logo=slack"></a>\n  <a href="https://pypi.org/project/prowler-cloud/"><img alt="Python Version" src="https://img.shields.io/pypi/v/prowler.svg"></a>\n  <a href="https://pypi.python.org/pypi/prowler-cloud/"><img alt="Python Version" src="https://img.shields.io/pypi/pyversions/prowler.svg"></a>\n  <a href="https://pypistats.org/packages/prowler"><img alt="PyPI Prowler Downloads" src="https://img.shields.io/pypi/dw/prowler.svg?label=prowler%20downloads"></a>\n  <a href="https://pypistats.org/packages/prowler-cloud"><img alt="PyPI Prowler-Cloud Downloads" src="https://img.shields.io/pypi/dw/prowler-cloud.svg?label=prowler-cloud%20downloads"></a>\n  <a href="https://formulae.brew.sh/formula/prowler#default"><img alt="Brew Prowler Downloads" src="https://img.shields.io/homebrew/installs/dm/prowler?label=brew%20downloads"></a>\n  <a href="https://hub.docker.com/r/toniblyx/prowler"><img alt="Docker Pulls" src="https://img.shields.io/docker/pulls/toniblyx/prowler"></a>\n  <a href="https://hub.docker.com/r/toniblyx/prowler"><img alt="Docker" src="https://img.shields.io/docker/cloud/build/toniblyx/prowler"></a>\n  <a href="https://hub.docker.com/r/toniblyx/prowler"><img alt="Docker" src="https://img.shields.io/docker/image-size/toniblyx/prowler"></a>\n  <a href="https://gallery.ecr.aws/o4g1s5r6/prowler"><img width="120" height=19" alt="AWS ECR Gallery" src="https://user-images.githubusercontent.com/3985464/151531396-b6535a68-c907-44eb-95a1-a09508178616.png"></a>\n</p>\n<p align="center">\n  <a href="https://github.com/prowler-cloud/prowler"><img alt="Repo size" src="https://img.shields.io/github/repo-size/prowler-cloud/prowler"></a>\n  <a href="https://github.com/prowler-cloud/prowler/issues"><img alt="Issues" src="https://img.shields.io/github/issues/prowler-cloud/prowler"></a>\n  <a href="https://github.com/prowler-cloud/prowler/releases"><img alt="Version" src="https://img.shields.io/github/v/release/prowler-cloud/prowler?include_prereleases"></a>\n  <a href="https://github.com/prowler-cloud/prowler/releases"><img alt="Version" src="https://img.shields.io/github/release-date/prowler-cloud/prowler"></a>\n  <a href="https://github.com/prowler-cloud/prowler"><img alt="Contributors" src="https://img.shields.io/github/contributors-anon/prowler-cloud/prowler"></a>\n  <a href="https://github.com/prowler-cloud/prowler"><img alt="License" src="https://img.shields.io/github/license/prowler-cloud/prowler"></a>\n  <a href="https://twitter.com/ToniBlyx"><img alt="Twitter" src="https://img.shields.io/twitter/follow/toniblyx?style=social"></a>\n  <a href="https://twitter.com/prowlercloud"><img alt="Twitter" src="https://img.shields.io/twitter/follow/prowlercloud?style=social"></a>\n</p>\n\n# Description\n\n`Prowler` is an Open Source security tool to perform AWS and Azure security best practices assessments, audits, incident response, continuous monitoring, hardening and forensics readiness.\n\nIt contains hundreds of controls covering CIS, PCI-DSS, ISO27001, GDPR, HIPAA, FFIEC, SOC2, AWS FTR, ENS and custom security frameworks.\n\n## Looking for Prowler v2 documentation?\nFor Prowler v2 Documentation, please go to https://github.com/prowler-cloud/prowler/tree/2.12.1.\n# ⚙️ Install\n\n## Pip package\nProwler is available as a project in [PyPI](https://pypi.org/project/prowler-cloud/), thus can be installed using pip with Python >= 3.9:\n\n```console\npip install prowler\nprowler -v\n```\n\n## Containers\n\nThe available versions of Prowler are the following:\n\n- `latest`: in sync with master branch (bear in mind that it is not a stable version)\n- `<x.y.z>` (release): you can find the releases [here](https://github.com/prowler-cloud/prowler/releases), those are stable releases.\n- `stable`: this tag always point to the latest release.\n\nThe container images are available here:\n\n- [DockerHub](https://hub.docker.com/r/toniblyx/prowler/tags)\n- [AWS Public ECR](https://gallery.ecr.aws/o4g1s5r6/prowler)\n\n## From Github\n\nPython >= 3.9 is required with pip and poetry:\n\n```\ngit clone https://github.com/prowler-cloud/prowler\ncd prowler\npoetry shell\npoetry install\npython prowler.py -v\n```\n\n# 📖 Documentation\n\nThe full documentation can now be found at [https://docs.prowler.cloud](https://docs.prowler.cloud)\n\n\n# 📐✏️ High level architecture\n\nYou can run Prowler from your workstation, an EC2 instance, Fargate or any other container, Codebuild, CloudShell and Cloud9.\n\n![Architecture](https://github.com/prowler-cloud/prowler/blob/62c1ce73bbcdd6b9e5ba03dfcae26dfd165defd9/docs/img/architecture.png?raw=True)\n\n# 📝 Requirements\n\nProwler has been written in Python using the [AWS SDK (Boto3)](https://boto3.amazonaws.com/v1/documentation/api/latest/index.html#) and [Azure SDK](https://azure.github.io/azure-sdk-for-python/).\n## AWS\n\nSince Prowler uses AWS Credentials under the hood, you can follow any authentication method as described [here](https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-quickstart.html#cli-configure-quickstart-precedence).\nMake sure you have properly configured your AWS-CLI with a valid Access Key and Region or declare AWS variables properly (or instance profile/role):\n\n  ```console\n  aws configure\n  ```\n\n  or\n\n  ```console\n  export AWS_ACCESS_KEY_ID="ASXXXXXXX"\n  export AWS_SECRET_ACCESS_KEY="XXXXXXXXX"\n  export AWS_SESSION_TOKEN="XXXXXXXXX"\n  ```\n\nThose credentials must be associated to a user or role with proper permissions to do all checks. To make sure, add the following AWS managed policies to the user or role being used:\n\n  - arn:aws:iam::aws:policy/SecurityAudit\n  - arn:aws:iam::aws:policy/job-function/ViewOnlyAccess\n\n  > Moreover, some read-only additional permissions are needed for several checks, make sure you attach also the custom policy [prowler-additions-policy.json](https://github.com/prowler-cloud/prowler/blob/master/permissions/prowler-additions-policy.json) to the role you are using.\n\n  > If you want Prowler to send findings to [AWS Security Hub](https://aws.amazon.com/security-hub), make sure you also attach the custom policy [prowler-security-hub.json](https://github.com/prowler-cloud/prowler/blob/master/permissions/prowler-security-hub.json).\n\n  ## Azure\n\n  Prowler for Azure supports the following authentication types:\n\n- Service principal authentication by environment variables (Enterprise Application)\n- Current az cli credentials stored\n- Interactive browser authentication\n- Managed identity authentication\n\n### Service Principal authentication\n\nTo allow Prowler assume the service principal identity to start the scan, it is needed to configure the following environment variables:\n\n```console\nexport AZURE_CLIENT_ID="XXXXXXXXX"\nexport AZURE_TENANT_ID="XXXXXXXXX"\nexport AZURE_CLIENT_SECRET="XXXXXXX"\n```\n\nIf you try to execute Prowler with the `--sp-env-auth` flag and those variables are empty or not exported, the execution is going to fail.\n### AZ CLI / Browser / Managed Identity authentication\n\nThe other three cases do not need additional configuration, `--az-cli-auth` and `--managed-identity-auth` are automated options, `--browser-auth` needs the user to authenticate using the default browser to start the scan.\n\n### Permissions\n\nTo use each one, you need to pass the proper flag to the execution. Prowler for Azure handles two types of permission scopes, which are:\n\n- **Azure Active Directory permissions**: Used to retrieve metadata from the identity assumed by Prowler and future AAD checks (not mandatory to have access to execute the tool)\n- **Subscription scope permissions**: Required to launch the checks against your resources, mandatory to launch the tool.\n\n\n#### Azure Active Directory scope\n\nAzure Active Directory (AAD) permissions required by the tool are the following:\n\n- `Directory.Read.All`\n- `Policy.Read.All`\n\n\n#### Subscriptions scope\n\nRegarding the subscription scope, Prowler by default scans all the subscriptions that is able to list, so it is required to add the following RBAC builtin roles per subscription  to the entity that is going to be assumed by the tool:\n\n- `Security Reader`\n- `Reader`\n\n\n# 💻 Basic Usage\n\nTo run prowler, you will need to specify the provider (e.g aws or azure):\n\n```console\nprowler <provider>\n```\n\n![Prowler Execution](https://github.com/prowler-cloud/prowler/blob/b91b0103ff38e66a915c8a0ed84905a07e4aae1d/docs/img/short-display.png?raw=True)\n\n> Running the `prowler` command without options will use your environment variable credentials.\n\nBy default, prowler will generate a CSV, a JSON and a HTML report, however you can generate JSON-ASFF (only for AWS Security Hub) report with `-M` or `--output-modes`:\n\n```console\nprowler <provider> -M csv json json-asff html\n```\n\nThe html report will be located in the `output` directory as the other files and it will look like:\n\n![Prowler Execution](https://github.com/prowler-cloud/prowler/blob/62c1ce73bbcdd6b9e5ba03dfcae26dfd165defd9/docs/img/html-output.png?raw=True)\n\nYou can use `-l`/`--list-checks` or `--list-services` to list all available checks or services within the provider.\n\n```console\nprowler <provider> --list-checks\nprowler <provider> --list-services\n```\n\nFor executing specific checks or services you can use options `-c`/`--checks` or `-s`/`--services`:\n\n```console\nprowler aws --checks s3_bucket_public_access\nprowler aws --services s3 ec2\n```\n\nAlso, checks and services can be excluded with options `-e`/`--excluded-checks` or `--excluded-services`:\n\n```console\nprowler aws --excluded-checks s3_bucket_public_access\nprowler aws --excluded-services s3 ec2\n```\n\nYou can always use `-h`/`--help` to access to the usage information and all the possible options:\n\n```console\nprowler -h\n```\n\n## Checks Configurations\nSeveral Prowler\'s checks have user configurable variables that can be modified in a common **configuration file**.\nThis file can be found in the following path:\n```\nprowler/config/config.yaml\n```\n\n## AWS\n\nUse a custom AWS profile with `-p`/`--profile` and/or AWS regions which you want to audit with `-f`/`--filter-region`:\n\n```console\nprowler aws --profile custom-profile -f us-east-1 eu-south-2\n```\n> By default, `prowler` will scan all AWS regions.\n\n## Azure\n\nWith Azure you need to specify which auth method is going to be used:\n\n```console\nprowler azure [--sp-env-auth, --az-cli-auth, --browser-auth, --managed-identity-auth]\n```\n> By default, `prowler` will scan all Azure subscriptions.\n\n# 🎉 New Features\n\n- Python: we got rid of all bash and it is now all in Python.\n- Faster: huge performance improvements (same account from 2.5 hours to 4 minutes).\n- Developers and community: we have made it easier to contribute with new checks and new compliance frameworks. We also included unit tests.\n- Multi-cloud: in addition to AWS, we have added Azure, we plan to include GCP and OCI soon, let us know if you want to contribute!\n\n# 📃 License\n\nProwler is licensed as Apache License 2.0 as specified in each file. You may obtain a copy of the License at\n<http://www.apache.org/licenses/LICENSE-2.0>\n',
    'author': 'Toni de la Fuente',
    'author_email': 'toni@blyx.com',
    'maintainer': 'Sergio Garcia',
    'maintainer_email': 'sergio@verica.io',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
