from webdriver_manager.chrome import ChromeDriverManager
from selenium import webdriver

# Base model which navigates, or executes scripts.

class FeatherAnalyst:
    
    def __init__(self):
        self.driver = None
        self.debug = False

    def chrome_options(self):
        
        options = webdriver.ChromeOptions()
        options.add_argument("--ignore-certificate-errors")     # Ignores SSL
        options.add_argument("--incognito")                     # Incognito
        options.add_argument("--headless")                      # No pop-up
        return options

    def driver_start(self):
        if not self.driver:
            # Creates driver object
            self.driver = webdriver.Chrome(
                ChromeDriverManager().install(),
                options = self.chrome_options()
            )
            
            if self.debug == True:
                print("Driver started: ",self.driver)

        else:
            raise Exception("Core: driver started")

    def navigate(self, url):
        """
        Navigates driver to specified url.

        :Params:
        * URL (str): url to go to

        :Output:
        * none
        """
        if self.driver:
            self.driver.get(url)

            if self.debug == True:
                print("Driver navigated: ",self.driver.current_url)
        else:
            raise Exception("Core: start driver")

    def driver_quit(self):
        """
        Safely checks and quits driver object.
        
        :Params:
        * none

        :Output:
        * none
        """
        if self.driver:
            self.driver = self.driver.quit()
            
            if self.debug == True:
                print("Driver terminated.")
        else:
            raise Exception("Core: start driver")

    def console_script(self, url, script):
        """
        Executes a script, or scripts for a specific url. Multi-script support exists to prevent needing
        to launch a new driver for every script. This console_script is a safe execution environment
        where the driver is opened, navigated, and closed.

        :Params:
        * url (str): a full https://domain.com/slug for the driver to navigate to
        * script (str, list): a string or list of strings for the JS web driver console to execute

        :Output:
        * output (str): string of output generated by execution of script argument
        """

        # Start driver and navigate
        self.driver_start()
        self.navigate(url)

        # Multi-script support
        if type(script) is list:
            output = []
            for i in script:
                local_output = self.driver.execute_script(i)
                output.append(local_output)

                if self.debug == True:
                    print("Executed script: ",i)
                    print("Output of script: ",local_output)

        # Single script
        elif type(script) is str:
            output = self.driver.execute_script(script)

        # Safely close driver
        self.driver_quit()

        return output