# kuob

A fork of the awesome project ASCIINEMA Terminal session recorder.
[kuob.sh](https://kuob.sh).

## Quick intro

kuob lets you easily record terminal sessions and replay
them in a terminal as well as in a web browser.

Install latest version:

    sudo pip3 install kuob

Record your first session:

    kuob rec first.cast

Now replay it with double speed:

    kuob play -s 2 first.cast

Or with normal speed but with idle time limited to 2 seconds:

    kuob play -i 2 first.cast

You can pass `-i 2` to `kuob rec` as well, to set it permanently on a
recording. Idle time limiting makes the recordings much more interesting to
watch. Try it.

If you want to watch and share it on the web, upload it:

    kuob upload first.cast

The above uploads it to [kuob.sh](https://kuob.org) instance,
and prints a secret link you can use to watch your recording in a web
browser.

You can record and upload in one step by omitting the filename:

    kuob rec

You'll be asked to confirm the upload when the recording is done. Nothing is
sent anywhere without your consent.

These are the basics, but there's much more you can do. The following sections
cover installation, usage and hosting of the recordings in more detail.

## Installation

### Python package

kuob is available on [PyPI](https://pypi.org/project/kuob/2.0.2/) and can
be installed with pip (Python 3 with setuptools required):

    sudo pip3 install kuob

This is the recommended way of installation, which gives you the latest released
version.

## Usage

kuob is composed of multiple commands, similar to `git`, `apt-get` or
`brew`.

When you run `kuob` with no arguments help message is displayed, listing
all available commands with their options.

### `rec [filename]`

__Record terminal session.__

By running `kuob rec [filename]` you start a new recording session. The
command (process) that is recorded can be specified with `-c` option (see
below), and defaults to `$SHELL` which is what you want in most cases.

You can temporarily pause recording of terminal by pressing <kbd>Ctrl+P</kbd>.
This is useful when you want to execute some commands during the recording
session that should not be captured (e.g. pasting secrets). Resume by pressing
<kbd>Ctrl+P</kbd> again.

Recording finishes when you exit the shell (hit <kbd>Ctrl+D</kbd> or type
`exit`). If the recorded process is not a shell then recording finishes when
the process exits.

If the `filename` argument is omitted then (after asking for confirmation) the
resulting asciicast is uploaded to
[kuob-server](https://github.com/kuob/kuob-server) (by default to
kuob.sh), where it can be watched and shared.

If the `filename` argument is given then the resulting recording (called
[asciicast](doc/asciicast-v2.md)) is saved to a local file. It can later be
replayed with `kuob play <filename>` and/or uploaded to kuob server
with `kuob upload <filename>`.

`KUOB_REC=1` is added to recorded process environment variables. This
can be used by your shell's config file (`.bashrc`, `.zshrc`) to alter the
prompt or play a sound when the shell is being recorded.

Available options:

* `--stdin` - Enable stdin (keyboard) recording (see below)
* `--append` - Append to existing recording
* `--raw` - Save raw STDOUT output, without timing information or other metadata
* `--overwrite` - Overwrite the recording if it already exists
* `-c, --command=<command>` - Specify command to record, defaults to $SHELL
* `-e, --env=<var-names>` - List of environment variables to capture, defaults
  to `SHELL,TERM`
* `-t, --title=<title>` - Specify the title of the asciicast
* `-i, --idle-time-limit=<sec>` - Limit recorded terminal inactivity to max `<sec>` seconds
* `-y, --yes` - Answer "yes" to all prompts (e.g. upload confirmation)
* `-q, --quiet` - Be quiet, suppress all notices/warnings (implies -y)

Stdin recording allows for capturing of all characters typed in by the user in
the currently recorded shell. This may be used by a player (e.g.
[kuob-player](https://github.com/kuob/kuob-player)) to display
pressed keys. Because it's basically a key-logging (scoped to a single shell
instance), it's disabled by default, and has to be explicitly enabled via
`--stdin` option.

### `play <filename>`

__Replay recorded asciicast in a terminal.__

This command replays given asciicast (as recorded by `rec` command) directly in
your terminal.

Following keyboard shortcuts are available:

- <kbd>Space</kbd> - toggle pause,
- <kbd>.</kbd> - step through a recording a frame at a time (when paused),
- <kbd>Ctrl+C</kbd> - exit.

Playing from a local file:

    kuob play /path/to/asciicast.cast

Playing from HTTP(S) URL:

    kuob play https://kuob.sh/a/22124.cast
    kuob play http://example.com/demo.cast

Playing from asciicast page URL (requires `<link rel="alternate"
type="application/x-asciicast" href="/my/ascii.cast">` in page's HTML):

    kuob play https://kuob.sh/a/22124
    kuob play http://example.com/blog/post.html

Playing from stdin:

    cat /path/to/asciicast.cast | kuob play -
    ssh user@host cat asciicast.cast | kuob play -

Playing from IPFS:

    kuob play dweb:/ipfs/QmNe7FsYaHc9SaDEAEXbaagAzNw9cH7YbzN4xV7jV1MCzK/ascii.cast

Available options:

* `-i, --idle-time-limit=<sec>` - Limit replayed terminal inactivity to max `<sec>` seconds
* `-s, --speed=<factor>` - Playback speed (can be fractional)

> For the best playback experience it is recommended to run `kuob play` in
> a terminal of dimensions not smaller than the one used for recording, as
> there's no "transcoding" of control sequences for new terminal size.

### `cat <filename>`

__Print full output of recorded asciicast to a terminal.__

While `kuob play <filename>` replays the recorded session using timing
information saved in the asciicast, `kuob cat <filename>` dumps the full
output (including all escape sequences) to a terminal immediately.

`kuob cat existing.cast >output.txt` gives the same result as recording via
`kuob rec --raw output.txt`.

### `upload <filename>`

__Upload recorded asciicast to kuob.sh site.__

This command uploads given asciicast (recorded by `rec` command) to
kuob.sh, where it can be watched and shared.

`kuob rec demo.cast` + `kuob play demo.cast` + `kuob upload
demo.cast` is a nice combo if you want to review an asciicast before
publishing it on kuob.sh.

### `auth`

__Link your install ID with your kuob.sh user account.__

If you want to manage your recordings (change title/theme, delete) at
kuob.sh you need to link your "install ID" with kuob.org user
account.

This command displays the URL to open in a web browser to do that. You may be
asked to log in first.

Install ID is a random ID ([UUID
v4](https://en.wikipedia.org/wiki/Universally_unique_identifier)) generated
locally when you run kuob for the first time, and saved at
`$HOME/.config/kuob/install-id`. Its purpose is to connect local machine
with uploaded recordings, so they can later be associated with kuob.sh
account. This way we decouple uploading from account creation, allowing them to
happen in any order.

> A new install ID is generated on each machine and system user account you use
> kuob on, so in order to keep all recordings under a single kuob.sh
> account you need to run `kuob auth` on all of those machines.

> kuob versions prior to 2.0 confusingly referred to install ID as "API
> token".


## Configuration file

You can configure kuob by creating config file at
`$HOME/.config/kuob/config`.

Configuration is split into sections (`[api]`, `[record]`, `[play]`). Here's a
list of all available options for each section:

```ini
[api]

; API server URL, default: https://kuob.sh
; If you run your own instance of kuob-server then set its address here
; It can also be overriden by setting KUOB_API_URL environment variable
url = https://kuob.example.com

[record]

; Command to record, default: $SHELL
command = /bin/bash -l

; Enable stdin (keyboard) recording, default: no
stdin = yes

; List of environment variables to capture, default: SHELL,TERM
env = SHELL,TERM,USER

; Limit recorded terminal inactivity to max n seconds, default: off
idle_time_limit = 2

; Answer "yes" to all interactive prompts, default: no
yes = true

; Be quiet, suppress all notices/warnings, default: no
quiet = true

[play]

; Playback speed (can be fractional), default: 1
speed = 2

; Limit replayed terminal inactivity to max n seconds, default: off
idle_time_limit = 1

[notifications]

; Should desktop notifications be enabled, default: yes
enabled = no

; Custom notification command
; Environment variable $TEXT contains notification text
command = tmux display-message "$TEXT"
```

A very minimal config file could look like that:

```ini
[record]
idle_time_limit = 2
```

Config directory location can be changed by setting `$KUOB_CONFIG_HOME`
environment variable.

If `$XDG_CONFIG_HOME` is set on Linux then kuob uses
`$XDG_CONFIG_HOME/kuob` instead of `$HOME/.config/kuob`.

> kuob versions prior to 1.1 used `$HOME/.kuob`. If you have it
> there you should `mv $HOME/.kuob $HOME/.config/kuob`.


## Origional ASCIINEMA Authors

Developed with passion by [Marcin Kulik](http://ku1ik.com) and great open
source [contributors](https://github.com/kuob/kuob/contributors).