class Nsrlx:
    """
    纳税人类型常量声明
    命名方式：统一以大写字母+下划线组成。税种缩写在前+税种分类+纳税期限分类+其他字段
    调用方式：类名.字段名。Nsrlx.ZZSXGM
    """

    # 增值税小规模纳税人类型，兼顾河南、广西
    ZZSXGM_STR = ['101010202', '101010201', '101010203']
    # 增值税小规模纳税人类型代码。
    ZZSXGM = '101010201'
    # 增值税小规模纳税人查账征收类型代码
    ZZSXGM_CZZS = '101010201'
    # 增值税小规模纳税人核定征收类型代码
    ZZSXGM_HDZS = '101010202'
    # 增值税小规模纳税人双定户类型代码
    ZZSXGM_SDH = '101010203'
    # 增值税一般纳税人类型代码
    ZZS_YBNSR = '101010101'
    # 附加税纳税人类型代码
    FJS = '101010109'
    # 定期定额纳税人类型代码
    DQDE = '101010110'
    # 印花税纳税人类型代码。各省使用的代码值略有不同，注意区分
    YHS_START = '10111010'
    # 月报
    YHS_YB = '101110104'
    # 季报
    YHS_JB = '101110105'
    # 半年报
    YHS_BNB = '101110106'
    # 次报
    YHS_AC = '101110103'
    # 年报
    YHS_NB = '101110107'
    # 企业所得税月季A查账征收
    QYSDS_YJA = '101040010010'
    # 企业所得税B核定征收
    QYSDS_YJB = '101040040010'
    # 工会经费
    GHJY = '399000201'
    # 财务报表
    CWBB_START = '50100'
    # 财务报表小企业
    CWBB_XQY = '501001031'
    # 财务报表一般企业已执行 月季报
    CWBB_YBQY_YZX_YJ = '501001071'
    # 财务报表一般企业未执行 月季报
    CWBB_YBQY_WZX_YJ = '501001011'
    # 文化事业建设费
    WHSYJSF = '103012611,103012612'
    # 文化事业建设费 广告业
    WHSYJSF_GGY = '103012611'
    # 文化事业建设费 娱乐业
    WHSYJSF_YLY = '103012612'
