# Generated by Django 2.0.7 on 2019-02-25 10:03

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='DomainComponent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=128)),
                ('dc', models.CharField(max_length=128)),
            ],
            options={
                'db_table': 'domain_component',
            },
        ),
        migrations.CreateModel(
            name='LDAPAttrMapping',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=128)),
                ('sel_expr', models.CharField(max_length=512)),
                ('from_tbls', models.CharField(max_length=512)),
                ('join_where', models.CharField(blank=True, default='', max_length=512, null=True)),
                ('create_proc', models.CharField(blank=True, default='', max_length=512, null=True)),
                ('delete_proc', models.CharField(blank=True, default='', max_length=512, null=True)),
                ('param_order', models.IntegerField()),
                ('expect_return', models.IntegerField()),
            ],
            options={
                'db_table': 'ldap_attr_mappings',
            },
        ),
        migrations.CreateModel(
            name='LDAPEntry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('dn', models.CharField(max_length=256)),
                ('keyval', models.IntegerField(default=1)),
                ('subject', models.IntegerField(choices=[(0, 'others'),(1, 'user'),(2, 'dept'),(3, 'group'),], default=0)),
            ],
            options={
                'db_table': 'raw_ldap_entries',
            },
        ),
        migrations.CreateModel(
            name='LDAPEntryObjectclasses',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('oc_name', models.CharField(max_length=128)),
                ('entry', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='sql_backend.LDAPEntry')),
            ],
            options={
                'db_table': 'ldap_entry_objclasses',
            },
        ),
        migrations.CreateModel(
            name='LDAPOCMappings',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=128)),
                ('keytbl', models.CharField(max_length=128)),
                ('keycol', models.CharField(max_length=128)),
                ('create_proc', models.CharField(blank=True, default='', max_length=512, null=True)),
                ('delete_proc', models.CharField(blank=True, default='', max_length=512, null=True)),
                ('expect_return', models.IntegerField()),
            ],
            options={
                'db_table': 'ldap_oc_mappings',
            },
        ),
        migrations.CreateModel(
            name='Organization',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=128)),
                ('o', models.CharField(max_length=128)),
            ],
            options={
                'db_table': 'organization',
            },
        ),
        migrations.CreateModel(
            name='OrganizationUnit',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=128)),
                ('ou', models.CharField(max_length=128)),
            ],
            options={
                'db_table': 'organization_unit',
            },
        ),
        migrations.AddField(
            model_name='ldapentry',
            name='oc_map',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='sql_backend.LDAPOCMappings'),
        ),
        migrations.AddField(
            model_name='ldapentry',
            name='parent',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, to='sql_backend.LDAPEntry'),
        ),
        migrations.AddField(
            model_name='ldapattrmapping',
            name='oc_map',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='sql_backend.LDAPOCMappings'),
        ),
    ]
