# Generated by Django 2.0.7 on 2019-06-17 11:52

from django.db import migrations, models
from django.conf import settings
from sys import _getframe
from ...common.setup_utils import validate_attr


def init_user_native_field(apps, schema_editor):
    '''
    补充初始化字段
    '''
    validate_attr(_getframe().f_code.co_filename, _getframe().f_code.co_name, _getframe().f_lineno,
                  'TESTING')
    if settings.TESTING:
        return None
    NativeField = apps.get_model('oneid_meta', 'NativeField')
    subject = 'user'

    NativeField.objects.create(subject=subject, name='职位', key='position', schema={'type': 'string'})
    NativeField.objects.create(subject=subject, name='私人邮箱', key='private_email', schema={'type': 'string'})

class Migration(migrations.Migration):

    dependencies = [
        ('oneid_meta', '0031_auto_20190611_1406'),
    ]

    operations = [
        migrations.AddField(
            model_name='user',
            name='position',
            field=models.CharField(blank=True, default='', max_length=255, verbose_name='职位'),
        ),
        migrations.AddField(
            model_name='user',
            name='private_email',
            field=models.CharField(blank=True, default='', max_length=255, verbose_name='私人邮箱'),
        ),
        migrations.RunPython(init_user_native_field),
    ]
