# Generated by Django 2.0.7 on 2019-07-09 04:16

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid
from sys import _getframe
from ...common.setup_utils import validate_attr


def init_account_config(apps, schema_editor):

    AccountConfig = apps.get_model('oneid_meta', 'AccountConfig')
    Site = apps.get_model('sites', 'Site')
    validate_attr(_getframe().f_code.co_filename, _getframe().f_code.co_name, _getframe().f_lineno,
                  'SITE_ID')
    site, _ = Site.objects.get_or_create(id=settings.SITE_ID)
    account_config, _ = AccountConfig.objects.get_or_create(site=site)

class Migration(migrations.Migration):

    dependencies = [
        ('sites', '0002_alter_domain_unique'),
        ('oneid_meta', '0034_auto_20190626_1639'),
    ]

    operations = [
        migrations.CreateModel(
            name='AccountConfig',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4, unique=True)),
                ('is_del', models.BooleanField(default=False, verbose_name='是否删除')),
                ('is_active', models.BooleanField(default=True, verbose_name='是否可用')),
                ('updated', models.DateTimeField(auto_now=True, null=True, verbose_name='更新时间')),
                ('created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('email_register', models.BooleanField(default=False, verbose_name='是否允许邮箱注册')),
                ('mobile_register', models.BooleanField(default=False, verbose_name='是否允许手机注册')),
                ('username_register', models.BooleanField(default=False, verbose_name='是否允许用户名注册')),
                ('email_reset_pwd', models.BooleanField(default=True, verbose_name='是否允许个人邮箱重置密码')),
                ('mobile_reset_pwd', models.BooleanField(default=False, verbose_name='是否允许手机重置密码')),
                ('site', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='account_config', to='sites.Site')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.RunPython(init_account_config),
    ]
