# Generated by Django 2.0.7 on 2019-07-09 06:28
from sys import _getframe

from django.db import migrations, models
import django.db.models.deletion
from django.conf import settings

from ...common.setup_utils import NotConfiguredException, validate_attr
from ...oneid_meta.models import config
import uuid


def init_sms_config(apps, schema_editor):

    SMSConfig = apps.get_model('oneid_meta', 'SMSConfig')
    Site = apps.get_model('sites', 'Site')
    validate_attr(_getframe().f_code.co_filename, _getframe().f_code.co_name, _getframe().f_lineno,
                  'SITE_ID')
    site, _ = Site.objects.get_or_create(id=settings.SITE_ID)
    sms_config, _ = SMSConfig.objects.get_or_create(site=site)

    validate_attr(_getframe().f_code.co_filename, _getframe().f_code.co_name, _getframe().f_lineno, 'TESTING')

    if not settings.TESTING:
        sms_config.access_key = getattr(settings, 'SMS_ALIYUN_ACCESS_KEY_ID', '')
        sms_config.access_secret = getattr(settings, 'SMS_ALIYUN_ACCESS_KEY_SECRET', '')
        sms_config.template_code = getattr(settings, 'SMS_ALIYUN_TEMPLATE_CODE', '')
        sms_config.save()


class Migration(migrations.Migration):

    dependencies = [
        ('sites', '0002_alter_domain_unique'),
        ('oneid_meta', '0035_accountconfig'),
    ]

    operations = [
        migrations.CreateModel(
            name='SMSConfig',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4, unique=True)),
                ('is_del', models.BooleanField(default=False, verbose_name='是否删除')),
                ('is_active', models.BooleanField(default=True, verbose_name='是否可用')),
                ('updated', models.DateTimeField(auto_now=True, null=True, verbose_name='更新时间')),
                ('created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('vendor', models.CharField(choices=[('aliyun', '阿里云')], default='aliyun', max_length=128, verbose_name='短信服务商')),
                ('access_key', models.CharField(blank=True, default='', max_length=255, verbose_name='AccessKey')),
                ('access_secret', models.CharField(blank=True, default='', max_length=255, verbose_name='AccessSecret')),
                ('signature', models.CharField(blank=True, default='', max_length=64, verbose_name='签名')),
                ('template_code', models.CharField(blank=True, default='', max_length=255, verbose_name='验证码通用文案模板ID')),
                ('template_register', models.CharField(blank=True, default='', max_length=255, verbose_name='注册文案模板ID')),
                ('template_reset_pwd', models.CharField(blank=True, default='', max_length=255, verbose_name='重置密码文案模板ID')),
                ('site', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='sms_config', to='sites.Site')),
            ],
            options={
                'abstract': False,
            },
            bases=(models.Model, config.SingletonConfigMixin),
        ),
        migrations.RunPython(init_sms_config),
    ]
