# Generated by Django 2.0.13 on 2019-12-16 04:13
# pylint: disable=invalid-name
import os
import uuid
from django.db import migrations, models
import django.db.models.deletion
from django.conf import settings
from ...djangosaml2idp.scripts.idpinit import run

BASEDIR = os.path.dirname(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))

def init_idp_config(apps, schema_editor):    # pylint: disable=unused-argument
    '''初始化IdP配置
    '''
    run()

class Migration(migrations.Migration):
    '''生成saml_app表
    '''
    dependencies = [
        ('oneid_meta', '0066_minioconfig_storageconfig'),
        ('sites', '0002_alter_domain_unique'),
    ]

    operations = [
        migrations.CreateModel(
            name='SAMLAPP',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4, unique=True)),
                ('is_del', models.BooleanField(default=False, verbose_name='是否删除')),
                ('is_active', models.BooleanField(default=True, verbose_name='是否可用')),
                ('updated', models.DateTimeField(auto_now=True, null=True, verbose_name='更新时间')),
                ('created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('entity_id', models.CharField(max_length=255, verbose_name='SP方entity_id')),
                ('acs', models.CharField(blank=True, max_length=255, verbose_name='SP方acs地址')),
                ('sls', models.CharField(blank=True, max_length=255, verbose_name='SP方sls地址')),
                ('cert', models.CharField(blank=True, max_length=2200, verbose_name='证书公钥')),
                ('xmldata', models.CharField(blank=True, max_length=5000, verbose_name='本地SP元数据')),
                ('app', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE,\
                    related_name='saml_app', to='oneid_meta.APP')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.RunPython(init_idp_config)
    ]
